/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.perworldchat;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;
import lol.hyper.githubreleaseapi.GitHubRelease;
import lol.hyper.githubreleaseapi.GitHubReleaseAPI;
import lol.hyper.perworldchat.bstats.bukkit.Metrics;
import lol.hyper.perworldchat.commands.CommandWorlds;
import lol.hyper.perworldchat.events.AsyncPlayerChat;
import lol.hyper.perworldchat.events.PlayerChangedWorld;
import lol.hyper.perworldchat.events.PlayerLeaveJoin;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class PerWorldChat
extends JavaPlugin {
    public final HashMap<World, Set<Player>> playerLocations = new HashMap();
    public final Logger logger = this.getLogger();
    public AsyncPlayerChat asyncPlayerChat;
    public PlayerChangedWorld playerChangedWorld;
    public PlayerLeaveJoin playerLeaveJoin;

    public void onEnable() {
        this.asyncPlayerChat = new AsyncPlayerChat(this);
        this.playerChangedWorld = new PlayerChangedWorld(this);
        this.playerLeaveJoin = new PlayerLeaveJoin(this);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this.asyncPlayerChat, (Plugin)this);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this.playerChangedWorld, (Plugin)this);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this.playerLeaveJoin, (Plugin)this);
        this.getCommand("worlds").setExecutor((CommandExecutor)new CommandWorlds(this));
        new Metrics(this, 11754);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, this::checkForUpdates);
    }

    public void checkForUpdates() {
        GitHubReleaseAPI api;
        try {
            api = new GitHubReleaseAPI("PerWorldChat", "hyperdefined");
        }
        catch (IOException e) {
            this.logger.warning("Unable to check updates!");
            e.printStackTrace();
            return;
        }
        GitHubRelease current = api.getReleaseByTag(this.getDescription().getVersion());
        GitHubRelease latest = api.getLatestVersion();
        if (current == null) {
            this.logger.warning("You are running a version that does not exist on GitHub. If you are in a dev environment, you can ignore this. Otherwise, this is a bug!");
            return;
        }
        int buildsBehind = api.getBuildsBehind(current);
        if (buildsBehind == 0) {
            this.logger.info("You are running the latest version.");
        } else {
            this.logger.warning("A new version is available (" + latest.getTagVersion() + ")! You are running version " + current.getTagVersion() + ". You are " + buildsBehind + " version(s) behind.");
        }
    }
}

