/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.item.EntityItem;
import org.spigotmc.SpigotWorldConfig;

public class TrackingRange {
    public static int getEntityTrackingRange(Entity entity, int defaultRange) {
        if (defaultRange == 0) {
            return defaultRange;
        }
        if (entity instanceof EntityEnderDragon) {
            return defaultRange;
        }
        SpigotWorldConfig config = entity.t.spigotConfig;
        if (entity instanceof EntityPlayer) {
            return config.playerTrackingRange;
        }
        switch (entity.activationType) {
            case RAIDER: 
            case MONSTER: 
            case FLYING_MONSTER: {
                return config.monsterTrackingRange;
            }
            case WATER: 
            case VILLAGER: 
            case ANIMAL: {
                return config.animalTrackingRange;
            }
        }
        if (entity instanceof EntityItemFrame || entity instanceof EntityPainting || entity instanceof EntityItem || entity instanceof EntityExperienceOrb) {
            return config.miscTrackingRange;
        }
        return config.otherTrackingRange;
    }

    public static TrackingRangeType getTrackingRangeType(Entity entity) {
        if (entity instanceof EntityEnderDragon) {
            return TrackingRangeType.ENDERDRAGON;
        }
        if (entity instanceof EntityPlayer) {
            return TrackingRangeType.PLAYER;
        }
        switch (entity.activationType) {
            case RAIDER: 
            case MONSTER: 
            case FLYING_MONSTER: {
                return TrackingRangeType.MONSTER;
            }
            case WATER: 
            case VILLAGER: 
            case ANIMAL: {
                return TrackingRangeType.ANIMAL;
            }
        }
        if (entity instanceof EntityItemFrame || entity instanceof EntityPainting || entity instanceof EntityItem || entity instanceof EntityExperienceOrb) {
            return TrackingRangeType.MISC;
        }
        return TrackingRangeType.OTHER;
    }

    public static enum TrackingRangeType {
        PLAYER,
        ANIMAL,
        MONSTER,
        MISC,
        OTHER,
        ENDERDRAGON;

    }
}

