/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.structure;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import org.apache.commons.lang3.Validate;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_18_R1.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftNamespacedKey;
import org.bukkit.structure.Structure;
import org.bukkit.structure.StructureManager;

public class CraftStructureManager
implements StructureManager {
    private final DefinedStructureManager structureManager;

    public CraftStructureManager(DefinedStructureManager structureManager) {
        this.structureManager = structureManager;
    }

    public Map<NamespacedKey, Structure> getStructures() {
        HashMap cachedStructures = new HashMap();
        for (Map.Entry<MinecraftKey, Optional<DefinedStructure>> entry : this.structureManager.e.entrySet()) {
            entry.getValue().ifPresent(definedStructure -> cachedStructures.put(CraftNamespacedKey.fromMinecraft((MinecraftKey)entry.getKey()), new CraftStructure((DefinedStructure)definedStructure)));
        }
        return Collections.unmodifiableMap(cachedStructures);
    }

    public Structure getStructure(NamespacedKey structureKey) {
        Validate.notNull((Object)structureKey, (String)"structureKey cannot be null", (Object[])new Object[0]);
        Optional<DefinedStructure> definedStructure = this.structureManager.e.get(CraftNamespacedKey.toMinecraft(structureKey));
        if (definedStructure == null) {
            return null;
        }
        return definedStructure.map(CraftStructure::new).orElse(null);
    }

    public Structure loadStructure(NamespacedKey structureKey, boolean register) {
        MinecraftKey minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        Optional<DefinedStructure> structure = this.structureManager.e.get(minecraftKey);
        structure = structure == null ? Optional.empty() : structure;
        structure = structure.isPresent() ? structure : this.structureManager.f(minecraftKey);
        Optional<DefinedStructure> optional = structure = structure.isPresent() ? structure : this.structureManager.e(minecraftKey);
        if (register) {
            this.structureManager.e.put(minecraftKey, structure);
        }
        return structure.map(CraftStructure::new).orElse(null);
    }

    public Structure loadStructure(NamespacedKey structureKey) {
        return this.loadStructure(structureKey, true);
    }

    public void saveStructure(NamespacedKey structureKey) {
        MinecraftKey minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        this.structureManager.c(minecraftKey);
    }

    public void saveStructure(NamespacedKey structureKey, Structure structure) throws IOException {
        Validate.notNull((Object)structure, (String)"structure cannot be null", (Object[])new Object[0]);
        File structureFile = this.getStructureFile(structureKey);
        Files.createDirectories(structureFile.toPath().getParent(), new FileAttribute[0]);
        this.saveStructure(structureFile, structure);
    }

    public Structure registerStructure(NamespacedKey structureKey, Structure structure) {
        Validate.notNull((Object)structure, (String)"structure cannot be null", (Object[])new Object[0]);
        MinecraftKey minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        Optional<DefinedStructure> optionalDefinedStructure = Optional.of(((CraftStructure)structure).getHandle());
        Optional<DefinedStructure> previousStructure = this.structureManager.e.put(minecraftKey, optionalDefinedStructure);
        return previousStructure == null ? null : (Structure)previousStructure.map(CraftStructure::new).orElse(null);
    }

    public Structure unregisterStructure(NamespacedKey structureKey) {
        MinecraftKey minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        Optional<DefinedStructure> previousStructure = this.structureManager.e.remove(minecraftKey);
        return previousStructure == null ? null : (Structure)previousStructure.map(CraftStructure::new).orElse(null);
    }

    public void deleteStructure(NamespacedKey structureKey) throws IOException {
        this.deleteStructure(structureKey, true);
    }

    public void deleteStructure(NamespacedKey structureKey, boolean unregister) throws IOException {
        MinecraftKey key = CraftNamespacedKey.toMinecraft(structureKey);
        if (unregister) {
            this.structureManager.e.remove(key);
        }
        Path path = this.structureManager.b(key, ".nbt");
        Files.deleteIfExists(path);
    }

    public File getStructureFile(NamespacedKey structureKey) {
        MinecraftKey minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        return this.structureManager.b(minecraftKey, ".nbt").toFile();
    }

    public Structure loadStructure(File file) throws IOException {
        Validate.notNull((Object)file, (String)"file cannot be null", (Object[])new Object[0]);
        FileInputStream fileinputstream = new FileInputStream(file);
        return this.loadStructure(fileinputstream);
    }

    public Structure loadStructure(InputStream inputStream) throws IOException {
        Validate.notNull((Object)inputStream, (String)"inputStream cannot be null", (Object[])new Object[0]);
        return new CraftStructure(this.structureManager.a(inputStream));
    }

    public void saveStructure(File file, Structure structure) throws IOException {
        Validate.notNull((Object)file, (String)"file cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)structure, (String)"structure cannot be null", (Object[])new Object[0]);
        FileOutputStream fileoutputstream = new FileOutputStream(file);
        this.saveStructure(fileoutputstream, structure);
    }

    public void saveStructure(OutputStream outputStream, Structure structure) throws IOException {
        Validate.notNull((Object)outputStream, (String)"outputStream cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)structure, (String)"structure cannot be null", (Object[])new Object[0]);
        NBTTagCompound nbttagcompound = ((CraftStructure)structure).getHandle().a(new NBTTagCompound());
        NBTCompressedStreamTools.a(nbttagcompound, outputStream);
    }

    public Structure createStructure() {
        return new CraftStructure(new DefinedStructure());
    }

    private MinecraftKey createAndValidateMinecraftStructureKey(NamespacedKey structureKey) {
        Validate.notNull((Object)structureKey, (String)"structureKey cannot be null", (Object[])new Object[0]);
        MinecraftKey minecraftkey = CraftNamespacedKey.toMinecraft(structureKey);
        if (minecraftkey.a().contains("//")) {
            throw new IllegalArgumentException("Resource key for Structures can not contain \"//\"");
        }
        return minecraftkey;
    }

    public Structure copy(Structure structure) {
        return new CraftStructure(this.structureManager.a(((CraftStructure)structure).getHandle().a(new NBTTagCompound())));
    }
}

