/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.inventory;

import com.destroystokyo.paper.Namespaced;
import com.destroystokyo.paper.NamespacedTag;
import com.destroystokyo.paper.PaperConfig;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.adventure.PaperAdventure;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.commands.arguments.blocks.ArgumentBlock;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.ItemBlock;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.EnumUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_18_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_18_R1.Overridden;
import org.bukkit.craftbukkit.v1_18_R1.attribute.CraftAttributeInstance;
import org.bukkit.craftbukkit.v1_18_R1.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.v1_18_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMetaArmorStand;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMetaAxolotlBucket;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMetaBanner;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMetaBlockState;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMetaBookSigned;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMetaBundle;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMetaCharge;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMetaCompass;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMetaCrossbow;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMetaEnchantedBook;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMetaEntityTag;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMetaKnowledgeBook;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMetaLeatherArmor;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMetaMap;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMetaPotion;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMetaSkull;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMetaSpawnEgg;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMetaSuspiciousStew;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMetaTropicalFishBucket;
import org.bukkit.craftbukkit.v1_18_R1.inventory.tags.DeprecatedCustomTagContainer;
import org.bukkit.craftbukkit.v1_18_R1.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_18_R1.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftNBTTagConfigSerializer;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftNamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.BlockDataMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.inventory.meta.tags.CustomItemTagContainer;
import org.bukkit.persistence.PersistentDataContainer;
import org.spigotmc.ValidateUtils;

@DelegateDeserialization(value=SerializableMeta.class)
class CraftMetaItem
implements ItemMeta,
Damageable,
Repairable,
BlockDataMeta {
    static final ItemMetaKey NAME = new ItemMetaKey("Name", "display-name");
    static final ItemMetaKey LOCNAME = new ItemMetaKey("LocName", "loc-name");
    static final ItemMetaKey DISPLAY = new ItemMetaKey("display");
    static final ItemMetaKey LORE = new ItemMetaKey("Lore", "lore");
    static final ItemMetaKey CUSTOM_MODEL_DATA = new ItemMetaKey("CustomModelData", "custom-model-data");
    static final ItemMetaKey ENCHANTMENTS = new ItemMetaKey("Enchantments", "enchants");
    static final ItemMetaKey ENCHANTMENTS_ID = new ItemMetaKey("id");
    static final ItemMetaKey ENCHANTMENTS_LVL = new ItemMetaKey("lvl");
    static final ItemMetaKey REPAIR = new ItemMetaKey("RepairCost", "repair-cost");
    static final ItemMetaKey ATTRIBUTES = new ItemMetaKey("AttributeModifiers", "attribute-modifiers");
    static final ItemMetaKey ATTRIBUTES_IDENTIFIER = new ItemMetaKey("AttributeName");
    static final ItemMetaKey ATTRIBUTES_NAME = new ItemMetaKey("Name");
    static final ItemMetaKey ATTRIBUTES_VALUE = new ItemMetaKey("Amount");
    static final ItemMetaKey ATTRIBUTES_TYPE = new ItemMetaKey("Operation");
    static final ItemMetaKey ATTRIBUTES_UUID_HIGH = new ItemMetaKey("UUIDMost");
    static final ItemMetaKey ATTRIBUTES_UUID_LOW = new ItemMetaKey("UUIDLeast");
    static final ItemMetaKey ATTRIBUTES_SLOT = new ItemMetaKey("Slot");
    static final ItemMetaKey HIDEFLAGS = new ItemMetaKey("HideFlags", "ItemFlags");
    static final ItemMetaKey UNBREAKABLE = new ItemMetaKey("Unbreakable");
    static final ItemMetaKey DAMAGE = new ItemMetaKey("Damage");
    static final ItemMetaKey BLOCK_DATA = new ItemMetaKey("BlockStateTag");
    static final ItemMetaKey BUKKIT_CUSTOM_TAG = new ItemMetaKey("PublicBukkitValues");
    static final ItemMetaKey CAN_DESTROY = new ItemMetaKey("CanDestroy");
    static final ItemMetaKey CAN_PLACE_ON = new ItemMetaKey("CanPlaceOn");
    private String displayName;
    private String locName;
    private List<String> lore;
    private Integer customModelData;
    private NBTTagCompound blockData;
    private EnchantmentMap enchantments;
    private Multimap<Attribute, AttributeModifier> attributeModifiers;
    private int repairCost;
    private int hideFlag;
    private boolean unbreakable;
    private int damage;
    private Set<Namespaced> placeableKeys = Sets.newHashSet();
    private Set<Namespaced> destroyableKeys = Sets.newHashSet();
    private static final Set<String> HANDLED_TAGS = Sets.newHashSet();
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    private NBTTagCompound internalTag;
    final Map<String, NBTBase> unhandledTags = new TreeMap<String, NBTBase>();
    private CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private int version = CraftMagicNumbers.INSTANCE.getDataVersion();

    CraftMetaItem(CraftMetaItem meta) {
        if (meta == null) {
            return;
        }
        this.displayName = meta.displayName;
        this.locName = meta.locName;
        if (meta.lore != null) {
            this.lore = new ArrayList<String>(meta.lore);
        }
        this.customModelData = meta.customModelData;
        this.blockData = meta.blockData;
        if (meta.enchantments != null) {
            this.enchantments = new EnchantmentMap(meta.enchantments);
        }
        if (meta.hasAttributeModifiers()) {
            this.attributeModifiers = LinkedHashMultimap.create(meta.attributeModifiers);
        }
        this.repairCost = meta.repairCost;
        this.hideFlag = meta.hideFlag;
        this.unbreakable = meta.unbreakable;
        this.damage = meta.damage;
        if (meta.hasPlaceableKeys()) {
            this.placeableKeys = new HashSet<Namespaced>(meta.placeableKeys);
        }
        if (meta.hasDestroyableKeys()) {
            this.destroyableKeys = new HashSet<Namespaced>(meta.destroyableKeys);
        }
        this.unhandledTags.putAll(meta.unhandledTags);
        this.persistentDataContainer.putAll(meta.persistentDataContainer.getRaw());
        this.internalTag = meta.internalTag;
        if (this.internalTag != null) {
            this.deserializeInternal(this.internalTag, meta);
        }
        this.version = meta.version;
    }

    CraftMetaItem(NBTTagCompound tag) {
        NBTTagList list;
        if (tag.e(CraftMetaItem.DISPLAY.NBT)) {
            NBTTagCompound display = tag.p(CraftMetaItem.DISPLAY.NBT);
            if (display.e(CraftMetaItem.NAME.NBT)) {
                this.displayName = ValidateUtils.limit(display.l(CraftMetaItem.NAME.NBT), PaperConfig.itemValidationDisplayNameLength);
            }
            if (display.e(CraftMetaItem.LOCNAME.NBT)) {
                this.locName = ValidateUtils.limit(display.l(CraftMetaItem.LOCNAME.NBT), PaperConfig.itemValidationLocNameLength);
            }
            if (display.e(CraftMetaItem.LORE.NBT)) {
                NBTTagList list2 = display.c(CraftMetaItem.LORE.NBT, 8);
                this.lore = new ArrayList<String>(list2.size());
                for (int index = 0; index < list2.size(); ++index) {
                    String line = ValidateUtils.limit(list2.j(index), PaperConfig.itemValidationLoreLineLength);
                    this.lore.add(line);
                }
            }
        }
        if (tag.b(CraftMetaItem.CUSTOM_MODEL_DATA.NBT, 3)) {
            this.customModelData = tag.h(CraftMetaItem.CUSTOM_MODEL_DATA.NBT);
        }
        if (tag.b(CraftMetaItem.BLOCK_DATA.NBT, 10)) {
            this.blockData = tag.p(CraftMetaItem.BLOCK_DATA.NBT);
        }
        this.enchantments = CraftMetaItem.buildEnchantments(tag, ENCHANTMENTS);
        this.attributeModifiers = CraftMetaItem.buildModifiers(tag, ATTRIBUTES);
        if (tag.e(CraftMetaItem.REPAIR.NBT)) {
            this.repairCost = tag.h(CraftMetaItem.REPAIR.NBT);
        }
        if (tag.e(CraftMetaItem.HIDEFLAGS.NBT)) {
            this.hideFlag = tag.h(CraftMetaItem.HIDEFLAGS.NBT);
        }
        if (tag.e(CraftMetaItem.UNBREAKABLE.NBT)) {
            this.unbreakable = tag.q(CraftMetaItem.UNBREAKABLE.NBT);
        }
        if (tag.e(CraftMetaItem.DAMAGE.NBT)) {
            this.damage = tag.h(CraftMetaItem.DAMAGE.NBT);
        }
        if (tag.e(CraftMetaItem.BUKKIT_CUSTOM_TAG.NBT)) {
            NBTTagCompound compound = tag.p(CraftMetaItem.BUKKIT_CUSTOM_TAG.NBT);
            Set<String> keys = compound.d();
            for (String key : keys) {
                this.persistentDataContainer.put(key, compound.c(key));
            }
        }
        if (tag.e(CraftMetaItem.CAN_DESTROY.NBT)) {
            list = tag.c(CraftMetaItem.CAN_DESTROY.NBT, 8);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Namespaced namespaced = this.deserializeNamespaced(list.j(i2));
                if (namespaced == null) continue;
                this.destroyableKeys.add(namespaced);
            }
        }
        if (tag.e(CraftMetaItem.CAN_PLACE_ON.NBT)) {
            list = tag.c(CraftMetaItem.CAN_PLACE_ON.NBT, 8);
            for (int i3 = 0; i3 < list.size(); ++i3) {
                Namespaced namespaced = this.deserializeNamespaced(list.j(i3));
                if (namespaced == null) continue;
                this.placeableKeys.add(namespaced);
            }
        }
        Set<String> keys = tag.d();
        for (String key : keys) {
            if (CraftMetaItem.getHandledTags().contains(key)) continue;
            this.unhandledTags.put(key, tag.c(key));
        }
    }

    static EnchantmentMap buildEnchantments(NBTTagCompound tag, ItemMetaKey key) {
        if (!tag.e(key.NBT)) {
            return null;
        }
        NBTTagList ench = tag.c(key.NBT, 10);
        EnchantmentMap enchantments = new EnchantmentMap();
        for (int i2 = 0; i2 < ench.size(); ++i2) {
            String id = ((NBTTagCompound)ench.k(i2)).l(CraftMetaItem.ENCHANTMENTS_ID.NBT);
            int level = 0xFFFF & ((NBTTagCompound)ench.k(i2)).g(CraftMetaItem.ENCHANTMENTS_LVL.NBT);
            Enchantment enchant = Enchantment.getByKey((NamespacedKey)CraftNamespacedKey.fromStringOrNull(id));
            if (enchant == null) continue;
            enchantments.put(enchant, level);
        }
        return enchantments;
    }

    static Multimap<Attribute, AttributeModifier> buildModifiers(NBTTagCompound tag, ItemMetaKey key) {
        LinkedHashMultimap modifiers = LinkedHashMultimap.create();
        if (!tag.b(key.NBT, 9)) {
            return modifiers;
        }
        NBTTagList mods = tag.c(key.NBT, 10);
        int size = mods.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Attribute attribute;
            net.minecraft.world.entity.ai.attributes.AttributeModifier nmsModifier;
            NBTTagCompound entry = mods.a(i2);
            if (entry.f() || (nmsModifier = net.minecraft.world.entity.ai.attributes.AttributeModifier.a(entry)) == null) continue;
            AttributeModifier attribMod = CraftAttributeInstance.convert(nmsModifier);
            String attributeName = CraftAttributeMap.convertIfNeeded(entry.l(CraftMetaItem.ATTRIBUTES_IDENTIFIER.NBT));
            if (attributeName == null || attributeName.isEmpty() || (attribute = CraftAttributeMap.fromMinecraft(attributeName)) == null) continue;
            if (entry.b(CraftMetaItem.ATTRIBUTES_SLOT.NBT, 8)) {
                String slotName = entry.l(CraftMetaItem.ATTRIBUTES_SLOT.NBT);
                if (slotName == null || slotName.isEmpty()) {
                    modifiers.put((Object)attribute, (Object)attribMod);
                    continue;
                }
                EquipmentSlot slot = null;
                try {
                    slot = CraftEquipmentSlot.getSlot(EnumItemSlot.a(slotName.toLowerCase(Locale.ROOT)));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (slot == null) {
                    modifiers.put((Object)attribute, (Object)attribMod);
                    continue;
                }
                attribMod = new AttributeModifier(attribMod.getUniqueId(), attribMod.getName(), attribMod.getAmount(), attribMod.getOperation(), slot);
            }
            modifiers.put((Object)attribute, (Object)attribMod);
        }
        return modifiers;
    }

    CraftMetaItem(Map<String, Object> map) {
        Map nbtMap;
        String internal;
        Iterable canDestroySerialized;
        Iterable canPlaceOnSerialized;
        Integer damage;
        Boolean unbreakable;
        Iterable hideFlags;
        Map blockData;
        Integer customModelData;
        this.displayName = CraftChatMessage.fromJSONOrStringOrNullToJSON(SerializableMeta.getString(map, CraftMetaItem.NAME.BUKKIT, true));
        this.locName = CraftChatMessage.fromJSONOrStringOrNullToJSON(SerializableMeta.getString(map, CraftMetaItem.LOCNAME.BUKKIT, true));
        Iterable lore = SerializableMeta.getObject(Iterable.class, map, CraftMetaItem.LORE.BUKKIT, true);
        if (lore != null) {
            this.lore = new ArrayList<String>();
            CraftMetaItem.safelyAdd(lore, this.lore, true);
        }
        if ((customModelData = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.CUSTOM_MODEL_DATA.BUKKIT, true)) != null) {
            this.setCustomModelData(customModelData);
        }
        if ((blockData = SerializableMeta.getObject(Map.class, map, CraftMetaItem.BLOCK_DATA.BUKKIT, true)) != null) {
            this.blockData = (NBTTagCompound)CraftNBTTagConfigSerializer.deserialize(blockData);
        }
        this.enchantments = CraftMetaItem.buildEnchantments(map, ENCHANTMENTS);
        this.attributeModifiers = CraftMetaItem.buildModifiers(map, ATTRIBUTES);
        Integer repairCost = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.REPAIR.BUKKIT, true);
        if (repairCost != null) {
            this.setRepairCost(repairCost);
        }
        if ((hideFlags = SerializableMeta.getObject(Iterable.class, map, CraftMetaItem.HIDEFLAGS.BUKKIT, true)) != null) {
            for (Object hideFlagObject : hideFlags) {
                String hideFlagString = (String)hideFlagObject;
                try {
                    ItemFlag hideFlatEnum = ItemFlag.valueOf((String)hideFlagString);
                    this.addItemFlags(hideFlatEnum);
                }
                catch (IllegalArgumentException hideFlatEnum) {}
            }
        }
        if ((unbreakable = SerializableMeta.getObject(Boolean.class, map, CraftMetaItem.UNBREAKABLE.BUKKIT, true)) != null) {
            this.setUnbreakable(unbreakable);
        }
        if ((damage = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.DAMAGE.BUKKIT, true)) != null) {
            this.setDamage(damage);
        }
        if ((canPlaceOnSerialized = SerializableMeta.getObject(Iterable.class, map, CraftMetaItem.CAN_PLACE_ON.BUKKIT, true)) != null) {
            for (Object canPlaceOnElement : canPlaceOnSerialized) {
                String canPlaceOnRaw = (String)canPlaceOnElement;
                Namespaced value = this.deserializeNamespaced(canPlaceOnRaw);
                if (value == null) continue;
                this.placeableKeys.add(value);
            }
        }
        if ((canDestroySerialized = SerializableMeta.getObject(Iterable.class, map, CraftMetaItem.CAN_DESTROY.BUKKIT, true)) != null) {
            for (Object canDestroyElement : canDestroySerialized) {
                String canDestroyRaw = (String)canDestroyElement;
                Namespaced value = this.deserializeNamespaced(canDestroyRaw);
                if (value == null) continue;
                this.destroyableKeys.add(value);
            }
        }
        if ((internal = SerializableMeta.getString(map, "internal", true)) != null) {
            ByteArrayInputStream buf = new ByteArrayInputStream(Base64.getDecoder().decode(internal));
            try {
                this.internalTag = NBTCompressedStreamTools.a(buf);
                this.deserializeInternal(this.internalTag, map);
                Set<String> keys = this.internalTag.d();
                for (String key : keys) {
                    if (CraftMetaItem.getHandledTags().contains(key)) continue;
                    this.unhandledTags.put(key, this.internalTag.c(key));
                }
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if ((nbtMap = SerializableMeta.getObject(Map.class, map, CraftMetaItem.BUKKIT_CUSTOM_TAG.BUKKIT, true)) != null) {
            this.persistentDataContainer.putAll((NBTTagCompound)CraftNBTTagConfigSerializer.deserialize(nbtMap));
        }
    }

    void deserializeInternal(NBTTagCompound tag, Object context) {
        if (tag.b(CraftMetaItem.ATTRIBUTES.NBT, 9)) {
            this.attributeModifiers = CraftMetaItem.buildModifiers(tag, ATTRIBUTES);
        }
    }

    static EnchantmentMap buildEnchantments(Map<String, Object> map, ItemMetaKey key) {
        Map ench = SerializableMeta.getObject(Map.class, map, key.BUKKIT, true);
        if (ench == null) {
            return null;
        }
        EnchantmentMap enchantments = new EnchantmentMap();
        for (Map.Entry entry : ench.entrySet()) {
            Enchantment enchantment;
            String enchantKey = entry.getKey().toString();
            if (enchantKey.equals("SWEEPING")) {
                enchantKey = "SWEEPING_EDGE";
            }
            if ((enchantment = Enchantment.getByName((String)enchantKey)) == null || !(entry.getValue() instanceof Integer)) continue;
            enchantments.put(enchantment, (Integer)entry.getValue());
        }
        return enchantments;
    }

    static Multimap<Attribute, AttributeModifier> buildModifiers(Map<String, Object> map, ItemMetaKey key) {
        Map mods = SerializableMeta.getObject(Map.class, map, key.BUKKIT, true);
        LinkedHashMultimap result = LinkedHashMultimap.create();
        if (mods == null) {
            return result;
        }
        for (Object obj : mods.keySet()) {
            String attributeName;
            if (!(obj instanceof String) || Strings.isNullOrEmpty((String)(attributeName = (String)obj))) continue;
            List list = SerializableMeta.getObject(List.class, mods, attributeName, true);
            if (list == null || list.isEmpty()) {
                return result;
            }
            for (Object o2 : list) {
                if (!(o2 instanceof AttributeModifier)) continue;
                AttributeModifier modifier = (AttributeModifier)o2;
                Attribute attribute = (Attribute)EnumUtils.getEnum(Attribute.class, (String)attributeName.toUpperCase(Locale.ROOT));
                if (attribute == null) continue;
                result.put((Object)attribute, (Object)modifier);
            }
        }
        return result;
    }

    @Overridden
    void applyToItem(NBTTagCompound itemTag) {
        List<String> items;
        if (this.hasDisplayName()) {
            this.setDisplayTag(itemTag, CraftMetaItem.NAME.NBT, NBTTagString.a(this.displayName));
        }
        if (this.hasLocalizedName()) {
            this.setDisplayTag(itemTag, CraftMetaItem.LOCNAME.NBT, NBTTagString.a(this.locName));
        }
        if (this.lore != null) {
            this.setDisplayTag(itemTag, CraftMetaItem.LORE.NBT, this.createStringList(this.lore));
        }
        if (this.hasCustomModelData()) {
            itemTag.a(CraftMetaItem.CUSTOM_MODEL_DATA.NBT, this.customModelData);
        }
        if (this.hasBlockData()) {
            itemTag.a(CraftMetaItem.BLOCK_DATA.NBT, this.blockData);
        }
        if (this.hideFlag != 0) {
            itemTag.a(CraftMetaItem.HIDEFLAGS.NBT, this.hideFlag);
        }
        CraftMetaItem.applyEnchantments(this.enchantments, itemTag, ENCHANTMENTS);
        CraftMetaItem.applyModifiers(this.attributeModifiers, itemTag, ATTRIBUTES);
        if (this.hasRepairCost()) {
            itemTag.a(CraftMetaItem.REPAIR.NBT, this.repairCost);
        }
        if (this.isUnbreakable()) {
            itemTag.a(CraftMetaItem.UNBREAKABLE.NBT, this.unbreakable);
        }
        if (this.hasDamage()) {
            itemTag.a(CraftMetaItem.DAMAGE.NBT, this.damage);
        }
        if (this.hasPlaceableKeys()) {
            items = this.placeableKeys.stream().map(this::serializeNamespaced).collect(Collectors.toList());
            itemTag.a(CraftMetaItem.CAN_PLACE_ON.NBT, CraftMetaItem.createNonComponentStringList(items));
        }
        if (this.hasDestroyableKeys()) {
            items = this.destroyableKeys.stream().map(this::serializeNamespaced).collect(Collectors.toList());
            itemTag.a(CraftMetaItem.CAN_DESTROY.NBT, CraftMetaItem.createNonComponentStringList(items));
        }
        for (Map.Entry entry : this.unhandledTags.entrySet()) {
            itemTag.a((String)entry.getKey(), (NBTBase)entry.getValue());
        }
        if (!this.persistentDataContainer.isEmpty()) {
            NBTTagCompound bukkitCustomCompound = new NBTTagCompound();
            Map<String, NBTBase> map = this.persistentDataContainer.getRaw();
            for (Map.Entry<String, NBTBase> nbtBaseEntry : map.entrySet()) {
                bukkitCustomCompound.a(nbtBaseEntry.getKey(), nbtBaseEntry.getValue());
            }
            itemTag.a(CraftMetaItem.BUKKIT_CUSTOM_TAG.NBT, bukkitCustomCompound);
        }
    }

    static NBTTagList createNonComponentStringList(List<String> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        NBTTagList tagList = new NBTTagList();
        for (String value : list) {
            tagList.add(NBTTagString.a(value));
        }
        return tagList;
    }

    NBTTagList createStringList(List<String> list) {
        if (list == null) {
            return null;
        }
        NBTTagList tagList = new NBTTagList();
        for (String value : list) {
            tagList.add(NBTTagString.a(this.version <= 0 || this.version >= 1803 ? value : CraftChatMessage.fromJSONComponent(value)));
        }
        return tagList;
    }

    static void applyEnchantments(Map<Enchantment, Integer> enchantments, NBTTagCompound tag, ItemMetaKey key) {
        if (enchantments == null) {
            return;
        }
        NBTTagList list = new NBTTagList();
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            NBTTagCompound subtag = new NBTTagCompound();
            subtag.a(CraftMetaItem.ENCHANTMENTS_ID.NBT, entry.getKey().getKey().toString());
            subtag.a(CraftMetaItem.ENCHANTMENTS_LVL.NBT, entry.getValue().shortValue());
            list.add(subtag);
        }
        tag.a(key.NBT, list);
    }

    static void applyModifiers(Multimap<Attribute, AttributeModifier> modifiers, NBTTagCompound tag, ItemMetaKey key) {
        if (modifiers == null || modifiers.isEmpty()) {
            return;
        }
        NBTTagList list = new NBTTagList();
        for (Map.Entry entry : modifiers.entries()) {
            EnumItemSlot slot;
            String name;
            net.minecraft.world.entity.ai.attributes.AttributeModifier nmsModifier;
            NBTTagCompound sub;
            if (entry.getKey() == null || entry.getValue() == null || (sub = (nmsModifier = CraftAttributeInstance.convert((AttributeModifier)entry.getValue())).e()).f() || (name = ((Attribute)entry.getKey()).getKey().toString()) == null || name.isEmpty()) continue;
            sub.a(CraftMetaItem.ATTRIBUTES_IDENTIFIER.NBT, name);
            if (((AttributeModifier)entry.getValue()).getSlot() != null && (slot = CraftEquipmentSlot.getNMS(((AttributeModifier)entry.getValue()).getSlot())) != null) {
                sub.a(CraftMetaItem.ATTRIBUTES_SLOT.NBT, slot.d());
            }
            list.add(sub);
        }
        tag.a(key.NBT, list);
    }

    void setDisplayTag(NBTTagCompound tag, String key, NBTBase value) {
        NBTTagCompound display = tag.p(CraftMetaItem.DISPLAY.NBT);
        if (!tag.e(CraftMetaItem.DISPLAY.NBT)) {
            tag.a(CraftMetaItem.DISPLAY.NBT, display);
        }
        display.a(key, value);
    }

    @Overridden
    boolean applicableTo(Material type) {
        return type != Material.AIR;
    }

    @Overridden
    boolean isEmpty() {
        return !this.hasDisplayName() && !this.hasLocalizedName() && !this.hasEnchants() && this.lore == null && !this.hasCustomModelData() && !this.hasBlockData() && !this.hasRepairCost() && this.unhandledTags.isEmpty() && this.persistentDataContainer.isEmpty() && this.hideFlag == 0 && !this.isUnbreakable() && !this.hasDamage() && !this.hasAttributeModifiers() && !this.hasPlaceableKeys() && !this.hasDestroyableKeys();
    }

    public Component displayName() {
        return this.displayName == null ? null : GsonComponentSerializer.gson().deserialize((Object)this.displayName);
    }

    public void displayName(Component displayName) {
        this.displayName = displayName == null ? null : (String)GsonComponentSerializer.gson().serialize(displayName);
    }

    public String getDisplayName() {
        return CraftChatMessage.fromJSONComponent(this.displayName);
    }

    public BaseComponent[] getDisplayNameComponent() {
        return this.displayName == null ? new BaseComponent[]{} : ComponentSerializer.parse((String)this.displayName);
    }

    public final void setDisplayName(String name) {
        this.displayName = CraftChatMessage.fromStringOrNullToJSON(name);
    }

    public void setDisplayNameComponent(BaseComponent[] component) {
        this.displayName = ComponentSerializer.toString((BaseComponent[])component);
    }

    public boolean hasDisplayName() {
        return this.displayName != null;
    }

    public String getLocalizedName() {
        return CraftChatMessage.fromJSONComponent(this.locName);
    }

    public void setLocalizedName(String name) {
        this.locName = CraftChatMessage.fromStringOrNullToJSON(name);
    }

    public boolean hasLocalizedName() {
        return this.locName != null;
    }

    public boolean hasLore() {
        return this.lore != null && !this.lore.isEmpty();
    }

    public List<Component> lore() {
        return this.lore != null ? PaperAdventure.asAdventureFromJson(this.lore) : null;
    }

    public void lore(List<Component> lore) {
        this.lore = lore != null ? PaperAdventure.asJson(lore) : null;
    }

    public boolean hasRepairCost() {
        return this.repairCost > 0;
    }

    public boolean hasEnchant(Enchantment ench) {
        Validate.notNull((Object)ench, (String)"Enchantment cannot be null");
        return this.hasEnchants() && this.enchantments.containsKey(ench);
    }

    public int getEnchantLevel(Enchantment ench) {
        Integer level;
        Validate.notNull((Object)ench, (String)"Enchantment cannot be null");
        Integer n2 = level = this.hasEnchants() ? (Integer)this.enchantments.get(ench) : null;
        if (level == null) {
            return 0;
        }
        return level;
    }

    public Map<Enchantment, Integer> getEnchants() {
        return this.hasEnchants() ? ImmutableSortedMap.copyOfSorted((SortedMap)this.enchantments) : ImmutableMap.of();
    }

    public boolean addEnchant(Enchantment ench, int level, boolean ignoreRestrictions) {
        Validate.notNull((Object)ench, (String)"Enchantment cannot be null");
        if (this.enchantments == null) {
            this.enchantments = new EnchantmentMap();
        }
        if (ignoreRestrictions || level >= ench.getStartLevel() && level <= ench.getMaxLevel()) {
            Integer old = this.enchantments.put(ench, level);
            return old == null || old != level;
        }
        return false;
    }

    public boolean removeEnchant(Enchantment ench) {
        boolean b2;
        Validate.notNull((Object)ench, (String)"Enchantment cannot be null");
        boolean bl = b2 = this.hasEnchants() && this.enchantments.remove(ench) != null;
        if (this.enchantments != null && this.enchantments.isEmpty()) {
            this.enchantments = null;
        }
        return b2;
    }

    public boolean hasEnchants() {
        return this.enchantments != null && !this.enchantments.isEmpty();
    }

    public boolean hasConflictingEnchant(Enchantment ench) {
        return CraftMetaItem.checkConflictingEnchants(this.enchantments, ench);
    }

    public void addItemFlags(ItemFlag ... hideFlags) {
        for (ItemFlag f2 : hideFlags) {
            this.hideFlag |= this.getBitModifier(f2);
        }
    }

    public void removeItemFlags(ItemFlag ... hideFlags) {
        for (ItemFlag f2 : hideFlags) {
            this.hideFlag &= ~this.getBitModifier(f2);
        }
    }

    public Set<ItemFlag> getItemFlags() {
        EnumSet<ItemFlag> currentFlags = EnumSet.noneOf(ItemFlag.class);
        for (ItemFlag f2 : ItemFlag.values()) {
            if (!this.hasItemFlag(f2)) continue;
            currentFlags.add(f2);
        }
        return currentFlags;
    }

    public boolean hasItemFlag(ItemFlag flag) {
        byte bitModifier = this.getBitModifier(flag);
        return (this.hideFlag & bitModifier) == bitModifier;
    }

    private byte getBitModifier(ItemFlag hideFlag) {
        return (byte)(1 << hideFlag.ordinal());
    }

    public List<String> getLore() {
        return this.lore == null ? null : new ArrayList(Lists.transform(this.lore, CraftChatMessage::fromJSONComponent));
    }

    public List<BaseComponent[]> getLoreComponents() {
        return this.lore == null ? null : new ArrayList(this.lore.stream().map(entry -> ComponentSerializer.parse((String)entry)).collect(Collectors.toList()));
    }

    public void setLore(List<String> lore) {
        if (lore == null || lore.isEmpty()) {
            this.lore = null;
        } else {
            if (this.lore == null) {
                this.lore = new ArrayList<String>(lore.size());
            } else {
                this.lore.clear();
            }
            CraftMetaItem.safelyAdd(lore, this.lore, false);
        }
    }

    public void setLoreComponents(List<BaseComponent[]> lore) {
        if (lore == null) {
            this.lore = null;
        } else if (this.lore == null) {
            this.lore = new ArrayList<String>(lore.size());
            CraftMetaItem.safelyAdd(lore, this.lore, false);
        } else {
            this.lore.clear();
            CraftMetaItem.safelyAdd(lore, this.lore, false);
        }
    }

    public boolean hasCustomModelData() {
        return this.customModelData != null;
    }

    public int getCustomModelData() {
        Preconditions.checkState((boolean)this.hasCustomModelData(), (Object)"We don't have CustomModelData! Check hasCustomModelData first!");
        return this.customModelData;
    }

    public void setCustomModelData(Integer data) {
        this.customModelData = data;
    }

    public boolean hasBlockData() {
        return this.blockData != null;
    }

    public BlockData getBlockData(Material material) {
        return CraftBlockData.fromData(ItemBlock.getBlockState(CraftMagicNumbers.getBlock(material).n(), this.blockData));
    }

    public void setBlockData(BlockData blockData) {
        this.blockData = blockData == null ? null : ((CraftBlockData)blockData).toStates();
    }

    public int getRepairCost() {
        return this.repairCost;
    }

    public void setRepairCost(int cost) {
        this.repairCost = cost;
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    public void setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
    }

    public boolean hasAttributeModifiers() {
        return this.attributeModifiers != null && !this.attributeModifiers.isEmpty();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers() {
        return this.hasAttributeModifiers() ? ImmutableMultimap.copyOf(this.attributeModifiers) : null;
    }

    private void checkAttributeList() {
        if (this.attributeModifiers == null) {
            this.attributeModifiers = LinkedHashMultimap.create();
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nullable EquipmentSlot slot) {
        this.checkAttributeList();
        LinkedHashMultimap result = LinkedHashMultimap.create();
        for (Map.Entry entry : this.attributeModifiers.entries()) {
            if (((AttributeModifier)entry.getValue()).getSlot() != null && ((AttributeModifier)entry.getValue()).getSlot() != slot) continue;
            result.put((Object)((Attribute)entry.getKey()), (Object)((AttributeModifier)entry.getValue()));
        }
        return result;
    }

    public Collection<AttributeModifier> getAttributeModifiers(@Nonnull Attribute attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        return this.attributeModifiers.containsKey((Object)attribute) ? ImmutableList.copyOf((Collection)this.attributeModifiers.get((Object)attribute)) : null;
    }

    public boolean addAttributeModifier(@Nonnull Attribute attribute, @Nonnull AttributeModifier modifier) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        Preconditions.checkNotNull((Object)modifier, (Object)"AttributeModifier cannot be null");
        this.checkAttributeList();
        for (Map.Entry entry : this.attributeModifiers.entries()) {
            Preconditions.checkArgument((!((AttributeModifier)entry.getValue()).getUniqueId().equals(modifier.getUniqueId()) ? 1 : 0) != 0, (String)"Cannot register AttributeModifier. Modifier is already applied! %s", (Object)modifier);
        }
        return this.attributeModifiers.put((Object)attribute, (Object)modifier);
    }

    public void setAttributeModifiers(@Nullable Multimap<Attribute, AttributeModifier> attributeModifiers) {
        if (attributeModifiers == null || attributeModifiers.isEmpty()) {
            this.attributeModifiers = LinkedHashMultimap.create();
            return;
        }
        this.checkAttributeList();
        this.attributeModifiers.clear();
        Iterator iterator = attributeModifiers.entries().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            if (next.getKey() == null || next.getValue() == null) {
                iterator.remove();
                continue;
            }
            this.attributeModifiers.put((Object)((Attribute)next.getKey()), (Object)((AttributeModifier)next.getValue()));
        }
    }

    public boolean removeAttributeModifier(@Nonnull Attribute attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        this.checkAttributeList();
        return !this.attributeModifiers.removeAll((Object)attribute).isEmpty();
    }

    public boolean removeAttributeModifier(@Nullable EquipmentSlot slot) {
        this.checkAttributeList();
        int removed = 0;
        Iterator iter = this.attributeModifiers.entries().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (((AttributeModifier)entry.getValue()).getSlot() != null && ((AttributeModifier)entry.getValue()).getSlot() != slot) continue;
            iter.remove();
            ++removed;
        }
        return removed > 0;
    }

    public boolean removeAttributeModifier(@Nonnull Attribute attribute, @Nonnull AttributeModifier modifier) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        Preconditions.checkNotNull((Object)modifier, (Object)"AttributeModifier cannot be null");
        this.checkAttributeList();
        int removed = 0;
        Iterator iter = this.attributeModifiers.entries().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (entry.getKey() == null || entry.getValue() == null) {
                iter.remove();
                ++removed;
                continue;
            }
            if (entry.getKey() != attribute || !((AttributeModifier)entry.getValue()).getUniqueId().equals(modifier.getUniqueId())) continue;
            iter.remove();
            ++removed;
        }
        return removed > 0;
    }

    public CustomItemTagContainer getCustomTagContainer() {
        return new DeprecatedCustomTagContainer(this.getPersistentDataContainer());
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    private static boolean compareModifiers(Multimap<Attribute, AttributeModifier> first, Multimap<Attribute, AttributeModifier> second) {
        if (first == null || second == null) {
            return false;
        }
        for (Map.Entry entry : first.entries()) {
            if (second.containsEntry(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        for (Map.Entry entry : second.entries()) {
            if (first.containsEntry(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean hasDamage() {
        return this.damage > 0;
    }

    public int getDamage() {
        return this.damage;
    }

    public void setDamage(int damage) {
        this.damage = damage;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof CraftMetaItem)) {
            return false;
        }
        return CraftItemFactory.instance().equals((ItemMeta)this, (ItemMeta)object);
    }

    @Overridden
    boolean equalsCommon(CraftMetaItem that) {
        return (this.hasDisplayName() ? that.hasDisplayName() && this.displayName.equals(that.displayName) : !that.hasDisplayName()) && (this.hasLocalizedName() ? that.hasLocalizedName() && this.locName.equals(that.locName) : !that.hasLocalizedName()) && (this.hasEnchants() ? that.hasEnchants() && this.enchantments.equals(that.enchantments) : !that.hasEnchants()) && Objects.equals(this.lore, that.lore) && (this.hasCustomModelData() ? that.hasCustomModelData() && this.customModelData.equals(that.customModelData) : !that.hasCustomModelData()) && (this.hasBlockData() ? that.hasBlockData() && this.blockData.equals(that.blockData) : !that.hasBlockData()) && (this.hasRepairCost() ? that.hasRepairCost() && this.repairCost == that.repairCost : !that.hasRepairCost()) && (this.hasAttributeModifiers() ? that.hasAttributeModifiers() && CraftMetaItem.compareModifiers(this.attributeModifiers, that.attributeModifiers) : !that.hasAttributeModifiers()) && this.unhandledTags.equals(that.unhandledTags) && this.persistentDataContainer.equals(that.persistentDataContainer) && this.hideFlag == that.hideFlag && this.isUnbreakable() == that.isUnbreakable() && (this.hasDamage() ? that.hasDamage() && this.damage == that.damage : !that.hasDamage()) && this.version == that.version && (this.hasPlaceableKeys() ? that.hasPlaceableKeys() && this.placeableKeys.equals(that.placeableKeys) : !that.hasPlaceableKeys()) && (this.hasDestroyableKeys() ? that.hasDestroyableKeys() && this.destroyableKeys.equals(that.destroyableKeys) : !that.hasDestroyableKeys());
    }

    @Overridden
    boolean notUncommon(CraftMetaItem meta) {
        return true;
    }

    public final int hashCode() {
        return this.applyHash();
    }

    @Overridden
    int applyHash() {
        int hash = 3;
        hash = 61 * hash + (this.hasDisplayName() ? this.displayName.hashCode() : 0);
        hash = 61 * hash + (this.hasLocalizedName() ? this.locName.hashCode() : 0);
        hash = 61 * hash + (this.lore != null ? this.lore.hashCode() : 0);
        hash = 61 * hash + (this.hasCustomModelData() ? this.customModelData.hashCode() : 0);
        hash = 61 * hash + (this.hasBlockData() ? this.blockData.hashCode() : 0);
        hash = 61 * hash + (this.hasEnchants() ? this.enchantments.hashCode() : 0);
        hash = 61 * hash + (this.hasRepairCost() ? this.repairCost : 0);
        hash = 61 * hash + this.unhandledTags.hashCode();
        hash = 61 * hash + (!this.persistentDataContainer.isEmpty() ? this.persistentDataContainer.hashCode() : 0);
        hash = 61 * hash + this.hideFlag;
        hash = 61 * hash + (this.isUnbreakable() ? 1231 : 1237);
        hash = 61 * hash + (this.hasDamage() ? this.damage : 0);
        hash = 61 * hash + (this.hasAttributeModifiers() ? this.attributeModifiers.hashCode() : 0);
        hash = 61 * hash + this.version;
        hash = 61 * hash + (this.hasPlaceableKeys() ? this.placeableKeys.hashCode() : 0);
        hash = 61 * hash + (this.hasDestroyableKeys() ? this.destroyableKeys.hashCode() : 0);
        return hash;
    }

    @Overridden
    public CraftMetaItem clone() {
        try {
            CraftMetaItem clone = (CraftMetaItem)super.clone();
            if (this.lore != null) {
                clone.lore = new ArrayList<String>(this.lore);
            }
            clone.customModelData = this.customModelData;
            clone.blockData = this.blockData;
            if (this.enchantments != null) {
                clone.enchantments = new EnchantmentMap(this.enchantments);
            }
            if (this.hasAttributeModifiers()) {
                clone.attributeModifiers = LinkedHashMultimap.create(this.attributeModifiers);
            }
            clone.persistentDataContainer = new CraftPersistentDataContainer(this.persistentDataContainer.getRaw(), DATA_TYPE_REGISTRY);
            clone.hideFlag = this.hideFlag;
            clone.unbreakable = this.unbreakable;
            clone.damage = this.damage;
            clone.version = this.version;
            if (this.placeableKeys != null) {
                clone.placeableKeys = Sets.newHashSet(this.placeableKeys);
            }
            if (this.destroyableKeys != null) {
                clone.destroyableKeys = Sets.newHashSet(this.destroyableKeys);
            }
            return clone;
        }
        catch (CloneNotSupportedException e2) {
            throw new Error(e2);
        }
    }

    public final Map<String, Object> serialize() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)"meta-type", SerializableMeta.classMap.get(this.getClass()));
        this.serialize((ImmutableMap.Builder<String, Object>)map);
        return map.build();
    }

    @Overridden
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        if (this.hasDisplayName()) {
            builder.put((Object)CraftMetaItem.NAME.BUKKIT, (Object)this.displayName);
        }
        if (this.hasLocalizedName()) {
            builder.put((Object)CraftMetaItem.LOCNAME.BUKKIT, (Object)this.locName);
        }
        if (this.lore != null) {
            builder.put((Object)CraftMetaItem.LORE.BUKKIT, (Object)ImmutableList.copyOf(this.lore));
        }
        if (this.hasCustomModelData()) {
            builder.put((Object)CraftMetaItem.CUSTOM_MODEL_DATA.BUKKIT, (Object)this.customModelData);
        }
        if (this.hasBlockData()) {
            builder.put((Object)CraftMetaItem.BLOCK_DATA.BUKKIT, CraftNBTTagConfigSerializer.serialize(this.blockData));
        }
        CraftMetaItem.serializeEnchantments(this.enchantments, builder, ENCHANTMENTS);
        CraftMetaItem.serializeModifiers(this.attributeModifiers, builder, ATTRIBUTES);
        if (this.hasRepairCost()) {
            builder.put((Object)CraftMetaItem.REPAIR.BUKKIT, (Object)this.repairCost);
        }
        ArrayList<String> hideFlags = new ArrayList<String>();
        for (ItemFlag hideFlagEnum : this.getItemFlags()) {
            hideFlags.add(hideFlagEnum.name());
        }
        if (!hideFlags.isEmpty()) {
            builder.put((Object)CraftMetaItem.HIDEFLAGS.BUKKIT, hideFlags);
        }
        if (this.isUnbreakable()) {
            builder.put((Object)CraftMetaItem.UNBREAKABLE.BUKKIT, (Object)this.unbreakable);
        }
        if (this.hasDamage()) {
            builder.put((Object)CraftMetaItem.DAMAGE.BUKKIT, (Object)this.damage);
        }
        if (this.hasPlaceableKeys()) {
            List cerealPlaceable = this.placeableKeys.stream().map(this::serializeNamespaced).collect(Collectors.toList());
            builder.put((Object)CraftMetaItem.CAN_PLACE_ON.BUKKIT, cerealPlaceable);
        }
        if (this.hasDestroyableKeys()) {
            List cerealDestroyable = this.destroyableKeys.stream().map(this::serializeNamespaced).collect(Collectors.toList());
            builder.put((Object)CraftMetaItem.CAN_DESTROY.BUKKIT, cerealDestroyable);
        }
        HashMap<String, NBTBase> internalTags = new HashMap<String, NBTBase>(this.unhandledTags);
        this.serializeInternal(internalTags);
        if (!internalTags.isEmpty()) {
            NBTTagCompound internal = new NBTTagCompound();
            for (Map.Entry e2 : internalTags.entrySet()) {
                internal.a((String)e2.getKey(), (NBTBase)e2.getValue());
            }
            try {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                NBTCompressedStreamTools.a(internal, buf);
                builder.put((Object)"internal", (Object)Base64.getEncoder().encodeToString(buf.toByteArray()));
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (!this.persistentDataContainer.isEmpty()) {
            builder.put((Object)CraftMetaItem.BUKKIT_CUSTOM_TAG.BUKKIT, this.persistentDataContainer.serialize());
        }
        return builder;
    }

    void serializeInternal(Map<String, NBTBase> unhandledTags) {
    }

    Material updateMaterial(Material material) {
        return material;
    }

    static void serializeEnchantments(Map<Enchantment, Integer> enchantments, ImmutableMap.Builder<String, Object> builder, ItemMetaKey key) {
        if (enchantments == null || enchantments.isEmpty()) {
            return;
        }
        ImmutableMap.Builder enchants = ImmutableMap.builder();
        for (Map.Entry<Enchantment, Integer> enchant : enchantments.entrySet()) {
            enchants.put((Object)enchant.getKey().getName(), (Object)enchant.getValue());
        }
        builder.put((Object)key.BUKKIT, (Object)enchants.build());
    }

    static void serializeModifiers(Multimap<Attribute, AttributeModifier> modifiers, ImmutableMap.Builder<String, Object> builder, ItemMetaKey key) {
        if (modifiers == null || modifiers.isEmpty()) {
            return;
        }
        LinkedHashMap mods = new LinkedHashMap();
        for (Map.Entry entry : modifiers.entries()) {
            Collection modCollection;
            if (entry.getKey() == null || (modCollection = modifiers.get((Object)((Attribute)entry.getKey()))) == null || modCollection.isEmpty()) continue;
            mods.put(((Attribute)entry.getKey()).name(), new ArrayList(modCollection));
        }
        builder.put((Object)key.BUKKIT, mods);
    }

    static void safelyAdd(Iterable<?> addFrom, Collection<String> addTo, boolean possiblyJsonInput) {
        if (addFrom == null) {
            return;
        }
        for (Object object : addFrom) {
            if (object instanceof BaseComponent[]) {
                addTo.add(ComponentSerializer.toString((BaseComponent[])((BaseComponent[])object)));
                continue;
            }
            if (!(object instanceof String)) {
                if (object != null) {
                    throw new IllegalArgumentException(addFrom + " cannot contain non-string " + object.getClass().getName());
                }
                addTo.add(CraftChatMessage.toJSON(new ChatComponentText("")));
                continue;
            }
            String entry = object.toString();
            if (possiblyJsonInput) {
                addTo.add(CraftChatMessage.fromJSONOrStringToJSON(entry));
                continue;
            }
            addTo.add(CraftChatMessage.fromStringToJSON(entry));
        }
    }

    static boolean checkConflictingEnchants(Map<Enchantment, Integer> enchantments, Enchantment ench) {
        if (enchantments == null || enchantments.isEmpty()) {
            return false;
        }
        for (Enchantment enchant : enchantments.keySet()) {
            if (!enchant.conflictsWith(ench)) continue;
            return true;
        }
        return false;
    }

    public final String toString() {
        return (String)SerializableMeta.classMap.get(this.getClass()) + "_META:" + this.serialize();
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getHandledTags() {
        Set<String> set = HANDLED_TAGS;
        synchronized (set) {
            if (HANDLED_TAGS.isEmpty()) {
                HANDLED_TAGS.addAll(Arrays.asList(CraftMetaItem.DISPLAY.NBT, CraftMetaItem.CUSTOM_MODEL_DATA.NBT, CraftMetaItem.BLOCK_DATA.NBT, CraftMetaItem.REPAIR.NBT, CraftMetaItem.ENCHANTMENTS.NBT, CraftMetaItem.HIDEFLAGS.NBT, CraftMetaItem.UNBREAKABLE.NBT, CraftMetaItem.DAMAGE.NBT, CraftMetaItem.BUKKIT_CUSTOM_TAG.NBT, CraftMetaItem.ATTRIBUTES.NBT, CraftMetaItem.ATTRIBUTES_IDENTIFIER.NBT, CraftMetaItem.ATTRIBUTES_NAME.NBT, CraftMetaItem.ATTRIBUTES_VALUE.NBT, CraftMetaItem.ATTRIBUTES_UUID_HIGH.NBT, CraftMetaItem.ATTRIBUTES_UUID_LOW.NBT, CraftMetaItem.ATTRIBUTES_SLOT.NBT, CraftMetaMap.MAP_SCALING.NBT, CraftMetaMap.MAP_COLOR.NBT, CraftMetaMap.MAP_ID.NBT, CraftMetaPotion.POTION_EFFECTS.NBT, CraftMetaPotion.DEFAULT_POTION.NBT, CraftMetaPotion.POTION_COLOR.NBT, CraftMetaSkull.SKULL_OWNER.NBT, CraftMetaSkull.SKULL_PROFILE.NBT, CraftMetaSpawnEgg.ENTITY_TAG.NBT, CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT, CraftMetaBook.BOOK_TITLE.NBT, CraftMetaBook.BOOK_AUTHOR.NBT, CraftMetaBook.BOOK_PAGES.NBT, CraftMetaBook.RESOLVED.NBT, CraftMetaBook.GENERATION.NBT, CraftMetaFirework.FIREWORKS.NBT, CraftMetaEnchantedBook.STORED_ENCHANTMENTS.NBT, CraftMetaCharge.EXPLOSION.NBT, CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT, CraftMetaKnowledgeBook.BOOK_RECIPES.NBT, CraftMetaTropicalFishBucket.VARIANT.NBT, CraftMetaAxolotlBucket.VARIANT.NBT, CraftMetaCrossbow.CHARGED.NBT, CraftMetaCrossbow.CHARGED_PROJECTILES.NBT, CraftMetaSuspiciousStew.EFFECTS.NBT, CraftMetaArmorStand.ENTITY_TAG.NBT, CraftMetaArmorStand.INVISIBLE.NBT, CraftMetaArmorStand.NO_BASE_PLATE.NBT, CraftMetaArmorStand.SHOW_ARMS.NBT, CraftMetaArmorStand.SMALL.NBT, CraftMetaArmorStand.MARKER.NBT, CraftMetaItem.CAN_DESTROY.NBT, CraftMetaItem.CAN_PLACE_ON.NBT, CraftMetaCompass.LODESTONE_DIMENSION.NBT, CraftMetaCompass.LODESTONE_POS.NBT, CraftMetaCompass.LODESTONE_TRACKED.NBT, CraftMetaBundle.ITEMS.NBT));
            }
            return HANDLED_TAGS;
        }
    }

    public Set<Material> getCanDestroy() {
        return !this.hasDestroyableKeys() ? Collections.emptySet() : this.legacyGetMatsFromKeys(this.destroyableKeys);
    }

    public void setCanDestroy(Set<Material> canDestroy) {
        Validate.notNull(canDestroy, (String)"Cannot replace with null set!");
        this.legacyClearAndReplaceKeys(this.destroyableKeys, canDestroy);
    }

    public Set<Material> getCanPlaceOn() {
        return !this.hasPlaceableKeys() ? Collections.emptySet() : this.legacyGetMatsFromKeys(this.placeableKeys);
    }

    public void setCanPlaceOn(Set<Material> canPlaceOn) {
        Validate.notNull(canPlaceOn, (String)"Cannot replace with null set!");
        this.legacyClearAndReplaceKeys(this.placeableKeys, canPlaceOn);
    }

    public Set<Namespaced> getDestroyableKeys() {
        return !this.hasDestroyableKeys() ? Collections.emptySet() : Sets.newHashSet(this.destroyableKeys);
    }

    public void setDestroyableKeys(Collection<Namespaced> canDestroy) {
        Validate.notNull(canDestroy, (String)"Cannot replace with null collection!");
        Validate.isTrue((boolean)this.ofAcceptableType(canDestroy), (String)"Can only use NamespacedKey or NamespacedTag objects!");
        this.destroyableKeys.clear();
        this.destroyableKeys.addAll(canDestroy);
    }

    public Set<Namespaced> getPlaceableKeys() {
        return !this.hasPlaceableKeys() ? Collections.emptySet() : Sets.newHashSet(this.placeableKeys);
    }

    public void setPlaceableKeys(Collection<Namespaced> canPlaceOn) {
        Validate.notNull(canPlaceOn, (String)"Cannot replace with null collection!");
        Validate.isTrue((boolean)this.ofAcceptableType(canPlaceOn), (String)"Can only use NamespacedKey or NamespacedTag objects!");
        this.placeableKeys.clear();
        this.placeableKeys.addAll(canPlaceOn);
    }

    public boolean hasPlaceableKeys() {
        return this.placeableKeys != null && !this.placeableKeys.isEmpty();
    }

    public boolean hasDestroyableKeys() {
        return this.destroyableKeys != null && !this.destroyableKeys.isEmpty();
    }

    @Deprecated
    private void legacyClearAndReplaceKeys(Collection<Namespaced> toUpdate, Collection<Material> beingSet) {
        if (beingSet.stream().anyMatch(Material::isLegacy)) {
            throw new IllegalArgumentException("Set must not contain any legacy materials!");
        }
        toUpdate.clear();
        toUpdate.addAll(beingSet.stream().map(Material::getKey).collect(Collectors.toSet()));
    }

    @Deprecated
    private Set<Material> legacyGetMatsFromKeys(Collection<Namespaced> names) {
        HashSet mats = Sets.newHashSet();
        for (Namespaced key : names) {
            Material material;
            if (!(key instanceof NamespacedKey) || (material = Material.matchMaterial((String)key.toString(), (boolean)false)) == null) continue;
            mats.add(material);
        }
        return mats;
    }

    @Nullable
    private Namespaced deserializeNamespaced(String raw) {
        boolean isTag = raw.length() > 0 && raw.codePointAt(0) == 35;
        ArgumentBlock blockParser = new ArgumentBlock(new StringReader(raw), true);
        try {
            blockParser = blockParser.a(false);
        }
        catch (CommandSyntaxException e2) {
            return null;
        }
        MinecraftKey key = isTag ? blockParser.d() : blockParser.s;
        if (key == null) {
            return null;
        }
        Object resource = null;
        try {
            resource = isTag ? new NamespacedTag(key.b(), key.a()) : CraftNamespacedKey.fromMinecraft(key);
        }
        catch (IllegalArgumentException ex) {
            Bukkit.getLogger().warning("Namespaced resource does not validate: " + key.toString());
            ex.printStackTrace();
        }
        return resource;
    }

    @Nonnull
    private String serializeNamespaced(Namespaced resource) {
        return resource.toString();
    }

    private boolean ofAcceptableType(Collection<Namespaced> namespacedResources) {
        for (Namespaced resource : namespacedResources) {
            if (resource instanceof NamespacedKey || resource instanceof NamespacedTag) continue;
            return false;
        }
        return true;
    }

    private static class EnchantmentMap
    extends TreeMap<Enchantment, Integer> {
        private EnchantmentMap(Map<Enchantment, Integer> enchantments) {
            this();
            this.putAll(enchantments);
        }

        private EnchantmentMap() {
            super(Comparator.comparing(o2 -> o2.getKey().toString()));
        }

        @Override
        public EnchantmentMap clone() {
            return (EnchantmentMap)super.clone();
        }
    }

    static class ItemMetaKey {
        final String BUKKIT;
        final String NBT;

        ItemMetaKey(String both) {
            this(both, both);
        }

        ItemMetaKey(String nbt, String bukkit) {
            this.NBT = nbt;
            this.BUKKIT = bukkit;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @Target(value={ElementType.FIELD})
        static @interface Specific {
            public To value();

            public static enum To {
                BUKKIT,
                NBT;

            }
        }
    }

    @SerializableAs(value="ItemMeta")
    public static final class SerializableMeta
    implements ConfigurationSerializable {
        static final String TYPE_FIELD = "meta-type";
        static final ImmutableMap<Class<? extends CraftMetaItem>, String> classMap = ImmutableMap.builder().put(CraftMetaArmorStand.class, (Object)"ARMOR_STAND").put(CraftMetaBanner.class, (Object)"BANNER").put(CraftMetaBlockState.class, (Object)"TILE_ENTITY").put(CraftMetaBook.class, (Object)"BOOK").put(CraftMetaBookSigned.class, (Object)"BOOK_SIGNED").put(CraftMetaSkull.class, (Object)"SKULL").put(CraftMetaLeatherArmor.class, (Object)"LEATHER_ARMOR").put(CraftMetaMap.class, (Object)"MAP").put(CraftMetaPotion.class, (Object)"POTION").put(CraftMetaSpawnEgg.class, (Object)"SPAWN_EGG").put(CraftMetaEnchantedBook.class, (Object)"ENCHANTED").put(CraftMetaFirework.class, (Object)"FIREWORK").put(CraftMetaCharge.class, (Object)"FIREWORK_EFFECT").put(CraftMetaKnowledgeBook.class, (Object)"KNOWLEDGE_BOOK").put(CraftMetaTropicalFishBucket.class, (Object)"TROPICAL_FISH_BUCKET").put(CraftMetaAxolotlBucket.class, (Object)"AXOLOTL_BUCKET").put(CraftMetaCrossbow.class, (Object)"CROSSBOW").put(CraftMetaSuspiciousStew.class, (Object)"SUSPICIOUS_STEW").put(CraftMetaEntityTag.class, (Object)"ENTITY_TAG").put(CraftMetaCompass.class, (Object)"COMPASS").put(CraftMetaBundle.class, (Object)"BUNDLE").put(CraftMetaItem.class, (Object)"UNSPECIFIC").build();
        static final ImmutableMap<String, Constructor<? extends CraftMetaItem>> constructorMap;

        private SerializableMeta() {
        }

        public static ItemMeta deserialize(Map<String, Object> map) throws Throwable {
            Validate.notNull(map, (String)"Cannot deserialize null map");
            String type = SerializableMeta.getString(map, TYPE_FIELD, false);
            Constructor constructor = (Constructor)constructorMap.get((Object)type);
            if (constructor == null) {
                throw new IllegalArgumentException(type + " is not a valid meta-type");
            }
            try {
                return (ItemMeta)constructor.newInstance(map);
            }
            catch (InstantiationException e2) {
                throw new AssertionError((Object)e2);
            }
            catch (IllegalAccessException e3) {
                throw new AssertionError((Object)e3);
            }
            catch (InvocationTargetException e4) {
                throw e4.getCause();
            }
        }

        public Map<String, Object> serialize() {
            throw new AssertionError();
        }

        static String getString(Map<?, ?> map, Object field, boolean nullable) {
            return SerializableMeta.getObject(String.class, map, field, nullable);
        }

        static boolean getBoolean(Map<?, ?> map, Object field) {
            Boolean value = SerializableMeta.getObject(Boolean.class, map, field, true);
            return value != null && value != false;
        }

        static <T> T getObject(Class<T> clazz, Map<?, ?> map, Object field, boolean nullable) {
            Object object = map.get(field);
            if (clazz.isInstance(object)) {
                return clazz.cast(object);
            }
            if (object == null) {
                if (!nullable) {
                    throw new NoSuchElementException(map + " does not contain " + field);
                }
                return null;
            }
            throw new IllegalArgumentException(field + "(" + object + ") is not a valid " + clazz);
        }

        static {
            ImmutableMap.Builder classConstructorBuilder = ImmutableMap.builder();
            for (Map.Entry mapping : classMap.entrySet()) {
                try {
                    classConstructorBuilder.put((Object)((String)mapping.getValue()), ((Class)mapping.getKey()).getDeclaredConstructor(Map.class));
                }
                catch (NoSuchMethodException e2) {
                    throw new AssertionError((Object)e2);
                }
            }
            constructorMap = classConstructorBuilder.build();
        }
    }
}

