/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.inventory;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMerchantRecipe;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Merchant;

public class CraftMerchant
implements Merchant {
    protected final IMerchant merchant;

    public CraftMerchant(IMerchant merchant) {
        this.merchant = merchant;
    }

    public IMerchant getMerchant() {
        return this.merchant;
    }

    public List<org.bukkit.inventory.MerchantRecipe> getRecipes() {
        return List.copyOf(Lists.transform((List)this.merchant.fA(), (Function)new Function<MerchantRecipe, org.bukkit.inventory.MerchantRecipe>(){

            public org.bukkit.inventory.MerchantRecipe apply(MerchantRecipe recipe) {
                return recipe.asBukkit();
            }
        }));
    }

    public void setRecipes(List<org.bukkit.inventory.MerchantRecipe> recipes) {
        MerchantRecipeList recipesList = this.merchant.fA();
        recipesList.clear();
        for (org.bukkit.inventory.MerchantRecipe recipe : recipes) {
            recipesList.add(CraftMerchantRecipe.fromBukkit(recipe).toMinecraft());
        }
    }

    public org.bukkit.inventory.MerchantRecipe getRecipe(int i2) {
        return ((MerchantRecipe)this.merchant.fA().get(i2)).asBukkit();
    }

    public void setRecipe(int i2, org.bukkit.inventory.MerchantRecipe merchantRecipe) {
        this.merchant.fA().set(i2, CraftMerchantRecipe.fromBukkit(merchantRecipe).toMinecraft());
    }

    public int getRecipeCount() {
        return this.merchant.fA().size();
    }

    public boolean isTrading() {
        return this.getTrader() != null;
    }

    public HumanEntity getTrader() {
        EntityHuman eh = this.merchant.fy();
        return eh == null ? null : eh.getBukkitEntity();
    }

    public int hashCode() {
        return this.merchant.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CraftMerchant && ((CraftMerchant)obj).merchant.equals(this.merchant);
    }
}

