/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.inventory;

import java.util.Arrays;
import java.util.List;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.crafting.IRecipe;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemStack;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

public class CraftInventoryCrafting
extends CraftInventory
implements CraftingInventory {
    private final IInventory resultInventory;

    public CraftInventoryCrafting(IInventory inventory, IInventory resultInventory) {
        super(inventory);
        this.resultInventory = resultInventory;
    }

    public IInventory getResultInventory() {
        return this.resultInventory;
    }

    public IInventory getMatrixInventory() {
        return this.inventory;
    }

    @Override
    public int getSize() {
        return this.getResultInventory().b() + this.getMatrixInventory().b();
    }

    @Override
    public void setContents(ItemStack[] items) {
        if (this.getSize() > items.length) {
            throw new IllegalArgumentException("Invalid inventory size; expected " + this.getSize() + " or less");
        }
        this.setContents(items[0], Arrays.copyOfRange(items, 1, items.length));
    }

    @Override
    public ItemStack[] getContents() {
        ItemStack[] items = new ItemStack[this.getSize()];
        List<net.minecraft.world.item.ItemStack> mcResultItems = this.getResultInventory().getContents();
        int i2 = 0;
        for (i2 = 0; i2 < mcResultItems.size(); ++i2) {
            items[i2] = CraftItemStack.asCraftMirror(mcResultItems.get(i2));
        }
        List<net.minecraft.world.item.ItemStack> mcItems = this.getMatrixInventory().getContents();
        for (int j2 = 0; j2 < mcItems.size(); ++j2) {
            items[i2 + j2] = CraftItemStack.asCraftMirror(mcItems.get(j2));
        }
        return items;
    }

    public void setContents(ItemStack result, ItemStack[] contents) {
        this.setResult(result);
        this.setMatrix(contents);
    }

    @Override
    public CraftItemStack getItem(int index) {
        if (index < this.getResultInventory().b()) {
            net.minecraft.world.item.ItemStack item = this.getResultInventory().a(index);
            return item.b() ? null : CraftItemStack.asCraftMirror(item);
        }
        net.minecraft.world.item.ItemStack item = this.getMatrixInventory().a(index - this.getResultInventory().b());
        return item.b() ? null : CraftItemStack.asCraftMirror(item);
    }

    @Override
    public void setItem(int index, ItemStack item) {
        if (index < this.getResultInventory().b()) {
            this.getResultInventory().a(index, CraftItemStack.asNMSCopy(item));
        } else {
            this.getMatrixInventory().a(index - this.getResultInventory().b(), CraftItemStack.asNMSCopy(item));
        }
    }

    public ItemStack[] getMatrix() {
        List<net.minecraft.world.item.ItemStack> matrix = this.getMatrixInventory().getContents();
        return this.asCraftMirror(matrix);
    }

    public ItemStack getResult() {
        net.minecraft.world.item.ItemStack item = this.getResultInventory().a(0);
        if (!item.b()) {
            return CraftItemStack.asCraftMirror(item);
        }
        return null;
    }

    public void setMatrix(ItemStack[] contents) {
        if (this.getMatrixInventory().b() > contents.length) {
            throw new IllegalArgumentException("Invalid inventory size; expected " + this.getMatrixInventory().b() + " or less");
        }
        for (int i2 = 0; i2 < this.getMatrixInventory().b(); ++i2) {
            if (i2 < contents.length) {
                this.getMatrixInventory().a(i2, CraftItemStack.asNMSCopy(contents[i2]));
                continue;
            }
            this.getMatrixInventory().a(i2, net.minecraft.world.item.ItemStack.b);
        }
    }

    public void setResult(ItemStack item) {
        List<net.minecraft.world.item.ItemStack> contents = this.getResultInventory().getContents();
        contents.set(0, CraftItemStack.asNMSCopy(item));
    }

    public Recipe getRecipe() {
        IRecipe recipe = this.getInventory().getCurrentRecipe();
        return recipe == null ? null : recipe.toBukkitRecipe();
    }
}

