/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.generator;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.IRegistry;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlock;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;

public class CustomWorldChunkManager
extends WorldChunkManager {
    private final WorldInfo worldInfo;
    private final BiomeProvider biomeProvider;
    private final IRegistry<BiomeBase> registry;

    private static List<BiomeBase> biomeListToBiomeBaseList(List<Biome> biomes, IRegistry<BiomeBase> registry) {
        ArrayList<BiomeBase> biomeBases = new ArrayList<BiomeBase>();
        for (Biome biome : biomes) {
            Preconditions.checkArgument((biome != Biome.CUSTOM ? 1 : 0) != 0, (String)"Cannot use the biome %s", (Object)biome);
            biomeBases.add(CraftBlock.biomeToBiomeBase(registry, biome));
        }
        return biomeBases;
    }

    public CustomWorldChunkManager(WorldInfo worldInfo, BiomeProvider biomeProvider, IRegistry<BiomeBase> registry) {
        super(CustomWorldChunkManager.biomeListToBiomeBaseList(biomeProvider.getBiomes(worldInfo), registry));
        this.worldInfo = worldInfo;
        this.biomeProvider = biomeProvider;
        this.registry = registry;
    }

    @Override
    protected Codec<? extends WorldChunkManager> a() {
        throw new UnsupportedOperationException("Cannot serialize CustomWorldChunkManager");
    }

    @Override
    public WorldChunkManager a(long seed) {
        throw new UnsupportedOperationException("Cannot copy CustomWorldChunkManager");
    }

    @Override
    public BiomeBase getNoiseBiome(int x2, int y2, int z2, Climate.Sampler noise) {
        Biome biome = this.biomeProvider.getBiome(this.worldInfo, x2 << 2, y2 << 2, z2 << 2);
        Preconditions.checkArgument((biome != Biome.CUSTOM ? 1 : 0) != 0, (String)"Cannot set the biome to %s", (Object)biome);
        return CraftBlock.biomeToBiomeBase(this.registry, biome);
    }
}

