/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.generator;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.IRegistry;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.WorldDataServer;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R1.util.WorldUUID;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;

public class CraftWorldInfo
implements WorldInfo {
    private final String name;
    private final UUID uuid;
    private final World.Environment environment;
    private final long seed;
    private final int minHeight;
    private final int maxHeight;
    private final ChunkGenerator vanillaChunkGenerator;
    private final IRegistry<BiomeBase> biomeRegistry;

    public CraftWorldInfo(IWorldDataServer worldDataServer, Convertable.ConversionSession session, World.Environment environment, DimensionManager dimensionManager) {
        this(worldDataServer, session, environment, dimensionManager, null, null);
    }

    public CraftWorldInfo(IWorldDataServer worldDataServer, Convertable.ConversionSession session, World.Environment environment, DimensionManager dimensionManager, ChunkGenerator chunkGenerator, IRegistry<BiomeBase> biomeRegistry) {
        this.biomeRegistry = biomeRegistry;
        this.vanillaChunkGenerator = chunkGenerator;
        this.name = worldDataServer.g();
        this.uuid = WorldUUID.getUUID(session.c.toFile());
        this.environment = environment;
        this.seed = ((WorldDataServer)worldDataServer).A().a();
        this.minHeight = dimensionManager.k();
        this.maxHeight = dimensionManager.k() + dimensionManager.l();
    }

    public CraftWorldInfo(String name, UUID uuid, World.Environment environment, long seed, int minHeight, int maxHeight) {
        this.vanillaChunkGenerator = null;
        this.biomeRegistry = null;
        this.name = name;
        this.uuid = uuid;
        this.environment = environment;
        this.seed = seed;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    public String getName() {
        return this.name;
    }

    public UUID getUID() {
        return this.uuid;
    }

    public World.Environment getEnvironment() {
        return this.environment;
    }

    public long getSeed() {
        return this.seed;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public BiomeProvider vanillaBiomeProvider() {
        final List<Biome> possibleBiomes = this.vanillaChunkGenerator.e().b().stream().map(biome -> CraftBlock.biomeBaseToBiome(this.biomeRegistry, biome)).toList();
        return new BiomeProvider(){

            public Biome getBiome(WorldInfo worldInfo, int x2, int y2, int z2) {
                return CraftBlock.biomeBaseToBiome(CraftWorldInfo.this.biomeRegistry, CraftWorldInfo.this.vanillaChunkGenerator.getNoiseBiome(x2 >> 2, y2 >> 2, z2 >> 2));
            }

            public List<Biome> getBiomes(WorldInfo worldInfo) {
                return possibleBiomes;
            }
        };
    }
}

