/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.generator;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_18_R1.CraftRegionAccessor;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_18_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMetaBlockState;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Consumer;

public class CraftLimitedRegion
extends CraftRegionAccessor
implements LimitedRegion {
    private final WeakReference<GeneratorAccessSeed> weakAccess;
    private final int centerChunkX;
    private final int centerChunkZ;
    private final int buffer = 16;
    private final BoundingBox region;
    private final List<net.minecraft.world.entity.Entity> entities = new ArrayList<net.minecraft.world.entity.Entity>();

    public CraftLimitedRegion(GeneratorAccessSeed access, ChunkCoordIntPair center) {
        this.weakAccess = new WeakReference<GeneratorAccessSeed>(access);
        this.centerChunkX = center.c;
        this.centerChunkZ = center.d;
        for (int x2 = -(this.buffer >> 4); x2 <= this.buffer >> 4; ++x2) {
            for (int z2 = -(this.buffer >> 4); z2 <= this.buffer >> 4; ++z2) {
                ProtoChunk chunk = (ProtoChunk)access.a(this.centerChunkX + x2, this.centerChunkZ + z2);
                for (NBTTagCompound compound : chunk.D()) {
                    EntityTypes.a(compound, access.getMinecraftWorld(), entity -> {
                        entity.generation = true;
                        this.entities.add((net.minecraft.world.entity.Entity)entity);
                        return entity;
                    });
                }
            }
        }
        CraftWorld world = access.getMinecraftWorld().getWorld();
        int xCenter = this.centerChunkX << 4;
        int zCenter = this.centerChunkZ << 4;
        int xMin = xCenter - this.getBuffer();
        int zMin = zCenter - this.getBuffer();
        int xMax = xCenter + this.getBuffer() + 16;
        int zMax = zCenter + this.getBuffer() + 16;
        this.region = new BoundingBox((double)xMin, (double)world.getMinHeight(), (double)zMin, (double)xMax, (double)world.getMaxHeight(), (double)zMax);
    }

    @Override
    public GeneratorAccessSeed getHandle() {
        GeneratorAccessSeed handle = (GeneratorAccessSeed)this.weakAccess.get();
        if (handle == null) {
            throw new IllegalStateException("GeneratorAccessSeed no longer present, are you using it in a different tick?");
        }
        return handle;
    }

    public void saveEntities() {
        GeneratorAccessSeed access = this.getHandle();
        for (int x2 = -(this.buffer >> 4); x2 <= this.buffer >> 4; ++x2) {
            for (int z2 = -(this.buffer >> 4); z2 <= this.buffer >> 4; ++z2) {
                ProtoChunk chunk = (ProtoChunk)access.a(this.centerChunkX + x2, this.centerChunkZ + z2);
                chunk.D().clear();
            }
        }
        for (net.minecraft.world.entity.Entity entity : this.entities) {
            if (!entity.bl()) continue;
            Preconditions.checkState((boolean)this.region.contains(entity.dc(), entity.de(), entity.di()), (String)"Entity %s is not in the region", (Object)entity);
            access.b(entity);
        }
    }

    public void breakLink() {
        this.weakAccess.clear();
    }

    public int getBuffer() {
        return this.buffer;
    }

    public boolean isInRegion(Location location) {
        return this.region.contains(location.getX(), location.getY(), location.getZ());
    }

    public boolean isInRegion(int x2, int y2, int z2) {
        return this.region.contains((double)x2, (double)y2, (double)z2);
    }

    public List<BlockState> getTileEntities() {
        ArrayList<BlockState> blockStates = new ArrayList<BlockState>();
        for (int x2 = -(this.buffer >> 4); x2 <= this.buffer >> 4; ++x2) {
            for (int z2 = -(this.buffer >> 4); z2 <= this.buffer >> 4; ++z2) {
                ProtoChunk chunk = (ProtoChunk)this.getHandle().a(this.centerChunkX + x2, this.centerChunkZ + z2);
                for (BlockPosition position : chunk.c()) {
                    blockStates.add(this.getBlockState(position.u(), position.v(), position.w()));
                }
            }
        }
        return blockStates;
    }

    @Override
    public Biome getBiome(int x2, int y2, int z2) {
        Preconditions.checkArgument((boolean)this.isInRegion(x2, y2, z2), (String)"Coordinates %s, %s, %s are not in the region", (Object)x2, (Object)y2, (Object)z2);
        return super.getBiome(x2, y2, z2);
    }

    @Override
    public void setBiome(int x2, int y2, int z2, BiomeBase biomeBase) {
        Preconditions.checkArgument((boolean)this.isInRegion(x2, y2, z2), (String)"Coordinates %s, %s, %s are not in the region", (Object)x2, (Object)y2, (Object)z2);
        IChunkAccess chunk = this.getHandle().a(x2 >> 4, z2 >> 4, ChunkStatus.c);
        chunk.setBiome(x2 >> 2, y2 >> 2, z2 >> 2, biomeBase);
    }

    @Override
    public BlockState getBlockState(int x2, int y2, int z2) {
        Preconditions.checkArgument((boolean)this.isInRegion(x2, y2, z2), (String)"Coordinates %s, %s, %s are not in the region", (Object)x2, (Object)y2, (Object)z2);
        TileEntity entity = this.getHandle().c_(new BlockPosition(x2, y2, z2));
        return CraftMetaBlockState.createBlockState(entity.q().getBukkitMaterial(), entity.m());
    }

    @Override
    public BlockData getBlockData(int x2, int y2, int z2) {
        Preconditions.checkArgument((boolean)this.isInRegion(x2, y2, z2), (String)"Coordinates %s, %s, %s are not in the region", (Object)x2, (Object)y2, (Object)z2);
        return super.getBlockData(x2, y2, z2);
    }

    @Override
    public Material getType(int x2, int y2, int z2) {
        Preconditions.checkArgument((boolean)this.isInRegion(x2, y2, z2), (String)"Coordinates %s, %s, %s are not in the region", (Object)x2, (Object)y2, (Object)z2);
        return super.getType(x2, y2, z2);
    }

    @Override
    public void setBlockData(int x2, int y2, int z2, BlockData blockData) {
        Preconditions.checkArgument((boolean)this.isInRegion(x2, y2, z2), (String)"Coordinates %s, %s, %s are not in the region", (Object)x2, (Object)y2, (Object)z2);
        this.getHandle().a(new BlockPosition(x2, y2, z2), ((CraftBlockData)blockData).getState(), 3);
    }

    @Override
    public boolean generateTree(Location location, Random random, TreeType treeType) {
        Preconditions.checkArgument((boolean)this.isInRegion(location), (String)"Coordinates %s, %s, %s are not in the region", (Object)location.getBlockX(), (Object)location.getBlockY(), (Object)location.getBlockZ());
        return super.generateTree(location, random, treeType);
    }

    @Override
    public boolean generateTree(Location location, Random random, TreeType treeType, Consumer<BlockState> consumer) {
        Preconditions.checkArgument((boolean)this.isInRegion(location), (String)"Coordinates %s, %s, %s are not in the region", (Object)location.getBlockX(), (Object)location.getBlockY(), (Object)location.getBlockZ());
        return super.generateTree(location, random, treeType, consumer);
    }

    public Collection<net.minecraft.world.entity.Entity> getNMSEntities() {
        return new ArrayList<net.minecraft.world.entity.Entity>(this.entities);
    }

    @Override
    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<T> function, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        Preconditions.checkArgument((boolean)this.isInRegion(location), (String)"Coordinates %s, %s, %s are not in the region", (Object)location.getBlockX(), (Object)location.getBlockY(), (Object)location.getBlockZ());
        return super.spawn(location, clazz, function, reason);
    }

    @Override
    public void addEntityToWorld(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        this.entities.add(entity);
    }

    public void setBlockState(int x2, int y2, int z2, BlockState state) {
        BlockPosition pos = new BlockPosition(x2, y2, z2);
        if (!state.getBlockData().matches((BlockData)this.getHandle().a_(pos).createCraftBlockData())) {
            throw new IllegalArgumentException("BlockData does not match! Expected " + state.getBlockData().getAsString(false) + ", got " + this.getHandle().a_(pos).createCraftBlockData().getAsString(false));
        }
        this.getHandle().c_(pos).a(((CraftBlockEntityState)state).getSnapshotNBT());
    }

    public void scheduleBlockUpdate(int x2, int y2, int z2) {
        BlockPosition position = new BlockPosition(x2, y2, z2);
        this.getHandle().a(position, this.getHandle().getBlockIfLoaded(position), 0);
    }

    public void scheduleFluidUpdate(int x2, int y2, int z2) {
        BlockPosition position = new BlockPosition(x2, y2, z2);
        this.getHandle().a(position, this.getHandle().b_(position).a(), 0);
    }

    public World getWorld() {
        return this.getHandle().getMinecraftWorld().getWorld();
    }

    public int getCenterChunkX() {
        return this.centerChunkX;
    }

    public int getCenterChunkZ() {
        return this.centerChunkZ;
    }
}

