/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.entity;

import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.PaperSkinParts;
import com.destroystokyo.paper.Title;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import io.papermc.paper.adventure.DisplayNames;
import io.papermc.paper.adventure.PaperAdventure;
import it.unimi.dsi.fastutil.shorts.Short2ObjectArrayMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.bossbar.HackyBossBarPlatformBridge;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.permission.PermissionChecker;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.title.TitlePart;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutChat;
import net.minecraft.network.protocol.game.PacketPlayOutCustomPayload;
import net.minecraft.network.protocol.game.PacketPlayOutCustomSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutMultiBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerListHeaderFooter;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutStopSound;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateAttributes;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.WhiteListEntry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.Validate;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Note;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationCanceller;
import org.bukkit.conversations.ManuallyAbandonedConversationCanceller;
import org.bukkit.craftbukkit.v1_18_R1.CraftEffect;
import org.bukkit.craftbukkit.v1_18_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_18_R1.CraftOfflinePlayer;
import org.bukkit.craftbukkit.v1_18_R1.CraftParticle;
import org.bukkit.craftbukkit.v1_18_R1.CraftServer;
import org.bukkit.craftbukkit.v1_18_R1.CraftSound;
import org.bukkit.craftbukkit.v1_18_R1.CraftStatistic;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R1.advancement.CraftAdvancement;
import org.bukkit.craftbukkit.v1_18_R1.advancement.CraftAdvancementProgress;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftSign;
import org.bukkit.craftbukkit.v1_18_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_18_R1.conversations.ConversationTracker;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R1.map.CraftMapView;
import org.bukkit.craftbukkit.v1_18_R1.map.RenderData;
import org.bukkit.craftbukkit.v1_18_R1.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerItemMendEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerRegisterChannelEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerUnregisterChannelEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryView;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;
import org.spigotmc.AsyncCatcher;

@DelegateDeserialization(value=CraftOfflinePlayer.class)
public class CraftPlayer
extends CraftHumanEntity
implements Player {
    private long firstPlayed = 0L;
    private long lastPlayed = 0L;
    private boolean hasPlayedBefore = false;
    private final ConversationTracker conversationTracker = new ConversationTracker();
    private final Set<String> channels = new HashSet<String>();
    private final Map<UUID, Set<WeakReference<Plugin>>> hiddenEntities = new HashMap<UUID, Set<WeakReference<Plugin>>>();
    private static final WeakHashMap<Plugin, WeakReference<Plugin>> pluginWeakReferences = new WeakHashMap();
    private int hash = 0;
    private double health = 20.0;
    private boolean scaledHealth = false;
    private double healthScale = 20.0;
    private PlayerResourcePackStatusEvent.Status resourcePackStatus;
    private String resourcePackHash;
    private static final boolean DISABLE_CHANNEL_LIMIT = System.getProperty("paper.disableChannelLimit") != null;
    private long lastSaveTime;
    private Component playerListHeader;
    private Component playerListFooter;
    private final Player.Spigot spigot = new Player.Spigot(){

        public InetSocketAddress getRawAddress() {
            return (InetSocketAddress)CraftPlayer.this.getHandle().b.a.getRawAddress();
        }

        public boolean getCollidesWithEntities() {
            return CraftPlayer.this.isCollidable();
        }

        public void setCollidesWithEntities(boolean collides) {
            CraftPlayer.this.setCollidable(collides);
        }

        public void respawn() {
            if (CraftPlayer.this.getHealth() <= 0.0 && CraftPlayer.this.isOnline()) {
                CraftPlayer.this.server.getServer().bg().a(CraftPlayer.this.getHandle(), false);
            }
        }

        public Set<Player> getHiddenPlayers() {
            HashSet<Player> ret = new HashSet<Player>();
            for (UUID u2 : CraftPlayer.this.hiddenEntities.keySet()) {
                Player p2 = CraftPlayer.this.getServer().getPlayer(u2);
                if (p2 == null) continue;
                ret.add(p2);
            }
            return Collections.unmodifiableSet(ret);
        }

        public void sendMessage(BaseComponent component) {
            this.sendMessage(new BaseComponent[]{component});
        }

        public void sendMessage(BaseComponent ... components) {
            if (CraftPlayer.this.getHandle().b == null) {
                return;
            }
            PacketPlayOutChat packet = new PacketPlayOutChat(null, net.minecraft.network.chat.ChatMessageType.b, SystemUtils.b);
            packet.components = components;
            CraftPlayer.this.getHandle().b.a(packet);
        }

        public void sendMessage(UUID sender, BaseComponent component) {
            this.sendMessage(ChatMessageType.CHAT, sender, component);
        }

        public void sendMessage(UUID sender, BaseComponent ... components) {
            this.sendMessage(ChatMessageType.CHAT, sender, components);
        }

        public void sendMessage(ChatMessageType position, BaseComponent component) {
            this.sendMessage(position, new BaseComponent[]{component});
        }

        public void sendMessage(ChatMessageType position, BaseComponent ... components) {
            if (CraftPlayer.this.getHandle().b == null) {
                return;
            }
            PacketPlayOutChat packet = new PacketPlayOutChat(null, net.minecraft.network.chat.ChatMessageType.a((byte)position.ordinal()), SystemUtils.b);
            packet.components = components;
            CraftPlayer.this.getHandle().b.a(packet);
        }

        public void sendMessage(ChatMessageType position, UUID sender, BaseComponent component) {
            this.sendMessage(position, sender, new BaseComponent[]{component});
        }

        public void sendMessage(ChatMessageType position, UUID sender, BaseComponent ... components) {
            if (CraftPlayer.this.getHandle().b == null) {
                return;
            }
            PacketPlayOutChat packet = new PacketPlayOutChat(null, net.minecraft.network.chat.ChatMessageType.a((byte)position.ordinal()), sender == null ? SystemUtils.b : sender);
            packet.components = components;
            CraftPlayer.this.getHandle().b.a(packet);
        }

        public int getPing() {
            return CraftPlayer.this.getHandle().e;
        }
    };

    public CraftPlayer(CraftServer server, EntityPlayer entity) {
        super(server, entity);
        this.firstPlayed = System.currentTimeMillis();
    }

    public GameProfile getProfile() {
        return this.getHandle().fp();
    }

    @Override
    public boolean isOp() {
        return this.server.getHandle().f(this.getProfile());
    }

    @Override
    public void setOp(boolean value) {
        if (value == this.isOp()) {
            return;
        }
        if (value) {
            this.server.getHandle().a(this.getProfile());
        } else {
            this.server.getHandle().b(this.getProfile());
        }
        this.perm.recalculatePermissions();
    }

    public boolean isOnline() {
        return this.server.getPlayer(this.getUniqueId()) != null;
    }

    public InetSocketAddress getAddress() {
        if (this.getHandle().b == null) {
            return null;
        }
        SocketAddress addr = this.getHandle().b.a.c();
        if (addr instanceof InetSocketAddress) {
            return (InetSocketAddress)addr;
        }
        return null;
    }

    public int getProtocolVersion() {
        if (this.getHandle().b == null) {
            return -1;
        }
        return this.getHandle().b.a.protocolVersion;
    }

    public InetSocketAddress getVirtualHost() {
        if (this.getHandle().b == null) {
            return null;
        }
        return this.getHandle().b.a.virtualHost;
    }

    @Override
    public double getEyeHeight(boolean ignorePose) {
        if (ignorePose) {
            return 1.62;
        }
        return this.getEyeHeight();
    }

    public void sendRawMessage(String message) {
        if (this.getHandle().b == null) {
            return;
        }
        for (IChatBaseComponent component : CraftChatMessage.fromString(message)) {
            this.getHandle().b.a(new PacketPlayOutChat(component, net.minecraft.network.chat.ChatMessageType.b, SystemUtils.b));
        }
    }

    public void sendRawMessage(UUID sender, String message) {
        if (this.getHandle().b == null) {
            return;
        }
        for (IChatBaseComponent component : CraftChatMessage.fromString(message)) {
            this.getHandle().b.a(new PacketPlayOutChat(component, net.minecraft.network.chat.ChatMessageType.a, sender == null ? SystemUtils.b : sender));
        }
    }

    @Override
    public void sendMessage(String message) {
        if (!this.conversationTracker.isConversingModaly()) {
            this.sendRawMessage(message);
        }
    }

    @Override
    public void sendMessage(String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    @Override
    public void sendMessage(UUID sender, String message) {
        if (!this.conversationTracker.isConversingModaly()) {
            this.sendRawMessage(sender, message);
        }
    }

    @Override
    public void sendMessage(UUID sender, String ... messages) {
        for (String message : messages) {
            this.sendMessage(sender, message);
        }
    }

    public void sendActionBar(BaseComponent[] message) {
        if (this.getHandle().b == null) {
            return;
        }
        ClientboundSetActionBarTextPacket packet = new ClientboundSetActionBarTextPacket((IChatBaseComponent)null);
        packet.components = message;
        this.getHandle().b.a(packet);
    }

    public void sendActionBar(String message) {
        if (this.getHandle().b == null || message == null || message.isEmpty()) {
            return;
        }
        this.getHandle().b.a(new ClientboundSetActionBarTextPacket(CraftChatMessage.fromStringOrNull(message)));
    }

    public void sendActionBar(char alternateChar, String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        this.sendActionBar(ChatColor.translateAlternateColorCodes((char)alternateChar, (String)message));
    }

    public void setPlayerListHeaderFooter(BaseComponent[] header, BaseComponent[] footer) {
        if (header != null) {
            String headerJson = ComponentSerializer.toString((BaseComponent[])header);
            this.playerListHeader = GsonComponentSerializer.gson().deserialize((Object)headerJson);
        } else {
            this.playerListHeader = null;
        }
        if (footer != null) {
            String footerJson = ComponentSerializer.toString((BaseComponent[])footer);
            this.playerListFooter = GsonComponentSerializer.gson().deserialize((Object)footerJson);
        } else {
            this.playerListFooter = null;
        }
        this.updatePlayerListHeaderFooter();
    }

    public void setPlayerListHeaderFooter(BaseComponent header, BaseComponent footer) {
        BaseComponent[] baseComponentArray;
        BaseComponent[] baseComponentArray2;
        if (header == null) {
            baseComponentArray2 = null;
        } else {
            BaseComponent[] baseComponentArray3 = new BaseComponent[1];
            baseComponentArray2 = baseComponentArray3;
            baseComponentArray3[0] = header;
        }
        if (footer == null) {
            baseComponentArray = null;
        } else {
            BaseComponent[] baseComponentArray4 = new BaseComponent[1];
            baseComponentArray = baseComponentArray4;
            baseComponentArray4[0] = footer;
        }
        this.setPlayerListHeaderFooter(baseComponentArray2, baseComponentArray);
    }

    public void setTitleTimes(int fadeInTicks, int stayTicks, int fadeOutTicks) {
        this.getHandle().b.a(new ClientboundSetTitlesAnimationPacket(fadeInTicks, stayTicks, fadeOutTicks));
    }

    public void setSubtitle(BaseComponent[] subtitle) {
        ClientboundSetSubtitleTextPacket packet = new ClientboundSetSubtitleTextPacket((IChatBaseComponent)null);
        packet.components = subtitle;
        this.getHandle().b.a(packet);
    }

    public void setSubtitle(BaseComponent subtitle) {
        this.setSubtitle(new BaseComponent[]{subtitle});
    }

    public void showTitle(BaseComponent[] title) {
        ClientboundSetTitleTextPacket packet = new ClientboundSetTitleTextPacket((IChatBaseComponent)null);
        packet.components = title;
        this.getHandle().b.a(packet);
    }

    public void showTitle(BaseComponent title) {
        this.showTitle(new BaseComponent[]{title});
    }

    public void showTitle(BaseComponent[] title, BaseComponent[] subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        this.setTitleTimes(fadeInTicks, stayTicks, fadeOutTicks);
        this.setSubtitle(subtitle);
        this.showTitle(title);
    }

    public void showTitle(BaseComponent title, BaseComponent subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        this.setTitleTimes(fadeInTicks, stayTicks, fadeOutTicks);
        this.setSubtitle(subtitle);
        this.showTitle(title);
    }

    public void sendTitle(Title title) {
        Preconditions.checkNotNull((Object)title, (Object)"Title is null");
        this.setTitleTimes(title.getFadeIn(), title.getStay(), title.getFadeOut());
        this.setSubtitle(title.getSubtitle() == null ? new BaseComponent[]{} : title.getSubtitle());
        this.showTitle(title.getTitle());
    }

    public void updateTitle(Title title) {
        Preconditions.checkNotNull((Object)title, (Object)"Title is null");
        this.setTitleTimes(title.getFadeIn(), title.getStay(), title.getFadeOut());
        if (title.getSubtitle() != null) {
            this.setSubtitle(title.getSubtitle());
        }
        this.showTitle(title.getTitle());
    }

    public void hideTitle() {
        this.getHandle().b.a(new ClientboundClearTitlesPacket(false));
    }

    public String getDisplayName() {
        return DisplayNames.getLegacy(this);
    }

    public void setDisplayName(String name) {
        this.getHandle().adventure$displayName = name != null ? PaperAdventure.LEGACY_SECTION_UXRC.deserialize(name) : Component.text((String)this.getName());
        this.getHandle().displayName = name == null ? this.getName() : name;
    }

    public void playerListName(Component name) {
        this.getHandle().listName = name == null ? null : PaperAdventure.asVanilla(name);
        for (EntityPlayer player : this.server.getHandle().j) {
            if (!player.getBukkitEntity().canSee(this)) continue;
            player.b.a(new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.d, this.getHandle()));
        }
    }

    public Component playerListName() {
        return this.getHandle().listName == null ? Component.text((String)this.getName()) : PaperAdventure.asAdventure(this.getHandle().listName);
    }

    public Component playerListHeader() {
        return this.playerListHeader;
    }

    public Component playerListFooter() {
        return this.playerListFooter;
    }

    public String getPlayerListName() {
        return this.getHandle().listName == null ? this.getName() : CraftChatMessage.fromComponent(this.getHandle().listName);
    }

    public void setPlayerListName(String name) {
        if (name == null) {
            name = this.getName();
        }
        this.getHandle().listName = name.equals(this.getName()) ? null : CraftChatMessage.fromStringOrNull(name);
        for (EntityPlayer player : this.server.getHandle().j) {
            if (!player.getBukkitEntity().canSee(this)) continue;
            player.b.a(new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.d, this.getHandle()));
        }
    }

    public String getPlayerListHeader() {
        return this.playerListHeader == null ? null : PaperAdventure.LEGACY_SECTION_UXRC.serialize(this.playerListHeader);
    }

    public String getPlayerListFooter() {
        return this.playerListFooter == null ? null : PaperAdventure.LEGACY_SECTION_UXRC.serialize(this.playerListFooter);
    }

    public void setPlayerListHeader(String header) {
        this.playerListHeader = header == null ? null : PaperAdventure.LEGACY_SECTION_UXRC.deserialize(header);
        this.updatePlayerListHeaderFooter();
    }

    public void setPlayerListFooter(String footer) {
        this.playerListFooter = footer == null ? null : PaperAdventure.LEGACY_SECTION_UXRC.deserialize(footer);
        this.updatePlayerListHeaderFooter();
    }

    public void setPlayerListHeaderFooter(String header, String footer) {
        this.playerListHeader = header == null ? null : PaperAdventure.LEGACY_SECTION_UXRC.deserialize(header);
        this.playerListFooter = footer == null ? null : PaperAdventure.LEGACY_SECTION_UXRC.deserialize(footer);
        this.updatePlayerListHeaderFooter();
    }

    private void updatePlayerListHeaderFooter() {
        if (this.getHandle().b == null) {
            return;
        }
        PacketPlayOutPlayerListHeaderFooter packet = new PacketPlayOutPlayerListHeaderFooter(this.playerListHeader == null ? new ChatComponentText("") : PaperAdventure.asVanilla(this.playerListHeader), this.playerListFooter == null ? new ChatComponentText("") : PaperAdventure.asVanilla(this.playerListFooter));
        this.getHandle().b.a(packet);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OfflinePlayer)) {
            return false;
        }
        OfflinePlayer other = (OfflinePlayer)obj;
        if (this.getUniqueId() == null || other.getUniqueId() == null) {
            return false;
        }
        boolean uuidEquals = this.getUniqueId().equals(other.getUniqueId());
        boolean idEquals = true;
        if (other instanceof CraftPlayer) {
            idEquals = this.getEntityId() == ((CraftPlayer)other).getEntityId();
        }
        return uuidEquals && idEquals;
    }

    public void kickPlayer(String message) {
        AsyncCatcher.catchOp("player kick");
        if (this.getHandle().b == null) {
            return;
        }
        this.getHandle().b.disconnect(message == null ? "" : message, PlayerKickEvent.Cause.PLUGIN);
    }

    public void kick(Component message) {
        this.kick(message, PlayerKickEvent.Cause.PLUGIN);
    }

    public void kick(Component message, PlayerKickEvent.Cause cause) {
        AsyncCatcher.catchOp("player kick");
        PlayerConnection connection = this.getHandle().b;
        if (connection != null) {
            connection.disconnect((Component)(message == null ? Component.empty() : message), cause);
        }
    }

    public int getViewDistance() {
        throw new NotImplementedException("Per-Player View Distance APIs need further understanding to properly implement (There are per world view distances though!)");
    }

    public void setViewDistance(int viewDistance) {
        throw new NotImplementedException("Per-Player View Distance APIs need further understanding to properly implement (There are per world view distances though!)");
    }

    public int getNoTickViewDistance() {
        throw new NotImplementedException("Per-Player View Distance APIs need further understanding to properly implement (There are per world view distances though!)");
    }

    public void setNoTickViewDistance(int viewDistance) {
        throw new NotImplementedException("Per-Player View Distance APIs need further understanding to properly implement (There are per world view distances though!)");
    }

    public int getSendViewDistance() {
        throw new NotImplementedException("Per-Player View Distance APIs need further understanding to properly implement (There are per world view distances though!)");
    }

    public void setSendViewDistance(int viewDistance) {
        throw new NotImplementedException("Per-Player View Distance APIs need further understanding to properly implement (There are per world view distances though!)");
    }

    public <T> T getClientOption(ClientOption<T> type) {
        if (ClientOption.SKIN_PARTS.equals(type)) {
            return type.getType().cast(new PaperSkinParts(this.getHandle().ai().a(EntityHuman.bQ).byteValue()));
        }
        if (ClientOption.CHAT_COLORS_ENABLED.equals(type)) {
            return type.getType().cast(this.getHandle().z());
        }
        if (ClientOption.CHAT_VISIBILITY.equals(type)) {
            return type.getType().cast(this.getHandle().A() == null ? ClientOption.ChatVisibility.UNKNOWN : ClientOption.ChatVisibility.valueOf((String)this.getHandle().A().name()));
        }
        if (ClientOption.LOCALE.equals(type)) {
            return type.getType().cast(this.getLocale());
        }
        if (ClientOption.MAIN_HAND.equals(type)) {
            return type.getType().cast(this.getMainHand());
        }
        if (ClientOption.VIEW_DISTANCE.equals(type)) {
            return type.getType().cast(this.getClientViewDistance());
        }
        throw new RuntimeException("Unknown settings type");
    }

    public Firework boostElytra(org.bukkit.inventory.ItemStack firework) {
        Validate.isTrue((boolean)this.isGliding(), (String)"Player must be gliding");
        Validate.isTrue((firework != null ? 1 : 0) != 0, (String)"firework == null");
        Validate.isTrue((firework.getType() == Material.FIREWORK_ROCKET ? 1 : 0) != 0, (String)"Firework must be Material.FIREWORK_ROCKET");
        ItemStack item = CraftItemStack.asNMSCopy(firework);
        WorldServer world = ((CraftWorld)this.getWorld()).getHandle();
        EntityFireworks entity = new EntityFireworks(world, item, this.getHandle());
        return world.b(entity) ? (Firework)entity.getBukkitEntity() : null;
    }

    public void sendOpLevel(byte level) {
        Preconditions.checkArgument((level >= 0 && level <= 4 ? 1 : 0) != 0, (Object)"Level must be within [0, 4]");
        this.getHandle().cB().ac().sendPlayerPermissionLevel(this.getHandle(), level, false);
    }

    public void setCompassTarget(Location loc) {
        if (this.getHandle().b == null) {
            return;
        }
        this.getHandle().b.a(new PacketPlayOutSpawnPosition(new BlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()), loc.getYaw()));
    }

    public Location getCompassTarget() {
        return this.getHandle().compassTarget;
    }

    public void chat(String msg) {
        if (this.getHandle().b == null) {
            return;
        }
        this.getHandle().b.chat(msg, false);
    }

    public boolean performCommand(String command) {
        return this.server.dispatchCommand((CommandSender)this, command);
    }

    public void playNote(Location loc, byte instrument, byte note) {
        if (this.getHandle().b == null) {
            return;
        }
        String instrumentName = null;
        switch (instrument) {
            case 0: {
                instrumentName = "harp";
                break;
            }
            case 1: {
                instrumentName = "basedrum";
                break;
            }
            case 2: {
                instrumentName = "snare";
                break;
            }
            case 3: {
                instrumentName = "hat";
                break;
            }
            case 4: {
                instrumentName = "bass";
                break;
            }
            case 5: {
                instrumentName = "flute";
                break;
            }
            case 6: {
                instrumentName = "bell";
                break;
            }
            case 7: {
                instrumentName = "guitar";
                break;
            }
            case 8: {
                instrumentName = "chime";
                break;
            }
            case 9: {
                instrumentName = "xylophone";
            }
        }
        float f2 = (float)Math.pow(2.0, ((double)note - 12.0) / 12.0);
        this.getHandle().b.a(new PacketPlayOutNamedSoundEffect(CraftSound.getSoundEffect("block.note_block." + instrumentName), net.minecraft.sounds.SoundCategory.c, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), 3.0f, f2));
    }

    public void playNote(Location loc, Instrument instrument, Note note) {
        if (this.getHandle().b == null) {
            return;
        }
        String instrumentName = null;
        switch (instrument.ordinal()) {
            case 0: {
                instrumentName = "harp";
                break;
            }
            case 1: {
                instrumentName = "basedrum";
                break;
            }
            case 2: {
                instrumentName = "snare";
                break;
            }
            case 3: {
                instrumentName = "hat";
                break;
            }
            case 4: {
                instrumentName = "bass";
                break;
            }
            case 5: {
                instrumentName = "flute";
                break;
            }
            case 6: {
                instrumentName = "bell";
                break;
            }
            case 7: {
                instrumentName = "guitar";
                break;
            }
            case 8: {
                instrumentName = "chime";
                break;
            }
            case 9: {
                instrumentName = "xylophone";
                break;
            }
            case 10: {
                instrumentName = "iron_xylophone";
                break;
            }
            case 11: {
                instrumentName = "cow_bell";
                break;
            }
            case 12: {
                instrumentName = "didgeridoo";
                break;
            }
            case 13: {
                instrumentName = "bit";
                break;
            }
            case 14: {
                instrumentName = "banjo";
                break;
            }
            case 15: {
                instrumentName = "pling";
                break;
            }
            case 16: {
                instrumentName = "xylophone";
            }
        }
        float f2 = (float)Math.pow(2.0, ((double)note.getId() - 12.0) / 12.0);
        this.getHandle().b.a(new PacketPlayOutNamedSoundEffect(CraftSound.getSoundEffect("block.note_block." + instrumentName), net.minecraft.sounds.SoundCategory.c, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), 3.0f, f2));
    }

    public void playSound(Location loc, Sound sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location loc, String sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch) {
        if (loc == null || sound == null || category == null || this.getHandle().b == null) {
            return;
        }
        PacketPlayOutNamedSoundEffect packet = new PacketPlayOutNamedSoundEffect(CraftSound.getSoundEffect(sound), net.minecraft.sounds.SoundCategory.valueOf(category.name()), loc.getX(), loc.getY(), loc.getZ(), volume, pitch);
        this.getHandle().b.a(packet);
    }

    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch) {
        if (loc == null || sound == null || category == null || this.getHandle().b == null) {
            return;
        }
        PacketPlayOutCustomSoundEffect packet = new PacketPlayOutCustomSoundEffect(new MinecraftKey(sound), net.minecraft.sounds.SoundCategory.valueOf(category.name()), new Vec3D(loc.getX(), loc.getY(), loc.getZ()), volume, pitch);
        this.getHandle().b.a(packet);
    }

    public void playSound(Entity entity, Sound sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch) {
        CraftEntity craftEntity;
        block3: {
            block2: {
                if (!(entity instanceof CraftEntity)) break block2;
                craftEntity = (CraftEntity)entity;
                if (sound != null && category != null && this.getHandle().b != null) break block3;
            }
            return;
        }
        PacketPlayOutEntitySound packet = new PacketPlayOutEntitySound(CraftSound.getSoundEffect(sound), net.minecraft.sounds.SoundCategory.valueOf(category.name()), craftEntity.getHandle(), volume, pitch);
        this.getHandle().b.a(packet);
    }

    public void stopSound(Sound sound) {
        this.stopSound(sound, null);
    }

    public void stopSound(String sound) {
        this.stopSound(sound, null);
    }

    public void stopSound(Sound sound, SoundCategory category) {
        this.stopSound(sound.getKey().getKey(), category);
    }

    public void stopSound(String sound, SoundCategory category) {
        if (this.getHandle().b == null) {
            return;
        }
        this.getHandle().b.a(new PacketPlayOutStopSound(new MinecraftKey(sound), category == null ? net.minecraft.sounds.SoundCategory.a : net.minecraft.sounds.SoundCategory.valueOf(category.name())));
    }

    public void stopAllSounds() {
        if (this.getHandle().b == null) {
            return;
        }
        this.getHandle().b.a(new PacketPlayOutStopSound(null, null));
    }

    public void playEffect(Location loc, Effect effect, int data) {
        if (this.getHandle().b == null) {
            return;
        }
        int packetData = effect.getId();
        PacketPlayOutWorldEvent packet = new PacketPlayOutWorldEvent(packetData, new BlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()), data, false);
        this.getHandle().b.a(packet);
    }

    public <T> void playEffect(Location loc, Effect effect, T data) {
        if (data != null) {
            Validate.isTrue((effect.getData() != null && effect.getData().isAssignableFrom(data.getClass()) ? 1 : 0) != 0, (String)"Wrong kind of data for this effect!");
        } else {
            Validate.isTrue((effect.getData() == null || effect == Effect.ELECTRIC_SPARK ? 1 : 0) != 0, (String)"Wrong kind of data for this effect!");
        }
        int datavalue = CraftEffect.getDataValue(effect, data);
        this.playEffect(loc, effect, datavalue);
    }

    public boolean breakBlock(Block block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"Block cannot be null");
        Preconditions.checkArgument((boolean)block.getWorld().equals(this.getWorld()), (Object)"Cannot break blocks across worlds");
        return this.getHandle().d.a(new BlockPosition(block.getX(), block.getY(), block.getZ()));
    }

    public void sendBlockChange(Location loc, Material material, byte data) {
        if (this.getHandle().b == null) {
            return;
        }
        PacketPlayOutBlockChange packet = new PacketPlayOutBlockChange(new BlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()), CraftMagicNumbers.getBlock(material, data));
        this.getHandle().b.a(packet);
    }

    public void sendBlockChange(Location loc, BlockData block) {
        if (this.getHandle().b == null) {
            return;
        }
        PacketPlayOutBlockChange packet = new PacketPlayOutBlockChange(new BlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()), ((CraftBlockData)block).getState());
        this.getHandle().b.a(packet);
    }

    public void sendMultiBlockChange(Map<Location, BlockData> blockChanges, boolean suppressLightUpdates) {
        BlockData blockData;
        if (this.getHandle().b == null) {
            return;
        }
        HashMap<SectionPosition, Short2ObjectMap> sectionMap = new HashMap<SectionPosition, Short2ObjectMap>();
        for (Map.Entry<Location, BlockData> entry : blockChanges.entrySet()) {
            Location location = entry.getKey();
            if (!location.getWorld().equals(this.getWorld())) continue;
            blockData = entry.getValue();
            BlockPosition blockPos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            SectionPosition sectionPos = SectionPosition.a(blockPos);
            Short2ObjectMap sectionData = sectionMap.computeIfAbsent(sectionPos, key -> new Short2ObjectArrayMap());
            sectionData.put(SectionPosition.b(blockPos), (Object)((CraftBlockData)blockData).getState());
        }
        for (Map.Entry<Object, Object> entry : sectionMap.entrySet()) {
            SectionPosition sectionPos = (SectionPosition)entry.getKey();
            blockData = (Short2ObjectMap)entry.getValue();
            PacketPlayOutMultiBlockChange packet = new PacketPlayOutMultiBlockChange(sectionPos, (Short2ObjectMap<IBlockData>)blockData, suppressLightUpdates);
            this.getHandle().b.a(packet);
        }
    }

    public void sendBlockDamage(Location loc, float progress) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"loc must not be null");
        Preconditions.checkArgument(((double)progress >= 0.0 && (double)progress <= 1.0 ? 1 : 0) != 0, (Object)"progress must be between 0.0 and 1.0 (inclusive)");
        if (this.getHandle().b == null) {
            return;
        }
        int stage = (int)(9.0f * progress);
        PacketPlayOutBlockBreakAnimation packet = new PacketPlayOutBlockBreakAnimation(this.getHandle().ae(), new BlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()), stage);
        this.getHandle().b.a(packet);
    }

    public void sendSignChange(Location loc, @Nullable List<Component> lines, DyeColor dyeColor, boolean hasGlowingText) {
        if (this.getHandle().b == null) {
            return;
        }
        if (lines == null) {
            lines = new ArrayList<Component>(4);
        }
        Validate.notNull((Object)loc, (String)"Location cannot be null");
        Validate.notNull((Object)dyeColor, (String)"DyeColor cannot be null");
        if (lines.size() < 4) {
            throw new IllegalArgumentException("Must have at least 4 lines");
        }
        IChatBaseComponent[] components = CraftSign.sanitizeLines(lines);
        this.sendSignChange0(components, loc, dyeColor, hasGlowingText);
    }

    private void sendSignChange0(IChatBaseComponent[] components, Location loc, DyeColor dyeColor, boolean hasGlowingText) {
        TileEntitySign sign = new TileEntitySign(new BlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()), Blocks.cg.n());
        sign.a(EnumColor.a(dyeColor.getWoolData()));
        sign.b(hasGlowingText);
        System.arraycopy(components, 0, sign.d, 0, sign.d.length);
        this.getHandle().b.a(sign.c());
    }

    public void sendSignChange(Location loc, String[] lines) {
        this.sendSignChange(loc, lines, DyeColor.BLACK);
    }

    public void sendSignChange(Location loc, String[] lines, DyeColor dyeColor) {
        this.sendSignChange(loc, lines, dyeColor, false);
    }

    public void sendSignChange(Location loc, String[] lines, DyeColor dyeColor, boolean hasGlowingText) {
        if (this.getHandle().b == null) {
            return;
        }
        if (lines == null) {
            lines = new String[4];
        }
        Validate.notNull((Object)loc, (String)"Location can not be null");
        Validate.notNull((Object)dyeColor, (String)"DyeColor can not be null");
        if (lines.length < 4) {
            throw new IllegalArgumentException("Must have at least 4 lines");
        }
        IChatBaseComponent[] components = CraftSign.sanitizeLines(lines);
        this.sendSignChange0(components, loc, dyeColor, hasGlowingText);
    }

    public void sendEquipmentChange(LivingEntity entity, EquipmentSlot slot, org.bukkit.inventory.ItemStack item) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"entity must not be null");
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot must not be null");
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"item must not be null");
        if (this.getHandle().b == null) {
            return;
        }
        List<Pair<EnumItemSlot, ItemStack>> equipment = Arrays.asList(new Pair((Object)CraftEquipmentSlot.getNMS(slot), (Object)CraftItemStack.asNMSCopy(item)));
        this.getHandle().b.a(new PacketPlayOutEntityEquipment(entity.getEntityId(), equipment));
    }

    public void sendMap(MapView map) {
        if (this.getHandle().b == null) {
            return;
        }
        RenderData data = ((CraftMapView)map).render(this);
        ArrayList<MapIcon> icons = new ArrayList<MapIcon>();
        for (MapCursor cursor : data.cursors) {
            if (!cursor.isVisible()) continue;
            icons.add(new MapIcon(MapIcon.Type.a(cursor.getRawType()), cursor.getX(), cursor.getY(), cursor.getDirection(), CraftChatMessage.fromStringOrNull(cursor.getCaption())));
        }
        PacketPlayOutMap packet = new PacketPlayOutMap(map.getId(), map.getScale().getValue(), map.isLocked(), icons, new WorldMap.b(0, 0, 128, 128, data.buffer));
        this.getHandle().b.a(packet);
    }

    @Override
    public void setRotation(float yaw, float pitch) {
        throw new UnsupportedOperationException("Cannot set rotation of players. Consider teleporting instead.");
    }

    @Override
    public CompletableFuture<Boolean> teleportAsync(Location loc, @Nonnull PlayerTeleportEvent.TeleportCause cause) {
        ((CraftWorld)loc.getWorld()).getHandle().k().markAreaHighPriority(new ChunkCoordIntPair(MathHelper.b(loc.getX()) >> 4, MathHelper.b(loc.getZ()) >> 4), 28, 3);
        return super.teleportAsync(loc, cause);
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"location.world");
        location.checkFinite();
        EntityPlayer entity = this.getHandle();
        if (this.getHealth() == 0.0 || entity.do()) {
            return false;
        }
        if (entity.b == null) {
            return false;
        }
        if (entity.bG()) {
            return false;
        }
        Location from = this.getLocation();
        Location to = location;
        PlayerTeleportEvent event = new PlayerTeleportEvent((Player)this, from, to, cause);
        this.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        entity.p();
        if (this.isSleeping()) {
            this.wakeup(false);
        }
        from = event.getFrom();
        to = event.getTo();
        WorldServer fromWorld = ((CraftWorld)from.getWorld()).getHandle();
        WorldServer toWorld = ((CraftWorld)to.getWorld()).getHandle();
        if (this.getHandle().bW != this.getHandle().bV) {
            this.getHandle().closeContainer(InventoryCloseEvent.Reason.TELEPORT);
        }
        if (fromWorld == toWorld) {
            entity.b.teleport(to);
        } else {
            this.server.getHandle().respawn(entity, toWorld, true, to, !toWorld.paperConfig.disableTeleportationSuffocationCheck);
        }
        return true;
    }

    @Override
    public boolean setPassenger(Entity passenger) {
        boolean wasSet = super.setPassenger(passenger);
        if (wasSet) {
            this.getHandle().b.a(new PacketPlayOutMount(this.getHandle()));
        }
        return wasSet;
    }

    public void setSneaking(boolean sneak) {
        this.getHandle().f(sneak);
    }

    public boolean isSneaking() {
        return this.getHandle().bI();
    }

    public boolean isSprinting() {
        return this.getHandle().bO();
    }

    public void setSprinting(boolean sprinting) {
        this.getHandle().g(sprinting);
    }

    public void loadData() {
        this.server.getHandle().r.b(this.getHandle());
    }

    public void saveData() {
        this.server.getHandle().r.a(this.getHandle());
    }

    @Deprecated
    public void updateInventory() {
        this.getHandle().bW.b();
    }

    public void setSleepingIgnored(boolean isSleeping) {
        this.getHandle().fauxSleeping = isSleeping;
        ((CraftWorld)this.getWorld()).getHandle().e();
    }

    public boolean isSleepingIgnored() {
        return this.getHandle().fauxSleeping;
    }

    public Location getBedSpawnLocation() {
        Optional<Vec3D> spawnLoc;
        WorldServer world = this.getHandle().c.a(this.getHandle().P());
        BlockPosition bed = this.getHandle().N();
        if (world != null && bed != null && (spawnLoc = EntityHuman.a(world, bed, this.getHandle().O(), this.getHandle().Q(), true)).isPresent()) {
            Vec3D vec = spawnLoc.get();
            return new Location((World)world.getWorld(), vec.b, vec.c, vec.d, this.getHandle().O(), 0.0f);
        }
        return null;
    }

    public void setBedSpawnLocation(Location location) {
        this.setBedSpawnLocation(location, false);
    }

    public void setBedSpawnLocation(Location location, boolean override) {
        if (location == null) {
            this.getHandle().setRespawnPosition(null, null, 0.0f, override, false, PlayerSetSpawnEvent.Cause.PLUGIN);
        } else {
            this.getHandle().a(((CraftWorld)location.getWorld()).getHandle().aa(), new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()), location.getYaw(), override, false);
        }
    }

    @Override
    public Location getBedLocation() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Not sleeping");
        BlockPosition bed = this.getHandle().N();
        return new Location(this.getWorld(), (double)bed.u(), (double)bed.v(), (double)bed.w());
    }

    @Override
    public boolean hasDiscoveredRecipe(NamespacedKey recipe) {
        Preconditions.checkArgument((recipe != null ? 1 : 0) != 0, (Object)"recipe cannot be null");
        return this.getHandle().E().b(CraftNamespacedKey.toMinecraft(recipe));
    }

    @Override
    public Set<NamespacedKey> getDiscoveredRecipes() {
        ImmutableSet.Builder bukkitRecipeKeys = ImmutableSet.builder();
        this.getHandle().E().a.forEach(key -> bukkitRecipeKeys.add((Object)CraftNamespacedKey.fromMinecraft(key)));
        return bukkitRecipeKeys.build();
    }

    public void incrementStatistic(Statistic statistic) {
        CraftStatistic.incrementStatistic(this.getHandle().D(), statistic);
    }

    public void decrementStatistic(Statistic statistic) {
        CraftStatistic.decrementStatistic(this.getHandle().D(), statistic);
    }

    public int getStatistic(Statistic statistic) {
        return CraftStatistic.getStatistic(this.getHandle().D(), statistic);
    }

    public void incrementStatistic(Statistic statistic, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().D(), statistic, amount);
    }

    public void decrementStatistic(Statistic statistic, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().D(), statistic, amount);
    }

    public void setStatistic(Statistic statistic, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().D(), statistic, newValue);
    }

    public void incrementStatistic(Statistic statistic, Material material) {
        CraftStatistic.incrementStatistic(this.getHandle().D(), statistic, material);
    }

    public void decrementStatistic(Statistic statistic, Material material) {
        CraftStatistic.decrementStatistic(this.getHandle().D(), statistic, material);
    }

    public int getStatistic(Statistic statistic, Material material) {
        return CraftStatistic.getStatistic(this.getHandle().D(), statistic, material);
    }

    public void incrementStatistic(Statistic statistic, Material material, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().D(), statistic, material, amount);
    }

    public void decrementStatistic(Statistic statistic, Material material, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().D(), statistic, material, amount);
    }

    public void setStatistic(Statistic statistic, Material material, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().D(), statistic, material, newValue);
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType) {
        CraftStatistic.incrementStatistic(this.getHandle().D(), statistic, entityType);
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType) {
        CraftStatistic.decrementStatistic(this.getHandle().D(), statistic, entityType);
    }

    public int getStatistic(Statistic statistic, EntityType entityType) {
        return CraftStatistic.getStatistic(this.getHandle().D(), statistic, entityType);
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().D(), statistic, entityType, amount);
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().D(), statistic, entityType, amount);
    }

    public void setStatistic(Statistic statistic, EntityType entityType, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().D(), statistic, entityType, newValue);
    }

    public void setPlayerTime(long time, boolean relative) {
        this.getHandle().timeOffset = time;
        this.getHandle().relativeTime = relative;
    }

    public long getPlayerTimeOffset() {
        return this.getHandle().timeOffset;
    }

    public long getPlayerTime() {
        return this.getHandle().getPlayerTime();
    }

    public boolean isPlayerTimeRelative() {
        return this.getHandle().relativeTime;
    }

    public void resetPlayerTime() {
        this.setPlayerTime(0L, true);
    }

    public void setPlayerWeather(WeatherType type) {
        this.getHandle().setPlayerWeather(type, true);
    }

    public WeatherType getPlayerWeather() {
        return this.getHandle().getPlayerWeather();
    }

    public void resetPlayerWeather() {
        this.getHandle().resetPlayerWeather();
    }

    public boolean isBanned() {
        return this.server.getBanList(BanList.Type.NAME).isBanned(this.getName());
    }

    public boolean isWhitelisted() {
        return this.server.getHandle().i().a(this.getProfile());
    }

    public void setWhitelisted(boolean value) {
        if (value) {
            this.server.getHandle().i().a(new WhiteListEntry(this.getProfile()));
        } else {
            this.server.getHandle().i().c(this.getProfile());
        }
    }

    @Override
    public void setGameMode(GameMode mode) {
        if (this.getHandle().b == null) {
            return;
        }
        if (mode == null) {
            throw new IllegalArgumentException("Mode cannot be null");
        }
        this.getHandle().setGameMode(EnumGamemode.a(mode.getValue()), PlayerGameModeChangeEvent.Cause.PLUGIN, null);
    }

    @Override
    public GameMode getGameMode() {
        return GameMode.getByValue((int)this.getHandle().d.b().a());
    }

    public int applyMending(int amount) {
        EntityPlayer handle = this.getHandle();
        ItemStack itemstack = EnchantmentManager.getRandomEquippedItemWithEnchant(Enchantments.K, handle);
        if (!itemstack.b() && itemstack.c().n()) {
            EntityExperienceOrb orb = EntityTypes.A.a(handle.t);
            orb.ar = amount;
            orb.spawnReason = ExperienceOrb.SpawnReason.CUSTOM;
            orb.o(handle.dc(), handle.de(), handle.di());
            int i2 = Math.min(orb.c(amount), itemstack.h());
            PlayerItemMendEvent event = CraftEventFactory.callPlayerItemMendEvent(handle, orb, itemstack, i2);
            i2 = event.getRepairAmount();
            orb.ah();
            if (!event.isCancelled()) {
                amount -= orb.b(i2);
                itemstack.b(itemstack.h() - i2);
            }
        }
        return amount;
    }

    public void giveExp(int exp, boolean applyMending) {
        if (applyMending) {
            exp = this.applyMending(exp);
        }
        this.getHandle().d(exp);
    }

    public void giveExpLevels(int levels) {
        this.getHandle().c(levels);
    }

    public float getExp() {
        return this.getHandle().cl;
    }

    public void setExp(float exp) {
        Preconditions.checkArgument(((double)exp >= 0.0 && (double)exp <= 1.0 ? 1 : 0) != 0, (String)"Experience progress must be between 0.0 and 1.0 (%s)", (Object)Float.valueOf(exp));
        this.getHandle().cl = exp;
        this.getHandle().cD = -1;
    }

    public int getLevel() {
        return this.getHandle().cj;
    }

    public void setLevel(int level) {
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0, (String)"Experience level must not be negative (%s)", (int)level);
        this.getHandle().cj = level;
        this.getHandle().cD = -1;
    }

    public int getTotalExperience() {
        return this.getHandle().ck;
    }

    public void setTotalExperience(int exp) {
        Preconditions.checkArgument((exp >= 0 ? 1 : 0) != 0, (String)"Total experience points must not be negative (%s)", (int)exp);
        this.getHandle().ck = exp;
    }

    public void sendExperienceChange(float progress) {
        this.sendExperienceChange(progress, this.getLevel());
    }

    public void sendExperienceChange(float progress, int level) {
        Preconditions.checkArgument(((double)progress >= 0.0 && (double)progress <= 1.0 ? 1 : 0) != 0, (String)"Experience progress must be between 0.0 and 1.0 (%s)", (Object)Float.valueOf(progress));
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0, (String)"Experience level must not be negative (%s)", (int)level);
        if (this.getHandle().b == null) {
            return;
        }
        PacketPlayOutExperience packet = new PacketPlayOutExperience(progress, this.getTotalExperience(), level);
        this.getHandle().b.a(packet);
    }

    @Nullable
    private static WeakReference<Plugin> getPluginWeakReference(@Nullable Plugin plugin) {
        return plugin == null ? null : pluginWeakReferences.computeIfAbsent(plugin, WeakReference::new);
    }

    @Deprecated
    public void hidePlayer(Player player) {
        this.hideEntity0(null, (Entity)player);
    }

    public void hidePlayer(Plugin plugin, Player player) {
        this.hideEntity(plugin, (Entity)player);
    }

    public void hideEntity(Plugin plugin, Entity entity) {
        Validate.notNull((Object)plugin, (String)"Plugin cannot be null");
        Validate.isTrue((boolean)plugin.isEnabled(), (String)"Plugin attempted to hide player while disabled");
        this.hideEntity0(plugin, entity);
    }

    private void hideEntity0(@Nullable Plugin plugin, Entity entity) {
        Validate.notNull((Object)entity, (String)"hidden entity cannot be null");
        if (this.getHandle().b == null) {
            return;
        }
        if (this.equals(entity)) {
            return;
        }
        Set<WeakReference<Plugin>> hidingPlugins = this.hiddenEntities.get(entity.getUniqueId());
        if (hidingPlugins != null) {
            hidingPlugins.add(CraftPlayer.getPluginWeakReference(plugin));
            return;
        }
        hidingPlugins = new HashSet<WeakReference<Plugin>>();
        hidingPlugins.add(CraftPlayer.getPluginWeakReference(plugin));
        this.hiddenEntities.put(entity.getUniqueId(), hidingPlugins);
        net.minecraft.world.entity.Entity other = ((CraftEntity)entity).getHandle();
        this.unregisterEntity(other);
    }

    private void unregisterEntity(net.minecraft.world.entity.Entity other) {
        PlayerChunkMap tracker = ((WorldServer)this.getHandle().t).k().a;
        PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)tracker.I.get(other.ae());
        if (entry != null) {
            entry.a(this.getHandle());
        }
        if (other instanceof EntityPlayer) {
            EntityPlayer otherPlayer = (EntityPlayer)other;
            if (otherPlayer.sentListPacket) {
                this.getHandle().b.a(new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.e, otherPlayer));
            }
        }
    }

    @Deprecated
    public void showPlayer(Player player) {
        this.showEntity0(null, (Entity)player);
    }

    public void showPlayer(Plugin plugin, Player player) {
        this.showEntity(plugin, (Entity)player);
    }

    public void showEntity(Plugin plugin, Entity entity) {
        Validate.notNull((Object)plugin, (String)"Plugin cannot be null");
        this.showEntity0(plugin, entity);
    }

    private void showEntity0(@Nullable Plugin plugin, Entity entity) {
        Validate.notNull((Object)entity, (String)"shown entity cannot be null");
        if (this.getHandle().b == null) {
            return;
        }
        if (this.equals(entity)) {
            return;
        }
        Set<WeakReference<Plugin>> hidingPlugins = this.hiddenEntities.get(entity.getUniqueId());
        if (hidingPlugins == null) {
            return;
        }
        hidingPlugins.remove(CraftPlayer.getPluginWeakReference(plugin));
        if (!hidingPlugins.isEmpty()) {
            return;
        }
        this.hiddenEntities.remove(entity.getUniqueId());
        net.minecraft.world.entity.Entity other = ((CraftEntity)entity).getHandle();
        this.registerEntity(other);
    }

    private void registerEntity(net.minecraft.world.entity.Entity other) {
        PlayerChunkMap.EntityTracker entry;
        PlayerChunkMap tracker = ((WorldServer)this.getHandle().t).k().a;
        if (other instanceof EntityPlayer) {
            EntityPlayer otherPlayer = (EntityPlayer)other;
            this.getHandle().b.a(new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.a, otherPlayer));
        }
        if ((entry = (PlayerChunkMap.EntityTracker)tracker.I.get(other.ae())) != null && !entry.f.contains(this.getHandle().b)) {
            entry.b(this.getHandle());
        }
    }

    private void reregisterPlayer(EntityPlayer player) {
        if (!this.hiddenEntities.containsKey(player.cm())) {
            this.unregisterEntity(player);
            this.registerEntity(player);
        }
    }

    public void setPlayerProfile(PlayerProfile profile) {
        EntityPlayer self = this.getHandle();
        ((EntityHuman)self).ct = CraftPlayerProfile.asAuthlibCopy(profile);
        if (!self.sentListPacket) {
            return;
        }
        List<EntityPlayer> players = this.server.getServer().bg().j;
        for (EntityPlayer player : players) {
            player.getBukkitEntity().reregisterPlayer(self);
        }
        this.refreshPlayer();
    }

    public PlayerProfile getPlayerProfile() {
        return new CraftPlayerProfile(this).clone();
    }

    private void refreshPlayer() {
        EntityPlayer handle = this.getHandle();
        Location loc = this.getLocation();
        PlayerConnection connection = handle.b;
        this.reregisterPlayer(handle);
        WorldServer worldserver = handle.x();
        connection.a(new PacketPlayOutRespawn(worldserver.q_(), worldserver.aa(), BiomeManager.a(worldserver.E()), handle.d.b(), handle.d.c(), worldserver.ad(), worldserver.D(), true));
        handle.w();
        connection.a(new PacketPlayOutPosition(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch(), Collections.emptySet(), 0, false));
        MinecraftServer.getServer().ac().e(handle);
        if (this.isOp()) {
            this.setOp(false);
            this.setOp(true);
        }
    }

    public void onEntityRemove(net.minecraft.world.entity.Entity entity) {
        this.hiddenEntities.remove(entity.cm());
    }

    public boolean canSee(Player player) {
        return this.canSee((Entity)player);
    }

    public boolean canSee(Entity entity) {
        return !this.hiddenEntities.containsKey(entity.getUniqueId());
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("name", this.getName());
        return result;
    }

    public Player getPlayer() {
        return this;
    }

    @Override
    public EntityPlayer getHandle() {
        return (EntityPlayer)this.entity;
    }

    public void setHandle(EntityPlayer entity) {
        super.setHandle(entity);
    }

    @Override
    public String toString() {
        return "CraftPlayer{name=" + this.getName() + "}";
    }

    @Override
    public int hashCode() {
        if (this.hash == 0 || this.hash == 485) {
            this.hash = 485 + (this.getUniqueId() != null ? this.getUniqueId().hashCode() : 0);
        }
        return this.hash;
    }

    public long getFirstPlayed() {
        return this.firstPlayed;
    }

    public long getLastPlayed() {
        return this.lastPlayed;
    }

    public boolean hasPlayedBefore() {
        return this.hasPlayedBefore;
    }

    public void setFirstPlayed(long firstPlayed) {
        this.firstPlayed = firstPlayed;
    }

    public long getLastLogin() {
        return this.getHandle().loginTime;
    }

    public long getLastSeen() {
        return this.isOnline() ? System.currentTimeMillis() : this.lastSaveTime;
    }

    public void readExtraData(NBTTagCompound nbttagcompound) {
        this.hasPlayedBefore = true;
        if (nbttagcompound.e("bukkit")) {
            NBTTagCompound data = nbttagcompound.p("bukkit");
            if (data.e("firstPlayed")) {
                this.firstPlayed = data.i("firstPlayed");
                this.lastPlayed = data.i("lastPlayed");
            }
            if (data.e("newExp")) {
                EntityPlayer handle = this.getHandle();
                handle.newExp = data.h("newExp");
                handle.newTotalExp = data.h("newTotalExp");
                handle.newLevel = data.h("newLevel");
                handle.expToDrop = data.h("expToDrop");
                handle.keepLevel = data.q("keepLevel");
            }
        }
    }

    public void setExtraData(NBTTagCompound nbttagcompound) {
        this.lastSaveTime = System.currentTimeMillis();
        if (!nbttagcompound.e("bukkit")) {
            nbttagcompound.a("bukkit", new NBTTagCompound());
        }
        NBTTagCompound data = nbttagcompound.p("bukkit");
        EntityPlayer handle = this.getHandle();
        data.a("newExp", handle.newExp);
        data.a("newTotalExp", handle.newTotalExp);
        data.a("newLevel", handle.newLevel);
        data.a("expToDrop", handle.expToDrop);
        data.a("keepLevel", handle.keepLevel);
        data.a("firstPlayed", this.getFirstPlayed());
        data.a("lastPlayed", System.currentTimeMillis());
        data.a("lastKnownName", handle.co());
        if (!nbttagcompound.e("Paper")) {
            nbttagcompound.a("Paper", new NBTTagCompound());
        }
        NBTTagCompound paper = nbttagcompound.p("Paper");
        paper.a("LastLogin", handle.loginTime);
        paper.a("LastSeen", System.currentTimeMillis());
    }

    public boolean beginConversation(Conversation conversation) {
        return this.conversationTracker.beginConversation(conversation);
    }

    public void abandonConversation(Conversation conversation) {
        this.conversationTracker.abandonConversation(conversation, new ConversationAbandonedEvent(conversation, (ConversationCanceller)new ManuallyAbandonedConversationCanceller()));
    }

    public void abandonConversation(Conversation conversation, ConversationAbandonedEvent details) {
        this.conversationTracker.abandonConversation(conversation, details);
    }

    public void acceptConversationInput(String input) {
        this.conversationTracker.acceptConversationInput(input);
    }

    public boolean isConversing() {
        return this.conversationTracker.isConversing();
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage((Messenger)this.server.getMessenger(), (Plugin)source, (String)channel, (byte[])message);
        if (this.getHandle().b == null) {
            return;
        }
        if (this.channels.contains(channel)) {
            channel = StandardMessenger.validateAndCorrectChannel((String)channel);
            PacketPlayOutCustomPayload packet = new PacketPlayOutCustomPayload(new MinecraftKey(channel), new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])message)));
            this.getHandle().b.a(packet);
        }
    }

    public void setTexturePack(String url) {
        this.setResourcePack(url);
    }

    public void setResourcePack(String url) {
        this.setResourcePack(url, (byte[])null);
    }

    public void setResourcePack(String url, byte[] hash) {
        this.setResourcePack(url, hash, false);
    }

    public void setResourcePack(String url, byte[] hash, String prompt) {
        this.setResourcePack(url, hash, prompt, false);
    }

    public void setResourcePack(String url, byte[] hash, boolean force) {
        this.setResourcePack(url, hash, (String)null, force);
    }

    public void setResourcePack(String url, byte[] hash, String prompt, boolean force) {
        Validate.notNull((Object)url, (String)"Resource pack URL cannot be null");
        if (hash != null) {
            Validate.isTrue((hash.length == 20 ? 1 : 0) != 0, (String)("Resource pack hash should be 20 bytes long but was " + hash.length));
            this.getHandle().a(url, BaseEncoding.base16().lowerCase().encode(hash), force, CraftChatMessage.fromStringOrNull(prompt, true));
        } else {
            this.getHandle().a(url, "", force, CraftChatMessage.fromStringOrNull(prompt, true));
        }
    }

    public void setResourcePack(String url, byte[] hashBytes, Component prompt, boolean force) {
        String hash;
        Validate.notNull((Object)url, (String)"Resource pack URL cannot be null");
        if (hashBytes != null) {
            Validate.isTrue((hashBytes.length == 20 ? 1 : 0) != 0, (String)("Resource pack hash should be 20 bytes long but was " + hashBytes.length));
            hash = BaseEncoding.base16().lowerCase().encode(hashBytes);
        } else {
            hash = "";
        }
        this.getHandle().a(url, hash, force, PaperAdventure.asVanilla(prompt));
    }

    public void addChannel(String channel) {
        Preconditions.checkState((DISABLE_CHANNEL_LIMIT || this.channels.size() < 128 ? 1 : 0) != 0, (String)"Cannot register channel '%s'. Too many channels registered!", (Object)channel);
        channel = StandardMessenger.validateAndCorrectChannel((String)channel);
        if (this.channels.add(channel)) {
            this.server.getPluginManager().callEvent((Event)new PlayerRegisterChannelEvent((Player)this, channel));
        }
    }

    public void removeChannel(String channel) {
        if (this.channels.remove(channel = StandardMessenger.validateAndCorrectChannel((String)channel))) {
            this.server.getPluginManager().callEvent((Event)new PlayerUnregisterChannelEvent((Player)this, channel));
        }
    }

    public Set<String> getListeningPluginChannels() {
        return ImmutableSet.copyOf(this.channels);
    }

    public void sendSupportedChannels() {
        if (this.getHandle().b == null) {
            return;
        }
        Set listening = this.server.getMessenger().getIncomingChannels();
        if (!listening.isEmpty()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            for (String channel : listening) {
                try {
                    stream.write(channel.getBytes("UTF8"));
                    stream.write(0);
                }
                catch (IOException ex) {
                    Logger.getLogger(CraftPlayer.class.getName()).log(Level.SEVERE, "Could not send Plugin Channel REGISTER to " + this.getName(), ex);
                }
            }
            this.getHandle().b.a(new PacketPlayOutCustomPayload(new MinecraftKey("register"), new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])stream.toByteArray()))));
        }
    }

    @Override
    public EntityType getType() {
        return EntityType.PLAYER;
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getPlayerMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getPlayerMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        Container container = this.getHandle().bW;
        if (container.getBukkitView().getType() != prop.getType()) {
            return false;
        }
        container.a(prop.getId(), value);
        return true;
    }

    public void disconnect(String reason) {
        this.conversationTracker.abandonAllConversations();
        this.perm.clearPermissions();
    }

    public boolean isFlying() {
        return this.getHandle().fr().b;
    }

    public void setFlying(boolean value) {
        boolean needsUpdate;
        boolean bl = needsUpdate = this.getHandle().fr().b != value;
        if (!this.getAllowFlight() && value) {
            throw new IllegalArgumentException("Cannot make player fly if getAllowFlight() is false");
        }
        this.getHandle().fr().b = value;
        if (needsUpdate) {
            this.getHandle().w();
        }
    }

    public boolean getAllowFlight() {
        return this.getHandle().fr().c;
    }

    public void setAllowFlight(boolean value) {
        if (this.isFlying() && !value) {
            this.getHandle().fr().b = false;
        }
        this.getHandle().fr().c = value;
        this.getHandle().w();
    }

    @Override
    public int getNoDamageTicks() {
        if (this.getHandle().cE > 0) {
            return Math.max(this.getHandle().cE, this.getHandle().X);
        }
        return this.getHandle().X;
    }

    @Override
    public void setNoDamageTicks(int ticks) {
        super.setNoDamageTicks(ticks);
        this.getHandle().cE = ticks;
    }

    public void setFlySpeed(float value) {
        this.validateSpeed(value);
        EntityPlayer player = this.getHandle();
        player.fr().f = value / 2.0f;
        player.w();
    }

    public void setWalkSpeed(float value) {
        this.validateSpeed(value);
        EntityPlayer player = this.getHandle();
        player.fr().g = value / 2.0f;
        player.w();
        this.getHandle().a(GenericAttributes.d).a(player.fr().g);
    }

    public float getFlySpeed() {
        return this.getHandle().fr().f * 2.0f;
    }

    public float getWalkSpeed() {
        return this.getHandle().fr().g * 2.0f;
    }

    private void validateSpeed(float value) {
        if (value < 0.0f) {
            if (value < -1.0f) {
                throw new IllegalArgumentException(value + " is too low");
            }
        } else if (value > 1.0f) {
            throw new IllegalArgumentException(value + " is too high");
        }
    }

    @Override
    public void setMaxHealth(double amount) {
        super.setMaxHealth(amount);
        this.health = Math.min(this.health, this.health);
        this.getHandle().u();
    }

    @Override
    public void resetMaxHealth() {
        super.resetMaxHealth();
        this.getHandle().u();
    }

    public CraftScoreboard getScoreboard() {
        return this.server.getScoreboardManager().getPlayerBoard(this);
    }

    public void setScoreboard(Scoreboard scoreboard) {
        Validate.notNull((Object)scoreboard, (String)"Scoreboard cannot be null");
        PlayerConnection playerConnection = this.getHandle().b;
        if (playerConnection == null) {
            throw new IllegalStateException("Cannot set scoreboard yet");
        }
        if (playerConnection.isDisconnected()) {
            // empty if block
        }
        this.server.getScoreboardManager().setPlayerBoard(this, scoreboard);
    }

    public void setHealthScale(double value) {
        Validate.isTrue(((float)value > 0.0f ? 1 : 0) != 0, (String)"Must be greater than 0");
        this.healthScale = value;
        this.scaledHealth = true;
        this.updateScaledHealth();
    }

    public double getHealthScale() {
        return this.healthScale;
    }

    public void setHealthScaled(boolean scale) {
        this.scaledHealth = scale;
        if (this.scaledHealth != this.scaledHealth) {
            this.updateScaledHealth();
        }
    }

    public boolean isHealthScaled() {
        return this.scaledHealth;
    }

    public float getScaledHealth() {
        return (float)(this.isHealthScaled() ? this.getHealth() * this.getHealthScale() / this.getMaxHealth() : this.getHealth());
    }

    @Override
    public double getHealth() {
        return this.health;
    }

    public void setRealHealth(double health) {
        if (Double.isNaN(health)) {
            return;
        }
        this.health = health;
    }

    public void updateScaledHealth() {
        this.updateScaledHealth(true);
    }

    public void updateScaledHealth(boolean sendHealth) {
        AttributeMapBase attributemapserver = this.getHandle().ep();
        Collection<AttributeModifiable> set = attributemapserver.b();
        this.injectScaledMaxHealth(set, true);
        if (this.getHandle().b != null) {
            this.getHandle().b.a(new PacketPlayOutUpdateAttributes(this.getHandle().ae(), set));
            if (sendHealth) {
                this.sendHealthUpdate();
            }
        }
        this.getHandle().ai().b(EntityLiving.bK, Float.valueOf(this.getScaledHealth()));
        this.getHandle().maxHealthCache = this.getMaxHealth();
    }

    public void sendHealthUpdate(double health, int foodLevel, float saturationLevel) {
        PacketPlayOutUpdateHealth packet = new PacketPlayOutUpdateHealth((float)health, foodLevel, saturationLevel);
        if (this.getHandle().queueHealthUpdatePacket) {
            this.getHandle().queuedHealthUpdatePacket = packet;
        } else {
            this.getHandle().b.a(packet);
        }
    }

    public void sendHealthUpdate() {
        this.sendHealthUpdate(this.getScaledHealth(), this.getHandle().fz().a(), this.getHandle().fz().e());
    }

    public void injectScaledMaxHealth(Collection<AttributeModifiable> collection, boolean force) {
        double healthMod;
        if (!this.scaledHealth && !force) {
            return;
        }
        for (AttributeModifiable genericInstance : collection) {
            if (genericInstance.a() != GenericAttributes.a) continue;
            collection.remove(genericInstance);
            break;
        }
        AttributeModifiable dummy = new AttributeModifiable(GenericAttributes.a, attribute -> {});
        double d2 = healthMod = this.scaledHealth ? this.healthScale : this.getMaxHealth();
        if (healthMod >= 3.4028234663852886E38 || healthMod <= 0.0) {
            healthMod = 20.0;
            this.getServer().getLogger().warning(this.getName() + " tried to crash the server with a large health attribute");
        }
        dummy.a(healthMod);
        collection.add(dummy);
    }

    public Entity getSpectatorTarget() {
        net.minecraft.world.entity.Entity followed = this.getHandle().G();
        return followed == this.getHandle() ? null : followed.getBukkitEntity();
    }

    public void setSpectatorTarget(Entity entity) {
        Preconditions.checkArgument((this.getGameMode() == GameMode.SPECTATOR ? 1 : 0) != 0, (Object)"Player must be in spectator mode");
        this.getHandle().c(entity == null ? null : ((CraftEntity)entity).getHandle());
    }

    public void sendTitle(String title, String subtitle) {
        this.sendTitle(title, subtitle, 10, 70, 20);
    }

    public void sendTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        ClientboundSetTitlesAnimationPacket times = new ClientboundSetTitlesAnimationPacket(fadeIn, stay, fadeOut);
        this.getHandle().b.a(times);
        if (title != null) {
            ClientboundSetTitleTextPacket packetTitle = new ClientboundSetTitleTextPacket(CraftChatMessage.fromStringOrNull(title));
            this.getHandle().b.a(packetTitle);
        }
        if (subtitle != null) {
            ClientboundSetSubtitleTextPacket packetSubtitle = new ClientboundSetSubtitleTextPacket(CraftChatMessage.fromStringOrNull(subtitle));
            this.getHandle().b.a(packetSubtitle);
        }
    }

    public void resetTitle() {
        ClientboundClearTitlesPacket packetReset = new ClientboundClearTitlesPacket(true);
        this.getHandle().b.a(packetReset);
    }

    public void spawnParticle(Particle particle, Location location, int count) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count);
    }

    public void spawnParticle(Particle particle, double x2, double y2, double z2, int count) {
        this.spawnParticle(particle, x2, y2, z2, count, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, data);
    }

    public <T> void spawnParticle(Particle particle, double x2, double y2, double z2, int count, T data) {
        this.spawnParticle(particle, x2, y2, z2, count, 0.0, 0.0, 0.0, data);
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    public void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, x2, y2, z2, count, offsetX, offsetY, offsetZ, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    public <T> void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, x2, y2, z2, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra);
    }

    public void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, x2, y2, z2, count, offsetX, offsetY, offsetZ, extra, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data);
    }

    public <T> void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        if (data != null && !particle.getDataType().isInstance(data)) {
            throw new IllegalArgumentException("data should be " + particle.getDataType() + " got " + data.getClass());
        }
        PacketPlayOutWorldParticles packetplayoutworldparticles = new PacketPlayOutWorldParticles(CraftParticle.toNMS(particle, data), true, x2, y2, z2, (float)offsetX, (float)offsetY, (float)offsetZ, (float)extra, count);
        this.getHandle().b.a(packetplayoutworldparticles);
    }

    public org.bukkit.advancement.AdvancementProgress getAdvancementProgress(Advancement advancement) {
        Preconditions.checkArgument((advancement != null ? 1 : 0) != 0, (Object)"advancement");
        CraftAdvancement craft = (CraftAdvancement)advancement;
        AdvancementDataPlayer data = this.getHandle().M();
        AdvancementProgress progress = data.b(craft.getHandle());
        return new CraftAdvancementProgress(craft, data, progress);
    }

    public int getClientViewDistance() {
        return this.getHandle().clientViewDistance == null ? Bukkit.getViewDistance() : this.getHandle().clientViewDistance;
    }

    public Locale locale() {
        return this.getHandle().adventure$locale;
    }

    public int getPing() {
        return this.getHandle().e;
    }

    public String getLocale() {
        String locale = this.getHandle().locale;
        return locale != null ? locale : "en_us";
    }

    public void setAffectsSpawning(boolean affects) {
        this.getHandle().affectsSpawning = affects;
    }

    public boolean getAffectsSpawning() {
        return this.getHandle().affectsSpawning;
    }

    public void setResourcePack(@NotNull String url, @NotNull String hash) {
        this.setResourcePack(url, hash, false, null);
    }

    public void setResourcePack(@NotNull String url, @NotNull String hash, boolean required) {
        this.setResourcePack(url, hash, required, null);
    }

    public void setResourcePack(@NotNull String url, @NotNull String hash, boolean required, Component resourcePackPrompt) {
        Validate.notNull((Object)url, (String)"Resource pack URL cannot be null");
        Validate.notNull((Object)hash, (String)"Hash cannot be null");
        IChatBaseComponent promptComponent = resourcePackPrompt != null ? PaperAdventure.asVanilla(resourcePackPrompt) : null;
        this.getHandle().a(url, hash, required, promptComponent);
    }

    public PlayerResourcePackStatusEvent.Status getResourcePackStatus() {
        return this.resourcePackStatus;
    }

    public String getResourcePackHash() {
        return this.resourcePackHash;
    }

    public boolean hasResourcePack() {
        return this.resourcePackStatus == PlayerResourcePackStatusEvent.Status.SUCCESSFULLY_LOADED;
    }

    public void setResourcePackStatus(PlayerResourcePackStatusEvent.Status status) {
        this.resourcePackStatus = status;
    }

    public void updateCommands() {
        if (this.getHandle().b == null) {
            return;
        }
        this.getHandle().c.aA().a(this.getHandle());
    }

    public void openBook(org.bukkit.inventory.ItemStack book) {
        Validate.isTrue((book != null ? 1 : 0) != 0, (String)"book == null");
        Validate.isTrue((book.getType() == Material.WRITTEN_BOOK ? 1 : 0) != 0, (String)"Book must be Material.WRITTEN_BOOK");
        org.bukkit.inventory.ItemStack hand = this.getInventory().getItemInMainHand();
        this.getInventory().setItemInMainHand(book);
        this.getHandle().a(CraftItemStack.asNMSCopy(book), EnumHand.a);
        this.getInventory().setItemInMainHand(hand);
    }

    @Override
    public void openSign(Sign sign) {
        CraftSign.openSign(sign, this);
    }

    public void showDemoScreen() {
        if (this.getHandle().b == null) {
            return;
        }
        this.getHandle().b.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.f, 0.0f));
    }

    public boolean isAllowingServerListings() {
        return this.getHandle().V();
    }

    public Component displayName() {
        return this.getHandle().adventure$displayName;
    }

    public void displayName(Component displayName) {
        this.getHandle().adventure$displayName = displayName != null ? displayName : Component.text((String)this.getName());
        this.getHandle().displayName = null;
    }

    public void sendMessage(Identity identity, Component message, MessageType type) {
        if (this.getHandle().b == null) {
            return;
        }
        PacketPlayOutChat packet = new PacketPlayOutChat(null, type == MessageType.CHAT ? net.minecraft.network.chat.ChatMessageType.a : net.minecraft.network.chat.ChatMessageType.b, identity.uuid());
        packet.adventure$message = message;
        this.getHandle().b.a(packet);
    }

    public void sendActionBar(Component message) {
        ClientboundSetActionBarTextPacket packet = new ClientboundSetActionBarTextPacket((IChatBaseComponent)null);
        packet.adventure$text = message;
        this.getHandle().b.a(packet);
    }

    public void sendPlayerListHeader(Component header) {
        this.playerListHeader = header;
        this.adventure$sendPlayerListHeaderAndFooter();
    }

    public void sendPlayerListFooter(Component footer) {
        this.playerListFooter = footer;
        this.adventure$sendPlayerListHeaderAndFooter();
    }

    public void sendPlayerListHeaderAndFooter(Component header, Component footer) {
        this.playerListHeader = header;
        this.playerListFooter = footer;
        this.adventure$sendPlayerListHeaderAndFooter();
    }

    private void adventure$sendPlayerListHeaderAndFooter() {
        PlayerConnection connection = this.getHandle().b;
        if (connection == null) {
            return;
        }
        PacketPlayOutPlayerListHeaderFooter packet = new PacketPlayOutPlayerListHeaderFooter(null, null);
        packet.adventure$header = this.playerListHeader == null ? Component.empty() : this.playerListHeader;
        packet.adventure$footer = this.playerListFooter == null ? Component.empty() : this.playerListFooter;
        connection.a(packet);
    }

    public void showTitle(net.kyori.adventure.title.Title title) {
        PlayerConnection connection = this.getHandle().b;
        Title.Times times = title.times();
        if (times != null) {
            connection.a(new ClientboundSetTitlesAnimationPacket(CraftPlayer.ticks(times.fadeIn()), CraftPlayer.ticks(times.stay()), CraftPlayer.ticks(times.fadeOut())));
        }
        ClientboundSetSubtitleTextPacket sp = new ClientboundSetSubtitleTextPacket((IChatBaseComponent)null);
        sp.adventure$text = title.subtitle();
        connection.a(sp);
        ClientboundSetTitleTextPacket tp = new ClientboundSetTitleTextPacket((IChatBaseComponent)null);
        tp.adventure$text = title.title();
        connection.a(tp);
    }

    public <T> void sendTitlePart(TitlePart<T> part, T value) {
        Objects.requireNonNull(part, "part");
        Objects.requireNonNull(value, "value");
        if (part == TitlePart.TITLE) {
            ClientboundSetTitleTextPacket tp = new ClientboundSetTitleTextPacket((IChatBaseComponent)null);
            tp.adventure$text = (Component)value;
            this.getHandle().b.a(tp);
        } else if (part == TitlePart.SUBTITLE) {
            ClientboundSetSubtitleTextPacket sp = new ClientboundSetSubtitleTextPacket((IChatBaseComponent)null);
            sp.adventure$text = (Component)value;
            this.getHandle().b.a(sp);
        } else if (part == TitlePart.TIMES) {
            Title.Times times = (Title.Times)value;
            this.getHandle().b.a(new ClientboundSetTitlesAnimationPacket(CraftPlayer.ticks(times.fadeIn()), CraftPlayer.ticks(times.stay()), CraftPlayer.ticks(times.fadeOut())));
        } else {
            throw new IllegalArgumentException("Unknown TitlePart");
        }
    }

    private static int ticks(Duration duration) {
        if (duration == null) {
            return -1;
        }
        return (int)(duration.toMillis() / 50L);
    }

    public void clearTitle() {
        this.getHandle().b.a(new ClientboundClearTitlesPacket(false));
    }

    public void showBossBar(BossBar bar) {
        ((HackyBossBarPlatformBridge)bar).paper$playerShow(this);
    }

    public void hideBossBar(BossBar bar) {
        ((HackyBossBarPlatformBridge)bar).paper$playerHide(this);
    }

    public void playSound(net.kyori.adventure.sound.Sound sound) {
        Vec3D pos = this.getHandle().cV();
        this.playSound(sound, pos.b, pos.c, pos.d);
    }

    public void playSound(net.kyori.adventure.sound.Sound sound, double x2, double y2, double z2) {
        MinecraftKey name = PaperAdventure.asVanilla(sound.name());
        Optional<SoundEffect> event = IRegistry.U.b(name);
        if (event.isPresent()) {
            this.getHandle().b.a(new PacketPlayOutNamedSoundEffect(event.get(), PaperAdventure.asVanilla(sound.source()), x2, y2, z2, sound.volume(), sound.pitch()));
        } else {
            this.getHandle().b.a(new PacketPlayOutCustomSoundEffect(name, PaperAdventure.asVanilla(sound.source()), new Vec3D(x2, y2, z2), sound.volume(), sound.pitch()));
        }
    }

    public void playSound(net.kyori.adventure.sound.Sound sound, Sound.Emitter emitter) {
        net.minecraft.world.entity.Entity entity;
        if (emitter == Sound.Emitter.self()) {
            entity = this.getHandle();
        } else if (emitter instanceof Entity) {
            entity = ((CraftEntity)emitter).getHandle();
        } else {
            throw new IllegalArgumentException("Sound emitter must be an Entity or self(), but was: " + emitter);
        }
        MinecraftKey name = PaperAdventure.asVanilla(sound.name());
        Optional<SoundEffect> event = IRegistry.U.b(name);
        if (event.isPresent()) {
            this.getHandle().b.a(new PacketPlayOutEntitySound(event.get(), PaperAdventure.asVanilla(sound.source()), entity, sound.volume(), sound.pitch()));
        } else {
            this.getHandle().b.a(new PacketPlayOutCustomSoundEffect(name, PaperAdventure.asVanilla(sound.source()), entity.cV(), sound.volume(), sound.pitch()));
        }
    }

    public void stopSound(SoundStop stop) {
        this.getHandle().b.a(new PacketPlayOutStopSound(PaperAdventure.asVanillaNullable(stop.sound()), PaperAdventure.asVanillaNullable(stop.source())));
    }

    public void openBook(Book book) {
        Locale locale = this.getHandle().adventure$locale;
        ItemStack item = PaperAdventure.asItemStack(book, locale);
        EntityPlayer player = this.getHandle();
        PlayerConnection connection = player.b;
        PlayerInventory inventory = player.fq();
        int slot = inventory.h.size() + inventory.k;
        int stateId = this.getHandle().bW.j();
        connection.a(new PacketPlayOutSetSlot(0, stateId, slot, item));
        connection.a(new PacketPlayOutOpenBook(EnumHand.a));
        connection.a(new PacketPlayOutSetSlot(0, stateId, slot, inventory.f()));
    }

    @Override
    public Pointers pointers() {
        if (this.adventure$pointers == null) {
            this.adventure$pointers = (Pointers)Pointers.builder().withDynamic(Identity.DISPLAY_NAME, this::displayName).withDynamic(Identity.NAME, this::getName).withDynamic(Identity.UUID, this::getUniqueId).withStatic(PermissionChecker.POINTER, arg_0 -> ((CraftPlayer)this).permissionValue(arg_0)).withDynamic(Identity.LOCALE, this::locale).build();
        }
        return this.adventure$pointers;
    }

    public float getCooldownPeriod() {
        return this.getHandle().fI();
    }

    public float getCooledAttackStrength(float adjustTicks) {
        return this.getHandle().v(adjustTicks);
    }

    public void resetCooldown() {
        this.getHandle().fJ();
    }

    @Override
    public void remove() {
        if (this.getHandle().getClass().equals(EntityPlayer.class)) {
            throw new UnsupportedOperationException("Calling Entity#remove on players produces undefined (bad) behavior");
        }
        super.remove();
    }

    public String getClientBrandName() {
        return this.getHandle().b != null ? this.getHandle().b.getClientBrandName() : null;
    }

    public Player.Spigot spigot() {
        return this.spigot;
    }
}

