/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.entity;

import com.destroystokyo.paper.entity.PaperPathfinder;
import com.destroystokyo.paper.entity.Pathfinder;
import com.google.common.base.Preconditions;
import net.minecraft.world.entity.EntityInsentient;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_18_R1.CraftServer;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.loot.LootTable;
import org.jetbrains.annotations.NotNull;

public abstract class CraftMob
extends CraftLivingEntity
implements Mob {
    private final PaperPathfinder paperPathfinder;

    public CraftMob(CraftServer server, EntityInsentient entity) {
        super(server, entity);
        this.paperPathfinder = new PaperPathfinder(entity);
    }

    public Pathfinder getPathfinder() {
        return this.paperPathfinder;
    }

    public void setTarget(LivingEntity target) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot set target during world generation");
        EntityInsentient entity = this.getHandle();
        if (target == null) {
            entity.setTarget(null, null, false);
        } else if (target instanceof CraftLivingEntity) {
            entity.setTarget(((CraftLivingEntity)target).getHandle(), null, false);
        }
    }

    public CraftLivingEntity getTarget() {
        if (this.getHandle().G() == null) {
            return null;
        }
        return (CraftLivingEntity)this.getHandle().G().getBukkitEntity();
    }

    public void setAware(boolean aware) {
        this.getHandle().aware = aware;
    }

    public boolean isAware() {
        return this.getHandle().aware;
    }

    @Override
    public EntityInsentient getHandle() {
        return (EntityInsentient)this.entity;
    }

    @Override
    public String toString() {
        return "CraftMob";
    }

    public void setLootTable(LootTable table) {
        this.getHandle().ce = table == null ? null : CraftNamespacedKey.toMinecraft(table.getKey());
    }

    public LootTable getLootTable() {
        if (this.getHandle().ce == null) {
            this.getHandle().ce = this.getHandle().N();
        }
        NamespacedKey key = CraftNamespacedKey.fromMinecraft(this.getHandle().ce);
        return Bukkit.getLootTable((NamespacedKey)key);
    }

    public void setSeed(long seed) {
        this.getHandle().cf = seed;
    }

    public long getSeed() {
        return this.getHandle().cf;
    }

    public boolean isInDaylight() {
        return this.getHandle().fu();
    }

    public void lookAt(@NotNull Location location) {
        Preconditions.checkNotNull((Object)location, (Object)"location cannot be null");
        Preconditions.checkArgument((boolean)location.getWorld().equals(this.getWorld()), (Object)"location in a different world");
        this.getHandle().z().a(location.getX(), location.getY(), location.getZ());
    }

    public void lookAt(@NotNull Location location, float headRotationSpeed, float maxHeadPitch) {
        Preconditions.checkNotNull((Object)location, (Object)"location cannot be null");
        Preconditions.checkArgument((boolean)location.getWorld().equals(this.getWorld()), (Object)"location in a different world");
        this.getHandle().z().a(location.getX(), location.getY(), location.getZ(), headRotationSpeed, maxHeadPitch);
    }

    public void lookAt(@NotNull Entity entity) {
        Preconditions.checkNotNull((Object)entity, (Object)"entity cannot be null");
        Preconditions.checkArgument((boolean)entity.getWorld().equals(this.getWorld()), (Object)"entity in a different world");
        this.getHandle().z().a(((CraftEntity)entity).getHandle());
    }

    public void lookAt(@NotNull Entity entity, float headRotationSpeed, float maxHeadPitch) {
        Preconditions.checkNotNull((Object)entity, (Object)"entity cannot be null");
        Preconditions.checkArgument((boolean)entity.getWorld().equals(this.getWorld()), (Object)"entity in a different world");
        this.getHandle().z().a(((CraftEntity)entity).getHandle(), headRotationSpeed, maxHeadPitch);
    }

    public void lookAt(double x2, double y2, double z2) {
        this.getHandle().z().a(x2, y2, z2);
    }

    public void lookAt(double x2, double y2, double z2, float headRotationSpeed, float maxHeadPitch) {
        this.getHandle().z().a(x2, y2, z2, headRotationSpeed, maxHeadPitch);
    }

    public int getHeadRotationSpeed() {
        return this.getHandle().V();
    }

    public int getMaxHeadPitch() {
        return this.getHandle().T();
    }

    public boolean isLeftHanded() {
        return this.getHandle().fs();
    }

    public void setLeftHanded(boolean leftHanded) {
        this.getHandle().t(leftHanded);
    }
}

