/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.EntityLightning;
import org.bukkit.craftbukkit.v1_18_R1.CraftServer;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class CraftLightningStrike
extends CraftEntity
implements LightningStrike {
    private final LightningStrike.Spigot spigot = new LightningStrike.Spigot(){

        public boolean isSilent() {
            return CraftLightningStrike.this.getHandle().isSilent;
        }
    };

    public CraftLightningStrike(CraftServer server, EntityLightning entity) {
        super(server, entity);
    }

    public boolean isEffect() {
        return this.getHandle().aq;
    }

    @Override
    public EntityLightning getHandle() {
        return (EntityLightning)this.entity;
    }

    @Override
    public String toString() {
        return "CraftLightningStrike";
    }

    public EntityType getType() {
        return EntityType.LIGHTNING;
    }

    public LightningStrike.Spigot spigot() {
        return this.spigot;
    }

    public int getFlashCount() {
        return this.getHandle().ap;
    }

    public void setFlashCount(int flashes) {
        Preconditions.checkArgument((flashes >= 0 ? 1 : 0) != 0, (Object)"Flashes has to be a positive number!");
        this.getHandle().ap = flashes;
    }

    public int getLifeTicks() {
        return this.getHandle().f;
    }

    public void setLifeTicks(int lifeTicks) {
        this.getHandle().f = lifeTicks;
    }

    @Nullable
    public Entity getCausingEntity() {
        EntityPlayer cause = this.getHandle().h();
        return cause == null ? null : cause.getBukkitEntity();
    }

    public void setCausingPlayer(@Nullable Player causingPlayer) {
        this.getHandle().b(causingPlayer == null ? null : ((CraftPlayer)causingPlayer).getHandle());
    }
}

