/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.monster.EntityCreeper;
import org.bukkit.craftbukkit.v1_18_R1.CraftServer;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftMonster;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreeperPowerEvent;

public class CraftCreeper
extends CraftMonster
implements Creeper {
    public CraftCreeper(CraftServer server, EntityCreeper entity) {
        super(server, entity);
    }

    public boolean isPowered() {
        return this.getHandle().a();
    }

    public void setPowered(boolean powered) {
        CreeperPowerEvent.PowerCause cause;
        CreeperPowerEvent.PowerCause powerCause = cause = powered ? CreeperPowerEvent.PowerCause.SET_ON : CreeperPowerEvent.PowerCause.SET_OFF;
        if (this.getHandle().generation || !this.callPowerEvent(cause)) {
            this.getHandle().setPowered(powered);
        }
    }

    private boolean callPowerEvent(CreeperPowerEvent.PowerCause cause) {
        CreeperPowerEvent event = new CreeperPowerEvent((Creeper)this.getHandle().getBukkitEntity(), cause);
        this.server.getPluginManager().callEvent((Event)event);
        return event.isCancelled();
    }

    public void setMaxFuseTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks < 0");
        this.getHandle().bX = ticks;
    }

    public int getMaxFuseTicks() {
        return this.getHandle().bX;
    }

    public void setFuseTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks < 0");
        Preconditions.checkArgument((ticks <= this.getMaxFuseTicks() ? 1 : 0) != 0, (Object)"ticks > maxFuseTicks");
        this.getHandle().bW = ticks;
    }

    public int getFuseTicks() {
        return this.getHandle().bW;
    }

    public void setExplosionRadius(int radius) {
        Preconditions.checkArgument((radius >= 0 ? 1 : 0) != 0, (Object)"radius < 0");
        this.getHandle().bY = radius;
    }

    public int getExplosionRadius() {
        return this.getHandle().bY;
    }

    public void explode() {
        this.getHandle().fB();
    }

    public void ignite() {
        this.getHandle().fy();
    }

    @Override
    public EntityCreeper getHandle() {
        return (EntityCreeper)this.entity;
    }

    @Override
    public String toString() {
        return "CraftCreeper";
    }

    @Override
    public EntityType getType() {
        return EntityType.CREEPER;
    }

    public void setIgnited(boolean ignited) {
        this.getHandle().setIgnited(ignited);
    }

    public boolean isIgnited() {
        return this.getHandle().t();
    }
}

