/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.block;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.BlockStructure;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import org.apache.commons.lang3.Validate;
import org.bukkit.World;
import org.bukkit.block.Structure;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.block.structure.UsageMode;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftLivingEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.BlockVector;

public class CraftStructureBlock
extends CraftBlockEntityState<TileEntityStructure>
implements Structure {
    private static final int MAX_SIZE = 48;

    public CraftStructureBlock(World world, TileEntityStructure tileEntity) {
        super(world, tileEntity);
    }

    public String getStructureName() {
        return ((TileEntityStructure)this.getSnapshot()).d();
    }

    public void setStructureName(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Structure Name cannot be null");
        ((TileEntityStructure)this.getSnapshot()).a(name);
    }

    public String getAuthor() {
        return ((TileEntityStructure)this.getSnapshot()).f;
    }

    public void setAuthor(String author) {
        Preconditions.checkArgument((author != null && !author.isEmpty() ? 1 : 0) != 0, (Object)"Author name cannot be null nor empty");
        ((TileEntityStructure)this.getSnapshot()).f = author;
    }

    public void setAuthor(LivingEntity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Structure Block author entity cannot be null");
        ((TileEntityStructure)this.getSnapshot()).a(((CraftLivingEntity)entity).getHandle());
    }

    public BlockVector getRelativePosition() {
        return new BlockVector(((TileEntityStructure)this.getSnapshot()).h.u(), ((TileEntityStructure)this.getSnapshot()).h.v(), ((TileEntityStructure)this.getSnapshot()).h.w());
    }

    public void setRelativePosition(BlockVector vector) {
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(vector.getBlockX(), -48, 48), (String)"Structure Size (X) must be between -48 and 48", (Object[])new Object[0]);
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(vector.getBlockY(), -48, 48), (String)"Structure Size (Y) must be between -48 and 48", (Object[])new Object[0]);
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(vector.getBlockZ(), -48, 48), (String)"Structure Size (Z) must be between -48 and 48", (Object[])new Object[0]);
        ((TileEntityStructure)this.getSnapshot()).h = new BlockPosition(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    public BlockVector getStructureSize() {
        return new BlockVector(((TileEntityStructure)this.getSnapshot()).i.u(), ((TileEntityStructure)this.getSnapshot()).i.v(), ((TileEntityStructure)this.getSnapshot()).i.w());
    }

    public void setStructureSize(BlockVector vector) {
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(vector.getBlockX(), 0, 48), (String)"Structure Size (X) must be between 0 and 48", (Object[])new Object[0]);
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(vector.getBlockY(), 0, 48), (String)"Structure Size (Y) must be between 0 and 48", (Object[])new Object[0]);
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(vector.getBlockZ(), 0, 48), (String)"Structure Size (Z) must be between 0 and 48", (Object[])new Object[0]);
        ((TileEntityStructure)this.getSnapshot()).i = new BlockPosition(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    public void setMirror(Mirror mirror) {
        ((TileEntityStructure)this.getSnapshot()).j = EnumBlockMirror.valueOf(mirror.name());
    }

    public Mirror getMirror() {
        return Mirror.valueOf((String)((TileEntityStructure)this.getSnapshot()).j.name());
    }

    public void setRotation(StructureRotation rotation) {
        ((TileEntityStructure)this.getSnapshot()).k = EnumBlockRotation.valueOf(rotation.name());
    }

    public StructureRotation getRotation() {
        return StructureRotation.valueOf((String)((TileEntityStructure)this.getSnapshot()).k.name());
    }

    public void setUsageMode(UsageMode mode) {
        ((TileEntityStructure)this.getSnapshot()).l = BlockPropertyStructureMode.valueOf(mode.name());
    }

    public UsageMode getUsageMode() {
        return UsageMode.valueOf((String)((TileEntityStructure)this.getSnapshot()).y().name());
    }

    public void setIgnoreEntities(boolean flag) {
        ((TileEntityStructure)this.getSnapshot()).m = flag;
    }

    public boolean isIgnoreEntities() {
        return ((TileEntityStructure)this.getSnapshot()).m;
    }

    public void setShowAir(boolean showAir) {
        ((TileEntityStructure)this.getSnapshot()).r = showAir;
    }

    public boolean isShowAir() {
        return ((TileEntityStructure)this.getSnapshot()).r;
    }

    public void setBoundingBoxVisible(boolean showBoundingBox) {
        ((TileEntityStructure)this.getSnapshot()).s = showBoundingBox;
    }

    public boolean isBoundingBoxVisible() {
        return ((TileEntityStructure)this.getSnapshot()).s;
    }

    public void setIntegrity(float integrity) {
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(integrity, 0.0f, 1.0f), (String)"Integrity must be between 0.0f and 1.0f", (Object[])new Object[0]);
        ((TileEntityStructure)this.getSnapshot()).t = integrity;
    }

    public float getIntegrity() {
        return ((TileEntityStructure)this.getSnapshot()).t;
    }

    public void setSeed(long seed) {
        ((TileEntityStructure)this.getSnapshot()).u = seed;
    }

    public long getSeed() {
        return ((TileEntityStructure)this.getSnapshot()).u;
    }

    public void setMetadata(String metadata) {
        Validate.notNull((Object)metadata, (String)"Structure metadata cannot be null", (Object[])new Object[0]);
        if (this.getUsageMode() == UsageMode.DATA) {
            ((TileEntityStructure)this.getSnapshot()).g = metadata;
        }
    }

    public String getMetadata() {
        return ((TileEntityStructure)this.getSnapshot()).g;
    }

    @Override
    protected void applyTo(TileEntityStructure tileEntity) {
        IBlockData data;
        super.applyTo(tileEntity);
        GeneratorAccess access = this.getWorldHandle();
        if (access instanceof net.minecraft.world.level.World) {
            tileEntity.a(tileEntity.y());
        } else if (access != null && (data = access.a_(this.getPosition())).a(Blocks.nm)) {
            access.a(this.getPosition(), (IBlockData)data.a(BlockStructure.a, tileEntity.y()), 2);
        }
    }

    private static boolean isBetween(int num, int min, int max) {
        return num >= min && num <= max;
    }

    private static boolean isBetween(float num, float min, float max) {
        return num >= min && num <= max;
    }
}

