/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.block;

import com.google.common.base.Preconditions;
import net.minecraft.world.level.block.BlockFurnace;
import net.minecraft.world.level.block.entity.TileEntityFurnace;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.World;
import org.bukkit.block.Furnace;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftContainer;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftInventoryFurnace;
import org.bukkit.inventory.FurnaceInventory;

public abstract class CraftFurnace<T extends TileEntityFurnace>
extends CraftContainer<T>
implements Furnace {
    public CraftFurnace(World world, T tileEntity) {
        super(world, tileEntity);
    }

    public FurnaceInventory getSnapshotInventory() {
        return new CraftInventoryFurnace((TileEntityFurnace)this.getSnapshot());
    }

    public FurnaceInventory getInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventoryFurnace((TileEntityFurnace)this.getTileEntity());
    }

    public short getBurnTime() {
        return (short)((TileEntityFurnace)this.getSnapshot()).t;
    }

    public void setBurnTime(short burnTime) {
        ((TileEntityFurnace)this.getSnapshot()).t = burnTime;
        this.data = (IBlockData)this.data.a(BlockFurnace.b, burnTime > 0);
    }

    public short getCookTime() {
        return (short)((TileEntityFurnace)this.getSnapshot()).v;
    }

    public void setCookTime(short cookTime) {
        ((TileEntityFurnace)this.getSnapshot()).v = cookTime;
    }

    public int getCookTimeTotal() {
        return ((TileEntityFurnace)this.getSnapshot()).w;
    }

    public void setCookTimeTotal(int cookTimeTotal) {
        ((TileEntityFurnace)this.getSnapshot()).w = cookTimeTotal;
    }

    public double getCookSpeedMultiplier() {
        return ((TileEntityFurnace)this.getSnapshot()).cookSpeedMultiplier;
    }

    public void setCookSpeedMultiplier(double multiplier) {
        Preconditions.checkArgument((multiplier >= 0.0 ? 1 : 0) != 0, (Object)"Furnace speed multiplier cannot be negative");
        Preconditions.checkArgument((multiplier <= 200.0 ? 1 : 0) != 0, (Object)"Furnace speed multiplier cannot more than 200");
        TileEntityFurnace snapshot = (TileEntityFurnace)this.getSnapshot();
        snapshot.cookSpeedMultiplier = multiplier;
        snapshot.w = TileEntityFurnace.getTotalCookTime(this.isPlaced() ? this.world.getHandle() : null, snapshot.y, snapshot, snapshot.cookSpeedMultiplier);
    }
}

