/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1.block;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import org.bukkit.World;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemStack;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class CraftCreatureSpawner
extends CraftBlockEntityState<TileEntityMobSpawner>
implements CreatureSpawner {
    public CraftCreatureSpawner(World world, TileEntityMobSpawner tileEntity) {
        super(world, tileEntity);
    }

    public EntityType getSpawnedType() {
        Optional<EntityTypes<?>> type = EntityTypes.a(((TileEntityMobSpawner)this.getSnapshot()).d().e.a());
        return type.isEmpty() ? EntityType.PIG : EntityType.fromName((String)EntityTypes.a(type.get()).a());
    }

    public void setSpawnedType(EntityType entityType) {
        if (entityType == null || entityType.getName() == null) {
            throw new IllegalArgumentException("Can't spawn EntityType " + entityType + " from mobspawners!");
        }
        ((TileEntityMobSpawner)this.getSnapshot()).d().a(EntityTypes.a(entityType.getName()).get());
    }

    public String getCreatureTypeName() {
        Optional<EntityTypes<?>> type = EntityTypes.a(((TileEntityMobSpawner)this.getSnapshot()).d().e.a());
        return type.isEmpty() ? "" : EntityTypes.a(type.get()).a();
    }

    public void setCreatureTypeByName(String creatureType) {
        EntityType type = EntityType.fromName((String)creatureType);
        if (type == null) {
            return;
        }
        this.setSpawnedType(type);
    }

    public int getDelay() {
        return ((TileEntityMobSpawner)this.getSnapshot()).d().c;
    }

    public void setDelay(int delay) {
        ((TileEntityMobSpawner)this.getSnapshot()).d().c = delay;
    }

    public int getMinSpawnDelay() {
        return ((TileEntityMobSpawner)this.getSnapshot()).d().h;
    }

    public void setMinSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay <= this.getMaxSpawnDelay() ? 1 : 0) != 0, (Object)"Minimum Spawn Delay must be less than or equal to Maximum Spawn Delay");
        ((TileEntityMobSpawner)this.getSnapshot()).d().h = spawnDelay;
    }

    public int getMaxSpawnDelay() {
        return ((TileEntityMobSpawner)this.getSnapshot()).d().i;
    }

    public void setMaxSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay > 0 ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than 0.");
        Preconditions.checkArgument((spawnDelay >= this.getMinSpawnDelay() ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than or equal to Minimum Spawn Delay");
        ((TileEntityMobSpawner)this.getSnapshot()).d().i = spawnDelay;
    }

    public int getMaxNearbyEntities() {
        return ((TileEntityMobSpawner)this.getSnapshot()).d().l;
    }

    public void setMaxNearbyEntities(int maxNearbyEntities) {
        ((TileEntityMobSpawner)this.getSnapshot()).d().l = maxNearbyEntities;
    }

    public int getSpawnCount() {
        return ((TileEntityMobSpawner)this.getSnapshot()).d().j;
    }

    public void setSpawnCount(int count) {
        ((TileEntityMobSpawner)this.getSnapshot()).d().j = count;
    }

    public int getRequiredPlayerRange() {
        return ((TileEntityMobSpawner)this.getSnapshot()).d().m;
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        ((TileEntityMobSpawner)this.getSnapshot()).d().m = requiredPlayerRange;
    }

    public int getSpawnRange() {
        return ((TileEntityMobSpawner)this.getSnapshot()).d().n;
    }

    public void setSpawnRange(int spawnRange) {
        ((TileEntityMobSpawner)this.getSnapshot()).d().n = spawnRange;
    }

    public boolean isActivated() {
        this.requirePlaced();
        return ((TileEntityMobSpawner)this.getSnapshot()).d().b(this.world.getHandle(), this.getPosition());
    }

    public void resetTimer() {
        this.requirePlaced();
        ((TileEntityMobSpawner)this.getSnapshot()).d().c(this.world.getHandle(), this.getPosition());
    }

    public void setSpawnedItem(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack != null && !itemStack.getType().isAir() ? 1 : 0) != 0, (Object)"spawners cannot spawn air");
        net.minecraft.world.item.ItemStack item = CraftItemStack.asNMSCopy(itemStack);
        NBTTagCompound entity = new NBTTagCompound();
        entity.a("id", IRegistry.Z.b(EntityTypes.Q).toString());
        entity.a("Item", item.b(new NBTTagCompound()));
        ((TileEntityMobSpawner)this.getSnapshot()).d().a((net.minecraft.world.level.World)(this.isPlaced() ? this.world.getHandle() : null), this.getPosition(), new MobSpawnerData(entity, Optional.empty()));
    }
}

