/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R1;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.projectile.EntityEgg;
import net.minecraft.world.entity.projectile.EntityEnderSignal;
import net.minecraft.world.entity.projectile.EntityEvokerFangs;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.entity.vehicle.EntityMinecartCommandBlock;
import net.minecraft.world.entity.vehicle.EntityMinecartFurnace;
import net.minecraft.world.entity.vehicle.EntityMinecartHopper;
import net.minecraft.world.entity.vehicle.EntityMinecartMobSpawner;
import net.minecraft.world.entity.vehicle.EntityMinecartRideable;
import net.minecraft.world.entity.vehicle.EntityMinecartTNT;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.BlockChorusFlower;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.RegionAccessor;
import org.bukkit.TreeType;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R1.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_18_R1.util.BlockStateListPopulator;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftMagicNumbers;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AbstractSkeleton;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Cat;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cod;
import org.bukkit.entity.ComplexLivingEntity;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Dolphin;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.Egg;
import org.bukkit.entity.ElderGuardian;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Fish;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Giant;
import org.bukkit.entity.GlowItemFrame;
import org.bukkit.entity.GlowSquid;
import org.bukkit.entity.Goat;
import org.bukkit.entity.Golem;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Husk;
import org.bukkit.entity.Illager;
import org.bukkit.entity.Illusioner;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LeashHitch;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Marker;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Mule;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.PiglinBrute;
import org.bukkit.entity.Pillager;
import org.bukkit.entity.Player;
import org.bukkit.entity.PolarBear;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Ravager;
import org.bukkit.entity.Salmon;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.entity.Slime;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.Spellcaster;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Squid;
import org.bukkit.entity.Stray;
import org.bukkit.entity.Strider;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.TraderLlama;
import org.bukkit.entity.Trident;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Turtle;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Vindicator;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkeleton;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zoglin;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieHorse;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.entity.minecart.SpawnerMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import org.bukkit.util.Consumer;
import org.bukkit.util.Vector;

public abstract class CraftRegionAccessor
implements RegionAccessor {
    public abstract GeneratorAccessSeed getHandle();

    public boolean isNormalWorld() {
        return this.getHandle() instanceof WorldServer;
    }

    public Biome getBiome(Location location) {
        return this.getBiome(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public Biome getBiome(int x2, int y2, int z2) {
        return CraftBlock.biomeBaseToBiome(this.getHandle().t().d(IRegistry.aR), this.getHandle().getNoiseBiome(x2 >> 2, y2 >> 2, z2 >> 2));
    }

    public void setBiome(Location location, Biome biome) {
        this.setBiome(location.getBlockX(), location.getBlockY(), location.getBlockZ(), biome);
    }

    public void setBiome(int x2, int y2, int z2, Biome biome) {
        Preconditions.checkArgument((biome != Biome.CUSTOM ? 1 : 0) != 0, (String)"Cannot set the biome to %s", (Object)biome);
        BiomeBase biomeBase = CraftBlock.biomeToBiomeBase(this.getHandle().t().d(IRegistry.aR), biome);
        this.setBiome(x2, y2, z2, biomeBase);
    }

    public abstract void setBiome(int var1, int var2, int var3, BiomeBase var4);

    public BlockState getBlockState(Location location) {
        return this.getBlockState(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public BlockState getBlockState(int x2, int y2, int z2) {
        return CraftBlock.at(this.getHandle(), new BlockPosition(x2, y2, z2)).getState();
    }

    public BlockData getBlockData(Location location) {
        return this.getBlockData(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public BlockData getBlockData(int x2, int y2, int z2) {
        return CraftBlockData.fromData(this.getData(x2, y2, z2));
    }

    public Material getType(Location location) {
        return this.getType(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public Material getType(int x2, int y2, int z2) {
        return CraftMagicNumbers.getMaterial(this.getData(x2, y2, z2).b());
    }

    private IBlockData getData(int x2, int y2, int z2) {
        return this.getHandle().a_(new BlockPosition(x2, y2, z2));
    }

    public void setBlockData(Location location, BlockData blockData) {
        this.setBlockData(location.getBlockX(), location.getBlockY(), location.getBlockZ(), blockData);
    }

    public void setBlockData(int x2, int y2, int z2, BlockData blockData) {
        GeneratorAccessSeed world = this.getHandle();
        BlockPosition pos = new BlockPosition(x2, y2, z2);
        IBlockData old = this.getHandle().a_(pos);
        CraftBlock.setTypeAndData(world, pos, old, ((CraftBlockData)blockData).getState(), true);
    }

    public void setType(Location location, Material material) {
        this.setType(location.getBlockX(), location.getBlockY(), location.getBlockZ(), material);
    }

    public void setType(int x2, int y2, int z2, Material material) {
        this.setBlockData(x2, y2, z2, material.createBlockData());
    }

    public boolean generateTree(Location location, Random random, TreeType treeType) {
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        return this.generateTree(this.getHandle(), this.getHandle().getMinecraftWorld().k().g(), pos, random, treeType);
    }

    public boolean generateTree(Location location, Random random, TreeType treeType, Consumer<BlockState> consumer) {
        return this.generateTree(location, random, treeType, consumer == null ? null : block -> {
            consumer.accept(block);
            return true;
        });
    }

    public boolean generateTree(Location location, Random random, TreeType treeType, Predicate<BlockState> predicate) {
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        BlockStateListPopulator populator = new BlockStateListPopulator(this.getHandle());
        boolean result = this.generateTree(populator, this.getHandle().getMinecraftWorld().k().g(), pos, random, treeType);
        populator.refreshTiles();
        for (BlockState blockState : populator.getList()) {
            if (predicate != null && !predicate.test(blockState)) continue;
            blockState.update(true, true);
        }
        return result;
    }

    public boolean generateTree(GeneratorAccessSeed access, ChunkGenerator chunkGenerator, BlockPosition pos, Random random, TreeType treeType) {
        WorldGenFeatureConfigured<WorldGenFeatureConfiguration, ?> gen;
        switch (treeType) {
            case BIG_TREE: {
                gen = TreeFeatures.n;
                break;
            }
            case BIRCH: {
                gen = TreeFeatures.i;
                break;
            }
            case REDWOOD: {
                gen = TreeFeatures.k;
                break;
            }
            case TALL_REDWOOD: {
                gen = TreeFeatures.l;
                break;
            }
            case JUNGLE: {
                gen = TreeFeatures.p;
                break;
            }
            case SMALL_JUNGLE: {
                gen = TreeFeatures.o;
                break;
            }
            case COCOA_TREE: {
                gen = TreeFeatures.m;
                break;
            }
            case JUNGLE_BUSH: {
                gen = TreeFeatures.v;
                break;
            }
            case RED_MUSHROOM: {
                gen = TreeFeatures.f;
                break;
            }
            case BROWN_MUSHROOM: {
                gen = TreeFeatures.e;
                break;
            }
            case SWAMP: {
                gen = TreeFeatures.u;
                break;
            }
            case ACACIA: {
                gen = TreeFeatures.j;
                break;
            }
            case DARK_OAK: {
                gen = TreeFeatures.h;
                break;
            }
            case MEGA_REDWOOD: {
                gen = TreeFeatures.r;
                break;
            }
            case TALL_BIRCH: {
                gen = TreeFeatures.s;
                break;
            }
            case CHORUS_PLANT: {
                BlockChorusFlower cfr_ignored_0 = (BlockChorusFlower)Blocks.iM;
                BlockChorusFlower.a(access, pos, random, 8);
                return true;
            }
            case CRIMSON_FUNGUS: {
                gen = TreeFeatures.b;
                break;
            }
            case WARPED_FUNGUS: {
                gen = TreeFeatures.d;
                break;
            }
            case AZALEA: {
                gen = TreeFeatures.w;
                break;
            }
            default: {
                gen = TreeFeatures.g;
            }
        }
        return ((WorldGenerator)gen.e).a(new FeaturePlaceContext(Optional.empty(), access, chunkGenerator, random, pos, gen.f));
    }

    public Entity spawnEntity(Location location, EntityType entityType) {
        return this.spawn(location, entityType.getEntityClass());
    }

    public Entity spawnEntity(Location loc, EntityType type, boolean randomizeData) {
        return this.spawn(loc, type.getEntityClass(), null, CreatureSpawnEvent.SpawnReason.CUSTOM, randomizeData);
    }

    public List<Entity> getEntities() {
        ArrayList<Entity> list = new ArrayList<Entity>();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity != null && (!this.isNormalWorld() || bukkitEntity.isValid())) {
                list.add(bukkitEntity);
            }
        });
        return list;
    }

    public List<LivingEntity> getLivingEntities() {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity != null && bukkitEntity instanceof LivingEntity && (!this.isNormalWorld() || bukkitEntity.isValid())) {
                list.add((LivingEntity)bukkitEntity);
            }
        });
        return list;
    }

    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> clazz) {
        ArrayList list = new ArrayList();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity == null) {
                return;
            }
            Class<?> bukkitClass = bukkitEntity.getClass();
            if (clazz.isAssignableFrom(bukkitClass) && (!this.isNormalWorld() || bukkitEntity.isValid())) {
                list.add(bukkitEntity);
            }
        });
        return list;
    }

    public Collection<Entity> getEntitiesByClasses(Class<?> ... classes) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity == null) {
                return;
            }
            Class<?> bukkitClass = bukkitEntity.getClass();
            for (Class clazz : classes) {
                if (!clazz.isAssignableFrom(bukkitClass)) continue;
                if (this.isNormalWorld() && !bukkitEntity.isValid()) break;
                list.add(bukkitEntity);
                break;
            }
        });
        return list;
    }

    public abstract Iterable<net.minecraft.world.entity.Entity> getNMSEntities();

    public <T extends Entity> T spawn(Location location, Class<T> clazz) throws IllegalArgumentException {
        return this.spawn(location, clazz, null, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<T> function) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, boolean randomizeData, Consumer<T> function) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, CreatureSpawnEvent.SpawnReason.CUSTOM, randomizeData);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<T> function, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, reason, true);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<T> function, CreatureSpawnEvent.SpawnReason reason, boolean randomizeData) throws IllegalArgumentException {
        net.minecraft.world.entity.Entity entity = this.createEntity(location, clazz, randomizeData);
        return this.addEntity(entity, reason, function, randomizeData);
    }

    public <T extends Entity> T addEntity(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        return this.addEntity(entity, reason, null, true);
    }

    public <T extends Entity> T addEntity(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason, Consumer<T> function, boolean randomizeData) throws IllegalArgumentException {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Cannot spawn null entity");
        if (randomizeData && entity instanceof EntityInsentient) {
            ((EntityInsentient)entity).a(this.getHandle(), this.getHandle().d_(entity.cW()), EnumMobSpawn.n, (GroupDataEntity)null, null);
        }
        if (!this.isNormalWorld()) {
            entity.generation = true;
        }
        if (function != null) {
            function.accept((Object)entity.getBukkitEntity());
        }
        this.addEntityToWorld(entity, reason);
        return (T)entity.getBukkitEntity();
    }

    public abstract void addEntityToWorld(net.minecraft.world.entity.Entity var1, CreatureSpawnEvent.SpawnReason var2);

    public net.minecraft.world.entity.Entity createEntity(Location location, Class<? extends Entity> clazz) throws IllegalArgumentException {
        return this.createEntity(location, clazz, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public net.minecraft.world.entity.Entity createEntity(Location location, Class<? extends Entity> clazz, boolean randomizeData) throws IllegalArgumentException {
        if (location == null || clazz == null) {
            throw new IllegalArgumentException("Location or entity class cannot be null");
        }
        net.minecraft.world.entity.Entity entity = null;
        WorldServer world = this.getHandle().getMinecraftWorld();
        double x2 = location.getX();
        double y2 = location.getY();
        double z2 = location.getZ();
        float pitch = location.getPitch();
        float yaw = location.getYaw();
        if (Boat.class.isAssignableFrom(clazz)) {
            entity = new EntityBoat(world, x2, y2, z2);
            entity.b(x2, y2, z2, yaw, pitch);
        } else if (Item.class.isAssignableFrom(clazz)) {
            entity = new EntityItem(world, x2, y2, z2, new ItemStack(net.minecraft.world.item.Item.a(Blocks.j)));
        } else if (FallingBlock.class.isAssignableFrom(clazz)) {
            entity = new EntityFallingBlock(world, x2, y2, z2, this.getHandle().a_(new BlockPosition(x2, y2, z2)));
        } else if (Projectile.class.isAssignableFrom(clazz)) {
            if (Snowball.class.isAssignableFrom(clazz)) {
                entity = new EntitySnowball(world, x2, y2, z2);
            } else if (Egg.class.isAssignableFrom(clazz)) {
                entity = new EntityEgg(world, x2, y2, z2);
            } else if (AbstractArrow.class.isAssignableFrom(clazz)) {
                if (TippedArrow.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.d.a(world);
                    ((EntityTippedArrow)entity).setPotionType(CraftPotionUtil.fromBukkit(new PotionData(PotionType.WATER, false, false)));
                } else {
                    entity = SpectralArrow.class.isAssignableFrom(clazz) ? EntityTypes.aH.a(world) : (Trident.class.isAssignableFrom(clazz) ? EntityTypes.aQ.a(world) : EntityTypes.d.a(world));
                }
                entity.b(x2, y2, z2, 0.0f, 0.0f);
            } else if (ThrownExpBottle.class.isAssignableFrom(clazz)) {
                entity = EntityTypes.aO.a(world);
                entity.b(x2, y2, z2, 0.0f, 0.0f);
            } else if (EnderPearl.class.isAssignableFrom(clazz)) {
                entity = EntityTypes.aN.a(world);
                entity.b(x2, y2, z2, 0.0f, 0.0f);
            } else if (ThrownPotion.class.isAssignableFrom(clazz)) {
                if (LingeringPotion.class.isAssignableFrom(clazz)) {
                    entity = new EntityPotion(world, x2, y2, z2);
                    ((EntityPotion)entity).a(CraftItemStack.asNMSCopy(new org.bukkit.inventory.ItemStack(Material.LINGERING_POTION, 1)));
                } else {
                    entity = new EntityPotion(world, x2, y2, z2);
                    ((EntityPotion)entity).a(CraftItemStack.asNMSCopy(new org.bukkit.inventory.ItemStack(Material.SPLASH_POTION, 1)));
                }
            } else if (Fireball.class.isAssignableFrom(clazz)) {
                entity = SmallFireball.class.isAssignableFrom(clazz) ? EntityTypes.aE.a(world) : (WitherSkull.class.isAssignableFrom(clazz) ? EntityTypes.bb.a(world) : (DragonFireball.class.isAssignableFrom(clazz) ? EntityTypes.r.a(world) : EntityTypes.S.a(world)));
                entity.b(x2, y2, z2, yaw, pitch);
                Vector direction = location.getDirection().multiply(10);
                ((EntityFireball)entity).setDirection(direction.getX(), direction.getY(), direction.getZ());
            } else if (ShulkerBullet.class.isAssignableFrom(clazz)) {
                entity = EntityTypes.az.a(world);
                entity.b(x2, y2, z2, yaw, pitch);
            } else if (LlamaSpit.class.isAssignableFrom(clazz)) {
                entity = EntityTypes.W.a(world);
                entity.b(x2, y2, z2, yaw, pitch);
            } else if (Firework.class.isAssignableFrom(clazz)) {
                entity = new EntityFireworks(world, x2, y2, z2, ItemStack.b);
            }
        } else if (Minecart.class.isAssignableFrom(clazz)) {
            entity = PoweredMinecart.class.isAssignableFrom(clazz) ? new EntityMinecartFurnace(world, x2, y2, z2) : (StorageMinecart.class.isAssignableFrom(clazz) ? new EntityMinecartChest(world, x2, y2, z2) : (ExplosiveMinecart.class.isAssignableFrom(clazz) ? new EntityMinecartTNT(world, x2, y2, z2) : (HopperMinecart.class.isAssignableFrom(clazz) ? new EntityMinecartHopper(world, x2, y2, z2) : (SpawnerMinecart.class.isAssignableFrom(clazz) ? new EntityMinecartMobSpawner(world, x2, y2, z2) : (CommandMinecart.class.isAssignableFrom(clazz) ? new EntityMinecartCommandBlock(world, x2, y2, z2) : new EntityMinecartRideable(world, x2, y2, z2))))));
        } else if (EnderSignal.class.isAssignableFrom(clazz)) {
            entity = new EntityEnderSignal(world, x2, y2, z2);
        } else if (EnderCrystal.class.isAssignableFrom(clazz)) {
            entity = EntityTypes.u.a(world);
            entity.b(x2, y2, z2, 0.0f, 0.0f);
        } else if (LivingEntity.class.isAssignableFrom(clazz)) {
            if (Chicken.class.isAssignableFrom(clazz)) {
                entity = EntityTypes.l.a(world);
            } else if (Cow.class.isAssignableFrom(clazz)) {
                entity = MushroomCow.class.isAssignableFrom(clazz) ? EntityTypes.ah.a(world) : EntityTypes.n.a(world);
            } else if (Golem.class.isAssignableFrom(clazz)) {
                if (Snowman.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.aF.a(world);
                } else if (IronGolem.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.P.a(world);
                } else if (Shulker.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.ay.a(world);
                }
            } else if (Creeper.class.isAssignableFrom(clazz)) {
                entity = EntityTypes.o.a(world);
            } else if (Ghast.class.isAssignableFrom(clazz)) {
                entity = EntityTypes.F.a(world);
            } else if (Pig.class.isAssignableFrom(clazz)) {
                entity = EntityTypes.an.a(world);
            } else if (!Player.class.isAssignableFrom(clazz)) {
                if (Sheep.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.ax.a(world);
                } else if (AbstractHorse.class.isAssignableFrom(clazz)) {
                    if (ChestedHorse.class.isAssignableFrom(clazz)) {
                        if (Donkey.class.isAssignableFrom(clazz)) {
                            entity = EntityTypes.q.a(world);
                        } else if (Mule.class.isAssignableFrom(clazz)) {
                            entity = EntityTypes.ag.a(world);
                        } else if (Llama.class.isAssignableFrom(clazz)) {
                            entity = TraderLlama.class.isAssignableFrom(clazz) ? EntityTypes.aR.a(world) : EntityTypes.V.a(world);
                        }
                    } else {
                        entity = SkeletonHorse.class.isAssignableFrom(clazz) ? EntityTypes.aC.a(world) : (ZombieHorse.class.isAssignableFrom(clazz) ? EntityTypes.bf.a(world) : EntityTypes.M.a(world));
                    }
                } else if (AbstractSkeleton.class.isAssignableFrom(clazz)) {
                    if (Stray.class.isAssignableFrom(clazz)) {
                        entity = EntityTypes.aK.a(world);
                    } else if (WitherSkeleton.class.isAssignableFrom(clazz)) {
                        entity = EntityTypes.ba.a(world);
                    } else if (Skeleton.class.isAssignableFrom(clazz)) {
                        entity = EntityTypes.aB.a(world);
                    }
                } else if (Slime.class.isAssignableFrom(clazz)) {
                    entity = MagmaCube.class.isAssignableFrom(clazz) ? EntityTypes.X.a(world) : EntityTypes.aD.a(world);
                } else if (Spider.class.isAssignableFrom(clazz)) {
                    entity = CaveSpider.class.isAssignableFrom(clazz) ? EntityTypes.k.a(world) : EntityTypes.aI.a(world);
                } else if (Squid.class.isAssignableFrom(clazz)) {
                    entity = GlowSquid.class.isAssignableFrom(clazz) ? EntityTypes.I.a(world) : EntityTypes.aJ.a(world);
                } else if (Tameable.class.isAssignableFrom(clazz)) {
                    if (Wolf.class.isAssignableFrom(clazz)) {
                        entity = EntityTypes.bc.a(world);
                    } else if (Parrot.class.isAssignableFrom(clazz)) {
                        entity = EntityTypes.al.a(world);
                    } else if (Cat.class.isAssignableFrom(clazz)) {
                        entity = EntityTypes.j.a(world);
                    }
                } else if (PigZombie.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.bh.a(world);
                } else if (Zombie.class.isAssignableFrom(clazz)) {
                    entity = Husk.class.isAssignableFrom(clazz) ? EntityTypes.N.a(world) : (ZombieVillager.class.isAssignableFrom(clazz) ? EntityTypes.bg.a(world) : (Drowned.class.isAssignableFrom(clazz) ? EntityTypes.s.a(world) : new EntityZombie(world)));
                } else if (Giant.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.G.a(world);
                } else if (Silverfish.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.aA.a(world);
                } else if (Enderman.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.w.a(world);
                } else if (Blaze.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.h.a(world);
                } else if (AbstractVillager.class.isAssignableFrom(clazz)) {
                    if (Villager.class.isAssignableFrom(clazz)) {
                        entity = EntityTypes.aV.a(world);
                    } else if (WanderingTrader.class.isAssignableFrom(clazz)) {
                        entity = EntityTypes.aX.a(world);
                    }
                } else if (Witch.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.aY.a(world);
                } else if (Wither.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.aZ.a(world);
                } else if (ComplexLivingEntity.class.isAssignableFrom(clazz)) {
                    if (EnderDragon.class.isAssignableFrom(clazz)) {
                        if (!this.isNormalWorld()) throw new IllegalArgumentException("Cannot spawn entity " + clazz.getName() + " during world generation");
                        entity = EntityTypes.v.a(this.getHandle().getMinecraftWorld());
                    }
                } else if (Ambient.class.isAssignableFrom(clazz)) {
                    if (Bat.class.isAssignableFrom(clazz)) {
                        entity = EntityTypes.f.a(world);
                    }
                } else if (Rabbit.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.au.a(world);
                } else if (Endermite.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.x.a(world);
                } else if (Guardian.class.isAssignableFrom(clazz)) {
                    entity = ElderGuardian.class.isAssignableFrom(clazz) ? EntityTypes.t.a(world) : EntityTypes.K.a(world);
                } else if (ArmorStand.class.isAssignableFrom(clazz)) {
                    entity = new EntityArmorStand(world, x2, y2, z2);
                } else if (PolarBear.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.ar.a(world);
                } else if (Vex.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.aU.a(world);
                } else if (Illager.class.isAssignableFrom(clazz)) {
                    if (Spellcaster.class.isAssignableFrom(clazz)) {
                        if (Evoker.class.isAssignableFrom(clazz)) {
                            entity = EntityTypes.y.a(world);
                        } else if (Illusioner.class.isAssignableFrom(clazz)) {
                            entity = EntityTypes.O.a(world);
                        }
                    } else if (Vindicator.class.isAssignableFrom(clazz)) {
                        entity = EntityTypes.aW.a(world);
                    } else if (Pillager.class.isAssignableFrom(clazz)) {
                        entity = EntityTypes.aq.a(world);
                    }
                } else if (Turtle.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.aT.a(world);
                } else if (Phantom.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.am.a(world);
                } else if (Fish.class.isAssignableFrom(clazz)) {
                    if (Cod.class.isAssignableFrom(clazz)) {
                        entity = EntityTypes.m.a(world);
                    } else if (PufferFish.class.isAssignableFrom(clazz)) {
                        entity = EntityTypes.at.a(world);
                    } else if (Salmon.class.isAssignableFrom(clazz)) {
                        entity = EntityTypes.aw.a(world);
                    } else if (TropicalFish.class.isAssignableFrom(clazz)) {
                        entity = EntityTypes.aS.a(world);
                    }
                } else if (Dolphin.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.p.a(world);
                } else if (Ocelot.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.ai.a(world);
                } else if (Ravager.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.av.a(world);
                } else if (Panda.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.ak.a(world);
                } else if (Fox.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.E.a(world);
                } else if (Bee.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.g.a(world);
                } else if (Hoglin.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.L.a(world);
                } else if (Piglin.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.ao.a(world);
                } else if (PiglinBrute.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.ap.a(world);
                } else if (Strider.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.aL.a(world);
                } else if (Zoglin.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.bd.a(world);
                } else if (Axolotl.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.e.a(world);
                } else if (Goat.class.isAssignableFrom(clazz)) {
                    entity = EntityTypes.J.a(world);
                }
            }
            if (entity != null) {
                entity.a(x2, y2, z2, yaw, pitch);
                entity.l(yaw);
            }
        } else if (Hanging.class.isAssignableFrom(clazz)) {
            if (LeashHitch.class.isAssignableFrom(clazz)) {
                entity = new EntityLeash(world, new BlockPosition(x2, y2, z2));
            } else {
                BlockFace face = BlockFace.SELF;
                BlockFace[] faces = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH};
                int width = 16;
                int height = 16;
                if (ItemFrame.class.isAssignableFrom(clazz)) {
                    width = 12;
                    height = 12;
                    faces = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH, BlockFace.UP, BlockFace.DOWN};
                }
                BlockPosition pos = new BlockPosition(x2, y2, z2);
                for (BlockFace dir : faces) {
                    IBlockData nmsBlock = this.getHandle().a_(pos.a(CraftBlock.blockFaceToNotch(dir)));
                    if (!nmsBlock.c().b() && !BlockDiodeAbstract.n(nmsBlock)) continue;
                    boolean taken = false;
                    AxisAlignedBB bb = ItemFrame.class.isAssignableFrom(clazz) ? EntityItemFrame.calculateBoundingBox(null, pos, CraftBlock.blockFaceToNotch(dir).f(), width, height) : EntityHanging.calculateBoundingBox(null, pos, CraftBlock.blockFaceToNotch(dir).f(), width, height);
                    List<net.minecraft.world.entity.Entity> list = this.getHandle().a_(null, bb);
                    Iterator<net.minecraft.world.entity.Entity> it = list.iterator();
                    while (!taken && it.hasNext()) {
                        net.minecraft.world.entity.Entity e2 = it.next();
                        if (!(e2 instanceof EntityHanging)) continue;
                        taken = true;
                    }
                    if (taken) continue;
                    face = dir;
                    break;
                }
                if (face == BlockFace.SELF) {
                    face = BlockFace.SOUTH;
                    randomizeData = false;
                }
                EnumDirection dir = CraftBlock.blockFaceToNotch(face).f();
                if (Painting.class.isAssignableFrom(clazz)) {
                    if (this.isNormalWorld() && randomizeData) {
                        entity = new EntityPainting(this.getHandle().getMinecraftWorld(), new BlockPosition(x2, y2, z2), dir);
                    } else {
                        entity = new EntityPainting((EntityTypes<? extends EntityPainting>)EntityTypes.aj, (World)this.getHandle().getMinecraftWorld());
                        entity.a(x2, y2, z2, yaw, pitch);
                        ((EntityPainting)entity).a(dir);
                    }
                } else if (ItemFrame.class.isAssignableFrom(clazz)) {
                    entity = GlowItemFrame.class.isAssignableFrom(clazz) ? new net.minecraft.world.entity.decoration.GlowItemFrame(world, new BlockPosition(x2, y2, z2), dir) : new EntityItemFrame(world, new BlockPosition(x2, y2, z2), dir);
                }
            }
        } else if (TNTPrimed.class.isAssignableFrom(clazz)) {
            entity = new EntityTNTPrimed(world, x2, y2, z2, null);
        } else if (ExperienceOrb.class.isAssignableFrom(clazz)) {
            entity = new EntityExperienceOrb(world, x2, y2, z2, 0, ExperienceOrb.SpawnReason.CUSTOM, null, null);
        } else if (LightningStrike.class.isAssignableFrom(clazz)) {
            entity = EntityTypes.U.a(world);
            entity.c(location.getX(), location.getY(), location.getZ());
        } else if (AreaEffectCloud.class.isAssignableFrom(clazz)) {
            entity = new EntityAreaEffectCloud(world, x2, y2, z2);
            entity.b(x2, y2, z2, yaw, pitch);
        } else if (EvokerFangs.class.isAssignableFrom(clazz)) {
            entity = new EntityEvokerFangs(world, x2, y2, z2, (float)Math.toRadians(yaw), 0, null);
        } else if (Marker.class.isAssignableFrom(clazz)) {
            entity = EntityTypes.Y.a(world);
            entity.e(x2, y2, z2);
        }
        if (entity == null) throw new IllegalArgumentException("Cannot spawn an entity for " + clazz.getName());
        return entity;
    }
}

