/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.timers;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.primitives.UnsignedLong;
import com.mojang.serialization.Dynamic;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimer;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomFunctionCallbackTimerQueue<T> {
    private static final Logger a = LogManager.getLogger();
    private static final String b = "Callback";
    private static final String c = "Name";
    private static final String d = "TriggerTime";
    private final CustomFunctionCallbackTimers<T> e;
    private final Queue<a<T>> f = new PriorityQueue<a<T>>(CustomFunctionCallbackTimerQueue.c());
    private UnsignedLong g = UnsignedLong.ZERO;
    private final Table<String, Long, a<T>> h = HashBasedTable.create();

    private static <T> Comparator<a<T>> c() {
        return Comparator.comparingLong(event -> event.a).thenComparing(event -> event.b);
    }

    public CustomFunctionCallbackTimerQueue(CustomFunctionCallbackTimers<T> timerCallbackSerializer, Stream<Dynamic<NBTBase>> stream) {
        this(timerCallbackSerializer);
        this.f.clear();
        this.h.clear();
        this.g = UnsignedLong.ZERO;
        stream.forEach(dynamic -> {
            if (!(dynamic.getValue() instanceof NBTTagCompound)) {
                a.warn("Invalid format of events: {}", (Object)dynamic);
                return;
            }
            this.a((NBTTagCompound)dynamic.getValue());
        });
    }

    public CustomFunctionCallbackTimerQueue(CustomFunctionCallbackTimers<T> timerCallbackSerializer) {
        this.e = timerCallbackSerializer;
    }

    public void a(T server, long time) {
        a<T> event;
        while ((event = this.f.peek()) != null && event.a <= time) {
            this.f.remove();
            this.h.remove((Object)event.c, (Object)time);
            event.d.handle(server, this, time);
        }
    }

    public void a(String name, long triggerTime, CustomFunctionCallbackTimer<T> callback) {
        if (this.h.contains((Object)name, (Object)triggerTime)) {
            return;
        }
        this.g = this.g.plus(UnsignedLong.ONE);
        a<T> event = new a<T>(triggerTime, this.g, name, callback);
        this.h.put((Object)name, (Object)triggerTime, event);
        this.f.add(event);
    }

    public int a(String name) {
        Collection collection = this.h.row((Object)name).values();
        collection.forEach(this.f::remove);
        int i2 = collection.size();
        collection.clear();
        return i2;
    }

    public Set<String> a() {
        return Collections.unmodifiableSet(this.h.rowKeySet());
    }

    private void a(NBTTagCompound nbt) {
        NBTTagCompound compoundTag = nbt.p(b);
        CustomFunctionCallbackTimer<T> timerCallback = this.e.a(compoundTag);
        if (timerCallback != null) {
            String string = nbt.l(c);
            long l2 = nbt.i(d);
            this.a(string, l2, timerCallback);
        }
    }

    private NBTTagCompound a(a<T> event) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a(c, event.c);
        compoundTag.a(d, event.a);
        compoundTag.a(b, this.e.a(event.d));
        return compoundTag;
    }

    public NBTTagList b() {
        NBTTagList listTag = new NBTTagList();
        this.f.stream().sorted(CustomFunctionCallbackTimerQueue.c()).map(this::a).forEach(listTag::add);
        return listTag;
    }

    public static class a<T> {
        public final long a;
        public final UnsignedLong b;
        public final String c;
        public final CustomFunctionCallbackTimer<T> d;

        a(long triggerTime, UnsignedLong id, String name, CustomFunctionCallbackTimer<T> callback) {
            this.a = triggerTime;
            this.b = id;
            this.c = name;
            this.d = callback;
        }
    }
}

