/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;

public class LootItemConditionEntityScore
implements LootItemCondition {
    final Map<String, IntRange> a;
    final LootTableInfo.EntityTarget b;

    LootItemConditionEntityScore(Map<String, IntRange> scores, LootTableInfo.EntityTarget target) {
        this.a = ImmutableMap.copyOf(scores);
        this.b = target;
    }

    @Override
    @Override
    public LootItemConditionType a() {
        return LootItemConditions.g;
    }

    @Override
    @Override
    public Set<LootContextParameter<?>> b() {
        return (Set)Stream.concat(Stream.of(this.b.a()), this.a.values().stream().flatMap(intRange -> intRange.a().stream())).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public boolean a(LootTableInfo lootContext) {
        Entity entity = lootContext.c(this.b.a());
        if (entity == null) {
            return false;
        }
        Scoreboard scoreboard = entity.t.K();
        for (Map.Entry<String, IntRange> entry : this.a.entrySet()) {
            if (this.a(lootContext, entity, scoreboard, entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    protected boolean a(LootTableInfo context, Entity entity, Scoreboard scoreboard, String objectiveName, IntRange range) {
        ScoreboardObjective objective = scoreboard.d(objectiveName);
        if (objective == null) {
            return false;
        }
        String string = entity.co();
        if (!scoreboard.b(string, objective)) {
            return false;
        }
        return range.b(context, scoreboard.c(string, objective).b());
    }

    public static a a(LootTableInfo.EntityTarget target) {
        return new a(target);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.a((LootTableInfo)object);
    }

    public static class a
    implements LootItemCondition.a {
        private final Map<String, IntRange> a = Maps.newHashMap();
        private final LootTableInfo.EntityTarget b;

        public a(LootTableInfo.EntityTarget target) {
            this.b = target;
        }

        public a a(String name, IntRange value) {
            this.a.put(name, value);
            return this;
        }

        @Override
        @Override
        public LootItemCondition build() {
            return new LootItemConditionEntityScore(this.a, this.b);
        }
    }

    public static class b
    implements LootSerializer<LootItemConditionEntityScore> {
        @Override
        @Override
        public void a(JsonObject json, LootItemConditionEntityScore object, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry<String, IntRange> entry : object.a.entrySet()) {
                jsonObject.add(entry.getKey(), context.serialize((Object)entry.getValue()));
            }
            json.add("scores", (JsonElement)jsonObject);
            json.add("entity", context.serialize((Object)object.b));
        }

        @Override
        public LootItemConditionEntityScore b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            Set set = ChatDeserializer.t(jsonObject, "scores").entrySet();
            LinkedHashMap map = Maps.newLinkedHashMap();
            for (Map.Entry entry : set) {
                map.put((String)entry.getKey(), ChatDeserializer.a((JsonElement)entry.getValue(), "score", jsonDeserializationContext, IntRange.class));
            }
            return new LootItemConditionEntityScore(map, ChatDeserializer.a(jsonObject, "entity", jsonDeserializationContext, LootTableInfo.EntityTarget.class));
        }

        @Override
        public /* synthetic */ Object a(JsonObject json, JsonDeserializationContext context) {
            return this.b(json, context);
        }
    }
}

