/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemEnchantedBook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class SetEnchantmentsFunction
extends LootItemFunctionConditional {
    final Map<Enchantment, NumberProvider> a;
    final boolean b;

    SetEnchantmentsFunction(LootItemCondition[] conditions, Map<Enchantment, NumberProvider> enchantments, boolean add) {
        super(conditions);
        this.a = ImmutableMap.copyOf(enchantments);
        this.b = add;
    }

    @Override
    @Override
    public LootItemFunctionType a() {
        return LootItemFunctions.e;
    }

    @Override
    @Override
    public Set<LootContextParameter<?>> b() {
        return (Set)this.a.values().stream().flatMap(numberProvider -> numberProvider.b().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
        this.a.forEach((arg_0, arg_1) -> SetEnchantmentsFunction.a((Object2IntMap)object2IntMap, context, arg_0, arg_1));
        if (stack.c() == Items.om) {
            ItemStack itemStack = new ItemStack(Items.rB);
            object2IntMap.forEach((enchantment, level) -> ItemEnchantedBook.a(itemStack, new WeightedRandomEnchant((Enchantment)enchantment, (int)level)));
            return itemStack;
        }
        Map<Enchantment, Integer> map = EnchantmentManager.a(stack);
        if (this.b) {
            object2IntMap.forEach((enchantment, level) -> SetEnchantmentsFunction.a(map, enchantment, Math.max(map.getOrDefault(enchantment, 0) + level, 0)));
        } else {
            object2IntMap.forEach((enchantment, level) -> SetEnchantmentsFunction.a(map, enchantment, Math.max(level, 0)));
        }
        EnchantmentManager.a(map, stack);
        return stack;
    }

    private static void a(Map<Enchantment, Integer> map, Enchantment enchantment, int level) {
        if (level == 0) {
            map.remove(enchantment);
        } else {
            map.put(enchantment, level);
        }
    }

    private static /* synthetic */ void a(Object2IntMap object2IntMap, LootTableInfo lootContext, Enchantment enchantment, NumberProvider numberProvider) {
        object2IntMap.put((Object)enchantment, numberProvider.a(lootContext));
    }

    public static class b
    extends LootItemFunctionConditional.c<SetEnchantmentsFunction> {
        @Override
        @Override
        public void a(JsonObject json, SetEnchantmentsFunction object, JsonSerializationContext context) {
            super.a(json, object, context);
            JsonObject jsonObject = new JsonObject();
            object.a.forEach((enchantment, numberProvider) -> {
                MinecraftKey resourceLocation = IRegistry.Y.b((Enchantment)enchantment);
                if (resourceLocation == null) {
                    throw new IllegalArgumentException("Don't know how to serialize enchantment " + enchantment);
                }
                jsonObject.add(resourceLocation.toString(), context.serialize(numberProvider));
            });
            json.add("enchantments", (JsonElement)jsonObject);
            json.addProperty("add", Boolean.valueOf(object.b));
        }

        @Override
        public SetEnchantmentsFunction a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditions) {
            HashMap map = Maps.newHashMap();
            if (jsonObject.has("enchantments")) {
                JsonObject jsonObject2 = ChatDeserializer.t(jsonObject, "enchantments");
                for (Map.Entry entry : jsonObject2.entrySet()) {
                    String string = (String)entry.getKey();
                    JsonElement jsonElement = (JsonElement)entry.getValue();
                    Enchantment enchantment = IRegistry.Y.b(new MinecraftKey(string)).orElseThrow(() -> new JsonSyntaxException("Unknown enchantment '" + string + "'"));
                    NumberProvider numberProvider = (NumberProvider)jsonDeserializationContext.deserialize(jsonElement, NumberProvider.class);
                    map.put(enchantment, numberProvider);
                }
            }
            boolean bl = ChatDeserializer.a(jsonObject, "add", false);
            return new SetEnchantmentsFunction(lootItemConditions, map, bl);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional b(JsonObject json, JsonDeserializationContext context, LootItemCondition[] conditions) {
            return this.a(json, context, conditions);
        }
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final Map<Enchantment, NumberProvider> a = Maps.newHashMap();
        private final boolean b;

        public a() {
            this(false);
        }

        public a(boolean add) {
            this.b = add;
        }

        @Override
        protected a a() {
            return this;
        }

        public a a(Enchantment enchantment, NumberProvider level) {
            this.a.put(enchantment, level);
            return this;
        }

        @Override
        @Override
        public LootItemFunction b() {
            return new SetEnchantmentsFunction(this.g(), this.a, this.b);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a d() {
            return this.a();
        }
    }
}

