/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootSerialization;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootPredicateManager
extends ResourceDataJson {
    private static final Logger a = LogManager.getLogger();
    private static final Gson b = LootSerialization.a().create();
    private Map<MinecraftKey, LootItemCondition> c = ImmutableMap.of();

    public LootPredicateManager() {
        super(b, "predicates");
    }

    @Nullable
    public LootItemCondition a(MinecraftKey id) {
        return this.c.get(id);
    }

    @Override
    @Override
    protected void a(Map<MinecraftKey, JsonElement> prepared, IResourceManager manager, GameProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        prepared.forEach((id, json) -> {
            try {
                if (json.isJsonArray()) {
                    LootItemCondition[] lootItemConditions = (LootItemCondition[])b.fromJson(json, LootItemCondition[].class);
                    builder.put(id, (Object)new a(lootItemConditions));
                } else {
                    LootItemCondition lootItemCondition = (LootItemCondition)b.fromJson(json, LootItemCondition.class);
                    builder.put(id, (Object)lootItemCondition);
                }
            }
            catch (Exception exception) {
                a.error("Couldn't parse loot table {}", id, (Object)exception);
            }
        });
        ImmutableMap map = builder.build();
        LootCollector validationContext = new LootCollector(LootContextParameterSets.k, ((Map)map)::get, id -> null);
        map.forEach((id, condition) -> condition.a(validationContext.b("{" + id + "}", (MinecraftKey)id)));
        validationContext.a().forEach((string, string2) -> a.warn("Found validation problem in {}: {}", string, string2));
        this.c = map;
    }

    public Set<MinecraftKey> a() {
        return Collections.unmodifiableSet(this.c.keySet());
    }

    static class a
    implements LootItemCondition {
        private final LootItemCondition[] a;
        private final Predicate<LootTableInfo> b;

        a(LootItemCondition[] terms) {
            this.a = terms;
            this.b = LootItemConditions.a(terms);
        }

        @Override
        public final boolean a(LootTableInfo lootContext) {
            return this.b.test(lootContext);
        }

        @Override
        @Override
        public void a(LootCollector reporter) {
            LootItemCondition.super.a(reporter);
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                this.a[i2].a(reporter.b(".term[" + i2 + "]"));
            }
        }

        @Override
        @Override
        public LootItemConditionType a() {
            throw new UnsupportedOperationException();
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.a((LootTableInfo)object);
        }
    }
}

