/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.destroystokyo.paper.exception.ServerInternalException;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.PersistentBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldPersistentData {
    private static final Logger a = LogManager.getLogger();
    public final Map<String, PersistentBase> b = Maps.newHashMap();
    private final DataFixer c;
    private final File d;

    public WorldPersistentData(File directory, DataFixer dataFixer) {
        this.c = dataFixer;
        this.d = directory;
    }

    private File a(String id) {
        return new File(this.d, id + ".dat");
    }

    public <T extends PersistentBase> T a(Function<NBTTagCompound, T> readFunction, Supplier<T> supplier, String id) {
        T savedData = this.a(readFunction, id);
        if (savedData != null) {
            return savedData;
        }
        PersistentBase savedData2 = (PersistentBase)supplier.get();
        this.a(id, savedData2);
        return (T)savedData2;
    }

    @Nullable
    public <T extends PersistentBase> T a(Function<NBTTagCompound, T> readFunction, String id) {
        PersistentBase savedData = this.b.get(id);
        if (savedData == null && !this.b.containsKey(id)) {
            savedData = this.b(readFunction, id);
            this.b.put(id, savedData);
        }
        return (T)savedData;
    }

    @Nullable
    private <T extends PersistentBase> T b(Function<NBTTagCompound, T> readFunction, String id) {
        try {
            File file = this.a(id);
            if (file.exists()) {
                NBTTagCompound compoundTag = this.a(id, SharedConstants.b().getWorldVersion());
                return (T)((PersistentBase)readFunction.apply(compoundTag.p("data")));
            }
        }
        catch (Exception var5) {
            a.error("Error loading saved data: {}", (Object)id, (Object)var5);
        }
        return (T)((PersistentBase)null);
    }

    public void a(String id, PersistentBase state) {
        this.b.put(id, state);
    }

    public NBTTagCompound a(String id, int dataVersion) throws IOException {
        NBTTagCompound var8;
        File file = this.a(id);
        FileInputStream fileInputStream = new FileInputStream(file);
        try (PushbackInputStream pushbackInputStream = new PushbackInputStream(fileInputStream, 2);){
            NBTTagCompound compoundTag;
            if (this.a(pushbackInputStream)) {
                compoundTag = NBTCompressedStreamTools.a(pushbackInputStream);
            } else {
                try (DataInputStream dataInputStream = new DataInputStream(pushbackInputStream);){
                    compoundTag = NBTCompressedStreamTools.a(dataInputStream);
                }
            }
            int i2 = compoundTag.b("DataVersion", 99) ? compoundTag.h("DataVersion") : 1343;
            var8 = GameProfileSerializer.a(this.c, DataFixTypes.h, compoundTag, i2, dataVersion);
        }
        catch (Throwable var15) {
            ServerInternalException.reportInternalException((Throwable)var15);
            try {
                fileInputStream.close();
            }
            catch (Throwable var10) {
                var15.addSuppressed(var10);
            }
            throw var15;
        }
        fileInputStream.close();
        return var8;
    }

    private boolean a(PushbackInputStream pushbackInputStream) throws IOException {
        int j2;
        byte[] bs = new byte[2];
        boolean bl = false;
        int i2 = pushbackInputStream.read(bs, 0, 2);
        if (i2 == 2 && (j2 = (bs[1] & 0xFF) << 8 | bs[0] & 0xFF) == 35615) {
            bl = true;
        }
        if (i2 != 0) {
            pushbackInputStream.unread(bs, 0, i2);
        }
        return bl;
    }

    public void a() {
        this.b.forEach((id, state) -> {
            if (state != null) {
                state.a(this.a((String)id));
            }
        });
    }
}

