/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.SessionLock;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldInfo;
import net.minecraft.world.level.storage.WorldNBTStorage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Convertable {
    static final Logger a = LogManager.getLogger();
    static final DateTimeFormatter b = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private static final String c = "icon.png";
    private static final ImmutableList<String> d = ImmutableList.of((Object)"RandomSeed", (Object)"generatorName", (Object)"generatorOptions", (Object)"generatorVersion", (Object)"legacy_custom_options", (Object)"MapFeatures", (Object)"BonusChest");
    public final Path e;
    private final Path f;
    final DataFixer g;

    public Convertable(Path savesDirectory, Path backupsDirectory, DataFixer dataFixer) {
        this.g = dataFixer;
        try {
            Files.createDirectories(Files.exists(savesDirectory, new LinkOption[0]) ? savesDirectory.toRealPath(new LinkOption[0]) : savesDirectory, new FileAttribute[0]);
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        this.e = savesDirectory;
        this.f = backupsDirectory;
    }

    public static Convertable a(Path path) {
        return new Convertable(path, path.resolve("../backups"), DataConverterRegistry.a());
    }

    private static <T> Pair<GeneratorSettings, Lifecycle> a(Dynamic<T> levelData, DataFixer dataFixer, int version) {
        Dynamic dynamic1 = levelData.get("WorldGenSettings").orElseEmptyMap();
        for (String s2 : d) {
            Optional optional = levelData.get(s2).result();
            if (!optional.isPresent()) continue;
            dynamic1 = dynamic1.set(s2, (Dynamic)((Object)optional.get()));
        }
        Dynamic dynamic2 = dataFixer.update(DataConverterTypes.z, dynamic1, version, SharedConstants.b().getWorldVersion());
        DataResult dataresult = GeneratorSettings.a.parse(dynamic2);
        Logger logger = a;
        Objects.requireNonNull(logger);
        return Pair.of((Object)dataresult.resultOrPartial(SystemUtils.a("WorldGenSettings: ", arg_0 -> ((Logger)logger).error(arg_0))).orElseGet(() -> {
            IRegistryCustom iregistrycustom = IRegistryCustom.Dimension.a(dynamic2);
            return GeneratorSettings.b(iregistrycustom);
        }), (Object)dataresult.lifecycle());
    }

    private static DataPackConfiguration a(Dynamic<?> dynamic) {
        DataResult dataresult = DataPackConfiguration.b.parse(dynamic);
        Logger logger = a;
        Objects.requireNonNull(logger);
        return dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElse(DataPackConfiguration.a);
    }

    public String a() {
        return "Anvil";
    }

    public List<WorldInfo> b() throws LevelStorageException {
        File[] afile;
        if (!Files.isDirectory(this.e, new LinkOption[0])) {
            throw new LevelStorageException(new ChatMessage("selectWorld.load_folder_access").getString());
        }
        ArrayList list = Lists.newArrayList();
        File[] afile1 = afile = this.e.toFile().listFiles();
        int i2 = afile.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            boolean flag;
            File file = afile1[j2];
            if (!file.isDirectory()) continue;
            try {
                flag = SessionLock.b(file.toPath());
            }
            catch (Exception exception) {
                a.warn("Failed to read {} lock", (Object)file, (Object)exception);
                continue;
            }
            try {
                WorldInfo worldinfo = this.a(file, this.a(file, flag));
                if (worldinfo == null) continue;
                list.add(worldinfo);
                continue;
            }
            catch (OutOfMemoryError outofmemoryerror) {
                MemoryReserve.b();
                System.gc();
                a.fatal("Ran out of memory trying to read summary of {}", (Object)file);
                throw outofmemoryerror;
            }
        }
        return list;
    }

    private int e() {
        return 19133;
    }

    @Nullable
    <T> T a(File file, BiFunction<File, DataFixer, T> levelDataParser) {
        T t0;
        if (!file.exists()) {
            return null;
        }
        File file1 = new File(file, "level.dat");
        if (file1.exists() && (t0 = levelDataParser.apply(file1, this.g)) != null) {
            return t0;
        }
        file1 = new File(file, "level.dat_old");
        return file1.exists() ? (T)levelDataParser.apply(file1, this.g) : null;
    }

    @Nullable
    private static DataPackConfiguration a(File file, DataFixer dataFixer) {
        try {
            NBTTagCompound nbttagcompound = NBTCompressedStreamTools.a(file);
            NBTTagCompound nbttagcompound1 = nbttagcompound.p("Data");
            nbttagcompound1.r("Player");
            int i2 = nbttagcompound1.b("DataVersion", 99) ? nbttagcompound1.h("DataVersion") : -1;
            Dynamic dynamic = dataFixer.update(DataFixTypes.a.a(), new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, nbttagcompound1), i2, SharedConstants.b().getWorldVersion());
            return dynamic.get("DataPacks").result().map(Convertable::a).orElse(DataPackConfiguration.a);
        }
        catch (Exception exception) {
            a.error("Exception reading {}", (Object)file, (Object)exception);
            return null;
        }
    }

    static BiFunction<File, DataFixer, WorldDataServer> a(DynamicOps<NBTBase> dynamicops, DataPackConfiguration dataPackSettings) {
        return (file, datafixer) -> {
            try {
                NBTTagCompound nbttagcompound = NBTCompressedStreamTools.a(file);
                NBTTagCompound nbttagcompound1 = nbttagcompound.p("Data");
                NBTTagCompound nbttagcompound2 = nbttagcompound1.b("Player", 10) ? nbttagcompound1.p("Player") : null;
                nbttagcompound1.r("Player");
                int i2 = nbttagcompound1.b("DataVersion", 99) ? nbttagcompound1.h("DataVersion") : -1;
                Dynamic dynamic = datafixer.update(DataFixTypes.a.a(), new Dynamic<NBTTagCompound>(dynamicops, nbttagcompound1), i2, SharedConstants.b().getWorldVersion());
                Pair<GeneratorSettings, Lifecycle> pair = Convertable.a(dynamic, datafixer, i2);
                LevelVersion levelversion = LevelVersion.a(dynamic);
                WorldSettings worldsettings = WorldSettings.a(dynamic, dataPackSettings);
                return WorldDataServer.a(dynamic, datafixer, i2, nbttagcompound2, worldsettings, levelversion, (GeneratorSettings)pair.getFirst(), (Lifecycle)pair.getSecond());
            }
            catch (Exception exception) {
                a.error("Exception reading {}", file, (Object)exception);
                return null;
            }
        };
    }

    BiFunction<File, DataFixer, WorldInfo> a(File file, boolean locked) {
        return (file1, datafixer) -> {
            try {
                NBTTagCompound nbttagcompound = NBTCompressedStreamTools.a(file1);
                NBTTagCompound nbttagcompound1 = nbttagcompound.p("Data");
                nbttagcompound1.r("Player");
                int i2 = nbttagcompound1.b("DataVersion", 99) ? nbttagcompound1.h("DataVersion") : -1;
                Dynamic dynamic = datafixer.update(DataFixTypes.a.a(), new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, nbttagcompound1), i2, SharedConstants.b().getWorldVersion());
                LevelVersion levelversion = LevelVersion.a(dynamic);
                int j2 = levelversion.a();
                if (j2 != 19132 && j2 != 19133) {
                    return null;
                }
                boolean flag1 = j2 != this.e();
                File file2 = new File(file, c);
                DataPackConfiguration datapackconfiguration = dynamic.get("DataPacks").result().map(Convertable::a).orElse(DataPackConfiguration.a);
                WorldSettings worldsettings = WorldSettings.a(dynamic, datapackconfiguration);
                return new WorldInfo(worldsettings, levelversion, file.getName(), flag1, locked, file2);
            }
            catch (Exception exception) {
                a.error("Exception reading {}", file1, (Object)exception);
                return null;
            }
        };
    }

    public boolean a(String name) {
        try {
            Path path = this.e.resolve(name);
            Files.createDirectory(path, new FileAttribute[0]);
            Files.deleteIfExists(path);
            return true;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    public boolean b(String name) {
        return Files.isDirectory(this.e.resolve(name), new LinkOption[0]);
    }

    public Path c() {
        return this.e;
    }

    public Path d() {
        return this.f;
    }

    public ConversionSession createAccess(String s2, ResourceKey<WorldDimension> dimensionType) throws IOException {
        return new ConversionSession(s2, dimensionType);
    }

    public static Path getStorageFolder(Path path, ResourceKey<WorldDimension> dimensionType) {
        if (dimensionType == WorldDimension.b) {
            return path;
        }
        if (dimensionType == WorldDimension.c) {
            return path.resolve("DIM-1");
        }
        if (dimensionType == WorldDimension.d) {
            return path.resolve("DIM1");
        }
        return path.resolve("dimensions").resolve(dimensionType.a().b()).resolve(dimensionType.a().a());
    }

    public class ConversionSession
    implements AutoCloseable {
        final SessionLock b;
        public final Path c;
        private final String d;
        private final Map<SavedFile, Path> e = Maps.newHashMap();
        public final ResourceKey<WorldDimension> dimensionType;

        public ConversionSession(String s2, ResourceKey<WorldDimension> dimensionType) throws IOException {
            this.dimensionType = dimensionType;
            this.d = s2;
            this.c = Convertable.this.e.resolve(s2);
            this.b = SessionLock.a(this.c);
        }

        public String a() {
            return this.d;
        }

        public Path a(SavedFile savePath) {
            return this.e.computeIfAbsent(savePath, savedfile1 -> this.c.resolve(savedfile1.a()));
        }

        public Path a(ResourceKey<World> key) {
            return Convertable.getStorageFolder(this.c, this.dimensionType);
        }

        private void h() {
            if (!this.b.a()) {
                throw new IllegalStateException("Lock is no longer valid");
            }
        }

        public WorldNBTStorage b() {
            this.h();
            return new WorldNBTStorage(this, Convertable.this.g);
        }

        @Nullable
        public WorldInfo c() {
            this.h();
            return Convertable.this.a(this.c.toFile(), Convertable.this.a(this.c.toFile(), false));
        }

        @Nullable
        public SaveData a(DynamicOps<NBTBase> dynamicops, DataPackConfiguration dataPackSettings) {
            this.h();
            return Convertable.this.a(this.c.toFile(), Convertable.a(dynamicops, dataPackSettings));
        }

        @Nullable
        public DataPackConfiguration d() {
            this.h();
            return Convertable.this.a(this.c.toFile(), Convertable::a);
        }

        public void a(IRegistryCustom registryManager, SaveData saveProperties) {
            this.a(registryManager, saveProperties, null);
        }

        public void a(IRegistryCustom registryManager, SaveData saveProperties, @Nullable NBTTagCompound nbt) {
            File file = this.c.toFile();
            NBTTagCompound nbttagcompound1 = saveProperties.a(registryManager, nbt);
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttagcompound2.a("Data", nbttagcompound1);
            try {
                File file1 = File.createTempFile("level", ".dat", file);
                NBTCompressedStreamTools.a(nbttagcompound2, file1);
                File file2 = new File(file, "level.dat_old");
                File file3 = new File(file, "level.dat");
                SystemUtils.a(file3, file1, file2);
            }
            catch (Exception exception) {
                a.error("Failed to save level {}", (Object)file, (Object)exception);
            }
        }

        public Optional<Path> e() {
            return !this.b.a() ? Optional.empty() : Optional.of(this.c.resolve(Convertable.c));
        }

        public void f() throws IOException {
            this.h();
            final Path path = this.c.resolve("session.lock");
            for (int i2 = 1; i2 <= 5; ++i2) {
                a.info("Attempt {}...", (Object)i2);
                try {
                    Files.walkFileTree(this.c, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        public FileVisitResult a(Path path1, BasicFileAttributes basicfileattributes) throws IOException {
                            if (!path1.equals(path)) {
                                a.debug("Deleting {}", (Object)path1);
                                Files.delete(path1);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        public FileVisitResult a(Path path1, IOException ioexception) throws IOException {
                            if (ioexception != null) {
                                throw ioexception;
                            }
                            if (path1.equals(ConversionSession.this.c)) {
                                ConversionSession.this.b.close();
                                Files.deleteIfExists(path);
                            }
                            Files.delete(path1);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    break;
                }
                catch (IOException ioexception) {
                    if (i2 >= 5) {
                        throw ioexception;
                    }
                    a.warn("Failed to delete {}", (Object)this.c, (Object)ioexception);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }

        public void a(String name) throws IOException {
            File file1;
            this.h();
            File file = new File(Convertable.this.e.toFile(), this.d);
            if (file.exists() && (file1 = new File(file, "level.dat")).exists()) {
                NBTTagCompound nbttagcompound = NBTCompressedStreamTools.a(file1);
                NBTTagCompound nbttagcompound1 = nbttagcompound.p("Data");
                nbttagcompound1.a("LevelName", name);
                NBTCompressedStreamTools.a(nbttagcompound, file1);
            }
        }

        public long g() throws IOException {
            this.h();
            String s2 = LocalDateTime.now().format(b);
            String s1 = s2 + "_" + this.d;
            Path path = Convertable.this.d();
            try {
                Files.createDirectories(Files.exists(path, new LinkOption[0]) ? path.toRealPath(new LinkOption[0]) : path, new FileAttribute[0]);
            }
            catch (IOException ioexception) {
                throw new RuntimeException(ioexception);
            }
            Path path1 = path.resolve(FileUtils.a(path, s1, ".zip"));
            try (final ZipOutputStream zipoutputstream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(path1, new OpenOption[0])));){
                final Path path2 = Paths.get(this.d, new String[0]);
                Files.walkFileTree(this.c, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    public FileVisitResult a(Path path3, BasicFileAttributes basicfileattributes) throws IOException {
                        if (path3.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String s2 = path2.resolve(ConversionSession.this.c.relativize(path3)).toString().replace('\\', '/');
                        ZipEntry zipentry = new ZipEntry(s2);
                        zipoutputstream.putNextEntry(zipentry);
                        com.google.common.io.Files.asByteSource((File)path3.toFile()).copyTo((OutputStream)zipoutputstream);
                        zipoutputstream.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            return Files.size(path1);
        }

        @Override
        public void close() throws IOException {
            this.b.close();
        }
    }
}

