/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.portal.ShapeDetectorShape;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_18_R1.util.BlockStateListPopulator;
import org.bukkit.event.Event;
import org.bukkit.event.world.PortalCreateEvent;

public class BlockPortalShape {
    private static final int c = 2;
    public static final int a = 21;
    private static final int d = 3;
    public static final int b = 21;
    private static final BlockBase.e e = (iblockdata, iblockaccess, blockposition) -> iblockdata.a(Blocks.bQ);
    private final GeneratorAccess f;
    private final EnumDirection.EnumAxis g;
    private final EnumDirection h;
    private int i;
    @Nullable
    private BlockPosition j;
    private int k;
    private final int l;
    BlockStateListPopulator blocks;

    public static Optional<BlockPortalShape> a(GeneratorAccess world, BlockPosition pos, EnumDirection.EnumAxis axis) {
        return BlockPortalShape.a(world, pos, (BlockPortalShape blockportalshape) -> blockportalshape.a() && blockportalshape.i == 0, axis);
    }

    public static Optional<BlockPortalShape> a(GeneratorAccess world, BlockPosition pos, Predicate<BlockPortalShape> predicate, EnumDirection.EnumAxis axis) {
        Optional<BlockPortalShape> optional = Optional.of(new BlockPortalShape(world, pos, axis)).filter(predicate);
        if (optional.isPresent()) {
            return optional;
        }
        EnumDirection.EnumAxis enumdirection_enumaxis1 = axis == EnumDirection.EnumAxis.a ? EnumDirection.EnumAxis.c : EnumDirection.EnumAxis.a;
        return Optional.of(new BlockPortalShape(world, pos, enumdirection_enumaxis1)).filter(predicate);
    }

    public BlockPortalShape(GeneratorAccess world, BlockPosition pos, EnumDirection.EnumAxis axis) {
        this.blocks = new BlockStateListPopulator(world.getMinecraftWorld());
        this.f = world;
        this.g = axis;
        this.h = axis == EnumDirection.EnumAxis.a ? EnumDirection.e : EnumDirection.d;
        this.j = this.a(pos);
        if (this.j == null) {
            this.j = pos;
            this.l = 1;
            this.k = 1;
        } else {
            this.l = this.d();
            if (this.l > 0) {
                this.k = this.e();
            }
        }
    }

    @Nullable
    private BlockPosition a(BlockPosition pos) {
        int i2 = Math.max(this.f.u_(), pos.v() - 21);
        while (pos.v() > i2 && BlockPortalShape.a(this.f.a_(pos.c()))) {
            pos = pos.c();
        }
        EnumDirection enumdirection = this.h.f();
        int j2 = this.a(pos, enumdirection) - 1;
        return j2 < 0 ? null : pos.a(enumdirection, j2);
    }

    private int d() {
        int i2 = this.a(this.j, this.h);
        return i2 >= 2 && i2 <= 21 ? i2 : 0;
    }

    private int a(BlockPosition pos, EnumDirection direction) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int i2 = 0; i2 <= 21; ++i2) {
            blockposition_mutableblockposition.g(pos).c(direction, i2);
            IBlockData iblockdata = this.f.a_(blockposition_mutableblockposition);
            if (!BlockPortalShape.a(iblockdata)) {
                if (!e.test(iblockdata, this.f, blockposition_mutableblockposition)) break;
                this.blocks.a((BlockPosition)blockposition_mutableblockposition, iblockdata, 18);
                return i2;
            }
            IBlockData iblockdata1 = this.f.a_(blockposition_mutableblockposition.c(EnumDirection.a));
            if (!e.test(iblockdata1, this.f, blockposition_mutableblockposition)) break;
            this.blocks.a((BlockPosition)blockposition_mutableblockposition, iblockdata1, 18);
        }
        return 0;
    }

    private int e() {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        int i2 = this.a(blockposition_mutableblockposition);
        return i2 >= 3 && i2 <= 21 && this.a(blockposition_mutableblockposition, i2) ? i2 : 0;
    }

    private boolean a(BlockPosition.MutableBlockPosition blockposition_mutableblockposition, int i2) {
        for (int j2 = 0; j2 < this.l; ++j2) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = blockposition_mutableblockposition.g(this.j).c(EnumDirection.b, i2).c(this.h, j2);
            if (!e.test(this.f.a_(blockposition_mutableblockposition1), this.f, blockposition_mutableblockposition1)) {
                return false;
            }
            this.blocks.a((BlockPosition)blockposition_mutableblockposition1, this.f.a_(blockposition_mutableblockposition1), 18);
        }
        return true;
    }

    private int a(BlockPosition.MutableBlockPosition blockposition_mutableblockposition) {
        for (int i2 = 0; i2 < 21; ++i2) {
            blockposition_mutableblockposition.g(this.j).c(EnumDirection.b, i2).c(this.h, -1);
            if (!e.test(this.f.a_(blockposition_mutableblockposition), this.f, blockposition_mutableblockposition)) {
                return i2;
            }
            blockposition_mutableblockposition.g(this.j).c(EnumDirection.b, i2).c(this.h, this.l);
            if (!e.test(this.f.a_(blockposition_mutableblockposition), this.f, blockposition_mutableblockposition)) {
                return i2;
            }
            for (int j2 = 0; j2 < this.l; ++j2) {
                blockposition_mutableblockposition.g(this.j).c(EnumDirection.b, i2).c(this.h, j2);
                IBlockData iblockdata = this.f.a_(blockposition_mutableblockposition);
                if (!BlockPortalShape.a(iblockdata)) {
                    return i2;
                }
                if (!iblockdata.a(Blocks.db)) continue;
                ++this.i;
            }
            this.blocks.a((BlockPosition)blockposition_mutableblockposition.g(this.j).c(EnumDirection.b, i2).c(this.h, -1), this.f.a_(blockposition_mutableblockposition), 18);
            this.blocks.a((BlockPosition)blockposition_mutableblockposition.g(this.j).c(EnumDirection.b, i2).c(this.h, this.l), this.f.a_(blockposition_mutableblockposition), 18);
        }
        return 21;
    }

    private static boolean a(IBlockData state) {
        return state.g() || state.a(TagsBlock.ax) || state.a(Blocks.db);
    }

    public boolean a() {
        return this.j != null && this.l >= 2 && this.l <= 21 && this.k >= 3 && this.k <= 21;
    }

    @Deprecated
    public boolean createPortalBlocks() {
        return this.createPortalBlocks(null);
    }

    public boolean createPortalBlocks(ItemActionContext itemActionContext) {
        CraftWorld bworld = this.f.getMinecraftWorld().getWorld();
        IBlockData iblockdata = (IBlockData)Blocks.db.n().a(BlockPortal.a, this.g);
        BlockPosition.a(this.j, this.j.a(EnumDirection.b, this.k - 1).a(this.h, this.l - 1)).forEach(blockposition -> this.blocks.a((BlockPosition)blockposition, iblockdata, 18));
        PortalCreateEvent event = new PortalCreateEvent(this.blocks.getList(), (World)bworld, itemActionContext == null || itemActionContext.o() == null ? null : itemActionContext.o().getBukkitEntity(), PortalCreateEvent.CreateReason.FIRE);
        this.f.getMinecraftWorld().n().server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        BlockPosition.a(this.j, this.j.a(EnumDirection.b, this.k - 1).a(this.h, this.l - 1)).forEach(blockposition -> this.f.a((BlockPosition)blockposition, iblockdata, 18));
        return true;
    }

    public boolean c() {
        return this.a() && this.i == this.l * this.k;
    }

    public static Vec3D a(BlockUtil.Rectangle portalRect, EnumDirection.EnumAxis portalAxis, Vec3D entityPos, EntitySize entityDimensions) {
        double d3;
        double d2;
        double d0 = (double)portalRect.b - (double)entityDimensions.a;
        double d1 = (double)portalRect.c - (double)entityDimensions.b;
        BlockPosition blockposition = portalRect.a;
        if (d0 > 0.0) {
            float f2 = (float)blockposition.a(portalAxis) + entityDimensions.a / 2.0f;
            d2 = MathHelper.a(MathHelper.c(entityPos.a(portalAxis) - (double)f2, 0.0, d0), 0.0, 1.0);
        } else {
            d2 = 0.5;
        }
        if (d1 > 0.0) {
            EnumDirection.EnumAxis enumdirection_enumaxis1 = EnumDirection.EnumAxis.b;
            d3 = MathHelper.a(MathHelper.c(entityPos.a(enumdirection_enumaxis1) - (double)blockposition.a(enumdirection_enumaxis1), 0.0, d1), 0.0, 1.0);
        } else {
            d3 = 0.0;
        }
        EnumDirection.EnumAxis enumdirection_enumaxis1 = portalAxis == EnumDirection.EnumAxis.a ? EnumDirection.EnumAxis.c : EnumDirection.EnumAxis.a;
        double d4 = entityPos.a(enumdirection_enumaxis1) - ((double)blockposition.a(enumdirection_enumaxis1) + 0.5);
        return new Vec3D(d2, d3, d4);
    }

    public static ShapeDetectorShape createPortalInfo(WorldServer worldserver, BlockUtil.Rectangle blockutil_rectangle, EnumDirection.EnumAxis enumdirection_enumaxis, Vec3D vec3d, EntitySize entitysize, Vec3D vec3d1, float f2, float f1, CraftPortalEvent portalEventInfo) {
        BlockPosition blockposition = blockutil_rectangle.a;
        IBlockData iblockdata = worldserver.a_(blockposition);
        EnumDirection.EnumAxis enumdirection_enumaxis1 = iblockdata.d(BlockProperties.F).orElse(EnumDirection.EnumAxis.a);
        double d0 = blockutil_rectangle.b;
        double d1 = blockutil_rectangle.c;
        int i2 = enumdirection_enumaxis == enumdirection_enumaxis1 ? 0 : 90;
        Vec3D vec3d2 = enumdirection_enumaxis == enumdirection_enumaxis1 ? vec3d1 : new Vec3D(vec3d1.d, vec3d1.c, -vec3d1.b);
        double d2 = (double)entitysize.a / 2.0 + (d0 - (double)entitysize.a) * vec3d.a();
        double d3 = (d1 - (double)entitysize.b) * vec3d.b();
        double d4 = 0.5 + vec3d.c();
        boolean flag = enumdirection_enumaxis1 == EnumDirection.EnumAxis.a;
        Vec3D vec3d3 = new Vec3D((double)blockposition.u() + (flag ? d2 : d4), (double)blockposition.v() + d3, (double)blockposition.w() + (flag ? d4 : d2));
        return new ShapeDetectorShape(vec3d3, vec3d2, f2 + (float)i2, f1, worldserver, portalEventInfo);
    }
}

