/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import com.google.common.collect.Lists;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;

public class Pathfinder {
    private static final float a = 1.5f;
    private final PathPoint[] b = new PathPoint[32];
    private final int c;
    public final PathfinderAbstract d;
    private static final boolean e = false;
    private final Path f = new Path();

    public Pathfinder(PathfinderAbstract pathNodeMaker, int range) {
        this.d = pathNodeMaker;
        this.c = range;
    }

    @Nullable
    public PathEntity a(ChunkCache world, EntityInsentient mob, Set<BlockPosition> positions, float followRange, int distance, float rangeMultiplier) {
        this.f.a();
        this.d.a(world, mob);
        PathPoint node = this.d.b();
        ArrayList map = Lists.newArrayList();
        for (BlockPosition blockPos : positions) {
            map.add(new AbstractMap.SimpleEntry<PathDestination, BlockPosition>(this.d.a((double)blockPos.u(), (double)blockPos.v(), (double)blockPos.w()), blockPos));
        }
        PathEntity path = this.findPath(world.a(), node, map, followRange, distance, rangeMultiplier);
        this.d.a();
        return path;
    }

    @Nullable
    private PathEntity findPath(GameProfilerFiller profiler, PathPoint startNode, List<Map.Entry<PathDestination, BlockPosition>> positions, float followRange, int distance, float rangeMultiplier) {
        profiler.a("find_path");
        profiler.a(MetricCategory.a);
        startNode.e = 0.0f;
        startNode.g = startNode.f = this.getBestH(startNode, positions);
        this.f.a();
        this.f.a(startNode);
        int i2 = 0;
        ArrayList entryList = Lists.newArrayListWithExpectedSize((int)positions.size());
        int j2 = (int)((float)this.c * rangeMultiplier);
        while (!this.f.e() && ++i2 < j2) {
            PathPoint node = this.f.c();
            node.i = true;
            for (int i1 = 0; i1 < positions.size(); ++i1) {
                Map.Entry entry = (Map.Entry)positions.get(i1);
                PathDestination target = (PathDestination)entry.getKey();
                if (!(node.c(target) <= (float)distance)) continue;
                target.e();
                entryList.add(entry);
            }
            if (!entryList.isEmpty()) break;
            if (node.a(startNode) >= followRange) continue;
            int k2 = this.d.a(this.b, node);
            for (int l2 = 0; l2 < k2; ++l2) {
                PathPoint node2 = this.b[l2];
                float f2 = node.a(node2);
                node2.j = node.j + f2;
                float g2 = node.e + f2 + node2.k;
                if (!(node2.j < followRange) || node2.c() && !(g2 < node2.e)) continue;
                node2.h = node;
                node2.e = g2;
                node2.f = this.getBestH(node2, positions) * 1.5f;
                if (node2.c()) {
                    this.f.a(node2, node2.e + node2.f);
                    continue;
                }
                node2.g = node2.e + node2.f;
                this.f.a(node2);
            }
        }
        PathEntity best = null;
        boolean entryListIsEmpty = entryList.isEmpty();
        Comparator<PathEntity> comparator = entryListIsEmpty ? Comparator.comparingInt(PathEntity::e) : Comparator.comparingDouble(PathEntity::n).thenComparingInt(PathEntity::e);
        for (Map.Entry entry : entryListIsEmpty ? positions : entryList) {
            PathEntity path = this.a(((PathDestination)entry.getKey()).d(), (BlockPosition)entry.getValue(), !entryListIsEmpty);
            if (best != null && comparator.compare(path, best) >= 0) continue;
            best = path;
        }
        return best;
    }

    private float getBestH(PathPoint node, List<Map.Entry<PathDestination, BlockPosition>> targets) {
        float f2 = Float.MAX_VALUE;
        int targetsSize = targets.size();
        for (int i2 = 0; i2 < targetsSize; ++i2) {
            PathDestination target = targets.get(i2).getKey();
            float g2 = node.a(target);
            target.a(g2, node);
            f2 = Math.min(g2, f2);
        }
        return f2;
    }

    private PathEntity a(PathPoint endNode, BlockPosition target, boolean reachesTarget) {
        ArrayList list = Lists.newArrayList();
        PathPoint node = endNode;
        list.add(0, endNode);
        while (node.h != null) {
            node = node.h;
            list.add(0, node);
        }
        return new PathEntity(list, target, reachesTarget);
    }
}

