/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.LightEngineLayer;
import net.minecraft.world.level.lighting.LightEngineStorageSky;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.apache.commons.lang3.mutable.MutableInt;

public final class LightEngineSky
extends LightEngineLayer<LightEngineStorageSky.a, LightEngineStorageSky> {
    private static final EnumDirection[] f = EnumDirection.values();
    private static final EnumDirection[] g = new EnumDirection[]{EnumDirection.c, EnumDirection.d, EnumDirection.e, EnumDirection.f};
    private final MutableInt mutableInt = new MutableInt();

    public LightEngineSky(ILightAccess chunkProvider) {
        super(chunkProvider, EnumSkyBlock.a, new LightEngineStorageSky(chunkProvider));
    }

    @Override
    protected int b(long sourceId, long targetId, int level) {
        if (targetId != Long.MAX_VALUE && sourceId != Long.MAX_VALUE) {
            VoxelShape voxelShape2;
            int q2;
            int p2;
            if (level >= 15) {
                return level;
            }
            IBlockData blockState = this.a(targetId, this.mutableInt);
            if (this.mutableInt.getValue() >= 15) {
                return 15;
            }
            int i2 = BlockPosition.a(sourceId);
            int j2 = BlockPosition.b(sourceId);
            int k2 = BlockPosition.c(sourceId);
            int l2 = BlockPosition.a(targetId);
            int m2 = BlockPosition.b(targetId);
            int n2 = BlockPosition.c(targetId);
            int o2 = Integer.signum(l2 - i2);
            EnumDirection direction = EnumDirection.a(o2, p2 = Integer.signum(m2 - j2), q2 = Integer.signum(n2 - k2));
            if (direction == null) {
                throw new IllegalStateException(String.format("Light was spread in illegal direction %d, %d, %d", o2, p2, q2));
            }
            IBlockData blockState2 = this.a(sourceId, null);
            VoxelShape voxelShape = this.a(blockState2, sourceId, direction);
            if (VoxelShapes.b(voxelShape, voxelShape2 = this.a(blockState, targetId, direction.f()))) {
                return 15;
            }
            boolean bl = i2 == l2 && k2 == n2;
            boolean bl2 = bl && j2 > m2;
            return bl2 && level == 0 && this.mutableInt.getValue() == 0 ? 0 : level + Math.max(1, this.mutableInt.getValue());
        }
        return 15;
    }

    @Override
    protected void a(long id, int level, boolean decrease) {
        long r2;
        long s2;
        int m2;
        long l2 = SectionPosition.e(id);
        int i2 = BlockPosition.b(id);
        int j2 = SectionPosition.b(i2);
        int k2 = SectionPosition.a(i2);
        if (j2 != 0) {
            m2 = 0;
        } else {
            int n2 = 0;
            while (!((LightEngineStorageSky)this.d).g(SectionPosition.a(l2, 0, -n2 - 1, 0)) && ((LightEngineStorageSky)this.d).a(k2 - n2 - 1)) {
                ++n2;
            }
            m2 = n2;
        }
        long p2 = BlockPosition.a(id, 0, -1 - m2 * 16, 0);
        long q2 = SectionPosition.e(p2);
        if (l2 == q2 || ((LightEngineStorageSky)this.d).g(q2)) {
            this.b(id, p2, level, decrease);
        }
        if (l2 == (s2 = SectionPosition.e(r2 = BlockPosition.a(id, EnumDirection.b))) || ((LightEngineStorageSky)this.d).g(s2)) {
            this.b(id, r2, level, decrease);
        }
        block1: for (EnumDirection direction : g) {
            int t2 = 0;
            do {
                long u2;
                long v2;
                if (l2 == (v2 = SectionPosition.e(u2 = BlockPosition.a(id, direction.i(), -t2, direction.k())))) {
                    this.b(id, u2, level, decrease);
                    continue block1;
                }
                if (!((LightEngineStorageSky)this.d).g(v2)) continue;
                long w2 = BlockPosition.a(id, 0, -t2, 0);
                this.b(w2, u2, level, decrease);
            } while (++t2 <= m2 * 16);
        }
    }

    @Override
    protected int a(long id, long excludedId, int maxLevel) {
        int i2 = maxLevel;
        long l2 = SectionPosition.e(id);
        NibbleArray dataLayer = ((LightEngineStorageSky)this.d).a(l2, true);
        for (EnumDirection direction : f) {
            int j2;
            long m2 = BlockPosition.a(id, direction);
            if (m2 == excludedId) continue;
            long n2 = SectionPosition.e(m2);
            NibbleArray dataLayer2 = l2 == n2 ? dataLayer : ((LightEngineStorageSky)this.d).a(n2, true);
            if (dataLayer2 != null) {
                j2 = this.a(dataLayer2, m2);
            } else {
                if (direction == EnumDirection.a) continue;
                j2 = 15 - ((LightEngineStorageSky)this.d).e(m2, true);
            }
            int o2 = this.b(m2, id, j2);
            if (i2 > o2) {
                i2 = o2;
            }
            if (i2 != 0) continue;
            return i2;
        }
        return i2;
    }

    @Override
    protected void f(long id) {
        ((LightEngineStorageSky)this.d).d();
        long l2 = SectionPosition.e(id);
        if (((LightEngineStorageSky)this.d).g(l2)) {
            super.f(id);
        } else {
            id = BlockPosition.e(id);
            while (!((LightEngineStorageSky)this.d).g(l2) && !((LightEngineStorageSky)this.d).m(l2)) {
                l2 = SectionPosition.a(l2, EnumDirection.b);
                id = BlockPosition.a(id, 0, 16, 0);
            }
            if (((LightEngineStorageSky)this.d).g(l2)) {
                super.f(id);
            }
        }
    }

    @Override
    public String b(long sectionPos) {
        return super.b(sectionPos) + (((LightEngineStorageSky)this.d).m(sectionPos) ? "*" : "");
    }
}

