/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import com.google.common.annotations.VisibleForTesting;
import java.util.stream.IntStream;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseSamplingSettings;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorOctaves;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorPerlin;

public class BlendedNoise
implements NoiseChunk.c {
    private final NoiseGeneratorOctaves a;
    private final NoiseGeneratorOctaves b;
    private final NoiseGeneratorOctaves c;
    private final double d;
    private final double e;
    private final double f;
    private final double g;
    private final int h;
    private final int i;

    private BlendedNoise(NoiseGeneratorOctaves lowerInterpolatedNoise, NoiseGeneratorOctaves upperInterpolatedNoise, NoiseGeneratorOctaves interpolationNoise, NoiseSamplingSettings config, int cellWidth, int cellHeight) {
        this.a = lowerInterpolatedNoise;
        this.b = upperInterpolatedNoise;
        this.c = interpolationNoise;
        this.d = 684.412 * config.a();
        this.e = 684.412 * config.b();
        this.f = this.d / config.c();
        this.g = this.e / config.d();
        this.h = cellWidth;
        this.i = cellHeight;
    }

    public BlendedNoise(RandomSource random, NoiseSamplingSettings config, int cellWidth, int cellHeight) {
        this(NoiseGeneratorOctaves.a(random, IntStream.rangeClosed(-15, 0)), NoiseGeneratorOctaves.a(random, IntStream.rangeClosed(-15, 0)), NoiseGeneratorOctaves.a(random, IntStream.rangeClosed(-7, 0)), config, cellWidth, cellHeight);
    }

    @Override
    @Override
    public double calculateNoise(int x2, int y2, int z2) {
        int i2 = Math.floorDiv(x2, this.h);
        int j2 = Math.floorDiv(y2, this.i);
        int k2 = Math.floorDiv(z2, this.h);
        double d2 = 0.0;
        double e2 = 0.0;
        double f2 = 0.0;
        boolean bl = true;
        double g2 = 1.0;
        for (int l2 = 0; l2 < 8; ++l2) {
            NoiseGeneratorPerlin improvedNoise = this.c.a(l2);
            if (improvedNoise != null) {
                f2 += improvedNoise.a(NoiseGeneratorOctaves.a((double)i2 * this.f * g2), NoiseGeneratorOctaves.a((double)j2 * this.g * g2), NoiseGeneratorOctaves.a((double)k2 * this.f * g2), this.g * g2, (double)j2 * this.g * g2) / g2;
            }
            g2 /= 2.0;
        }
        double h2 = (f2 / 10.0 + 1.0) / 2.0;
        boolean bl2 = h2 >= 1.0;
        boolean bl3 = h2 <= 0.0;
        g2 = 1.0;
        for (int m2 = 0; m2 < 16; ++m2) {
            NoiseGeneratorPerlin improvedNoise3;
            NoiseGeneratorPerlin improvedNoise2;
            double n2 = NoiseGeneratorOctaves.a((double)i2 * this.d * g2);
            double o2 = NoiseGeneratorOctaves.a((double)j2 * this.e * g2);
            double p2 = NoiseGeneratorOctaves.a((double)k2 * this.d * g2);
            double q2 = this.e * g2;
            if (!bl2 && (improvedNoise2 = this.a.a(m2)) != null) {
                d2 += improvedNoise2.a(n2, o2, p2, q2, (double)j2 * q2) / g2;
            }
            if (!bl3 && (improvedNoise3 = this.b.a(m2)) != null) {
                e2 += improvedNoise3.a(n2, o2, p2, q2, (double)j2 * q2) / g2;
            }
            g2 /= 2.0;
        }
        return MathHelper.b(d2 / 512.0, e2 / 512.0, h2) / 128.0;
    }

    @VisibleForTesting
    public void a(StringBuilder info) {
        info.append("BlendedNoise{minLimitNoise=");
        this.a.a(info);
        info.append(", maxLimitNoise=");
        this.b.a(info);
        info.append(", mainNoise=");
        this.c.a(info);
        info.append(String.format(", xzScale=%.3f, yScale=%.3f, xzMainScale=%.3f, yMainScale=%.3f, cellWidth=%d, cellHeight=%d", this.d, this.e, this.f, this.g, this.h, this.i)).append('}');
    }
}

