/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pieces;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record PiecesContainer(List<StructurePiece> a) {
    private final List<StructurePiece> a;
    private static final Logger b = LogManager.getLogger();
    private static final MinecraftKey c = new MinecraftKey("jigsaw");
    private static final Map<MinecraftKey, MinecraftKey> d = ImmutableMap.builder().put((Object)new MinecraftKey("nvi"), (Object)c).put((Object)new MinecraftKey("pcp"), (Object)c).put((Object)new MinecraftKey("bastionremnant"), (Object)c).put((Object)new MinecraftKey("runtime"), (Object)c).build();

    public PiecesContainer(List<StructurePiece> pieces) {
        this.a = List.copyOf(pieces);
    }

    public boolean a() {
        return this.a.isEmpty();
    }

    public boolean a(BlockPosition pos) {
        for (StructurePiece structurePiece : this.a) {
            if (!structurePiece.f().b(pos)) continue;
            return true;
        }
        return false;
    }

    public NBTBase a(StructurePieceSerializationContext context) {
        NBTTagList listTag = new NBTTagList();
        for (StructurePiece structurePiece : this.a) {
            listTag.add(structurePiece.a(context));
        }
        return listTag;
    }

    public static PiecesContainer a(NBTTagList list, StructurePieceSerializationContext context) {
        ArrayList list2 = Lists.newArrayList();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            NBTTagCompound compoundTag = list.a(i2);
            String string = compoundTag.l("id").toLowerCase(Locale.ROOT);
            MinecraftKey resourceLocation = new MinecraftKey(string);
            MinecraftKey resourceLocation2 = d.getOrDefault(resourceLocation, resourceLocation);
            WorldGenFeatureStructurePieceType structurePieceType = IRegistry.ba.a(resourceLocation2);
            if (structurePieceType == null) {
                b.error("Unknown structure piece id: {}", (Object)resourceLocation2);
                continue;
            }
            try {
                StructurePiece structurePiece = structurePieceType.load(context, compoundTag);
                list2.add(structurePiece);
                continue;
            }
            catch (Exception exception) {
                b.error("Exception loading structure piece with id {}", (Object)resourceLocation2, (Object)exception);
            }
        }
        return new PiecesContainer(list2);
    }

    public StructureBoundingBox b() {
        return StructurePiece.a(this.a.stream());
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{PiecesContainer.class, "pieces", "a"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PiecesContainer.class, "pieces", "a"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PiecesContainer.class, "pieces", "a"}, this, object);
    }

    public List<StructurePiece> c() {
        return this.a;
    }
}

