/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.base.MoreObjects;
import com.mojang.serialization.Codec;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StructureBoundingBox {
    private static final Logger b = LogManager.getLogger();
    public static final Codec<StructureBoundingBox> a = Codec.INT_STREAM.comapFlatMap(values -> SystemUtils.a(values, 6).map(array -> new StructureBoundingBox(array[0], array[1], array[2], array[3], array[4], array[5])), box -> IntStream.of(box.c, box.d, box.e, box.f, box.g, box.h)).stable();
    private int c;
    private int d;
    private int e;
    private int f;
    private int g;
    private int h;

    public StructureBoundingBox(BlockPosition pos) {
        this(pos.u(), pos.v(), pos.w(), pos.u(), pos.v(), pos.w());
    }

    public StructureBoundingBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.c = minX;
        this.d = minY;
        this.e = minZ;
        this.f = maxX;
        this.g = maxY;
        this.h = maxZ;
        if (maxX < minX || maxY < minY || maxZ < minZ) {
            String string = "Invalid bounding box data, inverted bounds for: " + this;
            if (SharedConstants.aJ) {
                throw new IllegalStateException(string);
            }
            b.error(string);
            this.c = Math.min(minX, maxX);
            this.d = Math.min(minY, maxY);
            this.e = Math.min(minZ, maxZ);
            this.f = Math.max(minX, maxX);
            this.g = Math.max(minY, maxY);
            this.h = Math.max(minZ, maxZ);
        }
    }

    public static StructureBoundingBox a(BaseBlockPosition first, BaseBlockPosition second) {
        return new StructureBoundingBox(Math.min(first.u(), second.u()), Math.min(first.v(), second.v()), Math.min(first.w(), second.w()), Math.max(first.u(), second.u()), Math.max(first.v(), second.v()), Math.max(first.w(), second.w()));
    }

    public static StructureBoundingBox a() {
        return new StructureBoundingBox(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public static StructureBoundingBox a(int x2, int y2, int z2, int offsetX, int offsetY, int offsetZ, int sizeX, int sizeY, int sizeZ, EnumDirection facing) {
        switch (facing) {
            default: {
                return new StructureBoundingBox(x2 + offsetX, y2 + offsetY, z2 + offsetZ, x2 + sizeX - 1 + offsetX, y2 + sizeY - 1 + offsetY, z2 + sizeZ - 1 + offsetZ);
            }
            case c: {
                return new StructureBoundingBox(x2 + offsetX, y2 + offsetY, z2 - sizeZ + 1 + offsetZ, x2 + sizeX - 1 + offsetX, y2 + sizeY - 1 + offsetY, z2 + offsetZ);
            }
            case e: {
                return new StructureBoundingBox(x2 - sizeZ + 1 + offsetZ, y2 + offsetY, z2 + offsetX, x2 + offsetZ, y2 + sizeY - 1 + offsetY, z2 + sizeX - 1 + offsetX);
            }
            case f: 
        }
        return new StructureBoundingBox(x2 + offsetZ, y2 + offsetY, z2 + offsetX, x2 + sizeZ - 1 + offsetZ, y2 + sizeY - 1 + offsetY, z2 + sizeX - 1 + offsetX);
    }

    public boolean a(StructureBoundingBox other) {
        return this.f >= other.c && this.c <= other.f && this.h >= other.e && this.e <= other.h && this.g >= other.d && this.d <= other.g;
    }

    public boolean a(int minX, int minZ, int maxX, int maxZ) {
        return this.f >= minX && this.c <= maxX && this.h >= minZ && this.e <= maxZ;
    }

    public static Optional<StructureBoundingBox> a(Iterable<BlockPosition> positions) {
        Iterator<BlockPosition> iterator = positions.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        StructureBoundingBox boundingBox = new StructureBoundingBox(iterator.next());
        iterator.forEachRemaining(boundingBox::a);
        return Optional.of(boundingBox);
    }

    public static Optional<StructureBoundingBox> b(Iterable<StructureBoundingBox> boxes) {
        Iterator<StructureBoundingBox> iterator = boxes.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        StructureBoundingBox boundingBox = iterator.next();
        StructureBoundingBox boundingBox2 = new StructureBoundingBox(boundingBox.c, boundingBox.d, boundingBox.e, boundingBox.f, boundingBox.g, boundingBox.h);
        iterator.forEachRemaining(boundingBox2::b);
        return Optional.of(boundingBox2);
    }

    @Deprecated
    public StructureBoundingBox b(StructureBoundingBox box) {
        this.c = Math.min(this.c, box.c);
        this.d = Math.min(this.d, box.d);
        this.e = Math.min(this.e, box.e);
        this.f = Math.max(this.f, box.f);
        this.g = Math.max(this.g, box.g);
        this.h = Math.max(this.h, box.h);
        return this;
    }

    @Deprecated
    public StructureBoundingBox a(BlockPosition pos) {
        this.c = Math.min(this.c, pos.u());
        this.d = Math.min(this.d, pos.v());
        this.e = Math.min(this.e, pos.w());
        this.f = Math.max(this.f, pos.u());
        this.g = Math.max(this.g, pos.v());
        this.h = Math.max(this.h, pos.w());
        return this;
    }

    @Deprecated
    public StructureBoundingBox a(int dx, int dy, int dz) {
        this.c += dx;
        this.d += dy;
        this.e += dz;
        this.f += dx;
        this.g += dy;
        this.h += dz;
        return this;
    }

    @Deprecated
    public StructureBoundingBox a(BaseBlockPosition vec) {
        return this.a(vec.u(), vec.v(), vec.w());
    }

    public StructureBoundingBox b(int x2, int y2, int z2) {
        return new StructureBoundingBox(this.c + x2, this.d + y2, this.e + z2, this.f + x2, this.g + y2, this.h + z2);
    }

    public StructureBoundingBox a(int offset) {
        return new StructureBoundingBox(this.g() - offset, this.h() - offset, this.i() - offset, this.j() + offset, this.k() + offset, this.l() + offset);
    }

    public boolean b(BaseBlockPosition vec) {
        return vec.u() >= this.c && vec.u() <= this.f && vec.w() >= this.e && vec.w() <= this.h && vec.v() >= this.d && vec.v() <= this.g;
    }

    public BaseBlockPosition b() {
        return new BaseBlockPosition(this.f - this.c, this.g - this.d, this.h - this.e);
    }

    public int c() {
        return this.f - this.c + 1;
    }

    public int d() {
        return this.g - this.d + 1;
    }

    public int e() {
        return this.h - this.e + 1;
    }

    public BlockPosition f() {
        return new BlockPosition(this.c + (this.f - this.c + 1) / 2, this.d + (this.g - this.d + 1) / 2, this.e + (this.h - this.e + 1) / 2);
    }

    public void a(Consumer<BlockPosition> consumer) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        consumer.accept(mutableBlockPos.d(this.f, this.g, this.h));
        consumer.accept(mutableBlockPos.d(this.c, this.g, this.h));
        consumer.accept(mutableBlockPos.d(this.f, this.d, this.h));
        consumer.accept(mutableBlockPos.d(this.c, this.d, this.h));
        consumer.accept(mutableBlockPos.d(this.f, this.g, this.e));
        consumer.accept(mutableBlockPos.d(this.c, this.g, this.e));
        consumer.accept(mutableBlockPos.d(this.f, this.d, this.e));
        consumer.accept(mutableBlockPos.d(this.c, this.d, this.e));
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("minX", this.c).add("minY", this.d).add("minZ", this.e).add("maxX", this.f).add("maxY", this.g).add("maxZ", this.h).toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof StructureBoundingBox) {
            StructureBoundingBox boundingBox = (StructureBoundingBox)object;
            return this.c == boundingBox.c && this.d == boundingBox.d && this.e == boundingBox.e && this.f == boundingBox.f && this.g == boundingBox.g && this.h == boundingBox.h;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.c, this.d, this.e, this.f, this.g, this.h);
    }

    public int g() {
        return this.c;
    }

    public int h() {
        return this.d;
    }

    public int i() {
        return this.e;
    }

    public int j() {
        return this.f;
    }

    public int k() {
        return this.g;
    }

    public int l() {
        return this.h;
    }
}

