/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.WorldGenWoodlandMansionPieces;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;

public class WorldGenWoodlandMansion
extends StructureGenerator<WorldGenFeatureEmptyConfiguration> {
    public WorldGenWoodlandMansion(Codec<WorldGenFeatureEmptyConfiguration> configCodec) {
        super(configCodec, WorldGenWoodlandMansion::a, WorldGenWoodlandMansion::a);
    }

    @Override
    @Override
    protected boolean a() {
        return false;
    }

    private static Optional<PieceGenerator<WorldGenFeatureEmptyConfiguration>> a(PieceGeneratorSupplier.a<WorldGenFeatureEmptyConfiguration> context2) {
        SeededRandom worldgenRandom = new SeededRandom(new LegacyRandomSource(0L));
        worldgenRandom.c(context2.c(), context2.d().c, context2.d().d);
        EnumBlockRotation rotation = EnumBlockRotation.a(worldgenRandom);
        int i2 = 5;
        int j2 = 5;
        if (rotation == EnumBlockRotation.b) {
            i2 = -5;
        } else if (rotation == EnumBlockRotation.c) {
            i2 = -5;
            j2 = -5;
        } else if (rotation == EnumBlockRotation.d) {
            j2 = -5;
        }
        int k2 = context2.d().a(7);
        int l2 = context2.d().b(7);
        int[] is = context2.a(k2, i2, l2, j2);
        int m2 = Math.min(Math.min(is[0], is[1]), Math.min(is[2], is[3]));
        if (m2 < 60) {
            return Optional.empty();
        }
        if (!context2.g().test(context2.a().getNoiseBiome(QuartPos.a(k2), QuartPos.a(is[0]), QuartPos.a(l2)))) {
            return Optional.empty();
        }
        BlockPosition blockPos = new BlockPosition(context2.d().b(), m2 + 1, context2.d().c());
        return Optional.of((structurePiecesBuilder, context) -> {
            LinkedList list = Lists.newLinkedList();
            WorldGenWoodlandMansionPieces.a(context.c(), blockPos, rotation, list, worldgenRandom);
            list.forEach(structurePiecesBuilder::a);
        });
    }

    private static void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, PiecesContainer children) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        int i2 = world.u_();
        StructureBoundingBox boundingBox = children.b();
        int j2 = boundingBox.h();
        for (int k2 = chunkBox.g(); k2 <= chunkBox.j(); ++k2) {
            block1: for (int l2 = chunkBox.i(); l2 <= chunkBox.l(); ++l2) {
                mutableBlockPos.d(k2, j2, l2);
                if (world.w(mutableBlockPos) || !boundingBox.b(mutableBlockPos) || !children.a(mutableBlockPos)) continue;
                for (int m2 = j2 - 1; m2 > i2; --m2) {
                    mutableBlockPos.q(m2);
                    if (!world.w(mutableBlockPos) && !world.a_(mutableBlockPos).c().a()) continue block1;
                    world.a((BlockPosition)mutableBlockPos, Blocks.m.n(), 2);
                }
            }
        }
    }
}

