/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureOreConfiguration;

public class WorldGenMinable
extends WorldGenerator<WorldGenFeatureOreConfiguration> {
    public WorldGenMinable(Codec<WorldGenFeatureOreConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    public boolean a(FeaturePlaceContext<WorldGenFeatureOreConfiguration> context) {
        Random random = context.d();
        BlockPosition blockPos = context.e();
        GeneratorAccessSeed worldGenLevel = context.b();
        WorldGenFeatureOreConfiguration oreConfiguration = context.f();
        float f2 = random.nextFloat() * (float)Math.PI;
        float g2 = (float)oreConfiguration.c / 8.0f;
        int i2 = MathHelper.f(((float)oreConfiguration.c / 16.0f * 2.0f + 1.0f) / 2.0f);
        double d2 = (double)blockPos.u() + Math.sin(f2) * (double)g2;
        double e2 = (double)blockPos.u() - Math.sin(f2) * (double)g2;
        double h2 = (double)blockPos.w() + Math.cos(f2) * (double)g2;
        double j2 = (double)blockPos.w() - Math.cos(f2) * (double)g2;
        int k2 = 2;
        double l2 = blockPos.v() + random.nextInt(3) - 2;
        double m2 = blockPos.v() + random.nextInt(3) - 2;
        int n2 = blockPos.u() - MathHelper.f(g2) - i2;
        int o2 = blockPos.v() - 2 - i2;
        int p2 = blockPos.w() - MathHelper.f(g2) - i2;
        int q2 = 2 * (MathHelper.f(g2) + i2);
        int r2 = 2 * (2 + i2);
        for (int s2 = n2; s2 <= n2 + q2; ++s2) {
            for (int t2 = p2; t2 <= p2 + q2; ++t2) {
                if (o2 > worldGenLevel.a(HeightMap.Type.c, s2, t2)) continue;
                return this.a(worldGenLevel, random, oreConfiguration, d2, e2, h2, j2, l2, m2, n2, o2, p2, q2, r2);
            }
        }
        return false;
    }

    protected boolean a(GeneratorAccessSeed world, Random random, WorldGenFeatureOreConfiguration config, double startX, double endX, double startZ, double endZ, double startY, double endY, int x2, int y2, int z2, int horizontalSize, int verticalSize) {
        int i2 = 0;
        BitSet bitSet = new BitSet(horizontalSize * verticalSize * horizontalSize);
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        int j2 = config.c;
        double[] ds = new double[j2 * 4];
        for (int k2 = 0; k2 < j2; ++k2) {
            float f2 = (float)k2 / (float)j2;
            double d2 = MathHelper.d((double)f2, startX, endX);
            double e2 = MathHelper.d((double)f2, startY, endY);
            double g2 = MathHelper.d((double)f2, startZ, endZ);
            double h2 = random.nextDouble() * (double)j2 / 16.0;
            double l2 = ((double)(MathHelper.a((float)Math.PI * f2) + 1.0f) * h2 + 1.0) / 2.0;
            ds[k2 * 4 + 0] = d2;
            ds[k2 * 4 + 1] = e2;
            ds[k2 * 4 + 2] = g2;
            ds[k2 * 4 + 3] = l2;
        }
        for (int m2 = 0; m2 < j2 - 1; ++m2) {
            if (ds[m2 * 4 + 3] <= 0.0) continue;
            for (int n2 = m2 + 1; n2 < j2; ++n2) {
                double q2;
                double p2;
                double o2;
                double r2;
                if (ds[n2 * 4 + 3] <= 0.0 || !((r2 = ds[m2 * 4 + 3] - ds[n2 * 4 + 3]) * r2 > (o2 = ds[m2 * 4 + 0] - ds[n2 * 4 + 0]) * o2 + (p2 = ds[m2 * 4 + 1] - ds[n2 * 4 + 1]) * p2 + (q2 = ds[m2 * 4 + 2] - ds[n2 * 4 + 2]) * q2)) continue;
                if (r2 > 0.0) {
                    ds[n2 * 4 + 3] = -1.0;
                    continue;
                }
                ds[m2 * 4 + 3] = -1.0;
            }
        }
        try (BulkSectionAccess bulkSectionAccess = new BulkSectionAccess(world);){
            for (int s2 = 0; s2 < j2; ++s2) {
                double t2 = ds[s2 * 4 + 3];
                if (t2 < 0.0) continue;
                double u2 = ds[s2 * 4 + 0];
                double v2 = ds[s2 * 4 + 1];
                double w2 = ds[s2 * 4 + 2];
                int aa2 = Math.max(MathHelper.b(u2 - t2), x2);
                int ab = Math.max(MathHelper.b(v2 - t2), y2);
                int ac = Math.max(MathHelper.b(w2 - t2), z2);
                int ad = Math.max(MathHelper.b(u2 + t2), aa2);
                int ae = Math.max(MathHelper.b(v2 + t2), ab);
                int af = Math.max(MathHelper.b(w2 + t2), ac);
                for (int ag = aa2; ag <= ad; ++ag) {
                    double ah = ((double)ag + 0.5 - u2) / t2;
                    if (!(ah * ah < 1.0)) continue;
                    for (int ai = ab; ai <= ae; ++ai) {
                        double aj = ((double)ai + 0.5 - v2) / t2;
                        if (!(ah * ah + aj * aj < 1.0)) continue;
                        block11: for (int ak = ac; ak <= af; ++ak) {
                            ChunkSection levelChunkSection;
                            int am;
                            double al = ((double)ak + 0.5 - w2) / t2;
                            if (!(ah * ah + aj * aj + al * al < 1.0) || world.d(ai) || bitSet.get(am = ag - x2 + (ai - y2) * horizontalSize + (ak - z2) * horizontalSize * verticalSize)) continue;
                            bitSet.set(am);
                            mutableBlockPos.d(ag, ai, ak);
                            if (!world.e_(mutableBlockPos) || (levelChunkSection = bulkSectionAccess.a(mutableBlockPos)) == null) continue;
                            int an = SectionPosition.b(ag);
                            int ao = SectionPosition.b(ai);
                            int ap = SectionPosition.b(ak);
                            IBlockData blockState = levelChunkSection.a(an, ao, ap);
                            for (WorldGenFeatureOreConfiguration.a targetBlockState : config.b) {
                                if (!WorldGenMinable.a(blockState, bulkSectionAccess::b, random, config, targetBlockState, mutableBlockPos)) continue;
                                levelChunkSection.a(an, ao, ap, targetBlockState.c, false);
                                ++i2;
                                continue block11;
                            }
                        }
                    }
                }
            }
        }
        return i2 > 0;
    }

    public static boolean a(IBlockData state, Function<BlockPosition, IBlockData> posToState, Random random, WorldGenFeatureOreConfiguration config, WorldGenFeatureOreConfiguration.a target, BlockPosition.MutableBlockPosition pos) {
        if (!target.b.a(state, random)) {
            return false;
        }
        if (WorldGenMinable.a(random, config.d)) {
            return true;
        }
        return !WorldGenMinable.a(posToState, (BlockPosition)pos);
    }

    protected static boolean a(Random random, float chance) {
        if (chance <= 0.0f) {
            return true;
        }
        if (chance >= 1.0f) {
            return false;
        }
        return random.nextFloat() >= chance;
    }
}

