/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureRuinedPortalConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.WorldGenFeatureRuinedPortalPieces;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;

public class WorldGenFeatureRuinedPortal
extends StructureGenerator<WorldGenFeatureRuinedPortalConfiguration> {
    private static final String[] a = new String[]{"ruined_portal/portal_1", "ruined_portal/portal_2", "ruined_portal/portal_3", "ruined_portal/portal_4", "ruined_portal/portal_5", "ruined_portal/portal_6", "ruined_portal/portal_7", "ruined_portal/portal_8", "ruined_portal/portal_9", "ruined_portal/portal_10"};
    private static final String[] w = new String[]{"ruined_portal/giant_portal_1", "ruined_portal/giant_portal_2", "ruined_portal/giant_portal_3"};
    private static final float x = 0.05f;
    private static final float y = 0.5f;
    private static final float z = 0.5f;
    private static final float A = 0.8f;
    private static final float B = 0.8f;
    private static final float C = 0.5f;
    private static final int D = 15;

    public WorldGenFeatureRuinedPortal(Codec<WorldGenFeatureRuinedPortalConfiguration> configCodec) {
        super(configCodec, WorldGenFeatureRuinedPortal::a);
    }

    private static Optional<PieceGenerator<WorldGenFeatureRuinedPortalConfiguration>> a(PieceGeneratorSupplier.a<WorldGenFeatureRuinedPortalConfiguration> context2) {
        MinecraftKey resourceLocation2;
        WorldGenFeatureRuinedPortalPieces.Position verticalPlacement7;
        WorldGenFeatureRuinedPortalPieces.a properties = new WorldGenFeatureRuinedPortalPieces.a();
        WorldGenFeatureRuinedPortalConfiguration ruinedPortalConfiguration = context2.e();
        SeededRandom worldgenRandom = new SeededRandom(new LegacyRandomSource(0L));
        worldgenRandom.c(context2.c(), context2.d().c, context2.d().d);
        if (ruinedPortalConfiguration.b == Type.b) {
            WorldGenFeatureRuinedPortalPieces.Position verticalPlacement = WorldGenFeatureRuinedPortalPieces.Position.b;
            properties.d = false;
            properties.c = 0.0f;
        } else if (ruinedPortalConfiguration.b == Type.c) {
            WorldGenFeatureRuinedPortalPieces.Position verticalPlacement2 = WorldGenFeatureRuinedPortalPieces.Position.a;
            properties.d = worldgenRandom.nextFloat() < 0.5f;
            properties.c = 0.8f;
            properties.e = true;
            properties.f = true;
        } else if (ruinedPortalConfiguration.b == Type.d) {
            WorldGenFeatureRuinedPortalPieces.Position verticalPlacement3 = WorldGenFeatureRuinedPortalPieces.Position.c;
            properties.d = false;
            properties.c = 0.5f;
            properties.f = true;
        } else if (ruinedPortalConfiguration.b == Type.e) {
            boolean bl = worldgenRandom.nextFloat() < 0.5f;
            WorldGenFeatureRuinedPortalPieces.Position verticalPlacement4 = bl ? WorldGenFeatureRuinedPortalPieces.Position.d : WorldGenFeatureRuinedPortalPieces.Position.a;
            properties.d = bl || worldgenRandom.nextFloat() < 0.5f;
        } else if (ruinedPortalConfiguration.b == Type.f) {
            WorldGenFeatureRuinedPortalPieces.Position verticalPlacement5 = WorldGenFeatureRuinedPortalPieces.Position.c;
            properties.d = false;
            properties.c = 0.8f;
        } else if (ruinedPortalConfiguration.b == Type.g) {
            WorldGenFeatureRuinedPortalPieces.Position verticalPlacement6 = WorldGenFeatureRuinedPortalPieces.Position.f;
            properties.d = worldgenRandom.nextFloat() < 0.5f;
            properties.c = 0.0f;
            properties.g = true;
        } else {
            boolean bl2 = worldgenRandom.nextFloat() < 0.5f;
            verticalPlacement7 = bl2 ? WorldGenFeatureRuinedPortalPieces.Position.e : WorldGenFeatureRuinedPortalPieces.Position.a;
            boolean bl = properties.d = bl2 || worldgenRandom.nextFloat() < 0.5f;
        }
        if (worldgenRandom.nextFloat() < 0.05f) {
            MinecraftKey resourceLocation = new MinecraftKey(w[worldgenRandom.nextInt(w.length)]);
        } else {
            resourceLocation2 = new MinecraftKey(a[worldgenRandom.nextInt(a.length)]);
        }
        DefinedStructure structureTemplate = context2.h().a(resourceLocation2);
        EnumBlockRotation rotation = SystemUtils.a(EnumBlockRotation.values(), (Random)worldgenRandom);
        EnumBlockMirror mirror = worldgenRandom.nextFloat() < 0.5f ? EnumBlockMirror.a : EnumBlockMirror.c;
        BlockPosition blockPos = new BlockPosition(structureTemplate.a().u() / 2, 0, structureTemplate.a().w() / 2);
        BlockPosition blockPos2 = context2.d().l();
        StructureBoundingBox boundingBox = structureTemplate.a(blockPos2, rotation, blockPos, mirror);
        BlockPosition blockPos3 = boundingBox.f();
        int i2 = context2.a().a(blockPos3.u(), blockPos3.w(), WorldGenFeatureRuinedPortalPieces.a(verticalPlacement7), context2.f()) - 1;
        int j2 = WorldGenFeatureRuinedPortal.a(worldgenRandom, context2.a(), verticalPlacement7, properties.d, i2, boundingBox.d(), boundingBox, context2.f());
        BlockPosition blockPos4 = new BlockPosition(blockPos2.u(), j2, blockPos2.w());
        if (!context2.g().test(context2.a().getNoiseBiome(QuartPos.a(blockPos4.u()), QuartPos.a(blockPos4.v()), QuartPos.a(blockPos4.w())))) {
            return Optional.empty();
        }
        return Optional.of((collector, context) -> {
            if (ruinedPortalConfiguration.b == Type.e || ruinedPortalConfiguration.b == Type.f || ruinedPortalConfiguration.b == Type.a) {
                properties.b = WorldGenFeatureRuinedPortal.a(blockPos4, context2.a().getNoiseBiome(QuartPos.a(blockPos4.u()), QuartPos.a(blockPos4.v()), QuartPos.a(blockPos4.w())));
            }
            collector.a(new WorldGenFeatureRuinedPortalPieces(context.c(), blockPos4, verticalPlacement7, properties, resourceLocation2, structureTemplate, rotation, mirror, blockPos));
        });
    }

    private static boolean a(BlockPosition pos, BiomeBase biome) {
        return biome.a(pos);
    }

    private static int a(Random random, ChunkGenerator chunkGenerator, WorldGenFeatureRuinedPortalPieces.Position verticalPlacement, boolean airPocket, int height, int blockCountY, StructureBoundingBox box, LevelHeightAccessor world) {
        int s2;
        int i2 = world.u_() + 15;
        if (verticalPlacement == WorldGenFeatureRuinedPortalPieces.Position.f) {
            if (airPocket) {
                int j2 = MathHelper.b(random, 32, 100);
            } else if (random.nextFloat() < 0.5f) {
                int k2 = MathHelper.b(random, 27, 29);
            } else {
                int l2 = MathHelper.b(random, 29, 100);
            }
        } else if (verticalPlacement == WorldGenFeatureRuinedPortalPieces.Position.d) {
            int m2 = height - blockCountY;
            int n2 = WorldGenFeatureRuinedPortal.a(random, 70, m2);
        } else if (verticalPlacement == WorldGenFeatureRuinedPortalPieces.Position.e) {
            int o2 = height - blockCountY;
            int p2 = WorldGenFeatureRuinedPortal.a(random, i2, o2);
        } else if (verticalPlacement == WorldGenFeatureRuinedPortalPieces.Position.b) {
            int q2 = height - blockCountY + MathHelper.b(random, 2, 8);
        } else {
            int r2 = height;
        }
        ImmutableList list = ImmutableList.of((Object)new BlockPosition(box.g(), 0, box.i()), (Object)new BlockPosition(box.j(), 0, box.i()), (Object)new BlockPosition(box.g(), 0, box.l()), (Object)new BlockPosition(box.j(), 0, box.l()));
        List list2 = list.stream().map(pos -> chunkGenerator.a(pos.u(), pos.w(), world)).collect(Collectors.toList());
        HeightMap.Type types = verticalPlacement == WorldGenFeatureRuinedPortalPieces.Position.c ? HeightMap.Type.c : HeightMap.Type.a;
        block0: for (s2 = r2; s2 > i2; --s2) {
            int t2 = 0;
            for (BlockColumn noiseColumn : list2) {
                IBlockData blockState = noiseColumn.a(s2);
                if (!types.e().test(blockState) || ++t2 != 3) continue;
                break block0;
            }
        }
        return s2;
    }

    private static int a(Random random, int min, int max) {
        if (min < max) {
            return MathHelper.b(random, min, max);
        }
        return max;
    }

    public static final class Type
    extends Enum<Type>
    implements INamable {
        public static final /* enum */ Type a = new Type("standard");
        public static final /* enum */ Type b = new Type("desert");
        public static final /* enum */ Type c = new Type("jungle");
        public static final /* enum */ Type d = new Type("swamp");
        public static final /* enum */ Type e = new Type("mountain");
        public static final /* enum */ Type f = new Type("ocean");
        public static final /* enum */ Type g = new Type("nether");
        public static final Codec<Type> h;
        private static final Map<String, Type> i;
        private final String j;
        private static final /* synthetic */ Type[] k;

        public static Type[] values() {
            return (Type[])k.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }

        private Type(String name) {
            this.j = name;
        }

        public String a() {
            return this.j;
        }

        public static Type a(String name) {
            return i.get(name);
        }

        @Override
        @Override
        public String c() {
            return this.j;
        }

        private static /* synthetic */ Type[] b() {
            return new Type[]{a, b, c, d, e, f, g};
        }

        static {
            k = Type.b();
            h = INamable.a(Type::values, Type::a);
            i = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::a, type -> type));
        }
    }
}

