/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldGenFeatureConfigured<FC extends WorldGenFeatureConfiguration, F extends WorldGenerator<FC>> {
    public static final Codec<WorldGenFeatureConfigured<?, ?>> a = IRegistry.aW.i().dispatch(configuredFeature -> configuredFeature.e, WorldGenerator::a);
    public static final Codec<Supplier<WorldGenFeatureConfigured<?, ?>>> b = RegistryFileCodec.a(IRegistry.aM, a);
    public static final Codec<List<Supplier<WorldGenFeatureConfigured<?, ?>>>> c = RegistryFileCodec.b(IRegistry.aM, a);
    public static final Logger d = LogManager.getLogger();
    public final F e;
    public final FC f;

    public WorldGenFeatureConfigured(F feature, FC config) {
        this.e = feature;
        this.f = config;
    }

    public F a() {
        return this.e;
    }

    public FC b() {
        return this.f;
    }

    public PlacedFeature a(List<PlacementModifier> modifiers) {
        return new PlacedFeature(() -> this, modifiers);
    }

    public PlacedFeature a(PlacementModifier ... modifiers) {
        return this.a(List.of(modifiers));
    }

    public PlacedFeature a(Block block) {
        return this.a(BlockPredicate.a(block.n(), (BaseBlockPosition)BlockPosition.b));
    }

    public PlacedFeature c() {
        return this.a(BlockPredicate.a(Blocks.a, (BaseBlockPosition)BlockPosition.b));
    }

    public PlacedFeature a(BlockPredicate predicate) {
        return this.a(BlockPredicateFilter.a(predicate));
    }

    public boolean a(GeneratorAccessSeed world, ChunkGenerator chunkGenerator, Random random, BlockPosition origin) {
        if (world.e_(origin)) {
            return ((WorldGenerator)this.e).a(new FeaturePlaceContext<FC>(Optional.empty(), world, chunkGenerator, random, origin, this.f));
        }
        return false;
    }

    public Stream<WorldGenFeatureConfigured<?, ?>> d() {
        return Stream.concat(Stream.of(this), this.f.e());
    }

    @Override
    public String toString() {
        return RegistryGeneration.d.c(this).map(Objects::toString).orElseGet(() -> a.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).toString());
    }
}

