/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.WorldGenBuriedTreasure;
import net.minecraft.world.level.levelgen.feature.WorldGenEndCity;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureBastionRemnant;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureDesertPyramid;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureIgloo;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureJunglePyramid;
import net.minecraft.world.level.levelgen.feature.WorldGenFeaturePillagerOutpost;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureRuinedPortal;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureShipwreck;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureSwampHut;
import net.minecraft.world.level.levelgen.feature.WorldGenMineshaft;
import net.minecraft.world.level.levelgen.feature.WorldGenMonument;
import net.minecraft.world.level.levelgen.feature.WorldGenNether;
import net.minecraft.world.level.levelgen.feature.WorldGenStronghold;
import net.minecraft.world.level.levelgen.feature.WorldGenVillage;
import net.minecraft.world.level.levelgen.feature.WorldGenWoodlandMansion;
import net.minecraft.world.level.levelgen.feature.configurations.RangeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureSettingsFeature;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfigurationChance;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureOceanRuinConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureRuinedPortalConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureShipwreckConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureVillageConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenMineshaftConfiguration;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.WorldGenFeatureNetherFossil;
import net.minecraft.world.level.levelgen.structure.WorldGenFeatureOceanRuin;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StructureGenerator<C extends WorldGenFeatureConfiguration> {
    public static final BiMap<String, StructureGenerator<?>> b = HashBiMap.create();
    private static final Map<StructureGenerator<?>, WorldGenStage.Decoration> a = Maps.newHashMap();
    private static final Logger w = LogManager.getLogger();
    public static final StructureGenerator<WorldGenFeatureVillageConfiguration> c = StructureGenerator.a("Pillager_Outpost", new WorldGenFeaturePillagerOutpost(WorldGenFeatureVillageConfiguration.a), WorldGenStage.Decoration.e);
    public static final StructureGenerator<WorldGenMineshaftConfiguration> d = StructureGenerator.a("Mineshaft", new WorldGenMineshaft(WorldGenMineshaftConfiguration.a), WorldGenStage.Decoration.d);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> e = StructureGenerator.a("Mansion", new WorldGenWoodlandMansion(WorldGenFeatureEmptyConfiguration.a), WorldGenStage.Decoration.e);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> f = StructureGenerator.a("Jungle_Pyramid", new WorldGenFeatureJunglePyramid(WorldGenFeatureEmptyConfiguration.a), WorldGenStage.Decoration.e);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> g = StructureGenerator.a("Desert_Pyramid", new WorldGenFeatureDesertPyramid(WorldGenFeatureEmptyConfiguration.a), WorldGenStage.Decoration.e);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> h = StructureGenerator.a("Igloo", new WorldGenFeatureIgloo(WorldGenFeatureEmptyConfiguration.a), WorldGenStage.Decoration.e);
    public static final StructureGenerator<WorldGenFeatureRuinedPortalConfiguration> i = StructureGenerator.a("Ruined_Portal", new WorldGenFeatureRuinedPortal(WorldGenFeatureRuinedPortalConfiguration.a), WorldGenStage.Decoration.e);
    public static final StructureGenerator<WorldGenFeatureShipwreckConfiguration> j = StructureGenerator.a("Shipwreck", new WorldGenFeatureShipwreck(WorldGenFeatureShipwreckConfiguration.a), WorldGenStage.Decoration.e);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> k = StructureGenerator.a("Swamp_Hut", new WorldGenFeatureSwampHut(WorldGenFeatureEmptyConfiguration.a), WorldGenStage.Decoration.e);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> l = StructureGenerator.a("Stronghold", new WorldGenStronghold(WorldGenFeatureEmptyConfiguration.a), WorldGenStage.Decoration.f);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> m = StructureGenerator.a("Monument", new WorldGenMonument(WorldGenFeatureEmptyConfiguration.a), WorldGenStage.Decoration.e);
    public static final StructureGenerator<WorldGenFeatureOceanRuinConfiguration> n = StructureGenerator.a("Ocean_Ruin", new WorldGenFeatureOceanRuin(WorldGenFeatureOceanRuinConfiguration.a), WorldGenStage.Decoration.e);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> o = StructureGenerator.a("Fortress", new WorldGenNether(WorldGenFeatureEmptyConfiguration.a), WorldGenStage.Decoration.h);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> p = StructureGenerator.a("EndCity", new WorldGenEndCity(WorldGenFeatureEmptyConfiguration.a), WorldGenStage.Decoration.e);
    public static final StructureGenerator<WorldGenFeatureConfigurationChance> q = StructureGenerator.a("Buried_Treasure", new WorldGenBuriedTreasure(WorldGenFeatureConfigurationChance.j), WorldGenStage.Decoration.d);
    public static final StructureGenerator<WorldGenFeatureVillageConfiguration> r = StructureGenerator.a("Village", new WorldGenVillage(WorldGenFeatureVillageConfiguration.a), WorldGenStage.Decoration.e);
    public static final StructureGenerator<RangeConfiguration> s = StructureGenerator.a("Nether_Fossil", new WorldGenFeatureNetherFossil(RangeConfiguration.a), WorldGenStage.Decoration.h);
    public static final StructureGenerator<WorldGenFeatureVillageConfiguration> t = StructureGenerator.a("Bastion_Remnant", new WorldGenFeatureBastionRemnant(WorldGenFeatureVillageConfiguration.a), WorldGenStage.Decoration.e);
    public static final List<StructureGenerator<?>> u = ImmutableList.of(c, r, s, l);
    public static final int v = 8;
    private final Codec<StructureFeature<C, StructureGenerator<C>>> x;
    private final PieceGeneratorSupplier<C> y;
    private final PostPlacementProcessor z;

    private static <F extends StructureGenerator<?>> F a(String name, F structureFeature, WorldGenStage.Decoration step) {
        b.put((Object)name.toLowerCase(Locale.ROOT), structureFeature);
        a.put(structureFeature, step);
        return (F)IRegistry.a(IRegistry.aY, name.toLowerCase(Locale.ROOT), structureFeature);
    }

    public StructureGenerator(Codec<C> configCodec, PieceGeneratorSupplier<C> piecesGenerator) {
        this(configCodec, piecesGenerator, PostPlacementProcessor.a);
    }

    public StructureGenerator(Codec<C> configCodec, PieceGeneratorSupplier<C> piecesGenerator, PostPlacementProcessor postPlacementProcessor) {
        this.x = configCodec.fieldOf("config").xmap(config -> new StructureFeature<WorldGenFeatureConfiguration, StructureGenerator>(this, (WorldGenFeatureConfiguration)config), configuredFeature -> configuredFeature.e).codec();
        this.y = piecesGenerator;
        this.z = postPlacementProcessor;
    }

    public WorldGenStage.Decoration b() {
        return a.get(this);
    }

    public static void c() {
    }

    @Nullable
    public static StructureStart<?> a(StructurePieceSerializationContext context, NBTTagCompound nbt, long worldSeed) {
        String string = nbt.l("id");
        if ("INVALID".equals(string)) {
            return StructureStart.b;
        }
        StructureGenerator<?> structureFeature = IRegistry.aY.a(new MinecraftKey(string.toLowerCase(Locale.ROOT)));
        if (structureFeature == null) {
            w.error("Unknown feature id: {}", (Object)string);
            return null;
        }
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(nbt.h("ChunkX"), nbt.h("ChunkZ"));
        int i2 = nbt.h("references");
        NBTTagList listTag = nbt.c("Children", 10);
        try {
            PiecesContainer piecesContainer = PiecesContainer.a(listTag, context);
            if (structureFeature == m) {
                piecesContainer = WorldGenMonument.a(chunkPos, worldSeed, piecesContainer);
            }
            return new StructureStart(structureFeature, chunkPos, i2, piecesContainer);
        }
        catch (Exception var10) {
            w.error("Failed Start with id {}", (Object)string, (Object)var10);
            return null;
        }
    }

    public Codec<StructureFeature<C, StructureGenerator<C>>> d() {
        return this.x;
    }

    public StructureFeature<C, ? extends StructureGenerator<C>> a(C config) {
        return new StructureFeature<C, StructureGenerator>(this, config);
    }

    public BlockPosition a(ChunkCoordIntPair chunkPos) {
        return new BlockPosition(chunkPos.d(), 0, chunkPos.e());
    }

    @Nullable
    public BlockPosition a(IWorldReader world, StructureManager structureAccessor, BlockPosition searchStartPos, int searchRadius, boolean skipExistingChunks, long worldSeed, StructureSettingsFeature config) {
        int i2 = config.a();
        int j2 = SectionPosition.a(searchStartPos.u());
        int k2 = SectionPosition.a(searchStartPos.w());
        block0: for (int l2 = 0; l2 <= searchRadius; ++l2) {
            for (int m2 = -l2; m2 <= l2; ++m2) {
                boolean bl = m2 == -l2 || m2 == l2;
                for (int n2 = -l2; n2 <= l2; ++n2) {
                    StructureCheckResult structureCheckResult;
                    boolean bl2;
                    boolean bl3 = bl2 = n2 == -l2 || n2 == l2;
                    if (!bl && !bl2) continue;
                    int o2 = j2 + i2 * m2;
                    int p2 = k2 + i2 * n2;
                    ChunkCoordIntPair chunkPos = this.a(config, worldSeed, o2, p2);
                    if (!world.p_().isChunkInBounds(chunkPos.c, chunkPos.d) || (structureCheckResult = structureAccessor.a(chunkPos, this, skipExistingChunks)) == StructureCheckResult.b) continue;
                    if (!skipExistingChunks && structureCheckResult == StructureCheckResult.a) {
                        return this.a(chunkPos);
                    }
                    IChunkAccess chunkAccess = world.a(chunkPos.c, chunkPos.d, ChunkStatus.d);
                    StructureStart<?> structureStart = structureAccessor.a(SectionPosition.a(chunkAccess), this, chunkAccess);
                    if (structureStart != null && structureStart.b()) {
                        if (skipExistingChunks && structureStart.d()) {
                            structureAccessor.a(structureStart);
                            return this.a(structureStart.c());
                        }
                        if (!skipExistingChunks) {
                            return this.a(structureStart.c());
                        }
                    }
                    if (l2 == 0) break;
                }
                if (l2 == 0) continue block0;
            }
        }
        return null;
    }

    protected boolean a() {
        return true;
    }

    public final ChunkCoordIntPair a(StructureSettingsFeature config, long seed, int x2, int z2) {
        int n2;
        int m2;
        int i2 = config.a();
        int j2 = config.b();
        int k2 = Math.floorDiv(x2, i2);
        int l2 = Math.floorDiv(z2, i2);
        SeededRandom worldgenRandom = new SeededRandom(new LegacyRandomSource(0L));
        worldgenRandom.a(seed, k2, l2, config.c());
        if (this.a()) {
            m2 = worldgenRandom.nextInt(i2 - j2);
            n2 = worldgenRandom.nextInt(i2 - j2);
        } else {
            m2 = (worldgenRandom.nextInt(i2 - j2) + worldgenRandom.nextInt(i2 - j2)) / 2;
            n2 = (worldgenRandom.nextInt(i2 - j2) + worldgenRandom.nextInt(i2 - j2)) / 2;
        }
        return new ChunkCoordIntPair(k2 * i2 + m2, l2 * i2 + n2);
    }

    public StructureStart<?> a(IRegistryCustom registryManager, ChunkGenerator chunkGenerator, WorldChunkManager biomeSource, DefinedStructureManager structureManager, long worldSeed, ChunkCoordIntPair pos, int structureReferences, StructureSettingsFeature structureConfig, C config, LevelHeightAccessor world, Predicate<BiomeBase> biomePredicate) {
        Optional<PieceGenerator<C>> optional;
        ChunkCoordIntPair chunkPos = this.a(structureConfig, worldSeed, pos.c, pos.d);
        if (pos.c == chunkPos.c && pos.d == chunkPos.d && (optional = this.y.createGenerator(new PieceGeneratorSupplier.a<C>(chunkGenerator, biomeSource, worldSeed, pos, config, world, biomePredicate, structureManager, registryManager))).isPresent()) {
            StructurePiecesBuilder structurePiecesBuilder = new StructurePiecesBuilder();
            SeededRandom worldgenRandom = new SeededRandom(new LegacyRandomSource(0L));
            worldgenRandom.c(worldSeed, pos.c, pos.d);
            optional.get().generatePieces(structurePiecesBuilder, new PieceGenerator.a<C>(config, chunkGenerator, structureManager, pos, world, worldgenRandom, worldSeed));
            StructureStart structureStart = new StructureStart(this, pos, structureReferences, structurePiecesBuilder.a());
            if (structureStart.b()) {
                return structureStart;
            }
        }
        return StructureStart.b;
    }

    public boolean a(IRegistryCustom registryManager, ChunkGenerator chunkGenerator, WorldChunkManager biomeSource, DefinedStructureManager structureManager, long worldSeed, ChunkCoordIntPair pos, C config, LevelHeightAccessor world, Predicate<BiomeBase> biomePredicate) {
        return this.y.createGenerator(new PieceGeneratorSupplier.a<C>(chunkGenerator, biomeSource, worldSeed, pos, config, world, biomePredicate, structureManager, registryManager)).isPresent();
    }

    public PostPlacementProcessor e() {
        return this.z;
    }

    public String f() {
        return (String)b.inverse().get((Object)this);
    }

    public StructureBoundingBox a(StructureBoundingBox box) {
        return box;
    }
}

