/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GlowLichenBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.GlowLichenConfiguration;

public class GlowLichenFeature
extends WorldGenerator<GlowLichenConfiguration> {
    public GlowLichenFeature(Codec<GlowLichenConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    public boolean a(FeaturePlaceContext<GlowLichenConfiguration> context) {
        GeneratorAccessSeed worldGenLevel = context.b();
        BlockPosition blockPos = context.e();
        Random random = context.d();
        GlowLichenConfiguration glowLichenConfiguration = context.f();
        if (!GlowLichenFeature.c(worldGenLevel.a_(blockPos))) {
            return false;
        }
        List<EnumDirection> list = GlowLichenFeature.a(glowLichenConfiguration, random);
        if (GlowLichenFeature.a(worldGenLevel, blockPos, worldGenLevel.a_(blockPos), glowLichenConfiguration, random, list)) {
            return true;
        }
        BlockPosition.MutableBlockPosition mutableBlockPos = blockPos.i();
        block0: for (EnumDirection direction : list) {
            mutableBlockPos.g(blockPos);
            List<EnumDirection> list2 = GlowLichenFeature.a(glowLichenConfiguration, random, direction.f());
            for (int i2 = 0; i2 < glowLichenConfiguration.b; ++i2) {
                mutableBlockPos.a((BaseBlockPosition)blockPos, direction);
                IBlockData blockState = worldGenLevel.a_(mutableBlockPos);
                if (!GlowLichenFeature.c(blockState) && !blockState.a(Blocks.dY)) continue block0;
                if (!GlowLichenFeature.a(worldGenLevel, mutableBlockPos, blockState, glowLichenConfiguration, random, list2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean a(GeneratorAccessSeed world, BlockPosition pos, IBlockData state, GlowLichenConfiguration config, Random random, List<EnumDirection> directions) {
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.i();
        for (EnumDirection direction : directions) {
            IBlockData blockState = world.a_(mutableBlockPos.a((BaseBlockPosition)pos, direction));
            if (!config.g.contains(blockState.b())) continue;
            GlowLichenBlock glowLichenBlock = (GlowLichenBlock)Blocks.dY;
            IBlockData blockState2 = glowLichenBlock.c(state, (IBlockAccess)world, pos, direction);
            if (blockState2 == null) {
                return false;
            }
            world.a(pos, blockState2, 3);
            world.z(pos).e(pos);
            if (random.nextFloat() < config.f) {
                glowLichenBlock.a(blockState2, (GeneratorAccess)world, pos, direction, random, true);
            }
            return true;
        }
        return false;
    }

    public static List<EnumDirection> a(GlowLichenConfiguration config, Random random) {
        ArrayList list = Lists.newArrayList(config.h);
        Collections.shuffle(list, random);
        return list;
    }

    public static List<EnumDirection> a(GlowLichenConfiguration config, Random random, EnumDirection excluded) {
        List<EnumDirection> list = config.h.stream().filter(direction -> direction != excluded).collect(Collectors.toList());
        Collections.shuffle(list, random);
        return list;
    }

    private static boolean c(IBlockData state) {
        return state.g() || state.a(Blocks.A);
    }
}

