/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;

public class FossilFeatureConfiguration
implements WorldGenFeatureConfiguration {
    public static final Codec<FossilFeatureConfiguration> a = RecordCodecBuilder.create(instance -> instance.group((App)MinecraftKey.a.listOf().fieldOf("fossil_structures").forGetter(fossilFeatureConfiguration -> fossilFeatureConfiguration.b), (App)MinecraftKey.a.listOf().fieldOf("overlay_structures").forGetter(fossilFeatureConfiguration -> fossilFeatureConfiguration.c), (App)DefinedStructureStructureProcessorType.n.fieldOf("fossil_processors").forGetter(fossilFeatureConfiguration -> fossilFeatureConfiguration.d), (App)DefinedStructureStructureProcessorType.n.fieldOf("overlay_processors").forGetter(fossilFeatureConfiguration -> fossilFeatureConfiguration.e), (App)Codec.intRange((int)0, (int)7).fieldOf("max_empty_corners_allowed").forGetter(fossilFeatureConfiguration -> fossilFeatureConfiguration.f)).apply((Applicative)instance, FossilFeatureConfiguration::new));
    public final List<MinecraftKey> b;
    public final List<MinecraftKey> c;
    public final Supplier<ProcessorList> d;
    public final Supplier<ProcessorList> e;
    public final int f;

    public FossilFeatureConfiguration(List<MinecraftKey> fossilStructures, List<MinecraftKey> overlayStructures, Supplier<ProcessorList> fossilProcessors, Supplier<ProcessorList> overlayProcessors, int maxEmptyCorners) {
        if (fossilStructures.isEmpty()) {
            throw new IllegalArgumentException("Fossil structure lists need at least one entry");
        }
        if (fossilStructures.size() != overlayStructures.size()) {
            throw new IllegalArgumentException("Fossil structure lists must be equal lengths");
        }
        this.b = fossilStructures;
        this.c = overlayStructures;
        this.d = fossilProcessors;
        this.e = overlayProcessors;
        this.f = maxEmptyCorners;
    }

    public FossilFeatureConfiguration(List<MinecraftKey> fossilStructures, List<MinecraftKey> overlayStructures, ProcessorList fossilProcessors, ProcessorList overlayProcessors, int maxEmptyCorners) {
        this(fossilStructures, overlayStructures, () -> fossilProcessors, () -> overlayProcessors, maxEmptyCorners);
    }
}

