/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.valueproviders.ClampedNormalFloat;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.DripstoneClusterConfiguration;

public class DripstoneClusterFeature
extends WorldGenerator<DripstoneClusterConfiguration> {
    public DripstoneClusterFeature(Codec<DripstoneClusterConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    public boolean a(FeaturePlaceContext<DripstoneClusterConfiguration> context) {
        GeneratorAccessSeed worldGenLevel = context.b();
        BlockPosition blockPos = context.e();
        DripstoneClusterConfiguration dripstoneClusterConfiguration = context.f();
        Random random = context.d();
        if (!DripstoneUtils.a(worldGenLevel, blockPos)) {
            return false;
        }
        int i2 = dripstoneClusterConfiguration.c.a(random);
        float f2 = dripstoneClusterConfiguration.i.a(random);
        float g2 = dripstoneClusterConfiguration.h.a(random);
        int j2 = dripstoneClusterConfiguration.d.a(random);
        int k2 = dripstoneClusterConfiguration.d.a(random);
        for (int l2 = -j2; l2 <= j2; ++l2) {
            for (int m2 = -k2; m2 <= k2; ++m2) {
                double d2 = this.a(j2, k2, l2, m2, dripstoneClusterConfiguration);
                BlockPosition blockPos2 = blockPos.b(l2, 0, m2);
                this.a(worldGenLevel, random, blockPos2, l2, m2, f2, d2, i2, g2, dripstoneClusterConfiguration);
            }
        }
        return true;
    }

    private void a(GeneratorAccessSeed world, Random random, BlockPosition pos, int localX, int localZ, float wetness, double dripstoneChance, int height, float density, DripstoneClusterConfiguration config) {
        boolean bl4;
        int ab;
        int aa2;
        int r2;
        boolean bl3;
        int n2;
        boolean bl2;
        Column column2;
        boolean bl;
        Optional<Column> optional = Column.a(world, pos, config.b, DripstoneUtils::c, DripstoneUtils::a);
        if (!optional.isPresent()) {
            return;
        }
        OptionalInt optionalInt = optional.get().b();
        OptionalInt optionalInt2 = optional.get().c();
        if (!optionalInt.isPresent() && !optionalInt2.isPresent()) {
            return;
        }
        boolean bl5 = bl = random.nextFloat() < wetness;
        if (bl && optionalInt2.isPresent() && this.b(world, pos.h(optionalInt2.getAsInt()))) {
            int i2 = optionalInt2.getAsInt();
            Column column = optional.get().a(OptionalInt.of(i2 - 1));
            world.a(pos.h(i2), Blocks.A.n(), 2);
        } else {
            column2 = optional.get();
        }
        OptionalInt optionalInt3 = column2.c();
        boolean bl6 = bl2 = random.nextDouble() < dripstoneChance;
        if (optionalInt.isPresent() && bl2 && !this.a((IWorldReader)world, pos.h(optionalInt.getAsInt()))) {
            int l2;
            int j2 = config.g.a(random);
            this.a(world, pos.h(optionalInt.getAsInt()), j2, EnumDirection.b);
            if (optionalInt3.isPresent()) {
                int k2 = Math.min(height, optionalInt.getAsInt() - optionalInt3.getAsInt());
            } else {
                l2 = height;
            }
            int m2 = this.a(random, localX, localZ, density, l2, config);
        } else {
            n2 = 0;
        }
        boolean bl7 = bl3 = random.nextDouble() < dripstoneChance;
        if (optionalInt3.isPresent() && bl3 && !this.a((IWorldReader)world, pos.h(optionalInt3.getAsInt()))) {
            int o2 = config.g.a(random);
            this.a(world, pos.h(optionalInt3.getAsInt()), o2, EnumDirection.a);
            if (optionalInt.isPresent()) {
                int p2 = Math.max(0, n2 + MathHelper.b(random, -config.e, config.e));
            } else {
                int q2 = this.a(random, localX, localZ, density, height, config);
            }
        } else {
            r2 = 0;
        }
        if (optionalInt.isPresent() && optionalInt3.isPresent() && optionalInt.getAsInt() - n2 <= optionalInt3.getAsInt() + r2) {
            int s2 = optionalInt3.getAsInt();
            int t2 = optionalInt.getAsInt();
            int u2 = Math.max(t2 - n2, s2 + 1);
            int v2 = Math.min(s2 + r2, t2 - 1);
            int w2 = MathHelper.b(random, u2, v2 + 1);
            int x2 = w2 - 1;
            int y2 = t2 - w2;
            int z2 = x2 - s2;
        } else {
            aa2 = n2;
            ab = r2;
        }
        boolean bl8 = bl4 = random.nextBoolean() && aa2 > 0 && ab > 0 && column2.d().isPresent() && aa2 + ab == column2.d().getAsInt();
        if (optionalInt.isPresent()) {
            DripstoneUtils.a(world, pos.h(optionalInt.getAsInt() - 1), EnumDirection.a, aa2, bl4);
        }
        if (optionalInt3.isPresent()) {
            DripstoneUtils.a(world, pos.h(optionalInt3.getAsInt() + 1), EnumDirection.b, ab, bl4);
        }
    }

    private boolean a(IWorldReader world, BlockPosition pos) {
        return world.a_(pos).a(Blocks.B);
    }

    private int a(Random random, int localX, int localZ, float density, int height, DripstoneClusterConfiguration config) {
        if (random.nextFloat() > density) {
            return 0;
        }
        int i2 = Math.abs(localX) + Math.abs(localZ);
        float f2 = (float)MathHelper.a((double)i2, 0.0, (double)config.l, (double)height / 2.0, 0.0);
        return (int)DripstoneClusterFeature.a(random, 0.0f, height, f2, config.f);
    }

    private boolean b(GeneratorAccessSeed world, BlockPosition pos) {
        IBlockData blockState = world.a_(pos);
        if (blockState.a(Blocks.A) || blockState.a(Blocks.pA) || blockState.a(Blocks.pz)) {
            return false;
        }
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            if (this.a((GeneratorAccess)world, pos.a(direction))) continue;
            return false;
        }
        return this.a((GeneratorAccess)world, pos.c());
    }

    private boolean a(GeneratorAccess world, BlockPosition pos) {
        IBlockData blockState = world.a_(pos);
        return blockState.a(TagsBlock.aR) || blockState.n().a(TagsFluid.b);
    }

    private void a(GeneratorAccessSeed world, BlockPosition pos, int height, EnumDirection direction) {
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.i();
        for (int i2 = 0; i2 < height; ++i2) {
            if (!DripstoneUtils.c(world, mutableBlockPos)) {
                return;
            }
            mutableBlockPos.c(direction);
        }
    }

    private double a(int radiusX, int radiusZ, int localX, int localZ, DripstoneClusterConfiguration config) {
        int i2 = radiusX - Math.abs(localX);
        int j2 = radiusZ - Math.abs(localZ);
        int k2 = Math.min(i2, j2);
        return MathHelper.a(k2, 0.0f, config.k, config.j, 1.0f);
    }

    private static float a(Random random, float min, float max, float mean, float deviation) {
        return ClampedNormalFloat.a(random, mean, deviation, min, max);
    }
}

