/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.blockpredicates;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.blockpredicates.AllOfPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.AnyOfPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.blockpredicates.HasSturdyFacePredicate;
import net.minecraft.world.level.levelgen.blockpredicates.InsideWorldBoundsPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.MatchingBlockTagPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.MatchingBlocksPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.MatchingFluidsPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.NotPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.ReplaceablePredicate;
import net.minecraft.world.level.levelgen.blockpredicates.SolidPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.TrueBlockPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.WouldSurvivePredicate;
import net.minecraft.world.level.material.FluidType;

public interface BlockPredicate
extends BiPredicate<GeneratorAccessSeed, BlockPosition> {
    public static final Codec<BlockPredicate> b = IRegistry.aJ.i().dispatch(BlockPredicate::a, BlockPredicateType::codec);
    public static final BlockPredicate c = BlockPredicate.a(Blocks.a, (BaseBlockPosition)BlockPosition.b);
    public static final BlockPredicate d = BlockPredicate.a(List.of(Blocks.a, Blocks.A), (BaseBlockPosition)BlockPosition.b);

    public BlockPredicateType<?> a();

    public static BlockPredicate a(List<BlockPredicate> predicates) {
        return new AllOfPredicate(predicates);
    }

    public static BlockPredicate a(BlockPredicate ... predicates) {
        return BlockPredicate.a(List.of(predicates));
    }

    public static BlockPredicate a(BlockPredicate first, BlockPredicate second) {
        return BlockPredicate.a(List.of(first, second));
    }

    public static BlockPredicate b(List<BlockPredicate> predicates) {
        return new AnyOfPredicate(predicates);
    }

    public static BlockPredicate b(BlockPredicate ... predicates) {
        return BlockPredicate.b(List.of(predicates));
    }

    public static BlockPredicate b(BlockPredicate first, BlockPredicate second) {
        return BlockPredicate.b(List.of(first, second));
    }

    public static BlockPredicate a(List<Block> blocks, BaseBlockPosition offset) {
        return new MatchingBlocksPredicate(offset, blocks);
    }

    public static BlockPredicate c(List<Block> blocks) {
        return BlockPredicate.a(blocks, BaseBlockPosition.g);
    }

    public static BlockPredicate a(Block block, BaseBlockPosition offset) {
        return BlockPredicate.a(List.of(block), offset);
    }

    public static BlockPredicate a(Tag<Block> tag, BaseBlockPosition offset) {
        return new MatchingBlockTagPredicate(offset, tag);
    }

    public static BlockPredicate a(Tag<Block> offset) {
        return BlockPredicate.a(offset, BaseBlockPosition.g);
    }

    public static BlockPredicate b(List<FluidType> fluids, BaseBlockPosition offset) {
        return new MatchingFluidsPredicate(offset, fluids);
    }

    public static BlockPredicate a(FluidType fluid, BaseBlockPosition offset) {
        return BlockPredicate.b(List.of(fluid), offset);
    }

    public static BlockPredicate a(BlockPredicate predicate) {
        return new NotPredicate(predicate);
    }

    public static BlockPredicate a(BaseBlockPosition offset) {
        return new ReplaceablePredicate(offset);
    }

    public static BlockPredicate b() {
        return BlockPredicate.a(BaseBlockPosition.g);
    }

    public static BlockPredicate a(IBlockData state, BaseBlockPosition offset) {
        return new WouldSurvivePredicate(offset, state);
    }

    public static BlockPredicate a(BaseBlockPosition offset, EnumDirection face) {
        return new HasSturdyFacePredicate(offset, face);
    }

    public static BlockPredicate a(EnumDirection face) {
        return BlockPredicate.a(BaseBlockPosition.g, face);
    }

    public static BlockPredicate b(BaseBlockPosition offset) {
        return new SolidPredicate(offset);
    }

    public static BlockPredicate c() {
        return BlockPredicate.b(BaseBlockPosition.g);
    }

    public static BlockPredicate c(BaseBlockPosition offset) {
        return new InsideWorldBoundsPredicate(offset);
    }

    public static BlockPredicate d() {
        return TrueBlockPredicate.a;
    }
}

