/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.data.worldgen.StructureFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.StructureSettingsFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureSettingsStronghold;

public class StructureSettings {
    public static final Codec<StructureSettings> a = RecordCodecBuilder.create(instance -> instance.group((App)StructureSettingsStronghold.a.optionalFieldOf("stronghold").forGetter(structuresettings -> Optional.ofNullable(structuresettings.f)), (App)Codec.simpleMap(IRegistry.aY.i(), StructureSettingsFeature.a, IRegistry.aY).fieldOf("structures").forGetter(structuresettings -> structuresettings.d)).apply((Applicative)instance, StructureSettings::new));
    public static final ImmutableMap<StructureGenerator<?>, StructureSettingsFeature> b = ImmutableMap.builder().put(StructureGenerator.r, (Object)new StructureSettingsFeature(34, 8, 10387312)).put(StructureGenerator.g, (Object)new StructureSettingsFeature(32, 8, 14357617)).put(StructureGenerator.h, (Object)new StructureSettingsFeature(32, 8, 14357618)).put(StructureGenerator.f, (Object)new StructureSettingsFeature(32, 8, 14357619)).put(StructureGenerator.k, (Object)new StructureSettingsFeature(32, 8, 14357620)).put(StructureGenerator.c, (Object)new StructureSettingsFeature(32, 8, 165745296)).put(StructureGenerator.l, (Object)new StructureSettingsFeature(1, 0, 0)).put(StructureGenerator.m, (Object)new StructureSettingsFeature(32, 5, 10387313)).put(StructureGenerator.p, (Object)new StructureSettingsFeature(20, 11, 10387313)).put(StructureGenerator.e, (Object)new StructureSettingsFeature(80, 20, 10387319)).put(StructureGenerator.q, (Object)new StructureSettingsFeature(1, 0, 0)).put(StructureGenerator.d, (Object)new StructureSettingsFeature(1, 0, 0)).put(StructureGenerator.i, (Object)new StructureSettingsFeature(40, 15, 34222645)).put(StructureGenerator.j, (Object)new StructureSettingsFeature(24, 4, 165745295)).put(StructureGenerator.n, (Object)new StructureSettingsFeature(20, 8, 14357621)).put(StructureGenerator.t, (Object)new StructureSettingsFeature(27, 4, 30084232)).put(StructureGenerator.o, (Object)new StructureSettingsFeature(27, 4, 30084232)).put(StructureGenerator.s, (Object)new StructureSettingsFeature(2, 1, 14357921)).build();
    public static final StructureSettingsStronghold c = new StructureSettingsStronghold(32, 3, 128);
    private final Map<StructureGenerator<?>, StructureSettingsFeature> d;
    private final ImmutableMap<StructureGenerator<?>, ImmutableMultimap<StructureFeature<?, ?>, ResourceKey<BiomeBase>>> e;
    @Nullable
    private final StructureSettingsStronghold f;

    private StructureSettings(Map<StructureGenerator<?>, StructureSettingsFeature> structures, @Nullable StructureSettingsStronghold stronghold) {
        this.f = stronghold;
        this.d = Maps.newHashMap(structures);
        HashMap hashmap = new HashMap();
        StructureFeatures.a((structurefeature, resourcekey) -> hashmap.computeIfAbsent(structurefeature.d, structuregenerator -> ImmutableMultimap.builder()).put(structurefeature, resourcekey));
        this.e = (ImmutableMap)hashmap.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((ImmutableMultimap.Builder)entry.getValue()).build()));
    }

    public StructureSettings(Optional<StructureSettingsStronghold> stronghold, Map<StructureGenerator<?>, StructureSettingsFeature> structures) {
        this(structures, stronghold.orElse(null));
    }

    public StructureSettings(boolean withStronghold) {
        this(Maps.newHashMap(b), withStronghold ? c : null);
    }

    @VisibleForTesting
    public Map<StructureGenerator<?>, StructureSettingsFeature> a() {
        return this.d;
    }

    @Nullable
    public StructureSettingsFeature a(StructureGenerator<?> structureType) {
        return this.d.get(structureType);
    }

    @Nullable
    public StructureSettingsStronghold b() {
        return this.f;
    }

    public ImmutableMultimap<StructureFeature<?, ?>, ResourceKey<BiomeBase>> b(StructureGenerator<?> feature) {
        return (ImmutableMultimap)this.e.getOrDefault(feature, (Object)ImmutableMultimap.of());
    }

    static {
        for (StructureGenerator structureGenerator : IRegistry.aY) {
            if (b.containsKey((Object)structureGenerator)) continue;
            throw new IllegalStateException("Structure feature without default settings: " + IRegistry.aY.b(structureGenerator));
        }
    }
}

