/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.biome.TerrainShaper;
import net.minecraft.world.level.biome.WorldChunkManagerTheEnd;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.TerrainInfo;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NoiseGenerator3Handler;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import net.minecraft.world.level.levelgen.synth.NoiseUtils;

public class NoiseSampler
implements Climate.Sampler {
    private static final float a = 1.0f;
    private static final float b = 0.08f;
    private static final float c = 0.4f;
    private static final double d = 1.5;
    private static final int e = 20;
    private static final double f = 0.2;
    private static final float g = 0.7f;
    private static final float h = 0.1f;
    private static final float i = 0.3f;
    private static final float j = 0.6f;
    private static final float k = 0.02f;
    private static final float l = -0.3f;
    private static final double m = 1.5;
    private final NoiseSettings n;
    private final boolean o;
    private final NoiseChunk.b p;
    private final BlendedNoise q;
    @Nullable
    private final NoiseGenerator3Handler r;
    private final NoiseGeneratorNormal s;
    private final NoiseGeneratorNormal t;
    private final NoiseGeneratorNormal u;
    private final NoiseGeneratorNormal v;
    private final NoiseGeneratorNormal w;
    private final NoiseGeneratorNormal x;
    private final NoiseGeneratorNormal y;
    private final NoiseGeneratorNormal z;
    private final NoiseGeneratorNormal A;
    private final NoiseGeneratorNormal B;
    private final NoiseGeneratorNormal C;
    private final NoiseGeneratorNormal D;
    private final NoiseGeneratorNormal E;
    private final NoiseGeneratorNormal F;
    private final NoiseGeneratorNormal G;
    private final NoiseGeneratorNormal H;
    private final NoiseGeneratorNormal I;
    private final NoiseGeneratorNormal J;
    private final NoiseGeneratorNormal K;
    private final NoiseGeneratorNormal L;
    private final NoiseGeneratorNormal M;
    private final NoiseGeneratorNormal N;
    private final NoiseGeneratorNormal O;
    private final NoiseGeneratorNormal P;
    private final NoiseGeneratorNormal Q;
    private final NoiseGeneratorNormal R;
    private final NoiseGeneratorNormal S;
    private final NoiseGeneratorNormal T;
    private final NoiseChunk.b U;
    private final NoiseChunk.b V;
    private final NoiseChunk.b W;
    private final NoiseChunk.b X;
    private final NoiseChunk.b Y;
    private final NoiseChunk.b Z;
    private final NoiseChunk.b aa;
    private final PositionalRandomFactory ab;
    private final PositionalRandomFactory ac;
    private final PositionalRandomFactory ad;
    private final List<Climate.d> ae = new OverworldBiomeBuilder().a();
    private final boolean af;

    public NoiseSampler(NoiseSettings config, boolean hasNoiseCaves, long seed, IRegistry<NoiseGeneratorNormal.a> noiseRegistry, SeededRandom.a randomProvider) {
        this.n = config;
        this.o = hasNoiseCaves;
        this.p = chunkNoiseSampler -> chunkNoiseSampler.a((int x2, int y2, int z2) -> this.a(x2, y2, z2, chunkNoiseSampler.a(QuartPos.a(x2), QuartPos.a(z2)).f(), chunkNoiseSampler.a()));
        if (config.a()) {
            RandomSource randomSource = randomProvider.a(seed);
            randomSource.b(17292);
            this.r = new NoiseGenerator3Handler(randomSource);
        } else {
            this.r = null;
        }
        this.af = config.b();
        int i2 = config.h();
        int j2 = Stream.of(net.minecraft.world.level.levelgen.NoiseSampler$c.values()).mapToInt(veinType -> veinType.f).min().orElse(i2);
        int k2 = Stream.of(net.minecraft.world.level.levelgen.NoiseSampler$c.values()).mapToInt(veinType -> veinType.g).max().orElse(i2);
        float f2 = 4.0f;
        double d2 = 2.6666666666666665;
        int l2 = i2 + 4;
        int m2 = i2 + config.i();
        boolean bl = config.c();
        PositionalRandomFactory positionalRandomFactory = randomProvider.a(seed).b();
        if (randomProvider != SeededRandom.a.a) {
            this.q = new BlendedNoise(positionalRandomFactory.a(new MinecraftKey("terrain")), config.j(), config.e(), config.d());
            this.N = Noises.a(noiseRegistry, positionalRandomFactory, bl ? Noises.e : Noises.a);
            this.O = Noises.a(noiseRegistry, positionalRandomFactory, bl ? Noises.f : Noises.b);
            this.S = Noises.a(noiseRegistry, positionalRandomFactory, Noises.j);
        } else {
            this.q = new BlendedNoise(randomProvider.a(seed), config.j(), config.e(), config.d());
            this.N = NoiseGeneratorNormal.a(randomProvider.a(seed), new NoiseGeneratorNormal.a(-7, 1.0, 1.0));
            this.O = NoiseGeneratorNormal.a(randomProvider.a(seed + 1L), new NoiseGeneratorNormal.a(-7, 1.0, 1.0));
            this.S = NoiseGeneratorNormal.b(positionalRandomFactory.a(Noises.j.a()), new NoiseGeneratorNormal.a(0, 0.0, new double[0]));
        }
        this.ab = positionalRandomFactory.a(new MinecraftKey("aquifer")).b();
        this.ac = positionalRandomFactory.a(new MinecraftKey("ore")).b();
        this.ad = positionalRandomFactory.a(new MinecraftKey("depth_based_layer")).b();
        this.t = Noises.a(noiseRegistry, positionalRandomFactory, Noises.k);
        this.u = Noises.a(noiseRegistry, positionalRandomFactory, Noises.l);
        this.w = Noises.a(noiseRegistry, positionalRandomFactory, Noises.m);
        this.v = Noises.a(noiseRegistry, positionalRandomFactory, Noises.n);
        this.y = Noises.a(noiseRegistry, positionalRandomFactory, Noises.o);
        this.z = Noises.a(noiseRegistry, positionalRandomFactory, Noises.p);
        this.A = Noises.a(noiseRegistry, positionalRandomFactory, Noises.q);
        this.B = Noises.a(noiseRegistry, positionalRandomFactory, Noises.r);
        this.C = Noises.a(noiseRegistry, positionalRandomFactory, Noises.s);
        this.D = Noises.a(noiseRegistry, positionalRandomFactory, Noises.t);
        this.E = Noises.a(noiseRegistry, positionalRandomFactory, Noises.u);
        this.F = Noises.a(noiseRegistry, positionalRandomFactory, Noises.v);
        this.G = Noises.a(noiseRegistry, positionalRandomFactory, Noises.w);
        this.H = Noises.a(noiseRegistry, positionalRandomFactory, Noises.x);
        this.I = Noises.a(noiseRegistry, positionalRandomFactory, Noises.y);
        this.J = Noises.a(noiseRegistry, positionalRandomFactory, Noises.z);
        this.K = Noises.a(noiseRegistry, positionalRandomFactory, Noises.A);
        this.L = Noises.a(noiseRegistry, positionalRandomFactory, Noises.B);
        this.x = Noises.a(noiseRegistry, positionalRandomFactory, Noises.C);
        this.M = Noises.a(noiseRegistry, positionalRandomFactory, Noises.D);
        this.P = Noises.a(noiseRegistry, positionalRandomFactory, bl ? Noises.g : Noises.c);
        this.Q = Noises.a(noiseRegistry, positionalRandomFactory, bl ? Noises.h : Noises.d);
        this.R = Noises.a(noiseRegistry, positionalRandomFactory, Noises.i);
        this.U = NoiseSampler.a(Noises.a(noiseRegistry, positionalRandomFactory, Noises.E), j2, k2, 0, 1.5);
        this.V = NoiseSampler.a(Noises.a(noiseRegistry, positionalRandomFactory, Noises.F), j2, k2, 0, 4.0);
        this.W = NoiseSampler.a(Noises.a(noiseRegistry, positionalRandomFactory, Noises.G), j2, k2, 0, 4.0);
        this.T = Noises.a(noiseRegistry, positionalRandomFactory, Noises.H);
        this.X = NoiseSampler.a(Noises.a(noiseRegistry, positionalRandomFactory, Noises.I), l2, m2, -1, 1.0);
        this.Y = NoiseSampler.a(Noises.a(noiseRegistry, positionalRandomFactory, Noises.J), l2, m2, 0, 1.0);
        this.Z = NoiseSampler.a(Noises.a(noiseRegistry, positionalRandomFactory, Noises.K), l2, m2, 0, 2.6666666666666665);
        this.aa = NoiseSampler.a(Noises.a(noiseRegistry, positionalRandomFactory, Noises.L), l2, m2, 0, 2.6666666666666665);
        this.s = Noises.a(noiseRegistry, positionalRandomFactory, Noises.M);
    }

    private static NoiseChunk.b a(NoiseGeneratorNormal noiseSampler, int minY, int maxY, int alternative, double scale) {
        NoiseChunk.c noiseFiller = (x2, y2, z2) -> {
            if (y2 > maxY || y2 < minY) {
                return alternative;
            }
            return noiseSampler.a((double)x2 * scale, (double)y2 * scale, (double)z2 * scale);
        };
        return chunkNoiseSampler -> chunkNoiseSampler.a(noiseFiller);
    }

    private double a(int x2, int y2, int z2, TerrainInfo point, Blender blender) {
        double d2 = this.q.calculateNoise(x2, y2, z2);
        boolean bl = !this.o;
        return this.a(x2, y2, z2, point, d2, bl, true, blender);
    }

    private double a(int x2, int y2, int z2, TerrainInfo point, double noise, boolean hasNoNoiseCaves, boolean bl, Blender blender) {
        double ag;
        double af;
        double ad;
        double g2;
        if (this.r != null) {
            double d2 = ((double)WorldChunkManagerTheEnd.a(this.r, x2 / 8, z2 / 8) - 8.0) / 128.0;
        } else {
            double e2 = bl ? this.d(point.c(), (double)x2, (double)z2) : 0.0;
            double f2 = (this.a(y2, point) + e2) * point.b();
            g2 = f2 * (double)(f2 > 0.0 ? 4 : 1);
        }
        void h2 = g2 + noise;
        double i2 = 1.5625;
        if (hasNoNoiseCaves || h2 < -64.0) {
            void j2 = h2;
            double k2 = 64.0;
            double l2 = -64.0;
        } else {
            void m2 = h2 - 1.5625;
            boolean bl2 = m2 < 0.0;
            double n2 = this.b(x2, y2, z2);
            double o2 = this.g(x2, y2, z2);
            double p2 = this.e(x2, y2, z2);
            double q2 = Math.min(n2, p2 + o2);
            if (bl2) {
                void r2 = h2;
                double s2 = q2 * 5.0;
                double t2 = -64.0;
            } else {
                double u2 = this.d(x2, y2, z2);
                if (u2 > 64.0) {
                    double v2 = 64.0;
                } else {
                    double w2 = this.M.a(x2, (double)y2 / 1.5, z2);
                    double aa2 = MathHelper.a(w2 + 0.27, -1.0, 1.0);
                    void ab = m2 * 1.28;
                    double ac = aa2 + MathHelper.b(0.5, 0.0, (double)ab);
                    ad = ac + u2;
                }
                double ae = this.f(x2, y2, z2);
                af = Math.min(q2, ae + o2);
                ag = this.c(x2, y2, z2);
            }
        }
        double ah = Math.max(Math.min(ad, af), ag);
        ah = this.a(ah, y2 / this.n.d());
        ah = blender.a(x2, y2, z2, ah);
        ah = MathHelper.a(ah, -64.0, 64.0);
        return ah;
    }

    private double d(double d2, double e2, double f2) {
        if (d2 == 0.0) {
            return 0.0;
        }
        float g2 = 1500.0f;
        double h2 = this.s.a(e2 * 1500.0, 0.0, f2 * 1500.0);
        return h2 > 0.0 ? d2 * h2 : d2 / 2.0 * h2;
    }

    private double a(int i2, TerrainInfo terrainInfo) {
        double d2 = 1.0 - (double)i2 / 128.0;
        return d2 + terrainInfo.a();
    }

    private double a(double noise, int y2) {
        int i2 = y2 - this.n.g();
        noise = this.n.k().a(noise, this.n.f() - i2);
        noise = this.n.l().a(noise, i2);
        return noise;
    }

    protected NoiseChunk.a a(NoiseChunk chunkNoiseSampler, NoiseChunk.c columnSampler, boolean hasNoodleCaves) {
        NoiseChunk.e sampler = this.p.instantiate(chunkNoiseSampler);
        NoiseChunk.e sampler2 = hasNoodleCaves ? this.X.instantiate(chunkNoiseSampler) : () -> -1.0;
        NoiseChunk.e sampler3 = hasNoodleCaves ? this.Y.instantiate(chunkNoiseSampler) : () -> 0.0;
        NoiseChunk.e sampler4 = hasNoodleCaves ? this.Z.instantiate(chunkNoiseSampler) : () -> 0.0;
        NoiseChunk.e sampler5 = hasNoodleCaves ? this.aa.instantiate(chunkNoiseSampler) : () -> 0.0;
        return (x2, y2, z2) -> {
            double d2;
            double e2 = d2 = sampler.sample();
            e2 = MathHelper.a(e2 * 0.64, -1.0, 1.0);
            e2 = e2 / 2.0 - e2 * e2 * e2 / 24.0;
            if (sampler2.sample() >= 0.0) {
                double f2 = 0.05;
                double g2 = 0.1;
                double h2 = MathHelper.a(sampler3.sample(), -1.0, 1.0, 0.05, 0.1);
                double i2 = Math.abs(1.5 * sampler4.sample()) - h2;
                double j2 = Math.abs(1.5 * sampler5.sample()) - h2;
                e2 = Math.min(e2, Math.max(i2, j2));
            }
            return chunkNoiseSampler.d().a(x2, y2, z2, d2, e2 += columnSampler.calculateNoise(x2, y2, z2));
        };
    }

    protected NoiseChunk.a a(NoiseChunk chunkNoiseSampler, boolean hasOreVeins) {
        if (!hasOreVeins) {
            return (x2, y2, z2) -> null;
        }
        NoiseChunk.e sampler = this.U.instantiate(chunkNoiseSampler);
        NoiseChunk.e sampler2 = this.V.instantiate(chunkNoiseSampler);
        NoiseChunk.e sampler3 = this.W.instantiate(chunkNoiseSampler);
        IBlockData blockState = null;
        return (x2, y2, z2) -> {
            RandomSource randomSource = this.ac.a(x2, y2, z2);
            double d2 = sampler.sample();
            c veinType = this.b(d2, y2);
            if (veinType == null) {
                return blockState;
            }
            if (randomSource.nextFloat() > 0.7f) {
                return blockState;
            }
            if (this.a(sampler2.sample(), sampler3.sample())) {
                double e2 = MathHelper.a(Math.abs(d2), (double)0.4f, (double)0.6f, (double)0.1f, (double)0.3f);
                if ((double)randomSource.nextFloat() < e2 && this.T.a(x2, y2, z2) > (double)-0.3f) {
                    return randomSource.nextFloat() < 0.02f ? veinType.d : veinType.c;
                }
                return veinType.e;
            }
            return blockState;
        };
    }

    protected int a(int x2, int z2, TerrainInfo point) {
        for (int i2 = this.n.g() + this.n.f(); i2 >= this.n.g(); --i2) {
            int j2 = i2 * this.n.d();
            double d2 = -0.703125;
            double e2 = this.a(x2, j2, z2, point, -0.703125, true, false, Blender.a());
            if (!(e2 > 0.390625)) continue;
            return j2;
        }
        return Integer.MAX_VALUE;
    }

    protected Aquifer a(NoiseChunk chunkNoiseSampler, int x2, int z2, int minimumY, int height, Aquifer.a fluidLevelSampler, boolean hasAquifers) {
        if (!hasAquifers) {
            return Aquifer.a(fluidLevelSampler);
        }
        int i2 = SectionPosition.a(x2);
        int j2 = SectionPosition.a(z2);
        return Aquifer.a(chunkNoiseSampler, new ChunkCoordIntPair(i2, j2), this.t, this.u, this.v, this.w, this.ab, minimumY * this.n.d(), height * this.n.d(), fluidLevelSampler);
    }

    @VisibleForDebug
    public a a(int i2, int j2, Blender blender) {
        double d2 = (double)i2 + this.a(i2, 0, j2);
        double e2 = (double)j2 + this.a(j2, i2, 0);
        double f2 = this.a(d2, 0.0, e2);
        double g2 = this.c(d2, 0.0, e2);
        double h2 = this.b(d2, 0.0, e2);
        TerrainInfo terrainInfo = this.a(QuartPos.c(i2), QuartPos.c(j2), (float)f2, (float)g2, (float)h2, blender);
        return new a(d2, e2, f2, g2, h2, terrainInfo);
    }

    @Override
    @Override
    public Climate.h sample(int x2, int y2, int z2) {
        return this.a(x2, y2, z2, this.a(x2, z2, Blender.a()));
    }

    @VisibleForDebug
    public Climate.h a(int i2, int j2, int k2, a flatNoiseData) {
        double d2 = flatNoiseData.a();
        double e2 = (double)j2 + this.a(j2, k2, i2);
        double f2 = flatNoiseData.b();
        double g2 = this.a(QuartPos.c(j2), flatNoiseData.f());
        return Climate.a((float)this.e(d2, e2, f2), (float)this.f(d2, e2, f2), (float)flatNoiseData.c(), (float)flatNoiseData.e(), (float)g2, (float)flatNoiseData.d());
    }

    public TerrainInfo a(int x2, int z2, float continentalness, float weirdness, float erosion, Blender blender) {
        TerrainShaper terrainShaper = this.n.o();
        TerrainShaper.b point = terrainShaper.a(continentalness, erosion, weirdness);
        float f2 = terrainShaper.a(point);
        float g2 = terrainShaper.b(point);
        float h2 = terrainShaper.c(point);
        TerrainInfo terrainInfo = new TerrainInfo(f2, g2, h2);
        return blender.a(x2, z2, terrainInfo);
    }

    @Override
    @Override
    public BlockPosition a() {
        return Climate.a(this.ae, this);
    }

    @VisibleForDebug
    public double a(int x2, int y2, int z2) {
        return this.S.a(x2, y2, z2) * 4.0;
    }

    private double e(double x2, double y2, double z2) {
        return this.N.a(x2, 0.0, z2);
    }

    private double f(double x2, double y2, double z2) {
        return this.O.a(x2, 0.0, z2);
    }

    @VisibleForDebug
    public double a(double x2, double y2, double z2) {
        if (SharedConstants.ai) {
            double d2;
            if (SharedConstants.a(new ChunkCoordIntPair(QuartPos.e(MathHelper.b(x2)), QuartPos.e(MathHelper.b(z2))))) {
                return -1.0;
            }
            return d2 * d2 * (double)((d2 = MathHelper.g(x2 / 2048.0) * 2.0 - 1.0) < 0.0 ? -1 : 1);
        }
        if (SharedConstants.aj) {
            double e2 = x2 * 0.005;
            return Math.sin(e2 + 0.5 * Math.sin(e2));
        }
        return this.P.a(x2, y2, z2);
    }

    @VisibleForDebug
    public double b(double x2, double y2, double z2) {
        if (SharedConstants.ai) {
            double d2;
            if (SharedConstants.a(new ChunkCoordIntPair(QuartPos.e(MathHelper.b(x2)), QuartPos.e(MathHelper.b(z2))))) {
                return -1.0;
            }
            return d2 * d2 * (double)((d2 = MathHelper.g(z2 / 256.0) * 2.0 - 1.0) < 0.0 ? -1 : 1);
        }
        if (SharedConstants.aj) {
            double e2 = z2 * 0.005;
            return Math.sin(e2 + 0.5 * Math.sin(e2));
        }
        return this.Q.a(x2, y2, z2);
    }

    @VisibleForDebug
    public double c(double x2, double y2, double z2) {
        return this.R.a(x2, y2, z2);
    }

    private double b(int x2, int y2, int z2) {
        double d2 = 0.75;
        double e2 = 0.5;
        double f2 = 0.37;
        double g2 = this.L.a((double)x2 * 0.75, (double)y2 * 0.5, (double)z2 * 0.75) + 0.37;
        int i2 = -10;
        double h2 = (double)(y2 - -10) / 40.0;
        double j2 = 0.3;
        return g2 + MathHelper.b(0.3, 0.0, h2);
    }

    private double c(int x2, int y2, int z2) {
        double d2 = 0.0;
        double e2 = 2.0;
        double f2 = NoiseUtils.a(this.z, x2, y2, z2, 0.0, 2.0);
        double g2 = 0.0;
        double h2 = 1.1;
        double i2 = NoiseUtils.a(this.A, x2, y2, z2, 0.0, 1.1);
        i2 = Math.pow(i2, 3.0);
        double j2 = 25.0;
        double k2 = 0.3;
        double l2 = this.y.a((double)x2 * 25.0, (double)y2 * 0.3, (double)z2 * 25.0);
        if ((l2 = i2 * (l2 * 2.0 - f2)) > 0.03) {
            return l2;
        }
        return Double.NEGATIVE_INFINITY;
    }

    private double d(int x2, int y2, int z2) {
        double d2 = this.x.a(x2, y2 * 8, z2);
        return MathHelper.m(d2) * 4.0;
    }

    private double e(int x2, int y2, int z2) {
        double d2 = this.H.a(x2 * 2, y2, z2 * 2);
        double e2 = net.minecraft.world.level.levelgen.NoiseSampler$b.b(d2);
        double f2 = 0.065;
        double g2 = 0.088;
        double h2 = NoiseUtils.a(this.I, x2, y2, z2, 0.065, 0.088);
        double i2 = NoiseSampler.a(this.F, (double)x2, (double)y2, (double)z2, e2);
        double j2 = Math.abs(e2 * i2) - h2;
        double k2 = NoiseSampler.a(this.G, (double)x2, (double)y2, (double)z2, e2);
        double l2 = Math.abs(e2 * k2) - h2;
        return NoiseSampler.a(Math.max(j2, l2));
    }

    private double f(int x2, int y2, int z2) {
        double d2 = this.D.a(x2 * 2, y2, z2 * 2);
        double e2 = net.minecraft.world.level.levelgen.NoiseSampler$b.a(d2);
        double f2 = 0.6;
        double g2 = 1.3;
        double h2 = NoiseUtils.a(this.E, x2 * 2, y2, z2 * 2, 0.6, 1.3);
        double i2 = NoiseSampler.a(this.B, (double)x2, (double)y2, (double)z2, e2);
        double j2 = 0.083;
        double k2 = Math.abs(e2 * i2) - 0.083 * h2;
        int l2 = this.n.g();
        int m2 = 8;
        double n2 = NoiseUtils.a(this.C, x2, 0.0, z2, l2, 8.0);
        double o2 = Math.abs(n2 - (double)y2 / 8.0) - 1.0 * h2;
        o2 = o2 * o2 * o2;
        return NoiseSampler.a(Math.max(o2, k2));
    }

    private double g(int x2, int y2, int z2) {
        double d2 = NoiseUtils.a(this.K, x2, y2, z2, 0.0, 0.1);
        return (0.4 - Math.abs(this.J.a(x2, y2, z2))) * d2;
    }

    public PositionalRandomFactory b() {
        return this.ad;
    }

    private static double a(double value) {
        return MathHelper.a(value, -1.0, 1.0);
    }

    private static double a(NoiseGeneratorNormal sampler, double x2, double y2, double z2, double invertedScale) {
        return sampler.a(x2 / invertedScale, y2 / invertedScale, z2 / invertedScale);
    }

    private boolean a(double firstOrePlacementNoise, double secondOrePlacementNoise) {
        double e2;
        double d2 = Math.abs(1.0 * firstOrePlacementNoise) - (double)0.08f;
        return Math.max(d2, e2 = Math.abs(1.0 * secondOrePlacementNoise) - (double)0.08f) < 0.0;
    }

    @Nullable
    private c b(double oreFrequencyNoise, int y2) {
        c veinType = oreFrequencyNoise > 0.0 ? net.minecraft.world.level.levelgen.NoiseSampler$c.a : net.minecraft.world.level.levelgen.NoiseSampler$c.b;
        int i2 = veinType.g - y2;
        int j2 = y2 - veinType.f;
        if (j2 < 0 || i2 < 0) {
            return null;
        }
        int k2 = Math.min(i2, j2);
        double d2 = MathHelper.a((double)k2, 0.0, 20.0, -0.2, 0.0);
        if (Math.abs(oreFrequencyNoise) + d2 < (double)0.4f) {
            return null;
        }
        return veinType;
    }

    static final class c
    extends Enum<c> {
        public static final /* enum */ c a = new c(Blocks.oU.n(), Blocks.qk.n(), Blocks.c.n(), 0, 50);
        public static final /* enum */ c b = new c(Blocks.I.n(), Blocks.qj.n(), Blocks.oL.n(), -60, -8);
        final IBlockData c;
        final IBlockData d;
        final IBlockData e;
        final int f;
        final int g;
        private static final /* synthetic */ c[] h;

        public static c[] values() {
            return (c[])h.clone();
        }

        public static c valueOf(String string) {
            return Enum.valueOf(c.class, string);
        }

        private c(IBlockData ore, IBlockData rawBlock, IBlockData stone, int minY, int maxY) {
            this.c = ore;
            this.d = rawBlock;
            this.e = stone;
            this.f = minY;
            this.g = maxY;
        }

        private static /* synthetic */ c[] a() {
            return new c[]{a, b};
        }

        static {
            h = net.minecraft.world.level.levelgen.NoiseSampler$c.a();
        }
    }

    public record a(double a, double b, double c, double d, double e, TerrainInfo f) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "shiftedX;shiftedZ;continentalness;weirdness;erosion;terrainInfo", "a", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "shiftedX;shiftedZ;continentalness;weirdness;erosion;terrainInfo", "a", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "shiftedX;shiftedZ;continentalness;weirdness;erosion;terrainInfo", "a", "b", "c", "d", "e", "f"}, this, object);
        }
    }

    static final class b {
        private b() {
        }

        static double a(double value) {
            if (value < -0.75) {
                return 0.5;
            }
            if (value < -0.5) {
                return 0.75;
            }
            if (value < 0.5) {
                return 1.0;
            }
            if (value < 0.75) {
                return 2.0;
            }
            return 3.0;
        }

        static double b(double value) {
            if (value < -0.5) {
                return 0.75;
            }
            if (value < 0.0) {
                return 1.0;
            }
            if (value < 0.5) {
                return 1.5;
            }
            return 2.0;
        }
    }
}

