/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ThreadingDetector;
import net.minecraft.world.level.levelgen.BitRandomSource;
import net.minecraft.world.level.levelgen.MarsagliaPolarGaussian;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;

public class LegacyRandomSource
implements BitRandomSource {
    private static final int c = 48;
    private static final long d = 0xFFFFFFFFFFFFL;
    private static final long e = 25214903917L;
    private static final long f = 11L;
    private final AtomicLong g = new AtomicLong();
    private final MarsagliaPolarGaussian h = new MarsagliaPolarGaussian(this);

    public LegacyRandomSource(long seed) {
        this.setSeed(seed);
    }

    @Override
    @Override
    public RandomSource a() {
        return new LegacyRandomSource(this.nextLong());
    }

    @Override
    @Override
    public PositionalRandomFactory b() {
        return new a(this.nextLong());
    }

    @Override
    @Override
    public void setSeed(long seed) {
        if (!this.g.compareAndSet(this.g.get(), (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL)) {
            throw ThreadingDetector.a("LegacyRandomSource", null);
        }
        this.h.a();
    }

    @Override
    @Override
    public int a(int bits) {
        long m2;
        long l2 = this.g.get();
        if (!this.g.compareAndSet(l2, m2 = l2 * 25214903917L + 11L & 0xFFFFFFFFFFFFL)) {
            throw ThreadingDetector.a("LegacyRandomSource", null);
        }
        return (int)(m2 >> 48 - bits);
    }

    @Override
    @Override
    public double nextGaussian() {
        return this.h.b();
    }

    public static class a
    implements PositionalRandomFactory {
        private final long a;

        public a(long seed) {
            this.a = seed;
        }

        @Override
        @Override
        public RandomSource a(int x2, int y2, int z2) {
            long l2 = MathHelper.c(x2, y2, z2);
            long m2 = l2 ^ this.a;
            return new LegacyRandomSource(m2);
        }

        @Override
        @Override
        public RandomSource a(String string) {
            int i2 = string.hashCode();
            return new LegacyRandomSource((long)i2 ^ this.a);
        }

        @Override
        @VisibleForTesting
        @Override
        public void a(StringBuilder info) {
            info.append("LegacyPositionalRandomFactory{").append(this.a).append("}");
        }
    }
}

