/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.DataBits;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeightMap {
    private static final Logger a = LogManager.getLogger();
    static final Predicate<IBlockData> b = state -> !state.g();
    static final Predicate<IBlockData> c = state -> state.c().c();
    private final DataBits d;
    private final Predicate<IBlockData> e;
    private final IChunkAccess f;

    public HeightMap(IChunkAccess chunk, Type type) {
        this.e = type.e();
        this.f = chunk;
        int i2 = MathHelper.e(chunk.v_() + 1);
        this.d = new SimpleBitStorage(i2, 256);
    }

    public static void a(IChunkAccess chunk, Set<Type> types) {
        int i2 = types.size();
        ObjectArrayList objectList = new ObjectArrayList(i2);
        ObjectListIterator objectListIterator = objectList.iterator();
        int j2 = chunk.b() + 16;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int k2 = 0; k2 < 16; ++k2) {
            block1: for (int l2 = 0; l2 < 16; ++l2) {
                for (Type types2 : types) {
                    objectList.add((Object)chunk.a(types2));
                }
                for (int m2 = j2 - 1; m2 >= chunk.u_(); --m2) {
                    mutableBlockPos.d(k2, m2, l2);
                    IBlockData blockState = chunk.a_(mutableBlockPos);
                    if (blockState.a(Blocks.a)) continue;
                    while (objectListIterator.hasNext()) {
                        HeightMap heightmap = (HeightMap)objectListIterator.next();
                        if (!heightmap.e.test(blockState)) continue;
                        heightmap.a(k2, l2, m2 + 1);
                        objectListIterator.remove();
                    }
                    if (objectList.isEmpty()) continue block1;
                    objectListIterator.back(i2);
                }
            }
        }
    }

    public boolean a(int x2, int y2, int z2, IBlockData state) {
        int i2 = this.a(x2, z2);
        if (y2 <= i2 - 2) {
            return false;
        }
        if (this.e.test(state)) {
            if (y2 >= i2) {
                this.a(x2, z2, y2 + 1);
                return true;
            }
        } else if (i2 - 1 == y2) {
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            for (int j2 = y2 - 1; j2 >= this.f.u_(); --j2) {
                mutableBlockPos.d(x2, j2, z2);
                if (!this.e.test(this.f.a_(mutableBlockPos))) continue;
                this.a(x2, z2, j2 + 1);
                return true;
            }
            this.a(x2, z2, this.f.u_());
            return true;
        }
        return false;
    }

    public int a(int x2, int z2) {
        return this.a(HeightMap.c(x2, z2));
    }

    public int b(int i2, int j2) {
        return this.a(HeightMap.c(i2, j2)) - 1;
    }

    private int a(int index) {
        return this.d.a(index) + this.f.u_();
    }

    private void a(int x2, int z2, int height) {
        this.d.b(HeightMap.c(x2, z2), height - this.f.u_());
    }

    public void a(IChunkAccess chunk, Type type, long[] ls) {
        long[] ms = this.d.a();
        if (ms.length == ls.length) {
            System.arraycopy(ls, 0, ms, 0, ls.length);
            return;
        }
        a.warn("Ignoring heightmap data for chunk " + chunk.f() + ", size does not match; expected: " + ms.length + ", got: " + ls.length);
        HeightMap.a(chunk, EnumSet.of(type));
    }

    public long[] a() {
        return this.d.a();
    }

    private static int c(int x2, int z2) {
        return x2 + z2 * 16;
    }

    public static final class Type
    extends Enum<Type>
    implements INamable {
        public static final /* enum */ Type a = new Type("WORLD_SURFACE_WG", Use.a, b);
        public static final /* enum */ Type b = new Type("WORLD_SURFACE", Use.c, b);
        public static final /* enum */ Type c = new Type("OCEAN_FLOOR_WG", Use.a, c);
        public static final /* enum */ Type d = new Type("OCEAN_FLOOR", Use.b, c);
        public static final /* enum */ Type e = new Type("MOTION_BLOCKING", Use.c, state -> state.c().c() || !state.n().c());
        public static final /* enum */ Type f = new Type("MOTION_BLOCKING_NO_LEAVES", Use.b, state -> (state.c().c() || !state.n().c()) && !(state.b() instanceof BlockLeaves));
        public static final Codec<Type> g;
        private final String h;
        private final Use i;
        private final Predicate<IBlockData> j;
        private static final Map<String, Type> k;
        private static final /* synthetic */ Type[] l;

        public static Type[] values() {
            return (Type[])l.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }

        private Type(String name, Use purpose, Predicate<IBlockData> blockPredicate) {
            this.h = name;
            this.i = purpose;
            this.j = blockPredicate;
        }

        public String a() {
            return this.h;
        }

        public boolean b() {
            return this.i == Use.c;
        }

        public boolean d() {
            return this.i != Use.a;
        }

        @Nullable
        public static Type a(String name) {
            return k.get(name);
        }

        public Predicate<IBlockData> e() {
            return this.j;
        }

        @Override
        @Override
        public String c() {
            return this.h;
        }

        private static /* synthetic */ Type[] f() {
            return new Type[]{a, b, c, d, e, f};
        }

        static {
            l = Type.f();
            g = INamable.a(Type::values, Type::a);
            k = SystemUtils.a(Maps.newHashMap(), (T hashMap) -> {
                for (Type types : Type.values()) {
                    hashMap.put(types.h, types);
                }
            });
        }
    }

    public static final class Use
    extends Enum<Use> {
        public static final /* enum */ Use a = new Use();
        public static final /* enum */ Use b = new Use();
        public static final /* enum */ Use c = new Use();
        private static final /* synthetic */ Use[] d;

        public static Use[] values() {
            return (Use[])d.clone();
        }

        public static Use valueOf(String string) {
            return Enum.valueOf(Use.class, string);
        }

        private static /* synthetic */ Use[] a() {
            return new Use[]{a, b, c};
        }

        static {
            d = Use.a();
        }
    }
}

