/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.resources.RegistryReadOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.biome.WorldChunkManagerMultiNoise;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderDebug;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.flat.GeneratorSettingsFlat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GeneratorSettings {
    public static final Codec<GeneratorSettings> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(GeneratorSettings::a), (App)Codec.BOOL.fieldOf("generate_features").orElse((Object)true).stable().forGetter(GeneratorSettings::b), (App)Codec.BOOL.fieldOf("bonus_chest").orElse((Object)false).stable().forGetter(GeneratorSettings::c), (App)RegistryMaterials.b(IRegistry.S, Lifecycle.stable(), WorldDimension.a).xmap(WorldDimension::a, Function.identity()).fieldOf("dimensions").forGetter(GeneratorSettings::d), (App)Codec.STRING.optionalFieldOf("legacy_custom_options").stable().forGetter(generatorsettings -> generatorsettings.g)).apply((Applicative)instance, instance.stable(GeneratorSettings::new))).comapFlatMap(GeneratorSettings::m, Function.identity());
    private static final Logger b = LogManager.getLogger();
    private final long c;
    private final boolean d;
    private final boolean e;
    private final RegistryMaterials<WorldDimension> f;
    private final Optional<String> g;

    private DataResult<GeneratorSettings> m() {
        WorldDimension worlddimension = this.f.a(WorldDimension.b);
        return worlddimension == null ? DataResult.error((String)"Overworld settings missing") : (this.n() ? DataResult.success((Object)this, (Lifecycle)Lifecycle.stable()) : DataResult.success((Object)this));
    }

    private boolean n() {
        return WorldDimension.a(this.c, this.f);
    }

    public GeneratorSettings(long seed, boolean generateStructures, boolean bonusChest, RegistryMaterials<WorldDimension> options) {
        this(seed, generateStructures, bonusChest, options, Optional.empty());
        WorldDimension worlddimension = options.a(WorldDimension.b);
        if (worlddimension == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
    }

    private GeneratorSettings(long seed, boolean generateStructures, boolean bonusChest, RegistryMaterials<WorldDimension> options, Optional<String> legacyCustomOptions) {
        this.c = seed;
        this.d = generateStructures;
        this.e = bonusChest;
        this.f = options;
        this.g = legacyCustomOptions;
    }

    public static GeneratorSettings a(IRegistryCustom registryManager) {
        int i2 = "North Carolina".hashCode();
        return new GeneratorSettings(i2, true, true, GeneratorSettings.a(registryManager.d(IRegistry.Q), DimensionManager.a(registryManager, i2), (ChunkGenerator)GeneratorSettings.a(registryManager, i2)));
    }

    public static GeneratorSettings b(IRegistryCustom registryManager) {
        long i2 = new Random().nextLong();
        return new GeneratorSettings(i2, true, false, GeneratorSettings.a(registryManager.d(IRegistry.Q), DimensionManager.a(registryManager, i2), (ChunkGenerator)GeneratorSettings.a(registryManager, i2)));
    }

    public static ChunkGeneratorAbstract a(IRegistryCustom registryManager, long seed) {
        return GeneratorSettings.a(registryManager, seed, true);
    }

    public static ChunkGeneratorAbstract a(IRegistryCustom registryManager, long seed, boolean flag) {
        return GeneratorSettings.a(registryManager, seed, GeneratorSettingBase.c, flag);
    }

    public static ChunkGeneratorAbstract a(IRegistryCustom registryManager, long seed, ResourceKey<GeneratorSettingBase> settings) {
        return GeneratorSettings.a(registryManager, seed, settings, true);
    }

    public static ChunkGeneratorAbstract a(IRegistryCustom registryManager, long seed, ResourceKey<GeneratorSettingBase> settings, boolean flag) {
        return new ChunkGeneratorAbstract(registryManager.d(IRegistry.aS), (WorldChunkManager)WorldChunkManagerMultiNoise.a.b.a(registryManager.d(IRegistry.aR), flag), seed, () -> registryManager.d(IRegistry.aK).d(settings));
    }

    public long a() {
        return this.c;
    }

    public boolean b() {
        return this.d;
    }

    public boolean c() {
        return this.e;
    }

    public static RegistryMaterials<WorldDimension> a(IRegistry<DimensionManager> dimensionTypeRegistry, RegistryMaterials<WorldDimension> optionsRegistry, ChunkGenerator overworldGenerator) {
        WorldDimension worlddimension = optionsRegistry.a(WorldDimension.b);
        Supplier<DimensionManager> supplier = () -> worlddimension == null ? dimensionTypeRegistry.d(DimensionManager.m) : worlddimension.b();
        return GeneratorSettings.a(optionsRegistry, supplier, overworldGenerator);
    }

    public static RegistryMaterials<WorldDimension> a(RegistryMaterials<WorldDimension> optionsRegistry, Supplier<DimensionManager> overworldDimensionType, ChunkGenerator overworldGenerator) {
        RegistryMaterials<WorldDimension> registrymaterials1 = new RegistryMaterials<WorldDimension>(IRegistry.S, Lifecycle.experimental());
        registrymaterials1.a(WorldDimension.b, new WorldDimension(overworldDimensionType, overworldGenerator), Lifecycle.stable());
        for (Map.Entry<ResourceKey<WorldDimension>, WorldDimension> entry : optionsRegistry.e()) {
            ResourceKey<WorldDimension> resourcekey = entry.getKey();
            if (resourcekey == WorldDimension.b) continue;
            registrymaterials1.a(resourcekey, entry.getValue(), optionsRegistry.d(entry.getValue()));
        }
        return registrymaterials1;
    }

    public RegistryMaterials<WorldDimension> d() {
        return this.f;
    }

    public ChunkGenerator e() {
        WorldDimension worlddimension = this.f.a(WorldDimension.b);
        if (worlddimension == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
        return worlddimension.c();
    }

    public ImmutableSet<ResourceKey<World>> f() {
        return (ImmutableSet)this.d().e().stream().map(Map.Entry::getKey).map(GeneratorSettings::a).collect(ImmutableSet.toImmutableSet());
    }

    public static ResourceKey<World> a(ResourceKey<WorldDimension> dimensionOptionsKey) {
        return ResourceKey.a(IRegistry.R, dimensionOptionsKey.a());
    }

    public static ResourceKey<WorldDimension> b(ResourceKey<World> worldKey) {
        return ResourceKey.a(IRegistry.S, worldKey.a());
    }

    public boolean g() {
        return this.e() instanceof ChunkProviderDebug;
    }

    public boolean h() {
        return this.e() instanceof ChunkProviderFlat;
    }

    public boolean i() {
        return this.g.isPresent();
    }

    public GeneratorSettings j() {
        return new GeneratorSettings(this.c, this.d, true, this.f, this.g);
    }

    public GeneratorSettings k() {
        return new GeneratorSettings(this.c, !this.d, this.e, this.f);
    }

    public GeneratorSettings l() {
        return new GeneratorSettings(this.c, this.d, !this.e, this.f);
    }

    public static GeneratorSettings a(IRegistryCustom registryManager, Properties properties) {
        String s2 = (String)MoreObjects.firstNonNull((Object)((String)properties.get("generator-settings")), (Object)"");
        properties.put("generator-settings", s2);
        String s1 = (String)MoreObjects.firstNonNull((Object)((String)properties.get("level-seed")), (Object)"");
        properties.put("level-seed", s1);
        String s22 = (String)properties.get("generate-structures");
        boolean flag = s22 == null || Boolean.parseBoolean(s22);
        properties.put("generate-structures", Objects.toString(flag));
        String s3 = (String)properties.get("level-type");
        String s4 = Optional.ofNullable(s3).map(s5 -> s5.toLowerCase(Locale.ROOT)).orElse("default");
        properties.put("level-type", s4);
        long i2 = new Random().nextLong();
        if (!s1.isEmpty()) {
            try {
                long j2 = Long.parseLong(s1);
                if (j2 != 0L) {
                    i2 = j2;
                }
            }
            catch (NumberFormatException numberformatexception) {
                i2 = s1.hashCode();
            }
        }
        IRegistry<DimensionManager> iregistry = registryManager.d(IRegistry.Q);
        IRegistry<BiomeBase> iregistry1 = registryManager.d(IRegistry.aR);
        RegistryMaterials<WorldDimension> registrymaterials = DimensionManager.a(registryManager, i2);
        int b0 = -1;
        switch (s4.hashCode()) {
            case -1100099890: {
                if (!s4.equals("largebiomes")) break;
                b0 = 3;
                break;
            }
            case 3145593: {
                if (!s4.equals("flat")) break;
                b0 = 0;
                break;
            }
            case 1045526590: {
                if (!s4.equals("debug_all_block_states")) break;
                b0 = 1;
                break;
            }
            case 1271599715: {
                if (!s4.equals("amplified")) break;
                b0 = 2;
            }
        }
        switch (b0) {
            case 0: {
                JsonObject jsonobject = !s2.isEmpty() ? ChatDeserializer.a(s2) : new JsonObject();
                Dynamic<JsonObject> dynamic = new Dynamic<JsonObject>(RegistryReadOps.a(JsonOps.INSTANCE, IResourceManager.Empty.a, (IRegistryCustom)((IRegistryCustom.Dimension)registryManager)), jsonobject);
                DataResult dataresult = GeneratorSettingsFlat.a.parse(dynamic);
                Logger logger = b;
                Objects.requireNonNull(logger);
                return new GeneratorSettings(i2, flag, false, GeneratorSettings.a(iregistry, registrymaterials, (ChunkGenerator)new ChunkProviderFlat((GeneratorSettingsFlat)dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElseGet(() -> GeneratorSettingsFlat.a(iregistry1)))));
            }
            case 1: {
                return new GeneratorSettings(i2, flag, false, GeneratorSettings.a(iregistry, registrymaterials, (ChunkGenerator)new ChunkProviderDebug(iregistry1)));
            }
            case 2: {
                return new GeneratorSettings(i2, flag, false, GeneratorSettings.a(iregistry, registrymaterials, (ChunkGenerator)GeneratorSettings.a(registryManager, i2, GeneratorSettingBase.e)));
            }
            case 3: {
                return new GeneratorSettings(i2, flag, false, GeneratorSettings.a(iregistry, registrymaterials, (ChunkGenerator)GeneratorSettings.a(registryManager, i2, GeneratorSettingBase.d)));
            }
        }
        return new GeneratorSettings(i2, flag, false, GeneratorSettings.a(iregistry, registrymaterials, (ChunkGenerator)GeneratorSettings.a(registryManager, i2)));
    }

    public GeneratorSettings a(boolean hardcore, OptionalLong seed) {
        RegistryMaterials<WorldDimension> registrymaterials;
        long i2 = seed.orElse(this.c);
        if (seed.isPresent()) {
            registrymaterials = new RegistryMaterials<WorldDimension>(IRegistry.S, Lifecycle.experimental());
            long j2 = seed.getAsLong();
            for (Map.Entry<ResourceKey<WorldDimension>, WorldDimension> entry : this.f.e()) {
                ResourceKey<WorldDimension> resourcekey = entry.getKey();
                registrymaterials.a(resourcekey, new WorldDimension(entry.getValue().a(), entry.getValue().c().a(j2)), this.f.d(entry.getValue()));
            }
        } else {
            registrymaterials = this.f;
        }
        GeneratorSettings generatorsettings = this.g() ? new GeneratorSettings(i2, false, false, registrymaterials) : new GeneratorSettings(i2, this.b(), this.c() && !hardcore, registrymaterials);
        return generatorsettings;
    }
}

