/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.RegistryLookupCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.util.MathHelper;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseSampler;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeaturePillagerOutpost;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureSwampHut;
import net.minecraft.world.level.levelgen.feature.WorldGenMonument;
import net.minecraft.world.level.levelgen.feature.WorldGenNether;
import net.minecraft.world.level.levelgen.material.MaterialRuleList;
import net.minecraft.world.level.levelgen.material.WorldGenMaterialRule;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;

public final class ChunkGeneratorAbstract
extends ChunkGenerator {
    public static final Codec<ChunkGeneratorAbstract> d = RecordCodecBuilder.create(instance -> instance.group((App)RegistryLookupCodec.a(IRegistry.aS).forGetter(chunkgeneratorabstract -> chunkgeneratorabstract.i), (App)WorldChunkManager.a.fieldOf("biome_source").forGetter(chunkgeneratorabstract -> chunkgeneratorabstract.b), (App)Codec.LONG.fieldOf("seed").stable().forGetter(chunkgeneratorabstract -> chunkgeneratorabstract.j), (App)GeneratorSettingBase.b.fieldOf("settings").forGetter(chunkgeneratorabstract -> chunkgeneratorabstract.f)).apply((Applicative)instance, instance.stable(ChunkGeneratorAbstract::new)));
    private static final IBlockData g = Blocks.a.n();
    private static final IBlockData[] h = new IBlockData[0];
    protected final IBlockData e;
    public final IRegistry<NoiseGeneratorNormal.a> i;
    private final long j;
    public final Supplier<GeneratorSettingBase> f;
    private final NoiseSampler k;
    private final SurfaceSystem l;
    private final WorldGenMaterialRule m;
    private final Aquifer.a n;

    public ChunkGeneratorAbstract(IRegistry<NoiseGeneratorNormal.a> noiseRegistry, WorldChunkManager biomeSource, long seed, Supplier<GeneratorSettingBase> settings) {
        this(noiseRegistry, biomeSource, biomeSource, seed, settings);
    }

    private ChunkGeneratorAbstract(IRegistry<NoiseGeneratorNormal.a> noiseRegistry, WorldChunkManager populationSource, WorldChunkManager biomeSource, long seed, Supplier<GeneratorSettingBase> settings) {
        super(populationSource, biomeSource, settings.get().a(), seed);
        this.i = noiseRegistry;
        this.j = seed;
        this.f = settings;
        GeneratorSettingBase generatorsettingbase = this.f.get();
        this.e = generatorsettingbase.c();
        NoiseSettings noisesettings = generatorsettingbase.b();
        this.k = new NoiseSampler(noisesettings, generatorsettingbase.i(), seed, noiseRegistry, generatorsettingbase.m());
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(NoiseChunk::a);
        builder.add(NoiseChunk::b);
        this.m = new MaterialRuleList((List<WorldGenMaterialRule>)builder.build());
        Aquifer.b aquifer_b = new Aquifer.b(-54, Blocks.B.n());
        int j2 = generatorsettingbase.f();
        Aquifer.b aquifer_b1 = new Aquifer.b(j2, generatorsettingbase.d());
        Aquifer.b aquifer_b2 = new Aquifer.b(noisesettings.h() - 1, Blocks.a.n());
        this.n = (k2, l2, i1) -> l2 < Math.min(-54, j2) ? aquifer_b : aquifer_b1;
        this.l = new SurfaceSystem(noiseRegistry, this.e, j2, seed, generatorsettingbase.m());
    }

    @Override
    public CompletableFuture<IChunkAccess> a(IRegistry<BiomeBase> biomeRegistry, Executor executor, Blender blender, StructureManager structureAccessor, IChunkAccess chunk) {
        return CompletableFuture.supplyAsync(SystemUtils.a("init_biomes", () -> {
            this.a(biomeRegistry, blender, structureAccessor, chunk);
            return chunk;
        }), SystemUtils.g());
    }

    private void a(IRegistry<BiomeBase> biomeRegistry, Blender blender, StructureManager structureAccessor, IChunkAccess chunk) {
        NoiseChunk noisechunk = chunk.a(this.k, () -> new Beardifier(structureAccessor, chunk), this.f.get(), this.n, blender);
        BiomeResolver biomeresolver = BelowZeroRetrogen.a(blender.a(this.c), biomeRegistry, chunk);
        chunk.a(biomeresolver, (int i2, int j2, int k2) -> this.k.a(i2, j2, k2, noisechunk.a(i2, k2)));
    }

    @Override
    public Climate.Sampler c() {
        return this.k;
    }

    @Override
    protected Codec<? extends ChunkGenerator> a() {
        return d;
    }

    @Override
    public ChunkGenerator a(long seed) {
        return new ChunkGeneratorAbstract(this.i, this.b.a(seed), seed, this.f);
    }

    public boolean a(long seed, ResourceKey<GeneratorSettingBase> settingsKey) {
        return this.j == seed && this.f.get().a(settingsKey);
    }

    @Override
    public int a(int x2, int z2, HeightMap.Type heightmap, LevelHeightAccessor world) {
        NoiseSettings noisesettings = this.f.get().b();
        int k2 = Math.max(noisesettings.h(), world.u_());
        int l2 = Math.min(noisesettings.h() + noisesettings.i(), world.ag());
        int i1 = MathHelper.a(k2, noisesettings.d());
        int j1 = MathHelper.a(l2 - k2, noisesettings.d());
        return j1 <= 0 ? world.u_() : this.a(x2, z2, (IBlockData[])null, heightmap.e(), i1, j1).orElse(world.u_());
    }

    @Override
    public BlockColumn a(int x2, int z2, LevelHeightAccessor world) {
        NoiseSettings noisesettings = this.f.get().b();
        int k2 = Math.max(noisesettings.h(), world.u_());
        int l2 = Math.min(noisesettings.h() + noisesettings.i(), world.ag());
        int i1 = MathHelper.a(k2, noisesettings.d());
        int j1 = MathHelper.a(l2 - k2, noisesettings.d());
        if (j1 <= 0) {
            return new BlockColumn(k2, h);
        }
        IBlockData[] aiblockdata = new IBlockData[j1 * noisesettings.d()];
        this.a(x2, z2, aiblockdata, (Predicate<IBlockData>)null, i1, j1);
        return new BlockColumn(k2, aiblockdata);
    }

    private OptionalInt a(int i2, int j2, @Nullable IBlockData[] states, @Nullable Predicate<IBlockData> predicate, int k2, int l2) {
        NoiseSettings noisesettings = this.f.get().b();
        int i1 = noisesettings.e();
        int j1 = noisesettings.d();
        int k1 = Math.floorDiv(i2, i1);
        int l1 = Math.floorDiv(j2, i1);
        int i22 = Math.floorMod(i2, i1);
        int j22 = Math.floorMod(j2, i1);
        int k22 = k1 * i1;
        int l22 = l1 * i1;
        double d0 = (double)i22 / (double)i1;
        double d1 = (double)j22 / (double)i1;
        NoiseChunk noisechunk = NoiseChunk.a(k22, l22, k2, l2, this.k, this.f.get(), this.n);
        noisechunk.b();
        noisechunk.a(0);
        for (int i3 = l2 - 1; i3 >= 0; --i3) {
            noisechunk.c(i3, 0);
            for (int j3 = j1 - 1; j3 >= 0; --j3) {
                IBlockData iblockdata1;
                int k3 = (k2 + i3) * j1 + j3;
                double d2 = (double)j3 / (double)j1;
                noisechunk.a(d2);
                noisechunk.b(d0);
                noisechunk.c(d1);
                IBlockData iblockdata = this.m.apply(noisechunk, i2, k3, j2);
                IBlockData iBlockData = iblockdata1 = iblockdata == null ? this.e : iblockdata;
                if (states != null) {
                    int l3 = i3 * j1 + j3;
                    states[l3] = iblockdata1;
                }
                if (predicate == null || !predicate.test(iblockdata1)) continue;
                return OptionalInt.of(k3 + 1);
            }
        }
        return OptionalInt.empty();
    }

    @Override
    public void a(RegionLimitedWorldAccess region, StructureManager structures, IChunkAccess chunk) {
        if (!SharedConstants.a(chunk.f())) {
            WorldGenerationContext worldgenerationcontext = new WorldGenerationContext(this, region, structures.getWorld());
            GeneratorSettingBase generatorsettingbase = this.f.get();
            NoiseChunk noisechunk = chunk.a(this.k, () -> new Beardifier(structures, chunk), generatorsettingbase, this.n, Blender.a(region));
            this.l.a(region.s_(), region.t().d(IRegistry.aR), generatorsettingbase.l(), worldgenerationcontext, chunk, noisechunk, generatorsettingbase.e());
        }
    }

    @Override
    public void a(RegionLimitedWorldAccess chunkRegion, long seed, BiomeManager biomeAccess, StructureManager structureAccessor, IChunkAccess chunk, WorldGenStage.Features generationStep) {
        BiomeManager biomemanager1 = biomeAccess.a((int j2, int k2, int l2) -> this.b.getNoiseBiome(j2, k2, l2, this.c()));
        SeededRandom seededrandom = new SeededRandom(new LegacyRandomSource(RandomSupport.a()));
        boolean flag = true;
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        NoiseChunk noisechunk = chunk.a(this.k, () -> new Beardifier(structureAccessor, chunk), this.f.get(), this.n, Blender.a(chunkRegion));
        Aquifer aquifer = noisechunk.d();
        CarvingContext carvingcontext = new CarvingContext(this, chunkRegion.t(), chunk.z(), noisechunk, structureAccessor.getWorld());
        CarvingMask carvingmask = ((ProtoChunk)chunk).b(generationStep);
        for (int j3 = -8; j3 <= 8; ++j3) {
            for (int k3 = -8; k3 <= 8; ++k3) {
                ChunkCoordIntPair chunkcoordintpair1 = new ChunkCoordIntPair(chunkcoordintpair.c + j3, chunkcoordintpair.d + k3);
                IChunkAccess ichunkaccess1 = chunkRegion.a(chunkcoordintpair1.c, chunkcoordintpair1.d);
                BiomeSettingsGeneration biomesettingsgeneration = ichunkaccess1.a(() -> this.b.getNoiseBiome(QuartPos.a(chunkcoordintpair1.d()), 0, QuartPos.a(chunkcoordintpair1.e()), this.c())).e();
                List<Supplier<WorldGenCarverWrapper<?>>> list = biomesettingsgeneration.a(generationStep);
                ListIterator<Supplier<WorldGenCarverWrapper<?>>> listiterator = list.listIterator();
                while (listiterator.hasNext()) {
                    int l3 = listiterator.nextIndex();
                    WorldGenCarverWrapper<?> worldgencarverwrapper = listiterator.next().get();
                    seededrandom.c(seed + (long)l3, chunkcoordintpair1.c, chunkcoordintpair1.d);
                    if (!worldgencarverwrapper.a(seededrandom)) continue;
                    Objects.requireNonNull(biomemanager1);
                    worldgencarverwrapper.a(carvingcontext, chunk, biomemanager1::a, seededrandom, aquifer, chunkcoordintpair1, carvingmask);
                }
            }
        }
    }

    @Override
    public CompletableFuture<IChunkAccess> a(Executor executor, Blender blender, StructureManager structureAccessor, IChunkAccess chunk) {
        NoiseSettings noisesettings = this.f.get().b();
        LevelHeightAccessor levelheightaccessor = chunk.z();
        int i2 = Math.max(noisesettings.h(), levelheightaccessor.u_());
        int j2 = Math.min(noisesettings.h() + noisesettings.i(), levelheightaccessor.ag());
        int k2 = MathHelper.a(i2, noisesettings.d());
        int l2 = MathHelper.a(j2 - i2, noisesettings.d());
        if (l2 <= 0) {
            return CompletableFuture.completedFuture(chunk);
        }
        int i1 = chunk.e(l2 * noisesettings.d() - 1 + i2);
        int j1 = chunk.e(i2);
        HashSet set = Sets.newHashSet();
        for (int k1 = i1; k1 >= j1; --k1) {
            ChunkSection chunksection = chunk.b(k1);
            chunksection.a();
            set.add(chunksection);
        }
        return CompletableFuture.supplyAsync(SystemUtils.a("wgen_fill_noise", () -> this.a(blender, structureAccessor, chunk, k2, l2)), SystemUtils.g()).whenCompleteAsync((ichunkaccess1, throwable) -> {
            for (ChunkSection chunksection1 : set) {
                chunksection1.b();
            }
        }, executor);
    }

    private IChunkAccess a(Blender blender, StructureManager structureAccessor, IChunkAccess chunk, int i2, int j2) {
        GeneratorSettingBase generatorsettingbase = this.f.get();
        NoiseChunk noisechunk = chunk.a(this.k, () -> new Beardifier(structureAccessor, chunk), generatorsettingbase, this.n, blender);
        HeightMap heightmap = chunk.a(HeightMap.Type.c);
        HeightMap heightmap1 = chunk.a(HeightMap.Type.a);
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        int k2 = chunkcoordintpair.d();
        int l2 = chunkcoordintpair.e();
        Aquifer aquifer = noisechunk.d();
        noisechunk.b();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        NoiseSettings noisesettings = generatorsettingbase.b();
        int i1 = noisesettings.e();
        int j1 = noisesettings.d();
        int k1 = 16 / i1;
        int l1 = 16 / i1;
        for (int i22 = 0; i22 < k1; ++i22) {
            noisechunk.a(i22);
            for (int j22 = 0; j22 < l1; ++j22) {
                ChunkSection chunksection = chunk.b(chunk.ah() - 1);
                for (int k22 = j2 - 1; k22 >= 0; --k22) {
                    noisechunk.c(k22, j22);
                    for (int l22 = j1 - 1; l22 >= 0; --l22) {
                        int i3 = (i2 + k22) * j1 + l22;
                        int j3 = i3 & 0xF;
                        int k3 = chunk.e(i3);
                        if (chunk.e(chunksection.g()) != k3) {
                            chunksection = chunk.b(k3);
                        }
                        double d0 = (double)l22 / (double)j1;
                        noisechunk.a(d0);
                        for (int l3 = 0; l3 < i1; ++l3) {
                            int i4 = k2 + i22 * i1 + l3;
                            int j4 = i4 & 0xF;
                            double d1 = (double)l3 / (double)i1;
                            noisechunk.b(d1);
                            for (int k4 = 0; k4 < i1; ++k4) {
                                int l4 = l2 + j22 * i1 + k4;
                                int i5 = l4 & 0xF;
                                double d2 = (double)k4 / (double)i1;
                                noisechunk.c(d2);
                                IBlockData iblockdata = this.m.apply(noisechunk, i4, i3, l4);
                                if (iblockdata == null) {
                                    iblockdata = this.e;
                                }
                                if ((iblockdata = this.a(noisechunk, i4, i3, l4, iblockdata)) == g || SharedConstants.a(chunk.f())) continue;
                                if (iblockdata.f() != 0 && chunk instanceof ProtoChunk) {
                                    blockposition_mutableblockposition.d(i4, i3, l4);
                                    ((ProtoChunk)chunk).j(blockposition_mutableblockposition);
                                }
                                chunksection.a(j4, j3, i5, iblockdata, false);
                                heightmap.a(j4, i3, i5, iblockdata);
                                heightmap1.a(j4, i3, i5, iblockdata);
                                if (!aquifer.a() || iblockdata.n().c()) continue;
                                blockposition_mutableblockposition.d(i4, i3, l4);
                                chunk.e(blockposition_mutableblockposition);
                            }
                        }
                    }
                }
            }
            noisechunk.c();
        }
        return chunk;
    }

    private IBlockData a(NoiseChunk chunkNoiseSampler, int x2, int y2, int z2, IBlockData state) {
        return state;
    }

    @Override
    public int f() {
        return this.f.get().b().i();
    }

    @Override
    public int g() {
        return this.f.get().f();
    }

    @Override
    public int h() {
        return this.f.get().b().h();
    }

    @Override
    public WeightedRandomList<BiomeSettingsMobs.c> a(BiomeBase biome, StructureManager accessor, EnumCreatureType group, BlockPosition pos) {
        if (!accessor.a(pos)) {
            return super.a(biome, accessor, group, pos);
        }
        if (accessor.b(pos, StructureGenerator.k).b()) {
            if (group == EnumCreatureType.a) {
                return WorldGenFeatureSwampHut.a;
            }
            if (group == EnumCreatureType.b) {
                return WorldGenFeatureSwampHut.w;
            }
        }
        if (group == EnumCreatureType.a) {
            if (accessor.a(pos, StructureGenerator.c).b()) {
                return WorldGenFeaturePillagerOutpost.a;
            }
            if (accessor.a(pos, StructureGenerator.m).b()) {
                return WorldGenMonument.a;
            }
            if (accessor.b(pos, StructureGenerator.o).b()) {
                return WorldGenNether.a;
            }
        }
        return (group == EnumCreatureType.e || group == EnumCreatureType.d) && accessor.a(pos, StructureGenerator.m).b() ? BiomeSettingsMobs.b : super.a(biome, accessor, group, pos);
    }

    @Override
    public void a(RegionLimitedWorldAccess region) {
        if (!this.f.get().g()) {
            ChunkCoordIntPair chunkcoordintpair = region.a();
            BiomeBase biomebase = region.v(chunkcoordintpair.l().h(region.ag() - 1));
            SeededRandom seededrandom = new SeededRandom(new LegacyRandomSource(RandomSupport.a()));
            seededrandom.a(region.E(), chunkcoordintpair.d(), chunkcoordintpair.e());
            SpawnerCreature.a(region, biomebase, chunkcoordintpair, seededrandom);
        }
    }

    @Deprecated
    public Optional<IBlockData> a(CarvingContext context, Function<BlockPosition, BiomeBase> posToBiome, IChunkAccess chunk, NoiseChunk chunkNoiseSampler, BlockPosition pos, boolean hasFluid) {
        return this.l.a(this.f.get().e(), context, posToBiome, chunk, chunkNoiseSampler, pos, hasFluid);
    }
}

