/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityTypeTest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityLookup<T extends EntityAccess> {
    private static final Logger a = LogManager.getLogger();
    private final Int2ObjectMap<T> b = new Int2ObjectLinkedOpenHashMap();
    private final Map<UUID, T> c = Maps.newHashMap();

    public <U extends T> void a(EntityTypeTest<T, U> filter, Consumer<U> action) {
        for (EntityAccess entityAccess : this.b.values()) {
            EntityAccess entityAccess2 = (EntityAccess)filter.a(entityAccess);
            if (entityAccess2 == null) continue;
            action.accept(entityAccess2);
        }
    }

    public Iterable<T> a() {
        return Iterables.unmodifiableIterable((Iterable)this.b.values());
    }

    public void a(T entity) {
        UUID uUID = entity.cm();
        if (this.c.containsKey(uUID)) {
            a.warn("Duplicate entity UUID {}: {}", (Object)uUID, entity);
            if (entity instanceof Entity) {
                EntityAccess old;
                if (World.DEBUG_ENTITIES) {
                    ((Entity)entity).addedToWorldStack = WorldServer.getAddToWorldStackTrace((Entity)entity);
                }
                if ((old = (EntityAccess)this.c.get(entity.cm())) instanceof Entity && old != null && old.ae() != entity.ae() && ((Entity)old).valid) {
                    Logger logger = LogManager.getLogger();
                    logger.error("Overwrote an existing entity " + old + " with " + entity);
                    if (World.DEBUG_ENTITIES) {
                        if (((Entity)old).addedToWorldStack != null) {
                            ((Entity)old).addedToWorldStack.printStackTrace();
                        } else {
                            logger.error("Oddly, the old entity was not added to the world in the normal way. Plugins?");
                        }
                        ((Entity)entity).addedToWorldStack.printStackTrace();
                    }
                }
            }
        } else {
            this.c.put(uUID, entity);
            this.b.put(entity.ae(), entity);
        }
    }

    public void b(T entity) {
        this.c.remove(entity.cm());
        this.b.remove(entity.ae());
    }

    @Nullable
    public T a(int id) {
        return (T)((EntityAccess)this.b.get(id));
    }

    @Nullable
    public T a(UUID uuid) {
        return (T)((EntityAccess)this.c.get(uuid));
    }

    public int b() {
        return this.c.size();
    }
}

