/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MCUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegionFileSection<R>
extends RegionFileCache
implements AutoCloseable {
    private static final Logger a = LogManager.getLogger();
    private static final String b = "Sections";
    private final Long2ObjectMap<Optional<R>> e = new Long2ObjectOpenHashMap();
    public final LongLinkedOpenHashSet f = new LongLinkedOpenHashSet();
    private final Function<Runnable, Codec<R>> g;
    private final Function<Runnable, R> h;
    private final DataFixer i;
    private final DataFixTypes j;
    protected final LevelHeightAccessor c;

    public RegionFileSection(Path path, Function<Runnable, Codec<R>> codecFactory, Function<Runnable, R> factory, DataFixer dataFixer, DataFixTypes dataFixTypes, boolean dsync, LevelHeightAccessor world) {
        super(path, dsync);
        this.g = codecFactory;
        this.h = factory;
        this.i = dataFixer;
        this.j = dataFixTypes;
        this.c = world;
    }

    public void unloadData(long coordinate) {
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(coordinate);
        this.a(chunkPos);
        Long2ObjectMap<Optional<R>> data = this.e;
        int before = data.size();
        for (int section = this.c.ai(); section < this.c.aj(); ++section) {
            data.remove(SectionPosition.b(chunkPos.c, section, chunkPos.d));
        }
        if (before != data.size()) {
            this.onUnload(coordinate);
        }
    }

    protected void onUnload(long coordinate) {
    }

    public boolean isEmpty(long coordinate) {
        Long2ObjectMap<Optional<R>> data = this.e;
        int x2 = MCUtil.getCoordinateX(coordinate);
        int z2 = MCUtil.getCoordinateZ(coordinate);
        for (int section = this.c.ai(); section < this.c.aj(); ++section) {
            Optional optional = (Optional)data.get(SectionPosition.b(x2, section, z2));
            if (optional == null || optional.orElse(null) == null) continue;
            return false;
        }
        return true;
    }

    protected void a(BooleanSupplier shouldKeepTicking) {
        while (!this.f.isEmpty() && shouldKeepTicking.getAsBoolean()) {
            ChunkCoordIntPair chunkPos = SectionPosition.a(this.f.firstLong()).r();
            this.d(chunkPos);
        }
    }

    @Nullable
    public Optional<R> c(long pos) {
        return (Optional)this.e.get(pos);
    }

    public Optional<R> d(long pos) {
        if (this.e(pos)) {
            return Optional.empty();
        }
        Optional<R> optional = this.c(pos);
        if (optional != null) {
            return optional;
        }
        this.b(SectionPosition.a(pos).r());
        optional = this.c(pos);
        if (optional == null) {
            throw SystemUtils.c(new IllegalStateException());
        }
        return optional;
    }

    protected boolean e(long pos) {
        int i2 = SectionPosition.c(SectionPosition.c(pos));
        return this.c.d(i2);
    }

    protected R f(long pos) {
        if (this.e(pos)) {
            throw SystemUtils.c(new IllegalArgumentException("sectionPos out of bounds"));
        }
        Optional<R> optional = this.d(pos);
        if (optional.isPresent()) {
            return optional.get();
        }
        R object = this.h.apply(() -> this.a(pos));
        this.e.put(pos, Optional.of(object));
        return object;
    }

    private void b(ChunkCoordIntPair chunkPos) {
        this.loadInData(chunkPos, this.c(chunkPos));
    }

    public void loadInData(ChunkCoordIntPair chunkPos, NBTTagCompound compound) {
        this.a(chunkPos, DynamicOpsNBT.a, compound);
    }

    @Nullable
    private NBTTagCompound c(ChunkCoordIntPair pos) {
        try {
            return this.a(pos);
        }
        catch (IOException var3) {
            a.error("Error reading chunk {} data from disk", (Object)pos, (Object)var3);
            return null;
        }
    }

    private <T> void a(ChunkCoordIntPair pos, DynamicOps<T> dynamicOps, @Nullable T data) {
        if (data == null) {
            for (int i2 = this.c.ai(); i2 < this.c.aj(); ++i2) {
                this.e.put(RegionFileSection.a(pos, i2), Optional.empty());
            }
        } else {
            int k2;
            Dynamic<T> dynamic = new Dynamic<T>(dynamicOps, data);
            int j2 = RegionFileSection.a(dynamic);
            boolean bl = j2 != (k2 = SharedConstants.b().getWorldVersion());
            Dynamic<NBTTagCompound> dynamic2 = this.j.a() == DataConverterTypes.j ? new Dynamic<NBTTagCompound>(dynamic.getOps(), MCDataConverter.convertTag(MCTypeRegistry.POI_CHUNK, (NBTTagCompound)dynamic.getValue(), j2, k2)) : this.i.update(this.j.a(), dynamic, j2, k2);
            OptionalDynamic<NBTTagCompound> optionalDynamic = dynamic2.get(b);
            for (int l2 = this.c.ai(); l2 < this.c.aj(); ++l2) {
                long m2 = RegionFileSection.a(pos, l2);
                Optional optional = optionalDynamic.get(Integer.toString(l2)).result().flatMap(dynamicx -> this.g.apply(() -> this.a(m2)).parse(dynamicx).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)));
                this.e.put(m2, optional);
                optional.ifPresent(object -> {
                    this.b(m2);
                    if (bl) {
                        this.a(m2);
                    }
                });
            }
        }
        if (this instanceof VillagePlace) {
            ((VillagePlace)this).queueUnload(pos.longKey, MinecraftServer.currentTickLong + 1L);
        }
    }

    private void d(ChunkCoordIntPair chunkPos) {
        Dynamic<NBTBase> dynamic = this.a(chunkPos, DynamicOpsNBT.a);
        NBTBase tag = dynamic.getValue();
        if (tag instanceof NBTTagCompound) {
            try {
                this.a(chunkPos, (NBTTagCompound)tag);
            }
            catch (IOException ioexception) {
                a.error("Error writing data to disk", (Throwable)ioexception);
            }
        } else {
            a.error("Expected compound tag, got {}", (Object)tag);
        }
    }

    private NBTTagCompound getDataInternal(ChunkCoordIntPair chunkcoordintpair) {
        Dynamic<NBTBase> dynamic = this.a(chunkcoordintpair, DynamicOpsNBT.a);
        NBTBase nbtbase = dynamic.getValue();
        if (nbtbase instanceof NBTTagCompound) {
            return (NBTTagCompound)nbtbase;
        }
        a.error("Expected compound tag, got {}", (Object)nbtbase);
        return null;
    }

    private <T> Dynamic<T> a(ChunkCoordIntPair chunkPos, DynamicOps<T> dynamicOps) {
        HashMap map = Maps.newHashMap();
        for (int i2 = this.c.ai(); i2 < this.c.aj(); ++i2) {
            long l2 = RegionFileSection.a(chunkPos, i2);
            this.f.remove(l2);
            Optional optional = (Optional)this.e.get(l2);
            if (optional == null || !optional.isPresent()) continue;
            DataResult dataResult = this.g.apply(() -> this.a(l2)).encodeStart(dynamicOps, optional.get());
            String string = Integer.toString(i2);
            dataResult.resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(object -> map.put(dynamicOps.createString(string), object));
        }
        return new Dynamic<Object>(dynamicOps, dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString(b), (Object)dynamicOps.createMap((Map)map), (Object)dynamicOps.createString("DataVersion"), (Object)dynamicOps.createInt(SharedConstants.b().getWorldVersion()))));
    }

    private static long a(ChunkCoordIntPair chunkPos, int y2) {
        return SectionPosition.b(chunkPos.c, y2, chunkPos.d);
    }

    protected void b(long pos) {
    }

    protected void a(long pos) {
        Optional optional = (Optional)this.e.get(pos);
        if (optional != null && optional.isPresent()) {
            this.f.add(pos);
        } else {
            a.warn("No data for position: {}", (Object)SectionPosition.a(pos));
        }
    }

    private static int a(Dynamic<?> dynamic) {
        return dynamic.get("DataVersion").asInt(1945);
    }

    public void a(ChunkCoordIntPair pos) {
        if (!this.f.isEmpty()) {
            for (int i2 = this.c.ai(); i2 < this.c.aj(); ++i2) {
                long l2 = RegionFileSection.a(pos, i2);
                if (!this.f.contains(l2)) continue;
                this.d(pos);
                return;
            }
        }
    }

    @Override
    public void close() throws IOException {
    }

    public NBTTagCompound getData(ChunkCoordIntPair chunkcoordintpair) {
        if (!this.f.isEmpty()) {
            for (int i2 = this.c.ai(); i2 < this.c.aj(); ++i2) {
                long j2 = SectionPosition.a(chunkcoordintpair, i2).s();
                if (!this.f.contains(j2)) continue;
                return this.getDataInternal(chunkcoordintpair);
            }
        }
        return null;
    }
}

