/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.util.Unit;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.util.thread.PairedQueue;
import net.minecraft.util.thread.ThreadedMailbox;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IOWorker
implements ChunkScanAccess,
AutoCloseable {
    private static final Logger a = LogManager.getLogger();
    private final AtomicBoolean b = new AtomicBoolean();
    private final ThreadedMailbox<PairedQueue.b> c;
    private final RegionFileCache d;
    private final Map<ChunkCoordIntPair, a> e = Maps.newLinkedHashMap();

    protected IOWorker(Path directory, boolean dsync, String name) {
        this.d = new RegionFileCache(directory, dsync);
        this.c = new ThreadedMailbox<PairedQueue.b>(new PairedQueue.a(Priority.values().length), SystemUtils.h(), "IOWorker-" + name);
    }

    public CompletableFuture<Void> a(ChunkCoordIntPair pos, @Nullable NBTTagCompound nbt) {
        return this.a(() -> {
            a pendingStore = this.e.computeIfAbsent(pos, chunkPos -> new a(nbt));
            pendingStore.a = nbt;
            return Either.left(pendingStore.b);
        }).thenCompose(Function.identity());
    }

    @Nullable
    public NBTTagCompound a(ChunkCoordIntPair pos) throws IOException {
        CompletableFuture<NBTTagCompound> completableFuture = this.b(pos);
        try {
            return completableFuture.join();
        }
        catch (CompletionException completionException) {
            if (completionException.getCause() instanceof IOException) {
                throw (IOException)completionException.getCause();
            }
            throw completionException;
        }
    }

    protected CompletableFuture<NBTTagCompound> b(ChunkCoordIntPair pos) {
        return this.a(() -> {
            a pendingStore = this.e.get(pos);
            if (pendingStore != null) {
                return Either.left(pendingStore.a);
            }
            try {
                NBTTagCompound compoundTag = this.d.a(pos);
                return Either.left(compoundTag);
            }
            catch (Exception exception) {
                a.warn("Failed to read chunk {}", (Object)pos, (Object)exception);
                return Either.right(exception);
            }
        });
    }

    public CompletableFuture<Void> a(boolean sync) {
        CompletionStage completableFuture = this.a(() -> Either.left(CompletableFuture.allOf((CompletableFuture[])this.e.values().stream().map(pendingStore -> pendingStore.b).toArray(CompletableFuture[]::new)))).thenCompose(Function.identity());
        if (sync) {
            return ((CompletableFuture)completableFuture).thenCompose(void_ -> this.a(() -> {
                try {
                    this.d.a();
                    return Either.left(null);
                }
                catch (Exception exception) {
                    a.warn("Failed to synchronize chunks", (Throwable)exception);
                    return Either.right(exception);
                }
            }));
        }
        return ((CompletableFuture)completableFuture).thenCompose(void_ -> this.a(() -> Either.left(null)));
    }

    @Override
    @Override
    public CompletableFuture<Void> a(ChunkCoordIntPair pos, StreamTagVisitor scanner) {
        return this.a(() -> {
            try {
                a pendingStore = this.e.get(pos);
                if (pendingStore != null) {
                    if (pendingStore.a != null) {
                        pendingStore.a.b(scanner);
                    }
                } else {
                    this.d.a(pos, scanner);
                }
                return Either.left(null);
            }
            catch (Exception exception) {
                a.warn("Failed to bulk scan chunk {}", (Object)pos, (Object)exception);
                return Either.right(exception);
            }
        });
    }

    private <T> CompletableFuture<T> a(Supplier<Either<T, Exception>> task) {
        return this.c.c((? super Mailbox<Either<Source, Exception>> processorHandle) -> new PairedQueue.b(Priority.a.ordinal(), () -> this.a(processorHandle, (Supplier)task)));
    }

    private void a() {
        if (this.e.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<ChunkCoordIntPair, a>> iterator = this.e.entrySet().iterator();
        Map.Entry<ChunkCoordIntPair, a> entry = iterator.next();
        iterator.remove();
        this.a(entry.getKey(), entry.getValue());
        this.b();
    }

    private void b() {
        this.c.a(new PairedQueue.b(Priority.b.ordinal(), this::a));
    }

    private void a(ChunkCoordIntPair pos, a result) {
        try {
            this.d.a(pos, result.a);
            result.b.complete(null);
        }
        catch (Exception exception) {
            a.error("Failed to store chunk {}", (Object)pos, (Object)exception);
            result.b.completeExceptionally(exception);
        }
    }

    @Override
    @Override
    public void close() throws IOException {
        if (!this.b.compareAndSet(false, true)) {
            return;
        }
        this.c.b((? super Mailbox<Source> processorHandle) -> new PairedQueue.b(Priority.c.ordinal(), () -> processorHandle.a(Unit.a))).join();
        this.c.close();
        try {
            this.d.close();
        }
        catch (Exception exception) {
            a.error("Failed to close storage", (Throwable)exception);
        }
    }

    private /* synthetic */ void a(Mailbox processorHandle, Supplier supplier) {
        if (!this.b.get()) {
            processorHandle.a((Either)supplier.get());
        }
        this.b();
    }

    static final class Priority
    extends Enum<Priority> {
        public static final /* enum */ Priority a = new Priority();
        public static final /* enum */ Priority b = new Priority();
        public static final /* enum */ Priority c = new Priority();
        private static final /* synthetic */ Priority[] d;

        public static Priority[] values() {
            return (Priority[])d.clone();
        }

        public static Priority valueOf(String string) {
            return Enum.valueOf(Priority.class, string);
        }

        private static /* synthetic */ Priority[] a() {
            return new Priority[]{a, b, c};
        }

        static {
            d = Priority.a();
        }
    }

    static class a {
        @Nullable
        NBTTagCompound a;
        final CompletableFuture<Void> b = new CompletableFuture();

        public a(@Nullable NBTTagCompound nbt) {
            this.a = nbt;
        }
    }
}

