/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import ca.spottedleaf.starlight.common.light.StarLightEngine;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTickList;
import net.minecraft.world.ticks.TickContainerAccess;

public class ProtoChunk
extends IChunkAccess {
    @Nullable
    private volatile LightEngine l;
    private volatile ChunkStatus m = ChunkStatus.c;
    private final List<NBTTagCompound> n = Lists.newArrayList();
    private final List<BlockPosition> o = Lists.newArrayList();
    private final Map<WorldGenStage.Features, CarvingMask> p = new Object2ObjectArrayMap();
    @Nullable
    private BelowZeroRetrogen q;
    private final ProtoChunkTickList<Block> r;
    private final ProtoChunkTickList<FluidType> s;

    public ProtoChunk(ChunkCoordIntPair pos, ChunkConverter upgradeData, LevelHeightAccessor world, IRegistry<BiomeBase> biomeRegistry, @Nullable BlendingData blendingData) {
        this(pos, upgradeData, null, new ProtoChunkTickList<Block>(), new ProtoChunkTickList<FluidType>(), world, biomeRegistry, blendingData);
    }

    public ProtoChunk(ChunkCoordIntPair pos, ChunkConverter upgradeData, @Nullable ChunkSection[] sections, ProtoChunkTickList<Block> blockTickScheduler, ProtoChunkTickList<FluidType> fluidTickScheduler, LevelHeightAccessor world, IRegistry<BiomeBase> biomeRegistry, @Nullable BlendingData blendingData) {
        super(pos, upgradeData, world, biomeRegistry, 0L, sections, blendingData);
        if (!(this instanceof ProtoChunkExtension)) {
            this.setBlockNibbles(StarLightEngine.getFilledEmptyLight(world));
            this.setSkyNibbles(StarLightEngine.getFilledEmptyLight(world));
        }
        this.r = blockTickScheduler;
        this.s = fluidTickScheduler;
    }

    @Override
    public TickContainerAccess<Block> o() {
        return this.r;
    }

    @Override
    public TickContainerAccess<FluidType> p() {
        return this.s;
    }

    @Override
    public IChunkAccess.a q() {
        return new IChunkAccess.a(this.r, this.s);
    }

    @Override
    public final Fluid getFluidIfLoaded(BlockPosition blockposition) {
        return this.b_(blockposition);
    }

    @Override
    public final IBlockData getBlockStateIfLoaded(BlockPosition blockposition) {
        return this.a_(blockposition);
    }

    @Override
    public IBlockData a_(BlockPosition pos) {
        return this.getBlockState(pos.u(), pos.v(), pos.w());
    }

    @Override
    public IBlockData getBlockState(int x2, int y2, int z2) {
        if (this.d(y2)) {
            return Blocks.lo.n();
        }
        ChunkSection levelChunkSection = this.d()[this.e(y2)];
        return levelChunkSection.c() ? Blocks.a.n() : levelChunkSection.a(x2 & 0xF, y2 & 0xF, z2 & 0xF);
    }

    @Override
    public Fluid b_(BlockPosition pos) {
        int i2 = pos.v();
        if (this.d(i2)) {
            return FluidTypes.a.h();
        }
        ChunkSection levelChunkSection = this.b(this.e(i2));
        return levelChunkSection.c() ? FluidTypes.a.h() : levelChunkSection.b(pos.u() & 0xF, i2 & 0xF, pos.w() & 0xF);
    }

    @Override
    public Stream<BlockPosition> n() {
        return this.o.stream();
    }

    public ShortList[] B() {
        ShortList[] shortLists = new ShortList[this.ah()];
        for (BlockPosition blockPos : this.o) {
            IChunkAccess.a(shortLists, this.e(blockPos.v())).add(ProtoChunk.k(blockPos));
        }
        return shortLists;
    }

    public void b(short chunkSliceRel, int sectionY) {
        this.j(ProtoChunk.a(chunkSliceRel, this.g(sectionY), this.c));
    }

    public void j(BlockPosition pos) {
        this.o.add(pos.h());
    }

    @Override
    @Nullable
    public IBlockData a(BlockPosition pos, IBlockData state, boolean moved) {
        int i2 = pos.u();
        int j2 = pos.v();
        int k2 = pos.w();
        if (j2 >= this.u_() && j2 < this.ag()) {
            int l2 = this.e(j2);
            if (this.k[l2].c() && state.a(Blocks.a)) {
                return state;
            }
            if (state.f() > 0) {
                this.o.add(new BlockPosition((i2 & 0xF) + this.f().d(), j2, (k2 & 0xF) + this.f().e()));
            }
            ChunkSection levelChunkSection = this.b(l2);
            IBlockData blockState = levelChunkSection.a(i2 & 0xF, j2 & 0xF, k2 & 0xF, state);
            if (this.m.b(ChunkStatus.k) && state != blockState && (state.b(this, pos) != blockState.b(this, pos) || state.f() != blockState.f() || state.e() || blockState.e())) {
                this.l.a(pos);
            }
            EnumSet<HeightMap.Type> enumSet = this.j().h();
            EnumSet<HeightMap.Type> enumSet2 = null;
            for (HeightMap.Type types : enumSet) {
                HeightMap heightmap = this.g.get(types);
                if (heightmap != null) continue;
                if (enumSet2 == null) {
                    enumSet2 = EnumSet.noneOf(HeightMap.Type.class);
                }
                enumSet2.add(types);
            }
            if (enumSet2 != null) {
                HeightMap.a(this, enumSet2);
            }
            for (HeightMap.Type types2 : enumSet) {
                this.g.get(types2).a(i2 & 0xF, j2, k2 & 0xF, state);
            }
            return blockState;
        }
        return Blocks.lo.n();
    }

    @Override
    public void a(TileEntity blockEntity) {
        this.i.put(blockEntity.p(), blockEntity);
    }

    @Override
    @Nullable
    public TileEntity c_(BlockPosition pos) {
        return this.i.get(pos);
    }

    public Map<BlockPosition, TileEntity> C() {
        return this.i;
    }

    public void b(NBTTagCompound entityTag) {
        this.n.add(entityTag);
    }

    @Override
    public void a(Entity entity) {
        if (!entity.bF()) {
            NBTTagCompound compoundTag = new NBTTagCompound();
            entity.e(compoundTag);
            this.b(compoundTag);
        }
    }

    @Override
    public void a(StructureGenerator<?> structure, StructureStart<?> start) {
        BelowZeroRetrogen belowZeroRetrogen = this.x();
        if (belowZeroRetrogen != null && start.b()) {
            StructureBoundingBox boundingBox = start.a();
            LevelHeightAccessor levelHeightAccessor = this.z();
            if (boundingBox.h() < levelHeightAccessor.u_() || boundingBox.k() >= levelHeightAccessor.ag()) {
                return;
            }
        }
        super.a(structure, start);
    }

    public List<NBTTagCompound> D() {
        return this.n;
    }

    @Override
    public ChunkStatus j() {
        return this.m;
    }

    public void a(ChunkStatus status) {
        this.m = status;
        if (this.q != null && status.b(this.q.a())) {
            this.a((BelowZeroRetrogen)null);
        }
        this.a(true);
    }

    @Override
    public BiomeBase getNoiseBiome(int biomeX, int biomeY, int biomeZ) {
        if (!(this.j().b(ChunkStatus.f) || this.q != null && this.q.a().b(ChunkStatus.f))) {
            throw new IllegalStateException("Asking for biomes before we have biomes");
        }
        return super.getNoiseBiome(biomeX, biomeY, biomeZ);
    }

    public static short k(BlockPosition pos) {
        int i2 = pos.u();
        int j2 = pos.v();
        int k2 = pos.w();
        int l2 = i2 & 0xF;
        int m2 = j2 & 0xF;
        int n2 = k2 & 0xF;
        return (short)(l2 | m2 << 4 | n2 << 8);
    }

    public static BlockPosition a(short sectionRel, int sectionY, ChunkCoordIntPair chunkPos) {
        int i2 = SectionPosition.a(chunkPos.c, sectionRel & 0xF);
        int j2 = SectionPosition.a(sectionY, sectionRel >>> 4 & 0xF);
        int k2 = SectionPosition.a(chunkPos.d, sectionRel >>> 8 & 0xF);
        return new BlockPosition(i2, j2, k2);
    }

    @Override
    public void e(BlockPosition pos) {
        if (!this.u(pos)) {
            IChunkAccess.a(this.a, this.e(pos.v())).add(ProtoChunk.k(pos));
        }
    }

    @Override
    public void a(short packedPos, int index) {
        IChunkAccess.a(this.a, index).add(packedPos);
    }

    public Map<BlockPosition, NBTTagCompound> E() {
        return Collections.unmodifiableMap(this.h);
    }

    @Override
    @Nullable
    public NBTTagCompound i(BlockPosition pos) {
        TileEntity blockEntity = this.c_(pos);
        return blockEntity != null ? blockEntity.m() : this.h.get(pos);
    }

    @Override
    public void d(BlockPosition pos) {
        this.i.remove(pos);
        this.h.remove(pos);
    }

    @Nullable
    public CarvingMask a(WorldGenStage.Features carver) {
        return this.p.get(carver);
    }

    public CarvingMask b(WorldGenStage.Features carver) {
        return this.p.computeIfAbsent(carver, carving -> new CarvingMask(this.v_(), this.u_()));
    }

    public void a(WorldGenStage.Features carver, CarvingMask carvingMask) {
        this.p.put(carver, carvingMask);
    }

    public void a(LightEngine lightingProvider) {
        this.l = lightingProvider;
    }

    public void a(@Nullable BelowZeroRetrogen belowZeroRetrogen) {
        this.q = belowZeroRetrogen;
    }

    @Override
    @Nullable
    public BelowZeroRetrogen x() {
        return this.q;
    }

    private static <T> LevelChunkTicks<T> a(ProtoChunkTickList<T> tickScheduler) {
        return new LevelChunkTicks<T>(tickScheduler.b());
    }

    public LevelChunkTicks<Block> F() {
        return ProtoChunk.a(this.r);
    }

    public LevelChunkTicks<FluidType> G() {
        return ProtoChunk.a(this.s);
    }

    @Override
    public LevelHeightAccessor z() {
        return this.y() ? BelowZeroRetrogen.b : this;
    }
}

