/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.EnumDirection8;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.BlockStemmed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkConverter {
    private static final Logger b = LogManager.getLogger();
    public static final ChunkConverter a = new ChunkConverter(BlockAccessAir.a);
    private static final String c = "Indices";
    private static final EnumDirection8[] d = EnumDirection8.values();
    private final EnumSet<EnumDirection8> e = EnumSet.noneOf(EnumDirection8.class);
    private final int[][] f;
    static final Map<Block, a> g = new IdentityHashMap<Block, a>();
    static final Set<a> h = Sets.newHashSet();

    private ChunkConverter(LevelHeightAccessor world) {
        this.f = new int[world.ah()][];
    }

    public ChunkConverter(NBTTagCompound nbt, LevelHeightAccessor world) {
        this(world);
        if (nbt.b(c, 10)) {
            NBTTagCompound compoundTag = nbt.p(c);
            for (int i2 = 0; i2 < this.f.length; ++i2) {
                String string = String.valueOf(i2);
                if (!compoundTag.b(string, 11)) continue;
                this.f[i2] = compoundTag.n(string);
            }
        }
        int j2 = nbt.h("Sides");
        for (EnumDirection8 direction8 : EnumDirection8.values()) {
            if ((j2 & 1 << direction8.ordinal()) == 0) continue;
            this.e.add(direction8);
        }
    }

    public void a(Chunk chunk) {
        this.b(chunk);
        for (EnumDirection8 direction8 : d) {
            ChunkConverter.a(chunk, direction8);
        }
        World level = chunk.D();
        h.forEach(blockFixer -> blockFixer.a(level));
    }

    private static void a(Chunk chunk, EnumDirection8 side) {
        World level = chunk.D();
        if (!chunk.r().e.remove((Object)side)) {
            return;
        }
        Set<EnumDirection> set = side.a();
        boolean i2 = false;
        int j2 = 15;
        boolean bl = set.contains(EnumDirection.f);
        boolean bl2 = set.contains(EnumDirection.e);
        boolean bl3 = set.contains(EnumDirection.d);
        boolean bl4 = set.contains(EnumDirection.c);
        boolean bl5 = set.size() == 1;
        ChunkCoordIntPair chunkPos = chunk.f();
        int k2 = chunkPos.d() + (bl5 && (bl4 || bl3) ? 1 : (bl2 ? 0 : 15));
        int l2 = chunkPos.d() + (bl5 && (bl4 || bl3) ? 14 : (bl2 ? 0 : 15));
        int m2 = chunkPos.e() + (bl5 && (bl || bl2) ? 1 : (bl4 ? 0 : 15));
        int n2 = chunkPos.e() + (bl5 && (bl || bl2) ? 14 : (bl4 ? 0 : 15));
        EnumDirection[] directions = EnumDirection.values();
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (BlockPosition blockPos : BlockPosition.b(k2, level.u_(), m2, l2, level.ag() - 1, n2)) {
            IBlockData blockState;
            IBlockData blockState2 = blockState = level.a_(blockPos);
            for (EnumDirection direction : directions) {
                mutableBlockPos.a((BaseBlockPosition)blockPos, direction);
                blockState2 = ChunkConverter.a(blockState2, direction, level, blockPos, mutableBlockPos);
            }
            Block.a(blockState, blockState2, level, blockPos, 18);
        }
    }

    private static IBlockData a(IBlockData oldState, EnumDirection dir, GeneratorAccess world, BlockPosition currentPos, BlockPosition otherPos) {
        return g.getOrDefault(oldState.b(), Type.b).a(oldState, dir, world.a_(otherPos), world, currentPos, otherPos);
    }

    private void b(Chunk chunk) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        BlockPosition.MutableBlockPosition mutableBlockPos2 = new BlockPosition.MutableBlockPosition();
        ChunkCoordIntPair chunkPos = chunk.f();
        World levelAccessor = chunk.D();
        for (int i2 = 0; i2 < this.f.length; ++i2) {
            ChunkSection levelChunkSection = chunk.b(i2);
            int[] is = this.f[i2];
            this.f[i2] = null;
            if (is == null || is.length <= 0) continue;
            EnumDirection[] directions = EnumDirection.values();
            DataPaletteBlock<IBlockData> palettedContainer = levelChunkSection.i();
            for (int j2 : is) {
                IBlockData blockState;
                int k2 = j2 & 0xF;
                int l2 = j2 >> 8 & 0xF;
                int m2 = j2 >> 4 & 0xF;
                mutableBlockPos.d(chunkPos.d() + k2, levelChunkSection.g() + l2, chunkPos.e() + m2);
                IBlockData blockState2 = blockState = palettedContainer.a(j2);
                for (EnumDirection direction : directions) {
                    mutableBlockPos2.a((BaseBlockPosition)mutableBlockPos, direction);
                    if (SectionPosition.a(mutableBlockPos.u()) != chunkPos.c || SectionPosition.a(mutableBlockPos.w()) != chunkPos.d) continue;
                    blockState2 = ChunkConverter.a(blockState2, direction, levelAccessor, mutableBlockPos, mutableBlockPos2);
                }
                Block.a(blockState, blockState2, levelAccessor, mutableBlockPos, 18);
            }
        }
        for (int n2 = 0; n2 < this.f.length; ++n2) {
            if (this.f[n2] != null) {
                b.warn("Discarding update data for section {} for chunk ({} {})", (Object)levelAccessor.g(n2), (Object)chunkPos.c, (Object)chunkPos.d);
            }
            this.f[n2] = null;
        }
    }

    public boolean a() {
        for (int[] is : this.f) {
            if (is == null) continue;
            return false;
        }
        return this.e.isEmpty();
    }

    public NBTTagCompound b() {
        NBTTagCompound compoundTag = new NBTTagCompound();
        NBTTagCompound compoundTag2 = new NBTTagCompound();
        for (int i2 = 0; i2 < this.f.length; ++i2) {
            String string = String.valueOf(i2);
            if (this.f[i2] == null || this.f[i2].length == 0) continue;
            compoundTag2.a(string, this.f[i2]);
        }
        if (!compoundTag2.f()) {
            compoundTag.a(c, compoundTag2);
        }
        int j2 = 0;
        for (EnumDirection8 direction8 : this.e) {
            j2 |= 1 << direction8.ordinal();
        }
        compoundTag.a("Sides", (byte)j2);
        return compoundTag;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static abstract class Type
    extends Enum<Type>
    implements a {
        public static final /* enum */ Type a = new Type(new Block[]{Blocks.jc, Blocks.db, Blocks.ka, Blocks.kb, Blocks.kc, Blocks.kd, Blocks.ke, Blocks.kf, Blocks.kg, Blocks.kh, Blocks.ki, Blocks.kj, Blocks.kk, Blocks.kl, Blocks.km, Blocks.kn, Blocks.ko, Blocks.kp, Blocks.fB, Blocks.fC, Blocks.fD, Blocks.er, Blocks.E, Blocks.C, Blocks.D, Blocks.cg, Blocks.ch, Blocks.ci, Blocks.cj, Blocks.ck, Blocks.cl, Blocks.cq, Blocks.cr, Blocks.cs, Blocks.ct, Blocks.cu, Blocks.cv}){

            @Override
            @Override
            public IBlockData a(IBlockData oldState, EnumDirection direction, IBlockData otherState, GeneratorAccess world, BlockPosition currentPos, BlockPosition otherPos) {
                return oldState;
            }
        };
        public static final /* enum */ Type b = new Type(new Block[0]){

            @Override
            @Override
            public IBlockData a(IBlockData oldState, EnumDirection direction, IBlockData otherState, GeneratorAccess world, BlockPosition currentPos, BlockPosition otherPos) {
                return oldState.a(direction, world.a_(otherPos), world, currentPos, otherPos);
            }
        };
        public static final /* enum */ Type c = new Type(new Block[]{Blocks.bX, Blocks.fE}){

            @Override
            @Override
            public IBlockData a(IBlockData oldState, EnumDirection direction, IBlockData otherState, GeneratorAccess world, BlockPosition currentPos, BlockPosition otherPos) {
                if (otherState.a(oldState.b()) && direction.n().d() && oldState.c(BlockChest.c) == BlockPropertyChestType.a && otherState.c(BlockChest.c) == BlockPropertyChestType.a) {
                    EnumDirection direction2 = oldState.c(BlockChest.b);
                    if (direction.n() != direction2.n() && direction2 == otherState.c(BlockChest.b)) {
                        BlockPropertyChestType chestType = direction == direction2.g() ? BlockPropertyChestType.b : BlockPropertyChestType.c;
                        world.a(otherPos, (IBlockData)otherState.a(BlockChest.c, chestType.a()), 18);
                        if (direction2 == EnumDirection.c || direction2 == EnumDirection.f) {
                            TileEntity blockEntity = world.c_(currentPos);
                            TileEntity blockEntity2 = world.c_(otherPos);
                            if (blockEntity instanceof TileEntityChest && blockEntity2 instanceof TileEntityChest) {
                                TileEntityChest.a((TileEntityChest)blockEntity, (TileEntityChest)blockEntity2);
                            }
                        }
                        return (IBlockData)oldState.a(BlockChest.c, chestType);
                    }
                }
                return oldState;
            }
        };
        public static final /* enum */ Type d = new Type(true, new Block[]{Blocks.ao, Blocks.am, Blocks.ap, Blocks.an, Blocks.ak, Blocks.al}){
            private final ThreadLocal<List<ObjectSet<BlockPosition>>> g = ThreadLocal.withInitial(() -> Lists.newArrayListWithCapacity((int)7));

            @Override
            @Override
            public IBlockData a(IBlockData oldState, EnumDirection direction, IBlockData otherState, GeneratorAccess world, BlockPosition currentPos, BlockPosition otherPos) {
                IBlockData blockState = oldState.a(direction, world.a_(otherPos), world, currentPos, otherPos);
                if (oldState != blockState) {
                    int i2 = blockState.c(BlockProperties.ax);
                    List<ObjectSet<BlockPosition>> list = this.g.get();
                    if (list.isEmpty()) {
                        for (int j2 = 0; j2 < 7; ++j2) {
                            list.add((ObjectSet<BlockPosition>)new ObjectOpenHashSet());
                        }
                    }
                    list.get(i2).add((Object)currentPos.h());
                }
                return oldState;
            }

            @Override
            @Override
            public void a(GeneratorAccess world) {
                BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
                List<ObjectSet<BlockPosition>> list = this.g.get();
                for (int i2 = 2; i2 < list.size(); ++i2) {
                    int j2 = i2 - 1;
                    ObjectSet<BlockPosition> objectSet = list.get(j2);
                    ObjectSet<BlockPosition> objectSet2 = list.get(i2);
                    for (BlockPosition blockPos : objectSet) {
                        IBlockData blockState = world.a_(blockPos);
                        if (blockState.c(BlockProperties.ax) < j2) continue;
                        world.a(blockPos, (IBlockData)blockState.a(BlockProperties.ax, j2), 18);
                        if (i2 == 7) continue;
                        for (EnumDirection direction : f) {
                            mutableBlockPos.a((BaseBlockPosition)blockPos, direction);
                            IBlockData blockState2 = world.a_(mutableBlockPos);
                            if (!blockState2.b(BlockProperties.ax) || blockState.c(BlockProperties.ax) <= i2) continue;
                            objectSet2.add((Object)mutableBlockPos.h());
                        }
                    }
                }
                list.clear();
            }
        };
        public static final /* enum */ Type e = new Type(new Block[]{Blocks.dW, Blocks.dV}){

            @Override
            @Override
            public IBlockData a(IBlockData oldState, EnumDirection direction, IBlockData otherState, GeneratorAccess world, BlockPosition currentPos, BlockPosition otherPos) {
                BlockStemmed stemGrownBlock;
                if (oldState.c(BlockStem.b) == 7 && otherState.a(stemGrownBlock = ((BlockStem)oldState.b()).c())) {
                    return (IBlockData)stemGrownBlock.d().n().a(BlockFacingHorizontal.aE, direction);
                }
                return oldState;
            }
        };
        public static final EnumDirection[] f;
        private static final /* synthetic */ Type[] g;

        public static Type[] values() {
            return (Type[])g.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }

        Type(Block ... blocks) {
            this(false, blocks);
        }

        Type(boolean bl, Block ... blocks) {
            for (Block block : blocks) {
                g.put(block, this);
            }
            if (bl) {
                h.add(this);
            }
        }

        private static /* synthetic */ Type[] a() {
            return new Type[]{a, b, c, d, e};
        }

        static {
            g = Type.a();
            f = EnumDirection.values();
        }
    }

    public static interface a {
        public IBlockData a(IBlockData var1, EnumDirection var2, IBlockData var3, GeneratorAccess var4, BlockPosition var5, BlockPosition var6);

        default public void a(GeneratorAccess world) {
        }
    }
}

