/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumBlockSupport;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialMapColor;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_18_R1.block.data.CraftBlockData;
import org.spigotmc.AsyncCatcher;

public abstract class BlockBase {
    protected static final EnumDirection[] aF = new EnumDirection[]{EnumDirection.e, EnumDirection.f, EnumDirection.c, EnumDirection.d, EnumDirection.a, EnumDirection.b};
    protected final Material aG;
    public final boolean aH;
    protected final float aI;
    protected final boolean aJ;
    protected final SoundEffectType aK;
    protected final float aL;
    protected final float aM;
    protected final float aN;
    protected final boolean aO;
    protected final Info aP;
    @Nullable
    protected MinecraftKey aQ;

    public BlockBase(Info settings) {
        this.aG = settings.a;
        this.aH = settings.c;
        this.aQ = settings.m;
        this.aI = settings.f;
        this.aJ = settings.i;
        this.aK = settings.d;
        this.aL = settings.j;
        this.aM = settings.k;
        this.aN = settings.l;
        this.aO = settings.v;
        this.aP = settings;
    }

    @Deprecated
    public void a(IBlockData state, GeneratorAccess world, BlockPosition pos, int flags, int maxUpdateDepth) {
    }

    @Deprecated
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        switch (type) {
            case a: {
                return !state.r(world, pos);
            }
            case b: {
                return world.b_(pos).a(TagsFluid.b);
            }
            case c: {
                return !state.r(world, pos);
            }
        }
        return false;
    }

    @Deprecated
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        return state;
    }

    @Deprecated
    public boolean a(IBlockData state, IBlockData stateFrom, EnumDirection direction) {
        return false;
    }

    @Deprecated
    public void a(IBlockData state, World world, BlockPosition pos, Block block, BlockPosition fromPos, boolean notify) {
        PacketDebug.a(world, pos);
    }

    @Deprecated
    public void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag, ItemActionContext itemActionContext) {
        this.b(iblockdata, world, blockposition, iblockdata1, flag);
    }

    @Deprecated
    public void b(IBlockData state, World world, BlockPosition pos, IBlockData oldState, boolean notify) {
        AsyncCatcher.catchOp("block onPlace");
    }

    @Deprecated
    public void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        AsyncCatcher.catchOp("block remove");
        if (state.m() && !state.a(newState.b())) {
            world.m(pos);
        }
    }

    @Deprecated
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        return EnumInteractionResult.d;
    }

    @Deprecated
    public boolean a(IBlockData state, World world, BlockPosition pos, int type, int data) {
        return false;
    }

    @Deprecated
    public EnumRenderType b_(IBlockData state) {
        return EnumRenderType.c;
    }

    @Deprecated
    public boolean g_(IBlockData state) {
        return false;
    }

    @Deprecated
    public boolean f_(IBlockData state) {
        return false;
    }

    @Deprecated
    public EnumPistonReaction d(IBlockData state) {
        return this.aG.g();
    }

    @Deprecated
    public Fluid c_(IBlockData state) {
        return FluidTypes.a.h();
    }

    @Deprecated
    public boolean d_(IBlockData state) {
        return false;
    }

    public EnumRandomOffset T_() {
        return EnumRandomOffset.a;
    }

    public float V_() {
        return 0.25f;
    }

    public float Y_() {
        return 0.2f;
    }

    @Deprecated
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return state;
    }

    @Deprecated
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state;
    }

    @Deprecated
    public boolean a(IBlockData state, BlockActionContext context) {
        return this.aG.e() && (context.n().b() || !context.n().a(this.k())) && (state.isDestroyable() || context.o() != null && context.o().fr().d);
    }

    @Deprecated
    public boolean a(IBlockData state, FluidType fluid) {
        return this.aG.e() || !this.aG.b();
    }

    @Deprecated
    public List<ItemStack> a(IBlockData state, LootTableInfo.Builder builder) {
        MinecraftKey minecraftkey = this.r();
        if (minecraftkey == LootTables.a) {
            return Collections.emptyList();
        }
        LootTableInfo loottableinfo = builder.a(LootContextParameters.g, state).a(LootContextParameterSets.l);
        WorldServer worldserver = loottableinfo.c();
        LootTable loottable = worldserver.n().aG().a(minecraftkey);
        return loottable.a(loottableinfo);
    }

    @Deprecated
    public long a(IBlockData state, BlockPosition pos) {
        return MathHelper.a(pos);
    }

    @Deprecated
    public VoxelShape b_(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return state.j(world, pos);
    }

    @Deprecated
    public VoxelShape f(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return this.c(state, world, pos, VoxelShapeCollision.a());
    }

    @Deprecated
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return VoxelShapes.a();
    }

    @Deprecated
    public int g(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return state.i(world, pos) ? world.O() : (state.a(world, pos) ? 0 : 1);
    }

    @Nullable
    @Deprecated
    public ITileInventory b(IBlockData state, World world, BlockPosition pos) {
        return null;
    }

    @Deprecated
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        return true;
    }

    @Deprecated
    public float b(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return state.r(world, pos) ? 0.2f : 1.0f;
    }

    @Deprecated
    public int a(IBlockData state, World world, BlockPosition pos) {
        return 0;
    }

    @Deprecated
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return VoxelShapes.b();
    }

    @Deprecated
    public VoxelShape c(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return this.aH ? state.j(world, pos) : VoxelShapes.a();
    }

    @Deprecated
    public boolean a_(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return Block.a(state.k(world, pos));
    }

    @Deprecated
    public VoxelShape b(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return this.c(state, world, pos, context);
    }

    @Deprecated
    public void b(IBlockData state, WorldServer world, BlockPosition pos, Random random) {
        this.a(state, world, pos, random);
    }

    @Deprecated
    public void a(IBlockData state, WorldServer world, BlockPosition pos, Random random) {
    }

    @Deprecated
    public float a(IBlockData state, EntityHuman player, IBlockAccess world, BlockPosition pos) {
        float f2 = state.h(world, pos);
        if (f2 == -1.0f) {
            return 0.0f;
        }
        int i2 = player.d(state) ? 30 : 100;
        return player.c(state) / f2 / (float)i2;
    }

    @Deprecated
    public void a(IBlockData state, WorldServer world, BlockPosition pos, ItemStack stack) {
    }

    @Deprecated
    public void a(IBlockData state, World world, BlockPosition pos, EntityHuman player) {
    }

    @Deprecated
    public int a(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return 0;
    }

    @Deprecated
    public void a(IBlockData state, World world, BlockPosition pos, Entity entity) {
    }

    @Deprecated
    public int b(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return 0;
    }

    public final MinecraftKey r() {
        if (this.aQ == null) {
            MinecraftKey minecraftkey = IRegistry.X.b(this.p());
            this.aQ = new MinecraftKey(minecraftkey.b(), "blocks/" + minecraftkey.a());
        }
        return this.aQ;
    }

    @Deprecated
    public void a(World world, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
    }

    public abstract Item k();

    protected abstract Block p();

    public MaterialMapColor s() {
        return this.aP.b.apply(this.p().n());
    }

    public float t() {
        return this.aP.g;
    }

    public static class Info {
        Material a;
        Function<IBlockData, MaterialMapColor> b;
        boolean c = true;
        SoundEffectType d = SoundEffectType.e;
        ToIntFunction<IBlockData> e = iblockdata -> 0;
        float f;
        float g;
        boolean h;
        boolean i;
        float j = 0.6f;
        float k = 1.0f;
        float l = 1.0f;
        MinecraftKey m;
        boolean n = true;
        boolean o;
        d<EntityTypes<?>> p = (iblockdata, iblockaccess, blockposition, entitytypes) -> iblockdata.d(iblockaccess, blockposition, EnumDirection.b) && iblockdata.f() < 14;
        e q = (iblockdata, iblockaccess, blockposition) -> iblockdata.c().f() && iblockdata.r(iblockaccess, blockposition);
        e r;
        e s = this.r = (iblockdata, iblockaccess, blockposition) -> this.a.c() && iblockdata.r(iblockaccess, blockposition);
        e t = (iblockdata, iblockaccess, blockposition) -> false;
        e u = (iblockdata, iblockaccess, blockposition) -> false;
        boolean v;

        private Info(Material material, MaterialMapColor mapColorProvider) {
            this(material, (IBlockData iblockdata) -> mapColorProvider);
        }

        private Info(Material material, Function<IBlockData, MaterialMapColor> mapColorProvider) {
            this.a = material;
            this.b = mapColorProvider;
        }

        public static Info a(Material material) {
            return Info.a(material, material.h());
        }

        public static Info a(Material material, EnumColor color) {
            return Info.a(material, color.e());
        }

        public static Info a(Material material, MaterialMapColor color) {
            return new Info(material, color);
        }

        public static Info a(Material material, Function<IBlockData, MaterialMapColor> mapColor) {
            return new Info(material, mapColor);
        }

        public static Info a(BlockBase block) {
            Info blockbase_info = new Info(block.aG, block.aP.b);
            blockbase_info.a = block.aP.a;
            blockbase_info.g = block.aP.g;
            blockbase_info.f = block.aP.f;
            blockbase_info.c = block.aP.c;
            blockbase_info.i = block.aP.i;
            blockbase_info.e = block.aP.e;
            blockbase_info.b = block.aP.b;
            blockbase_info.d = block.aP.d;
            blockbase_info.j = block.aP.j;
            blockbase_info.k = block.aP.k;
            blockbase_info.v = block.aP.v;
            blockbase_info.n = block.aP.n;
            blockbase_info.o = block.aP.o;
            blockbase_info.h = block.aP.h;
            return blockbase_info;
        }

        public Info a() {
            this.c = false;
            this.n = false;
            return this;
        }

        public Info b() {
            this.n = false;
            return this;
        }

        public Info a(float slipperiness) {
            this.j = slipperiness;
            return this;
        }

        public Info b(float velocityMultiplier) {
            this.k = velocityMultiplier;
            return this;
        }

        public Info c(float jumpVelocityMultiplier) {
            this.l = jumpVelocityMultiplier;
            return this;
        }

        public Info a(SoundEffectType soundGroup) {
            this.d = soundGroup;
            return this;
        }

        public Info a(ToIntFunction<IBlockData> luminance) {
            this.e = luminance;
            return this;
        }

        public Info a(float hardness, float resistance) {
            return this.e(hardness).f(resistance);
        }

        public Info c() {
            return this.d(0.0f);
        }

        public Info d(float strength) {
            this.a(strength, strength);
            return this;
        }

        public Info d() {
            this.i = true;
            return this;
        }

        public Info e() {
            this.v = true;
            return this;
        }

        public Info f() {
            this.m = LootTables.a;
            return this;
        }

        public Info a(Block source) {
            this.m = source.r();
            return this;
        }

        public Info g() {
            this.o = true;
            return this;
        }

        public Info a(d<EntityTypes<?>> predicate) {
            this.p = predicate;
            return this;
        }

        public Info a(e predicate) {
            this.q = predicate;
            return this;
        }

        public Info b(e predicate) {
            this.r = predicate;
            return this;
        }

        public Info c(e predicate) {
            this.s = predicate;
            return this;
        }

        public Info d(e predicate) {
            this.t = predicate;
            return this;
        }

        public Info e(e predicate) {
            this.u = predicate;
            return this;
        }

        public Info h() {
            this.h = true;
            return this;
        }

        public Info a(MaterialMapColor color) {
            this.b = iblockdata -> color;
            return this;
        }

        public Info e(float hardness) {
            this.g = hardness;
            return this;
        }

        public Info f(float resistance) {
            this.f = Math.max(0.0f, resistance);
            return this;
        }
    }

    public static enum EnumRandomOffset {
        a,
        b,
        c;

    }

    public static abstract class BlockData
    extends IBlockDataHolder<Block, IBlockData> {
        private final int b;
        private final boolean g;
        private final boolean h;
        private final Material i;
        private final MaterialMapColor j;
        public final float k;
        private final boolean l;
        private final boolean m;
        private final e n;
        private final e o;
        private final e p;
        private final e q;
        private final e r;
        @Nullable
        protected Cache a;
        private CraftBlockData cachedCraftBlockData;
        protected boolean shapeExceedsCube = true;
        protected boolean isTicking;
        protected Fluid fluid;
        protected int opacityIfCached = -1;
        protected final boolean conditionallyFullOpaque;

        public final int getEmittedLight() {
            return this.b;
        }

        public final boolean isTransparentOnSomeFaces() {
            return this.g;
        }

        public final boolean isOpaque() {
            return this.m;
        }

        protected BlockData(Block block, ImmutableMap<IBlockState<?>, Comparable<?>> propertyMap, MapCodec<IBlockData> codec) {
            super(block, propertyMap, codec);
            Info blockbase_info = block.aP;
            this.b = blockbase_info.e.applyAsInt(this.q());
            this.g = block.g_(this.q());
            this.h = blockbase_info.o;
            this.i = blockbase_info.a;
            this.j = blockbase_info.b.apply(this.q());
            this.k = blockbase_info.g;
            this.l = blockbase_info.h;
            this.m = blockbase_info.n;
            this.n = blockbase_info.q;
            this.o = blockbase_info.r;
            this.p = blockbase_info.s;
            this.q = blockbase_info.t;
            this.r = blockbase_info.u;
            this.conditionallyFullOpaque = this.isOpaque() & this.isTransparentOnSomeFaces();
        }

        public CraftBlockData createCraftBlockData() {
            if (this.cachedCraftBlockData == null) {
                this.cachedCraftBlockData = CraftBlockData.createData(this.q());
            }
            return (CraftBlockData)this.cachedCraftBlockData.clone();
        }

        public final boolean shapeExceedsCube() {
            return this.shapeExceedsCube;
        }

        public final int getOpacityIfCached() {
            return this.opacityIfCached;
        }

        public final boolean isConditionallyFullOpaque() {
            return this.conditionallyFullOpaque;
        }

        public void a() {
            this.fluid = this.b().c_(this.q());
            this.isTicking = this.b().e_(this.q());
            if (!this.b().o()) {
                this.a = new Cache(this.q());
            }
            this.shapeExceedsCube = this.a == null || this.a.c;
            this.opacityIfCached = this.a == null || this.isConditionallyFullOpaque() ? -1 : this.a.h;
        }

        public Block b() {
            return (Block)this.e;
        }

        public final boolean isDestroyable() {
            return this.b().isDestroyable();
        }

        public Material c() {
            return this.i;
        }

        public boolean a(IBlockAccess world, BlockPosition pos, EntityTypes<?> type) {
            return this.b().aP.p.test(this.q(), world, pos, type);
        }

        public boolean a(IBlockAccess world, BlockPosition pos) {
            return this.a != null ? this.a.g : this.b().c(this.q(), world, pos);
        }

        public int b(IBlockAccess world, BlockPosition pos) {
            return this.a != null ? this.a.h : this.b().g(this.q(), world, pos);
        }

        public VoxelShape a(IBlockAccess world, BlockPosition pos, EnumDirection direction) {
            return this.a != null && this.a.i != null ? this.a.i[direction.ordinal()] : VoxelShapes.a(this.c(world, pos), direction);
        }

        public VoxelShape c(IBlockAccess world, BlockPosition pos) {
            return this.b().b_(this.q(), world, pos);
        }

        public final boolean d() {
            return this.shapeExceedsCube;
        }

        public final boolean e() {
            return this.g;
        }

        public final int f() {
            return this.b;
        }

        public final boolean g() {
            return this.h;
        }

        public MaterialMapColor d(IBlockAccess world, BlockPosition pos) {
            return this.j;
        }

        public IBlockData a(EnumBlockRotation rotation) {
            return this.b().a(this.q(), rotation);
        }

        public IBlockData a(EnumBlockMirror mirror) {
            return this.b().a(this.q(), mirror);
        }

        public EnumRenderType h() {
            return this.b().b_(this.q());
        }

        public boolean e(IBlockAccess world, BlockPosition pos) {
            return this.r.test(this.q(), world, pos);
        }

        public float f(IBlockAccess world, BlockPosition pos) {
            return this.b().b(this.q(), world, pos);
        }

        public boolean g(IBlockAccess world, BlockPosition pos) {
            return this.n.test(this.q(), world, pos);
        }

        public boolean i() {
            return this.b().f_(this.q());
        }

        public int b(IBlockAccess world, BlockPosition pos, EnumDirection direction) {
            return this.b().a(this.q(), world, pos, direction);
        }

        public boolean j() {
            return this.b().d_(this.q());
        }

        public int a(World world, BlockPosition pos) {
            return this.b().a(this.q(), world, pos);
        }

        public float h(IBlockAccess world, BlockPosition pos) {
            return this.k;
        }

        public float a(EntityHuman player, IBlockAccess world, BlockPosition pos) {
            return this.b().a(this.q(), player, world, pos);
        }

        public int c(IBlockAccess world, BlockPosition pos, EnumDirection direction) {
            return this.b().b(this.q(), world, pos, direction);
        }

        public EnumPistonReaction k() {
            return !this.isDestroyable() ? EnumPistonReaction.c : this.b().d(this.q());
        }

        public boolean i(IBlockAccess world, BlockPosition pos) {
            if (this.a != null) {
                return this.a.a;
            }
            IBlockData iblockdata = this.q();
            return iblockdata.l() ? Block.a(iblockdata.c(world, pos)) : false;
        }

        public final boolean l() {
            return this.m;
        }

        public boolean a(IBlockData state, EnumDirection direction) {
            return this.b().a(this.q(), state, direction);
        }

        public VoxelShape j(IBlockAccess world, BlockPosition pos) {
            return this.a(world, pos, VoxelShapeCollision.a());
        }

        public VoxelShape a(IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
            return this.b().a(this.q(), world, pos, context);
        }

        public VoxelShape k(IBlockAccess world, BlockPosition pos) {
            return this.a != null ? this.a.b : this.b(world, pos, VoxelShapeCollision.a());
        }

        public VoxelShape b(IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
            return this.b().c(this.q(), world, pos, context);
        }

        public VoxelShape l(IBlockAccess world, BlockPosition pos) {
            return this.b().f(this.q(), world, pos);
        }

        public VoxelShape c(IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
            return this.b().b(this.q(), world, pos, context);
        }

        public VoxelShape m(IBlockAccess world, BlockPosition pos) {
            return this.b().a(this.q(), world, pos);
        }

        public final boolean a(IBlockAccess world, BlockPosition pos, Entity entity) {
            return this.a(world, pos, entity, EnumDirection.b);
        }

        public final boolean a(IBlockAccess world, BlockPosition pos, Entity entity, EnumDirection direction) {
            return Block.a(this.b(world, pos, VoxelShapeCollision.a(entity)), direction);
        }

        public Vec3D n(IBlockAccess world, BlockPosition pos) {
            Block block = this.b();
            EnumRandomOffset blockbase_enumrandomoffset = block.T_();
            if (blockbase_enumrandomoffset == EnumRandomOffset.a) {
                return Vec3D.a;
            }
            long i2 = MathHelper.c(pos.u(), 0, pos.w());
            float f2 = block.V_();
            double d0 = MathHelper.a(((double)((float)(i2 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
            double d1 = blockbase_enumrandomoffset == EnumRandomOffset.c ? ((double)((float)(i2 >> 4 & 0xFL) / 15.0f) - 1.0) * (double)block.Y_() : 0.0;
            double d2 = MathHelper.a(((double)((float)(i2 >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
            return new Vec3D(d0, d1, d2);
        }

        public boolean a(World world, BlockPosition pos, int type, int data) {
            return this.b().a(this.q(), world, pos, type, data);
        }

        public void a(World world, BlockPosition pos, Block block, BlockPosition posFrom, boolean notify) {
            this.b().a(this.q(), world, pos, block, posFrom, notify);
        }

        public final void a(GeneratorAccess world, BlockPosition pos, int flags) {
            this.a(world, pos, flags, 512);
        }

        public final void a(GeneratorAccess world, BlockPosition pos, int flags, int maxUpdateDepth) {
            this.b();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (EnumDirection enumdirection : aF) {
                blockposition_mutableblockposition.a((BaseBlockPosition)pos, enumdirection);
                IBlockData iblockdata = world.a_(blockposition_mutableblockposition);
                IBlockData iblockdata1 = iblockdata.a(enumdirection.f(), this.q(), world, (BlockPosition)blockposition_mutableblockposition, pos);
                Block.a(iblockdata, iblockdata1, world, blockposition_mutableblockposition, flags, maxUpdateDepth);
            }
        }

        public final void b(GeneratorAccess world, BlockPosition pos, int flags) {
            this.b(world, pos, flags, 512);
        }

        public void b(GeneratorAccess world, BlockPosition pos, int flags, int maxUpdateDepth) {
            this.b().a(this.q(), world, pos, flags, maxUpdateDepth);
        }

        public void a(World world, BlockPosition pos, IBlockData state, boolean notify) {
            this.b().b(this.q(), world, pos, state, notify);
        }

        public void b(World world, BlockPosition pos, IBlockData state, boolean moved) {
            this.b().a(this.q(), world, pos, state, moved);
        }

        public void a(WorldServer world, BlockPosition pos, Random random) {
            this.b().a(this.q(), world, pos, random);
        }

        public void b(WorldServer world, BlockPosition pos, Random random) {
            this.b().b(this.q(), world, pos, random);
        }

        public void a(World world, BlockPosition pos, Entity entity) {
            this.b().a(this.q(), world, pos, entity);
        }

        public void a(WorldServer world, BlockPosition pos, ItemStack stack) {
            this.b().a(this.q(), world, pos, stack);
        }

        public List<ItemStack> a(LootTableInfo.Builder builder) {
            return this.b().a(this.q(), builder);
        }

        public EnumInteractionResult a(World world, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
            return this.b().a(this.q(), world, hit.a(), player, hand, hit);
        }

        public void a(World world, BlockPosition pos, EntityHuman player) {
            this.b().a(this.q(), world, pos, player);
        }

        public boolean o(IBlockAccess world, BlockPosition pos) {
            return this.o.test(this.q(), world, pos);
        }

        public boolean p(IBlockAccess world, BlockPosition pos) {
            return this.p.test(this.q(), world, pos);
        }

        public IBlockData a(EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
            return this.b().a(this.q(), direction, neighborState, world, pos, neighborPos);
        }

        public boolean a(IBlockAccess world, BlockPosition pos, PathMode type) {
            return this.b().a(this.q(), world, pos, type);
        }

        public boolean a(BlockActionContext context) {
            return this.b().a(this.q(), context);
        }

        public boolean a(FluidType fluid) {
            return this.b().a(this.q(), fluid);
        }

        public boolean a(IWorldReader world, BlockPosition pos) {
            return this.b().a(this.q(), world, pos);
        }

        public boolean q(IBlockAccess world, BlockPosition pos) {
            return this.q.test(this.q(), world, pos);
        }

        @Nullable
        public ITileInventory b(World world, BlockPosition pos) {
            return this.b().b(this.q(), world, pos);
        }

        @Override
        public boolean a(Tag<Block> tag) {
            return tag.a(this.b());
        }

        @Override
        public boolean a(Tag<Block> tag, Predicate<BlockData> predicate) {
            return this.a(tag) && predicate.test(this);
        }

        public boolean m() {
            return this.b() instanceof ITileEntity;
        }

        @Nullable
        public <T extends TileEntity> BlockEntityTicker<T> a(World world, TileEntityTypes<T> blockEntityType) {
            return this.b() instanceof ITileEntity ? ((ITileEntity)((Object)this.b())).a(world, this.q(), blockEntityType) : null;
        }

        public boolean a(Block block) {
            return this.b() == block;
        }

        public final Fluid n() {
            return this.fluid;
        }

        public final boolean o() {
            return this.isTicking;
        }

        public long a(BlockPosition pos) {
            return this.b().a(this.q(), pos);
        }

        public SoundEffectType p() {
            return this.b().m(this.q());
        }

        public void a(World world, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
            this.b().a(world, state, hit, projectile);
        }

        public boolean d(IBlockAccess world, BlockPosition pos, EnumDirection direction) {
            return this.a(world, pos, direction, EnumBlockSupport.a);
        }

        public boolean a(IBlockAccess world, BlockPosition pos, EnumDirection direction, EnumBlockSupport shapeType) {
            return this.a != null ? this.a.a(direction, shapeType) : shapeType.a(this.q(), world, pos, direction);
        }

        public boolean r(IBlockAccess world, BlockPosition pos) {
            return this.a != null ? this.a.d : this.b().a_(this.q(), world, pos);
        }

        protected abstract IBlockData q();

        public boolean r() {
            return this.l;
        }

        private static final class Cache {
            private static final EnumDirection[] e = EnumDirection.values();
            private static final int f = EnumBlockSupport.values().length;
            protected final boolean a;
            final boolean g;
            final int h;
            @Nullable
            final VoxelShape[] i;
            protected final VoxelShape b;
            protected final boolean c;
            private final boolean[] j;
            protected final boolean d;

            Cache(IBlockData state) {
                Block block = state.b();
                this.a = state.i(BlockAccessAir.a, BlockPosition.b);
                this.g = block.c(state, BlockAccessAir.a, BlockPosition.b);
                this.h = block.g(state, BlockAccessAir.a, BlockPosition.b);
                if (!state.l()) {
                    this.i = null;
                } else {
                    this.i = new VoxelShape[e.length];
                    VoxelShape voxelshape = block.b_(state, BlockAccessAir.a, BlockPosition.b);
                    EnumDirection[] aenumdirection = e;
                    int i2 = aenumdirection.length;
                    for (int j2 = 0; j2 < i2; ++j2) {
                        EnumDirection enumdirection = aenumdirection[j2];
                        this.i[enumdirection.ordinal()] = VoxelShapes.a(voxelshape, enumdirection);
                    }
                }
                this.b = block.c(state, BlockAccessAir.a, BlockPosition.b, VoxelShapeCollision.a());
                if (!this.b.b() && block.T_() != EnumRandomOffset.a) {
                    throw new IllegalStateException(String.format("%s has a collision shape and an offset type, but is not marked as dynamicShape in its properties.", IRegistry.X.b(block)));
                }
                this.c = Arrays.stream(EnumDirection.EnumAxis.values()).anyMatch(enumdirection_enumaxis -> this.b.b((EnumDirection.EnumAxis)enumdirection_enumaxis) < 0.0 || this.b.c((EnumDirection.EnumAxis)enumdirection_enumaxis) > 1.0);
                this.j = new boolean[e.length * f];
                for (EnumDirection enumdirection1 : e) {
                    for (EnumBlockSupport enumblocksupport : EnumBlockSupport.values()) {
                        this.j[Cache.b((EnumDirection)enumdirection1, (EnumBlockSupport)enumblocksupport)] = enumblocksupport.a(state, BlockAccessAir.a, BlockPosition.b, enumdirection1);
                    }
                }
                this.d = Block.a(state.k(BlockAccessAir.a, BlockPosition.b));
            }

            public boolean a(EnumDirection direction, EnumBlockSupport shapeType) {
                return this.j[Cache.b(direction, shapeType)];
            }

            private static int b(EnumDirection direction, EnumBlockSupport shapeType) {
                return direction.ordinal() * f + shapeType.ordinal();
            }
        }
    }

    public static interface e {
        public boolean test(IBlockData var1, IBlockAccess var2, BlockPosition var3);
    }

    public static interface d<A> {
        public boolean test(IBlockData var1, IBlockAccess var2, BlockPosition var3, A var4);
    }
}

